/*
 * Decompiled with CFR 0.152.
 */
package au.org.ala.ws.tokens;

import au.org.ala.ws.tokens.TokenClient;
import com.google.common.annotations.VisibleForTesting;
import com.nimbusds.oauth2.sdk.AuthorizationGrant;
import com.nimbusds.oauth2.sdk.ClientCredentialsGrant;
import com.nimbusds.oauth2.sdk.ParseException;
import com.nimbusds.oauth2.sdk.RefreshTokenGrant;
import com.nimbusds.oauth2.sdk.Scope;
import com.nimbusds.oauth2.sdk.TokenRequest;
import com.nimbusds.oauth2.sdk.auth.ClientAuthentication;
import com.nimbusds.oauth2.sdk.auth.ClientSecretBasic;
import com.nimbusds.oauth2.sdk.auth.Secret;
import com.nimbusds.oauth2.sdk.id.ClientID;
import com.nimbusds.oauth2.sdk.token.AccessToken;
import com.nimbusds.oauth2.sdk.token.RefreshToken;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.pac4j.core.profile.ProfileManager;
import org.pac4j.oidc.config.OidcConfiguration;
import org.pac4j.oidc.credentials.OidcCredentials;
import org.pac4j.oidc.profile.OidcProfile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TokenService {
    static final Logger log = LoggerFactory.getLogger(TokenService.class);
    final boolean cacheTokens;
    final String clientId;
    final String clientSecret;
    final String jwtScopes;
    final List<String> finalScopes;
    private final OidcConfiguration oidcConfiguration;
    private final ProfileManager profileManager;
    private final TokenClient tokenClient;
    private long expiryWindow = 1L;
    private volatile transient OidcCredentials cachedCredentials;
    private volatile transient long cachedCredentialsLifetime = 0L;
    @VisibleForTesting
    final Object lock = new Object();

    public TokenService(OidcConfiguration oidcConfiguration, ProfileManager profileManager, TokenClient tokenClient, String clientId, String clientSecret, String jwtScopes, boolean cacheTokens) {
        this.cacheTokens = cacheTokens;
        this.oidcConfiguration = oidcConfiguration;
        this.profileManager = profileManager;
        this.tokenClient = tokenClient;
        this.clientId = clientId;
        this.clientSecret = clientSecret;
        this.jwtScopes = jwtScopes;
        this.finalScopes = jwtScopes != null && !jwtScopes.isEmpty() ? Arrays.stream(jwtScopes.split(" ")).filter(Predicate.not(String::isEmpty)).collect(Collectors.toList()) : null;
    }

    public AccessToken getAuthToken(boolean requireUser) {
        if (this.profileManager == null) {
            if (requireUser) {
                log.debug("Unable to retrieve user access token, no profile manager configured");
                return null;
            }
            return this.getClientCredentialsAccessToken();
        }
        return this.profileManager.getProfile(OidcProfile.class).map(OidcProfile::getAccessToken).orElseGet(() -> {
            if (requireUser) {
                return null;
            }
            return this.getClientCredentialsAccessToken();
        });
    }

    AccessToken getClientCredentialsAccessToken() {
        if (this.oidcConfiguration != null) {
            try {
                OidcCredentials credentials = this.cacheTokens ? this.getOrRefreshToken() : this.clientCredentials();
                return credentials.getAccessToken();
            }
            catch (Exception e) {
                log.debug("Error generating token", (Throwable)e);
            }
        } else {
            log.debug("Not generating token because OIDC is not configured");
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private OidcCredentials getOrRefreshToken() throws IOException, ParseException {
        long now = System.currentTimeMillis() / 1000L - this.expiryWindow;
        long lifetime = this.cachedCredentialsLifetime;
        if (lifetime == 0L || now >= lifetime) {
            Object object = this.lock;
            synchronized (object) {
                lifetime = this.cachedCredentialsLifetime;
                if (lifetime == 0L || now >= lifetime) {
                    OidcCredentials credentials;
                    this.cachedCredentials = credentials = this.tokenSupplier(this.cachedCredentials);
                    this.cachedCredentialsLifetime = System.currentTimeMillis() / 1000L + credentials.getAccessToken().getLifetime();
                    return credentials;
                }
            }
        }
        return this.cachedCredentials;
    }

    private OidcCredentials tokenSupplier(OidcCredentials existingCredentials) throws IOException, ParseException {
        OidcCredentials credentials = null;
        if (existingCredentials != null && existingCredentials.getRefreshToken() != null) {
            try {
                log.debug("Refreshing existing token");
                credentials = this.refreshToken(existingCredentials.getRefreshToken());
            }
            catch (Exception e) {
                log.warn("Couldn't get refresh token from {}", (Object)existingCredentials.getRefreshToken(), (Object)e);
            }
        }
        if (credentials == null) {
            log.debug("Requesting new client credentials token");
            credentials = this.clientCredentials();
        }
        return credentials;
    }

    private OidcCredentials clientCredentials() throws IOException, ParseException {
        TokenRequest tokenRequest = new TokenRequest(this.oidcConfiguration.findProviderMetadata().getTokenEndpointURI(), (ClientAuthentication)new ClientSecretBasic(new ClientID(this.clientId), new Secret(this.clientSecret)), (AuthorizationGrant)new ClientCredentialsGrant(), this.finalScopes == null ? new Scope() : new Scope(this.finalScopes.toArray(new String[0])));
        return this.tokenClient.executeTokenRequest(tokenRequest);
    }

    private OidcCredentials refreshToken(RefreshToken refreshToken) throws IOException, ParseException {
        TokenRequest tokenRequest = new TokenRequest(this.oidcConfiguration.findProviderMetadata().getTokenEndpointURI(), (ClientAuthentication)new ClientSecretBasic(new ClientID(this.clientId), new Secret(this.clientSecret)), (AuthorizationGrant)new RefreshTokenGrant(refreshToken), this.finalScopes == null ? new Scope() : new Scope(this.finalScopes.toArray(new String[0])));
        return this.tokenClient.executeTokenRequest(tokenRequest);
    }
}

