/*
 * Decompiled with CFR 0.152.
 */
package au.org.ala.biocache.web;

import au.org.ala.biocache.service.SpeciesSearchService;
import au.org.ala.biocache.util.converter.FqField;
import au.org.ala.biocache.web.AbstractSecureController;
import com.fasterxml.jackson.annotation.JsonInclude;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.util.Map;
import javax.inject.Inject;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class AutocompleteController
extends AbstractSecureController {
    @Inject
    protected SpeciesSearchService speciesSearchService;

    @Operation(summary="Autocomplete service which filters only lists taxa with occurrence data", tags={"Autocomplete"})
    @Tag(name="Autocomplete", description="Services that support autocomplete text boxes")
    @RequestMapping(value={"autocomplete/search"}, method={RequestMethod.GET}, produces={"application/json"})
    @ResponseBody
    public Map search(@RequestParam(value="q") String query, @FqField @RequestParam(value="fq", required=false) String[] filterQuery, @RequestParam(value="pageSize", required=false, defaultValue="10") Integer max, @RequestParam(value="all", required=false, defaultValue="false") Boolean includeAll, @RequestParam(value="synonyms", required=false, defaultValue="true") Boolean searchSynonyms, @RequestParam(value="counts", required=false, defaultValue="true") Boolean counts) throws Exception {
        return this.speciesSearchService.search(query, filterQuery, max.intValue(), searchSynonyms.booleanValue(), includeAll.booleanValue(), counts.booleanValue());
    }
}

