/*
 * Decompiled with CFR 0.152.
 */
package au.org.ala.biocache.web;

import au.com.bytecode.opencsv.CSVWriter;
import au.org.ala.biocache.dto.AssertionCode;
import au.org.ala.biocache.dto.AssertionCodes;
import au.org.ala.biocache.dto.AssertionStatus;
import au.org.ala.biocache.dto.ErrorCode;
import au.org.ala.biocache.dto.QualityAssertion;
import au.org.ala.biocache.dto.UserAssertions;
import au.org.ala.biocache.service.AssertionService;
import au.org.ala.biocache.util.solr.FieldMappingUtil;
import au.org.ala.biocache.web.AbstractSecureController;
import com.fasterxml.jackson.core.JsonEncoding;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.swagger.annotations.ApiParam;
import io.swagger.v3.oas.annotations.Hidden;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.Parameters;
import io.swagger.v3.oas.annotations.enums.ParameterIn;
import io.swagger.v3.oas.annotations.security.SecurityRequirement;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.support.AbstractMessageSource;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.annotation.Secured;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.server.ResponseStatusException;

@RestController
public class AssertionController
extends AbstractSecureController {
    private static final Logger logger = Logger.getLogger(AssertionController.class);
    @Value(value="${registry.url:https://collections.ala.org.au}")
    protected String registryUrl = "https://collections.ala.org.au";
    @Inject
    private AbstractMessageSource messageSource;
    @Inject
    private AssertionService assertionService;
    @Inject
    private FieldMappingUtil fieldMappingUtil;

    @Tag(name="Assertions", description="Services providing CRUD operations on annotations, assertions for data")
    @Operation(summary="Retrieve an array of the assertion codes in use by the processing system", tags={"Assertions"})
    @Parameters(value={@Parameter(name="accept", description="Return contentType; 'application/json' (default) or 'text/plain'", in=ParameterIn.HEADER)})
    @RequestMapping(value={"/assertions/codes"}, method={RequestMethod.GET}, produces={"application/json", "text/plain"})
    public void showCodes(@RequestParam(value="deprecated", required=false, defaultValue="false") Boolean isDeprecated, HttpServletRequest request, HttpServletResponse response) throws Exception {
        Collection result = this.applyi18n(AssertionCodes.getAll(), isDeprecated.booleanValue(), true);
        String accept = request.getHeader("Accept");
        if (accept == null) {
            accept = "";
        }
        if (accept.startsWith("text/plain")) {
            response.setContentType("text/plain");
            CSVWriter writer = new CSVWriter((Writer)new OutputStreamWriter((OutputStream)response.getOutputStream()));
            writer.writeNext(new String[]{"Code", "Name", "", "Description", "Wiki", "", "", "", "", "", "", "", "", "", "empty"});
            for (AssertionCode ac : result) {
                writer.writeNext(new String[]{ac.getCode().toString(), ac.getName(), "", this.messageSource.getMessage("desc." + ac.getName(), null, this.messageSource.getMessage(ac.getName(), null, ac.getName(), Locale.getDefault()), Locale.getDefault()), "Wiki", "", "", "", "", "", "", "", "", "", "empty"});
            }
            writer.flush();
            writer.close();
        } else {
            response.setContentType("application/json");
            JsonFactory jsonFactory = new JsonFactory();
            JsonGenerator jsonGenerator = jsonFactory.createGenerator((OutputStream)response.getOutputStream(), JsonEncoding.UTF8);
            jsonGenerator.setCodec((ObjectCodec)new ObjectMapper());
            jsonGenerator.writeObject((Object)result);
            jsonGenerator.flush();
            jsonGenerator.close();
        }
    }

    @Operation(summary="Retrieve an array of the assertion codes in use by users", tags={"Assertions"})
    @RequestMapping(value={"/assertions/user/codes"}, method={RequestMethod.GET}, produces={"application/json"})
    @ResponseBody
    public Collection<AssertionCode> showUserCodes(@RequestParam(value="deprecated", required=false, defaultValue="false") Boolean isDeprecated) throws Exception {
        return this.applyi18n(AssertionCodes.userAssertionCodes, isDeprecated.booleanValue(), false);
    }

    @SecurityRequirement(name="JWT")
    @Operation(summary="Add an assertion", tags={"Assertions", "Occurrence"})
    @RequestMapping(value={"/occurrences/assertions/add"}, method={RequestMethod.POST})
    public ResponseEntity addAssertionWithParams(@RequestParam(value="recordUuid", required=true) String recordUuid, @RequestParam(value="code", required=true) String code, @RequestParam(value="comment", required=false) String comment, @RequestParam(value="userId", required=true) String userId, @RequestParam(value="userDisplayName", required=true) String userDisplayName, @RequestParam(value="userAssertionStatus", required=false) String userAssertionStatus, @RequestParam(value="assertionUuid", required=false) String assertionUuid, @RequestParam(value="relatedRecordId", required=false) String relatedRecordId, @RequestParam(value="relatedRecordReason", required=false) String relatedRecordReason, @RequestParam(value="updateId", required=false) String updateId, HttpServletRequest request, HttpServletResponse response) throws Exception {
        return this.addAssertion(recordUuid, code, userId, userDisplayName, comment, userAssertionStatus, assertionUuid, relatedRecordId, relatedRecordReason, updateId, request, response);
    }

    @Hidden
    @SecurityRequirement(name="JWT")
    @Operation(summary="Bulk add an assertion", tags={"Assertions"})
    @RequestMapping(value={"/bulk/assertions/add"}, method={RequestMethod.POST})
    public void addBulkAssertions(@RequestParam(value="assertions", required=true) String json, @RequestParam(value="userId", required=true) String userId, @RequestParam(value="userDisplayName", required=true) String userDisplayName, HttpServletRequest request, HttpServletResponse response) throws Exception {
        if (!this.shouldPerformOperation(request, response)) {
            throw new ResponseStatusException(HttpStatus.FORBIDDEN, "Insufficient authentication credentials provided.");
        }
        ObjectMapper om = new ObjectMapper();
        List assertions = (List)om.readValue(json, (TypeReference)new /* Unavailable Anonymous Inner Class!! */);
        logger.debug((Object)("The assertions in a list of maps: " + String.valueOf(assertions)));
        Map<String, List<Map>> uuidMappedAssertions = assertions.stream().collect(Collectors.groupingBy(assertion -> (String)assertion.get("recordUuid")));
        uuidMappedAssertions.forEach((uuid, maps) -> {
            try {
                UserAssertions userAssertions = new UserAssertions();
                for (Map as : maps) {
                    QualityAssertion qa = new QualityAssertion();
                    Integer code = Integer.parseInt((String)as.get("code"));
                    qa.setCode(code);
                    if (code.equals(AssertionCodes.VERIFIED.getCode())) {
                        qa.setRelatedUuid((String)as.get("assertionUuid"));
                        qa.setQaStatus(Integer.valueOf(Integer.parseInt((String)as.get("userAssertionStatus"))));
                    } else {
                        qa.setQaStatus(AssertionStatus.QA_UNCONFIRMED);
                    }
                    qa.setComment((String)as.get("comment"));
                    qa.setUserId(userId);
                    qa.setUserDisplayName(userDisplayName);
                    qa.setReferenceRowKey(uuid);
                    userAssertions.add((Object)qa);
                }
                this.assertionService.bulkAddAssertions(uuid, userAssertions);
            }
            catch (IOException e) {
                logger.error((Object)("Failed to bulk add assertions for record: " + uuid));
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
        });
    }

    @SecurityRequirement(name="JWT")
    @Operation(summary="Add an assertion to a record", tags={"Assertions"})
    @RequestMapping(value={"/occurrences/{recordUuid}/assertions/add"}, method={RequestMethod.POST})
    @ApiParam(value="recordUuid", required=true)
    public ResponseEntity addAssertion(@PathVariable(value="recordUuid") String recordUuid, @Parameter(description="Assertion code") @RequestParam(value="code") String code, @Parameter(description="Atlas user ID") @RequestParam(value="userId") String userId, @RequestParam(value="userDisplayName") String userDisplayName, @RequestParam(value="comment", required=false) String comment, @RequestParam(value="userAssertionStatus", required=false) String userAssertionStatus, @RequestParam(value="assertionUuid", required=false) String assertionUuid, @RequestParam(value="relatedRecordId", required=false) String relatedRecordId, @RequestParam(value="relatedRecordReason", required=false) String relatedRecordReason, @RequestParam(value="updateId", required=false) String updateId, HttpServletRequest request, HttpServletResponse response) throws Exception {
        if (!this.shouldPerformOperation(request, response)) {
            throw new ResponseStatusException(HttpStatus.FORBIDDEN, "Insufficient authentication credentials provided.");
        }
        try {
            if (StringUtils.isEmpty((String)updateId)) {
                Optional qa = this.assertionService.addAssertion(recordUuid, code, comment, userId, userDisplayName, userAssertionStatus, assertionUuid, relatedRecordId, relatedRecordReason);
                if (qa.isPresent()) {
                    String server = request.getSession().getServletContext().getInitParameter("serverName");
                    return ResponseEntity.created((URI)new URI(server + "/occurrences/" + recordUuid + "/assertions/" + ((QualityAssertion)qa.get()).getUuid())).contentLength(0L).build();
                }
            } else if (this.assertionService.editAssertion(recordUuid, updateId, comment)) {
                return ResponseEntity.ok().contentLength(0L).build();
            }
            throw new ResponseStatusException(HttpStatus.BAD_REQUEST);
        }
        catch (IOException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new ResponseStatusException(HttpStatus.INTERNAL_SERVER_ERROR, " e.getMessage()", (Throwable)e);
        }
    }

    @SecurityRequirement(name="JWT")
    @Operation(summary="Removes an assertion", tags={"Assertions", "Occurrence"})
    @RequestMapping(value={"/occurrences/assertions/delete"}, method={RequestMethod.DELETE})
    public ResponseEntity deleteAssertionWithParams(@RequestParam(value="recordUuid", required=true) String recordUuid, @RequestParam(value="assertionUuid", required=true) String assertionUuid, HttpServletRequest request, HttpServletResponse response) throws Exception {
        return this.deleteAssertion(recordUuid, assertionUuid, request, response);
    }

    @SecurityRequirement(name="JWT")
    @Operation(summary="Removes an assertion from a record", tags={"Assertions", "Occurrence"})
    @RequestMapping(value={"/occurrences/{recordUuid}/assertions/delete"}, method={RequestMethod.DELETE})
    @ApiParam(value="recordUuid", required=true)
    public ResponseEntity deleteAssertionWithParam(@PathVariable(value="recordUuid") String recordUuid, @RequestParam(value="assertionUuid", required=true) String assertionUuid, HttpServletRequest request, HttpServletResponse response) throws Exception {
        return this.deleteAssertion(recordUuid, assertionUuid, request, response);
    }

    @Deprecated
    @SecurityRequirement(name="JWT")
    @Operation(summary="Removes an assertion", tags={"Deprecated"})
    @RequestMapping(value={"/occurrences/assertions/delete"}, method={RequestMethod.POST})
    public ResponseEntity deleteAssertionWithParamsPost(@RequestParam(value="recordUuid", required=true) String recordUuid, @RequestParam(value="assertionUuid", required=true) String assertionUuid, HttpServletRequest request, HttpServletResponse response) throws Exception {
        return this.deleteAssertion(recordUuid, assertionUuid, request, response);
    }

    @SecurityRequirement(name="JWT")
    @Operation(summary="Removes an assertion from a record", tags={"Assertions", "Occurrence"})
    @RequestMapping(value={"/occurrences/{recordUuid}/assertions/{assertionUuid}"}, method={RequestMethod.DELETE})
    @ApiParam(value="recordUuid", required=true)
    public ResponseEntity deleteAssertion(@PathVariable(value="recordUuid") String recordUuid, @PathVariable(value="assertionUuid") String assertionUuid, HttpServletRequest request, HttpServletResponse response) throws Exception {
        if (!this.shouldPerformOperation(request, response)) {
            throw new ResponseStatusException(HttpStatus.FORBIDDEN, "Insufficient authentication credentials provided.");
        }
        try {
            if (this.assertionService.deleteAssertion(recordUuid, assertionUuid)) {
                return ResponseEntity.ok().contentLength(0L).build();
            }
            throw new ResponseStatusException(HttpStatus.BAD_REQUEST, "recordUuid " + recordUuid + " or assertionUuid " + assertionUuid + " doesn't exist");
        }
        catch (IOException e) {
            logger.error((Object)("Failed to delete assertion [id: " + assertionUuid + "] for record " + recordUuid));
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new ResponseStatusException(HttpStatus.INTERNAL_SERVER_ERROR, e.getMessage(), (Throwable)e);
        }
    }

    @Deprecated
    @SecurityRequirement(name="JWT")
    @Operation(summary="Deprecated - use HTTP DELETE", tags={"Deprecated"})
    @RequestMapping(value={"/occurrences/{recordUuid}/assertions/delete"}, method={RequestMethod.POST})
    @ApiParam(value="recordUuid", required=true)
    public ResponseEntity deleteAssertionPost(@PathVariable(value="recordUuid") String recordUuid, @RequestParam(value="apiKey", required=true) String apiKey, @RequestParam(value="assertionUuid", required=true) String assertionUuid, HttpServletRequest request, HttpServletResponse response) throws Exception {
        if (!this.shouldPerformOperation(request, response)) {
            throw new ResponseStatusException(HttpStatus.FORBIDDEN, "Insufficient authentication credentials provided.");
        }
        try {
            if (this.assertionService.deleteAssertion(recordUuid, assertionUuid)) {
                return ResponseEntity.ok().contentLength(0L).build();
            }
            throw new ResponseStatusException(HttpStatus.BAD_REQUEST, "recordUuid " + recordUuid + " or assertionUuid " + assertionUuid + " doesn't exist");
        }
        catch (IOException e) {
            logger.error((Object)("Failed to delete assertion [id: " + assertionUuid + "] for record " + recordUuid));
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new ResponseStatusException(HttpStatus.INTERNAL_SERVER_ERROR, e.getMessage(), (Throwable)e);
        }
    }

    @Deprecated
    @SecurityRequirement(name="JWT")
    @Operation(summary="Get assertions for a record", tags={"Deprecated"})
    @RequestMapping(value={"/occurrences/assertions"}, method={RequestMethod.GET}, produces={"application/json"})
    @ResponseBody
    public Object getAssertionWithParams(@RequestParam(value="recordUuid", required=true) String recordUuid, @RequestParam(value="assertionUuid", required=false) String assertionUuid, HttpServletResponse response) throws Exception {
        if (assertionUuid != null) {
            return this.getAssertion(recordUuid, assertionUuid, response);
        }
        return this.getAssertions(recordUuid, response);
    }

    @Operation(summary="Get a single assertion", tags={"Assertions"})
    @RequestMapping(value={"/occurrences/{recordUuid}/assertions/{assertionUuid}"}, method={RequestMethod.GET}, produces={"application/json"})
    @ResponseBody
    public QualityAssertion getAssertion(@ApiParam(value="recordUuid", required=true) @PathVariable(value="recordUuid") String recordUuid, @ApiParam(value="assertionUuid", required=true) @PathVariable(value="assertionUuid") String assertionUuid, HttpServletResponse response) throws Exception {
        try {
            QualityAssertion assertion = this.assertionService.getAssertion(recordUuid, assertionUuid);
            if (assertion != null) {
                return assertion;
            }
            response.setStatus(404);
        }
        catch (IOException e) {
            logger.error((Object)("Failed to get assertion [id: " + assertionUuid + "] for record " + recordUuid));
            logger.error((Object)e.getMessage(), (Throwable)e);
            response.sendError(500, e.getMessage());
        }
        return null;
    }

    @Operation(summary="Get a assertions for a record", tags={"Assertions"})
    @RequestMapping(value={"/occurrences/{recordUuid}/assertions"}, method={RequestMethod.GET}, produces={"application/json"})
    @ApiParam(value="recordUuid", required=true)
    @ResponseBody
    public List<QualityAssertion> getAssertions(@PathVariable(value="recordUuid") String recordUuid, HttpServletResponse response) throws Exception {
        try {
            return this.assertionService.getAssertions(recordUuid);
        }
        catch (Exception e) {
            logger.error((Object)("Failed to get assertions for record " + recordUuid));
            logger.error((Object)e.getMessage(), (Throwable)e);
            response.sendError(500, e.getMessage());
            return null;
        }
    }

    @Deprecated
    @Operation(summary="Retrieve details fo assertion querries applied to this record", tags={"Deprecated"})
    @RequestMapping(value={"/occurrences/{recordUuid}/assertionQueries"}, method={RequestMethod.GET})
    @ApiParam(value="recordUuid", required=true)
    @ResponseBody
    public List<QualityAssertion> getAssertionQueries(@PathVariable(value="recordUuid") String recordUuid) throws Exception {
        return new ArrayList<QualityAssertion>();
    }

    @SecurityRequirement(name="JWT")
    @Secured(value={"ROLE_ADMIN", "ala/internal"})
    @Operation(summary="Synchronise assertions into the index", tags={"Monitoring"})
    @RequestMapping(value={"/sync"}, method={RequestMethod.GET})
    @ResponseBody
    public Boolean indexAll(HttpServletRequest request, HttpServletResponse response) throws Exception {
        if (request.getUserPrincipal() != null) {
            if (this.assertionService.indexAll()) {
                response.setStatus(200);
            } else {
                response.setStatus(200, "An index all user assertions job already running. Your request won't be processed.");
            }
        } else {
            response.sendError(403, "An invalid API Key was provided.");
        }
        return null;
    }

    @Operation(summary="Monitoring the progress of synchronising assertions into the index", tags={"Monitoring"})
    @RequestMapping(value={"/sync/status"}, method={RequestMethod.GET})
    @ResponseBody
    public String indexAllStatus(HttpServletRequest request, HttpServletResponse response) throws Exception {
        if (request.getUserPrincipal() != null) {
            return this.assertionService.isIndexAllRunning() ? "indexAll task is running" : "No task is running";
        }
        response.sendError(403, "An invalid API Key was provided.");
        return null;
    }

    private Collection<AssertionCode> applyi18n(ErrorCode[] errorCodes, boolean includeDeprecated, boolean sortByName) {
        ArrayList<AssertionCode> formattedAssertionCodes = new ArrayList<AssertionCode>();
        for (ErrorCode errorCode : errorCodes) {
            formattedAssertionCodes.add(new AssertionCode(errorCode.getName(), errorCode.getCode(), errorCode.getFatal(), this.messageSource.getMessage(errorCode.getName(), null, errorCode.getDescription(), null), ErrorCode.Category.valueOf((String)errorCode.getCategory()), errorCode.getTermsRequiredToTest()));
        }
        if (includeDeprecated) {
            this.fieldMappingUtil.getFieldValueMappingStream("assertions").filter(assertionMapping -> Arrays.stream(errorCodes).anyMatch(errorCode -> errorCode.getName().equals(assertionMapping.getRight()))).map(assertionMapping -> {
                AssertionCode assertionCode = new AssertionCode();
                assertionCode.setName((String)assertionMapping.getLeft());
                assertionCode.setDeprecated(true);
                assertionCode.setNewName((String)assertionMapping.getRight());
                return assertionCode;
            }).forEach(formattedAssertionCodes::add);
        }
        if (sortByName) {
            formattedAssertionCodes.sort(Comparator.comparing(ErrorCode::getName, String.CASE_INSENSITIVE_ORDER));
        }
        return formattedAssertionCodes;
    }
}

