/*
 * Decompiled with CFR 0.152.
 */
package au.org.ala.biocache.util;

import org.apache.log4j.Logger;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryCollection;
import org.locationtech.jts.geom.MultiPolygon;
import org.locationtech.jts.geom.Polygon;
import org.locationtech.jts.io.WKTReader;
import org.locationtech.jts.simplify.TopologyPreservingSimplifier;

/*
 * Exception performing whole class analysis ignored.
 */
public class SpatialUtils {
    private static final Logger logger = Logger.getLogger(SpatialUtils.class);

    public static String getWKTQuery(String spatialField, String wkt, boolean negated) {
        Object field;
        StringBuilder sb = new StringBuilder();
        String operation = negated ? " AND " : " OR ";
        Object object = field = negated ? "-" + spatialField : spatialField;
        if (wkt.startsWith("GEOMETRYCOLLECTION")) {
            try {
                WKTReader r = new WKTReader();
                GeometryCollection gc = (GeometryCollection)r.read(wkt);
                sb.append("(");
                for (int i = 0; i < gc.getNumGeometries(); ++i) {
                    Geometry g = gc.getGeometryN(i);
                    if (i > 0) {
                        sb.append(operation);
                    }
                    sb.append((String)field).append(":\"Intersects(");
                    sb.append(g.toText());
                    sb.append(")\"");
                }
                sb.append(")");
            }
            catch (Exception e) {
                logger.error((Object)("failed to parse WKT: " + wkt.substring(0, 255) + "..."), (Throwable)e);
            }
        } else {
            sb.append((String)field).append(":\"Intersects(");
            sb.append(wkt);
            sb.append(")\"");
        }
        return sb.toString();
    }

    public static String simplifyWkt(String wkt, int maxPoints) throws Exception {
        WKTReader r = new WKTReader();
        try {
            int numPoints = 0;
            for (int i = 0; i < wkt.length(); ++i) {
                if (wkt.charAt(i) != ',') continue;
                ++numPoints;
            }
            if (maxPoints <= 0 || numPoints <= maxPoints) {
                return wkt;
            }
            Geometry g = r.read(wkt);
            double averageDistance = 0.0;
            if (g.getGeometryType().equals("Polygon")) {
                averageDistance = SpatialUtils.getPolygonAverageDistance((Polygon)((Polygon)g));
            } else if (g.getGeometryType().equals("MultiPolygon")) {
                averageDistance = SpatialUtils.getMultipolygonAverageDistance((MultiPolygon)((MultiPolygon)g));
            } else if (g.getGeometryType().equals("GeometryCollection")) {
                averageDistance = SpatialUtils.getGeometryCollectionAverageDistance((Geometry)g);
            }
            double distance = (double)g.getNumPoints() / (double)maxPoints * averageDistance;
            Geometry newG = TopologyPreservingSimplifier.simplify((Geometry)g, (double)distance);
            logger.debug((Object)("WKT simplified reduced points from " + g.getNumPoints() + " to " + newG.getNumPoints()));
            return newG.toString();
        }
        catch (Exception e) {
            throw new Exception("WKT simplification failed");
        }
    }

    static double getPolygonAverageDistance(Polygon p) {
        Coordinate[] coordinates = p.getExteriorRing().getCoordinates();
        double sumOfSq = 0.0;
        int count = coordinates.length - 1;
        for (int i = 1; i < coordinates.length; ++i) {
            sumOfSq += Math.pow(coordinates[i].x - coordinates[i - 1].x, 2.0) + Math.pow(coordinates[i].y - coordinates[i - 1].y, 2.0);
        }
        for (int j = 0; j < p.getNumInteriorRing(); ++j) {
            coordinates = p.getInteriorRingN(j).getCoordinates();
            count += coordinates.length - 1;
            for (int i = 1; i < coordinates.length; ++i) {
                sumOfSq += Math.pow(coordinates[i].x - coordinates[i - 1].x, 2.0) + Math.pow(coordinates[i].y - coordinates[i - 1].y, 2.0);
            }
        }
        return Math.sqrt(sumOfSq / (double)count);
    }

    static double getMultipolygonAverageDistance(MultiPolygon mp) {
        double sum = 0.0;
        for (int i = 0; i < mp.getNumGeometries(); ++i) {
            Geometry g1 = mp.getGeometryN(i);
            sum += SpatialUtils.getPolygonAverageDistance((Polygon)((Polygon)g1));
        }
        return sum / (double)mp.getNumGeometries();
    }

    static double getGeometryCollectionAverageDistance(Geometry g) {
        double sum = 0.0;
        for (int i = 0; i < g.getNumGeometries(); ++i) {
            Geometry g1 = g.getGeometryN(i);
            if (g1.getGeometryType().equals("Polygon")) {
                sum += SpatialUtils.getPolygonAverageDistance((Polygon)((Polygon)g));
                continue;
            }
            if (!g1.getGeometryType().equals("MultiPolygon")) continue;
            sum += SpatialUtils.getMultipolygonAverageDistance((MultiPolygon)((MultiPolygon)g));
        }
        return sum / (double)g.getNumGeometries();
    }
}

