/*
 * Decompiled with CFR 0.152.
 */
package au.org.ala.biocache.util;

import java.awt.Color;

public class ColorUtil {
    public static final int[] colourList = new int[]{0x3366CC, 14432530, 0xFF9900, 1087000, 0x990099, 39366, 0xDD4477, 0x66AA00, 12070446, 3236757, 0x994499, 0x22AA99, 0xAAAA11, 0x6633CC, 15102720, 9111303, 6623335, 3314274, 5600422, 3882668, 12022562, 1496608, 12129155, 16004510, 10246453, 11125779, 2783117, 6720796, 12493843, 809250, 7615505};
    public static final String[] colorsNames = new String[]{"DarkRed", "IndianRed", "DarkSalmon", "SaddleBrown", "Chocolate", "SandyBrown", "Orange", "DarkGreen", "Green", "Lime", "LightGreen", "MidnightBlue", "Blue", "SteelBlue", "CadetBlue", "Aqua", "PowderBlue", "DarkOliveGreen", "DarkKhaki", "Yellow", "Moccasin", "Indigo", "Purple", "Fuchsia", "Plum", "Black", "White"};
    public static final String[] colorsCodes = new String[]{"8b0000", "FF0000", "CD5C5C", "E9967A", "8B4513", "D2691E", "F4A460", "FFA500", "006400", "008000", "00FF00", "90EE90", "191970", "0000FF", "4682B4", "5F9EA0", "00FFFF", "B0E0E6", "556B2F", "BDB76B", "FFFF00", "FFE4B5", "4B0082", "800080", "FF00FF", "DDA0DD", "000000", "FFFFFF"};

    public static int getRangedColour(int pos, int length) {
        int[] colourRange = new int[]{11728, 23458, 35955, 47428, 59158, 0xA0FF00, 0xFFFF00, 16762900, 0xFFA000, 16734976, 0xFF0000};
        double step = 1.0 / (double)colourRange.length;
        double p = (double)pos / (double)length;
        double dist = p / step;
        int minI = (int)Math.floor(dist);
        int maxI = (int)Math.ceil(dist);
        if (maxI >= colourRange.length) {
            maxI = colourRange.length - 1;
        }
        double minorP = p - (double)minI * step;
        double minorDist = minorP / step;
        int colour = 0;
        for (int i = 0; i < 3; ++i) {
            int minC = colourRange[minI] >> i * 8 & 0xFF;
            int maxC = colourRange[maxI] >> i * 8 & 0xFF;
            int c = Math.min((int)((double)(maxC - minC) * minorDist + (double)minC), 255);
            colour |= (c & 0xFF) << i * 8;
        }
        return colour;
    }

    public static String getRGB(int colour) {
        return (colour >> 16 & 0xFF) + "," + (colour >> 8 & 0xFF) + "," + (colour & 0xFF);
    }

    public static Color getColor(String htmlRGB, Float opacity) {
        if (htmlRGB == null || htmlRGB.length() != 6) {
            throw new IllegalArgumentException("badly formatted RGB string: " + htmlRGB);
        }
        int red = Integer.parseInt(htmlRGB.substring(0, 2), 16);
        int green = Integer.parseInt(htmlRGB.substring(2, 4), 16);
        int blue = Integer.parseInt(htmlRGB.substring(4), 16);
        int alpha = (int)(255.0f * opacity.floatValue());
        int colour = red << 16 | green << 8 | blue;
        return new Color(colour |= alpha << 24, true);
    }
}

