/*
 * Decompiled with CFR 0.152.
 */
package au.org.ala.biocache.stream;

import au.org.ala.biocache.dao.SearchDAOImpl;
import au.org.ala.biocache.dto.SpatialSearchRequestDTO;
import au.org.ala.biocache.dto.TaxaCountDTO;
import au.org.ala.biocache.stream.ProcessInterface;
import au.org.ala.biocache.util.SearchUtils;
import com.fasterxml.jackson.core.JsonEncoding;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.OutputStream;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.apache.solr.client.solrj.io.Tuple;

public class StreamTaxaCount
implements ProcessInterface {
    private static final Logger logger = Logger.getLogger(StreamTaxaCount.class);
    SearchDAOImpl searchDAO;
    SearchUtils searchUtils;
    SpatialSearchRequestDTO request;
    OutputStream outputStream;
    boolean isNamesAndLSID;
    boolean isCommonNameAndLSID;
    boolean includeRank;
    Pattern pattern = Pattern.compile("\\|");
    JsonGenerator jsonGenerator;
    int recordCount = 0;

    public StreamTaxaCount(SearchDAOImpl searchDAO, SearchUtils searchUtils, SpatialSearchRequestDTO request, Boolean includeRank, OutputStream outputStream) {
        this.request = request;
        this.searchDAO = searchDAO;
        this.searchUtils = searchUtils;
        this.outputStream = outputStream;
        this.isNamesAndLSID = "names_and_lsid".equals(request.getFacets()[0]);
        this.isCommonNameAndLSID = "common_name_and_lsid".equals(request.getFacets()[0]);
        this.includeRank = includeRank;
        this.initWriter();
    }

    public boolean process(Tuple tuple) {
        if (this.request.getStart() == null || this.recordCount >= this.request.getStart()) {
            String name = null;
            Long count = 0L;
            for (Object value : tuple.getMap().values()) {
                if (value instanceof String) {
                    name = (String)value;
                    continue;
                }
                count = (Long)value;
            }
            try {
                TaxaCountDTO tcDTO = null;
                if (this.isNamesAndLSID) {
                    values = this.pattern.split(name, 5);
                    if (values.length >= 5) {
                        if (!"||||".equals(name)) {
                            tcDTO = new TaxaCountDTO(values[0], count);
                            tcDTO.setGuid(StringUtils.trimToNull((String)values[1]));
                            tcDTO.setCommonName("null".equals(values[2]) ? "" : values[2]);
                            tcDTO.setKingdom(values[3]);
                            tcDTO.setFamily(values[4]);
                            if (this.includeRank && StringUtils.isNotEmpty((String)tcDTO.getGuid())) {
                                tcDTO.setRank(this.searchUtils.getTaxonSearch(tcDTO.getGuid())[1].split(":")[0]);
                            }
                        }
                    } else {
                        if (logger.isDebugEnabled()) {
                            logger.debug((Object)("The values length: " + values.length + " :" + name));
                        }
                        tcDTO = new TaxaCountDTO(name, count);
                    }
                    if (tcDTO != null && tcDTO.getCount() > 0L) {
                        this.write(tcDTO);
                    }
                } else if (this.isCommonNameAndLSID) {
                    values = this.pattern.split(name, 6);
                    if (values.length >= 5) {
                        if (!"|||||".equals(name)) {
                            tcDTO = new TaxaCountDTO(values[1], count);
                            tcDTO.setGuid(StringUtils.trimToNull((String)values[2]));
                            tcDTO.setCommonName("null".equals(values[0]) ? "" : values[0]);
                            tcDTO.setKingdom(values[values.length - 2]);
                            tcDTO.setFamily(values[values.length - 1]);
                            if (this.includeRank && StringUtils.isNotEmpty((String)tcDTO.getGuid())) {
                                tcDTO.setRank(this.searchUtils.getTaxonSearch(tcDTO.getGuid())[1].split(":")[0]);
                            }
                        }
                    } else {
                        if (logger.isDebugEnabled()) {
                            logger.debug((Object)("The values length: " + values.length + " :" + name));
                        }
                        tcDTO = new TaxaCountDTO(name, count);
                    }
                    if (tcDTO != null && tcDTO.getCount() > 0L) {
                        this.write(tcDTO);
                    }
                }
            }
            catch (Exception e) {
                logger.error((Object)e);
            }
        }
        ++this.recordCount;
        return true;
    }

    public boolean flush() {
        try {
            this.jsonGenerator.writeEndArray();
            this.jsonGenerator.flush();
        }
        catch (Exception e) {
            logger.error((Object)"cannot finish writing JSON", (Throwable)e);
        }
        return true;
    }

    void initWriter() {
        try {
            JsonFactory jsonFactory = new JsonFactory();
            this.jsonGenerator = jsonFactory.createGenerator(this.outputStream, JsonEncoding.UTF8);
            this.jsonGenerator.setCodec((ObjectCodec)new ObjectMapper());
            this.jsonGenerator.writeStartArray();
        }
        catch (Exception e) {
            logger.error((Object)"cannot output JSON", (Throwable)e);
        }
    }

    void write(TaxaCountDTO d) throws IOException {
        this.jsonGenerator.writeObject((Object)d);
    }
}

