/*
 * Decompiled with CFR 0.152.
 */
package au.org.ala.biocache.stream;

import au.com.bytecode.opencsv.CSVWriter;
import au.org.ala.biocache.dao.SearchDAOImpl;
import au.org.ala.biocache.dto.SpatialSearchRequestDTO;
import au.org.ala.biocache.dto.TaxaCountDTO;
import au.org.ala.biocache.stream.StreamTaxaCount;
import au.org.ala.biocache.util.SearchUtils;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import org.apache.log4j.Logger;

public class StreamTaxaAsTSVCircle
extends StreamTaxaCount {
    private static final Logger logger = Logger.getLogger(StreamTaxaAsTSVCircle.class);
    CSVWriter csvWriter;

    public StreamTaxaAsTSVCircle(SearchDAOImpl searchDAO, SearchUtils searchUtils, SpatialSearchRequestDTO request, OutputStream outputStream) {
        super(searchDAO, searchUtils, request, Boolean.valueOf(false), outputStream);
    }

    public boolean flush() {
        try {
            this.csvWriter.flush();
        }
        catch (IOException e) {
            logger.error((Object)e);
        }
        return true;
    }

    void initWriter() {
        try {
            this.csvWriter = new CSVWriter((Writer)new OutputStreamWriter(this.outputStream), '\t', '\"');
        }
        catch (Exception e) {
            logger.error((Object)"cannot init CSV output");
        }
        this.csvWriter.writeNext(new String[]{"Taxon ID", "Kingdom", "Family", "Scientific name", "Common name", "Record count"});
    }

    void write(TaxaCountDTO d) {
        String[] record = new String[]{d.getGuid(), d.getKingdom(), d.getFamily(), d.getName(), d.getCommonName(), d.getCount().toString()};
        this.csvWriter.writeNext(record);
    }
}

