/*
 * Decompiled with CFR 0.152.
 */
package au.org.ala.biocache.stream;

import au.org.ala.biocache.dao.SearchDAOImpl;
import au.org.ala.biocache.dto.SpatialSearchRequestDTO;
import au.org.ala.biocache.stream.ProcessInterface;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.apache.solr.client.solrj.io.Tuple;
import org.springframework.context.support.AbstractMessageSource;

public class ExploreFacet
implements ProcessInterface {
    private static final Logger logger = Logger.getLogger(ExploreFacet.class);
    Map<String, Long> occurrenceCounts;
    SpatialSearchRequestDTO requestParams;
    SearchDAOImpl searchDao;
    AbstractMessageSource messageSource;
    String facetName;

    public ExploreFacet(Map<String, Long> occurrenceCounts, SpatialSearchRequestDTO requestParams, SearchDAOImpl searchDao) {
        this.requestParams = requestParams;
        this.occurrenceCounts = occurrenceCounts;
        this.searchDao = searchDao;
        this.messageSource = searchDao.messageSource;
        this.facetName = requestParams.getFacets()[0];
    }

    public boolean process(Tuple tuple) {
        try {
            long entryCount;
            if (tuple != null && tuple.fieldNames.size() > 0 && (entryCount = tuple.getLong((Object)"count(*)").longValue()) > 0L) {
                String countEntryName = tuple.getString((Object)"name");
                if (StringUtils.isEmpty((String)countEntryName)) {
                    String label = "";
                    if (this.messageSource != null) {
                        label = this.messageSource.getMessage(this.facetName + ".novalue", null, "Not supplied", null);
                    }
                    this.occurrenceCounts.put(label, entryCount);
                } else if (countEntryName.equals("before")) {
                    // empty if block
                }
            }
            return true;
        }
        catch (IllegalArgumentException e) {
            logger.warn((Object)("Failed to convert tuple to OccurrenceIndex: " + e.getMessage()));
            return false;
        }
    }

    public boolean flush() {
        return true;
    }
}

