/*
 * Decompiled with CFR 0.152.
 */
package au.org.ala.biocache.service;

import au.org.ala.biocache.dao.SearchDAO;
import au.org.ala.biocache.dto.SpatialSearchRequestDTO;
import au.org.ala.biocache.dto.SpeciesImageDTO;
import au.org.ala.biocache.dto.SpeciesImagesDTO;
import au.org.ala.biocache.service.RestartDataService;
import au.org.ala.biocache.service.SpeciesImageService;
import au.org.ala.biocache.util.SearchUtils;
import au.org.ala.biocache.util.solr.FieldMappingUtil;
import com.fasterxml.jackson.core.type.TypeReference;
import java.util.Arrays;
import java.util.Map;
import javax.inject.Inject;
import org.apache.log4j.Logger;
import org.apache.solr.client.solrj.response.QueryResponse;
import org.apache.solr.common.util.SimpleOrderedMap;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.context.event.ApplicationReadyEvent;
import org.springframework.context.event.EventListener;
import org.springframework.stereotype.Component;

@Component(value="SpeciesImageService")
public class SpeciesImageService {
    private static final Logger logger = Logger.getLogger(SpeciesImageService.class);
    @Inject
    protected SearchDAO searchDAO;
    @Inject
    protected FieldMappingUtil fieldMappingUtil;
    private Object cacheLock = new Object();
    private SpeciesImagesDTO cache = (SpeciesImagesDTO)RestartDataService.get((Object)this, (String)"cache", (TypeReference)new /* Unavailable Anonymous Inner Class!! */, SpeciesImagesDTO.class);
    private boolean updatingCache = false;
    Thread updateCacheThread;
    @Value(value="${autocomplete.species.images.enabled:true}")
    private Boolean enabled;
    @Value(value="${images.preferredFqs:}")
    private String preferredFqs;
    @Value(value="${images.requiredFqs:}")
    private String requiredFqs;

    private void fillMap(Map<Long, SpeciesImageDTO> map, SpatialSearchRequestDTO params) throws Exception {
        QueryResponse qr = this.searchDAO.searchGroupedFacets(params);
        for (SimpleOrderedMap item : SearchUtils.getList((Object)qr.getResponse(), (Object[])new Object[]{"facets", "lft", "buckets"})) {
            String dataResourceUid = (String)SearchUtils.getVal((Object)item, (Object[])new Object[]{"dataResourceUid", "buckets", 0, 0});
            String imageUrl = (String)SearchUtils.getVal((Object)item, (Object[])new Object[]{"imageID", "buckets", 0, 0});
            SpeciesImageDTO image = new SpeciesImageDTO(dataResourceUid, imageUrl);
            if (item.getVal(1) instanceof Integer) {
                image.setCount(((Integer)item.getVal(1)).longValue());
            } else if (item.getVal(1) instanceof Long) {
                image.setCount(((Long)item.getVal(1)).longValue());
            }
            try {
                if (item.getVal(0) instanceof Integer) {
                    map.put(((Integer)item.getVal(0)).longValue(), image);
                    continue;
                }
                if (!(item.getVal(0) instanceof Long)) continue;
                map.put((Long)item.getVal(0), image);
            }
            catch (Exception exception) {}
        }
    }

    @EventListener(value={ApplicationReadyEvent.class})
    public void init() {
        this.resetCache();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SpeciesImagesDTO getSpeciesImages() {
        if (!this.enabled.booleanValue()) {
            return null;
        }
        if (this.cache.getSpeciesImage() == null) {
            Object object = this.cacheLock;
            synchronized (object) {
                if (!this.updatingCache && this.cache == null) {
                    this.updatingCache = true;
                    this.updateCacheThread.start();
                }
            }
        }
        return this.cache;
    }

    public SpeciesImageDTO get(long left, long right) {
        SpeciesImagesDTO speciesImages = this.getSpeciesImages();
        if (speciesImages == null || speciesImages.getLft() == null) {
            return null;
        }
        long[] lft = speciesImages.getLft();
        SpeciesImageDTO[] images = speciesImages.getSpeciesImage();
        int pos = Arrays.binarySearch(lft, left);
        if (pos < 0) {
            pos = -1 * pos - 1;
        }
        SpeciesImageDTO ret = null;
        if (pos < lft.length && lft[pos] < right) {
            ret = new SpeciesImageDTO(images[pos].getDataResourceUid(), images[pos].getImage());
        }
        long sum = 0L;
        while (pos < lft.length && lft[pos] < right) {
            sum += images[pos++].getCount();
        }
        if (ret != null && sum > 0L) {
            ret.setCount(sum);
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resetCache() {
        Object object = this.cacheLock;
        synchronized (object) {
            if (!this.updatingCache) {
                this.updatingCache = true;
                this.updateCacheThread = new CacheThread(this);
                this.updateCacheThread.start();
            }
        }
    }
}

