/*
 * Decompiled with CFR 0.152.
 */
package au.org.ala.biocache.service;

import au.org.ala.biocache.service.LoggerRestService;
import au.org.ala.biocache.service.LoggerService;
import au.org.ala.biocache.service.RestartDataService;
import com.fasterxml.jackson.core.type.TypeReference;
import io.reactivex.rxjava3.core.Flowable;
import io.reactivex.rxjava3.schedulers.Schedulers;
import io.reactivex.rxjava3.subscribers.DisposableSubscriber;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import org.ala.client.model.LogEventVO;
import org.apache.log4j.Logger;
import org.reactivestreams.Subscriber;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestOperations;

@Component(value="loggerRestService")
public class LoggerRestService
implements LoggerService {
    private static final Logger logger = Logger.getLogger(LoggerRestService.class);
    private List<Map<String, Object>> loggerReasons = (List)RestartDataService.get((Object)this, (String)"loggerReasons", (TypeReference)new /* Unavailable Anonymous Inner Class!! */, ArrayList.class);
    private List<Map<String, Object>> loggerSources = (List)RestartDataService.get((Object)this, (String)"loggerSources", (TypeReference)new /* Unavailable Anonymous Inner Class!! */, ArrayList.class);
    private List<Integer> reasonIds = (List)RestartDataService.get((Object)this, (String)"reasonIds", (TypeReference)new /* Unavailable Anonymous Inner Class!! */, ArrayList.class);
    private List<Integer> sourceIds = (List)RestartDataService.get((Object)this, (String)"sourceIds", (TypeReference)new /* Unavailable Anonymous Inner Class!! */, ArrayList.class);
    private CountDownLatch initialised = new CountDownLatch(1);
    @Value(value="${logger.service.url:https://logger.ala.org.au/service/logger}")
    protected String loggerUriPrefix;
    @Value(value="${caches.log.enabled:true}")
    protected Boolean enabled = null;
    @Value(value="${logger.service.thread.pool:1}")
    protected int loggerThreadPool = 1;
    @Value(value="${logger.service.throttle.delay:0}")
    protected long throttleDelay = 0L;
    @Value(value="${logger.service.queue.size:100}")
    protected int eventQueueSize = 100;
    protected DisposableSubscriber logEventSubscriber;
    private BlockingQueue<LogEventVO> eventQueue;
    @Inject
    private RestOperations restTemplate;

    public List<Map<String, Object>> getReasons() {
        this.isReady();
        return this.loggerReasons;
    }

    public List<Map<String, Object>> getSources() {
        this.isReady();
        return this.loggerSources;
    }

    public List<Integer> getReasonIds() {
        this.isReady();
        return this.reasonIds;
    }

    public List<Integer> getSourceIds() {
        this.isReady();
        return this.sourceIds;
    }

    public void logEvent(LogEventVO logEvent) {
        try {
            this.eventQueue.put(logEvent);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    public void logEventSync(LogEventVO logEvent) {
        HttpHeaders headers = new HttpHeaders();
        headers.set("User-Agent", logEvent.getUserAgent());
        HttpEntity request = new HttpEntity((Object)logEvent, (MultiValueMap)headers);
        try {
            ResponseEntity response = this.restTemplate.postForEntity(this.loggerUriPrefix, (Object)request, Void.class, new Object[0]);
            if (response.getStatusCode() != HttpStatus.OK) {
                logger.warn((Object)"failed to log event");
            }
        }
        catch (Exception e) {
            logger.warn((Object)"failed to log event", (Throwable)e);
        }
    }

    private void isReady() {
        try {
            this.initialised.await();
        }
        catch (Exception e) {
            logger.error((Object)e);
        }
    }

    @Scheduled(fixedDelay=43200000L)
    public void reloadCache() {
        if (this.loggerReasons.size() > 0) {
            this.initialised.countDown();
        }
        if (this.enabled.booleanValue()) {
            logger.info((Object)"Refreshing the log sources and reasons");
            List list = this.getEntities(LoggerType.reasons);
            if (list.size() > 0) {
                this.loggerReasons = list;
            }
            if ((list = this.getEntities(LoggerType.sources)).size() > 0) {
                this.loggerSources = list;
            }
            if ((list = this.getIdList(this.loggerReasons)).size() > 0) {
                this.reasonIds = list;
            }
            if ((list = this.getIdList(this.loggerSources)).size() > 0) {
                this.sourceIds = list;
            }
        } else if (this.reasonIds == null) {
            logger.info((Object)"Providing some sensible default values for the log cache");
            this.reasonIds = new ArrayList();
            this.sourceIds = new ArrayList();
            for (int i = 0; i < 11; ++i) {
                this.reasonIds.add(i);
                if (i >= 8) continue;
                this.sourceIds.add(i);
            }
        }
        this.initialised.countDown();
    }

    @PostConstruct
    public void init() {
        this.eventQueue = new ArrayBlockingQueue(this.eventQueueSize);
        ExecutorService executor = Executors.newFixedThreadPool(this.loggerThreadPool);
        Flowable backpressureAwarePublisher = Flowable.generate(() -> this.eventQueue, (queue, emitter) -> emitter.onNext((Object)((LogEventVO)queue.take())));
        this.logEventSubscriber = (DisposableSubscriber)backpressureAwarePublisher.subscribeOn(Schedulers.single()).observeOn(Schedulers.from((Executor)executor)).subscribeWith((Subscriber)new /* Unavailable Anonymous Inner Class!! */);
        this.reloadCache();
    }

    @PreDestroy
    void destroy() {
        this.logEventSubscriber.dispose();
    }

    protected List<Integer> getIdList(List<Map<String, Object>> list) {
        ArrayList<Integer> returnList = new ArrayList<Integer>();
        for (Map<String, Object> value : list) {
            returnList.add((Integer)value.get("id"));
        }
        return returnList;
    }

    protected List<Map<String, Object>> getEntities(LoggerType type) {
        List<Map<String, Object>> entities = new ArrayList<Map<String, Object>>();
        try {
            String jsonUri = this.loggerUriPrefix + "/" + type.name();
            logger.info((Object)("Requesting " + type.name() + " via: " + jsonUri));
            entities = (List)this.restTemplate.getForObject(jsonUri, List.class, new Object[0]);
            logger.info((Object)("The values : " + String.valueOf(entities)));
        }
        catch (Exception ex) {
            logger.error((Object)("RestTemplate error: " + ex.getMessage()), (Throwable)ex);
        }
        return entities;
    }
}

