/*
 * Decompiled with CFR 0.152.
 */
package au.org.ala.biocache.service;

import au.org.ala.biocache.dto.Kvp;
import au.org.ala.biocache.service.DownloadService;
import au.org.ala.biocache.service.ListsService;
import au.org.ala.biocache.service.RestartDataService;
import au.org.ala.biocache.util.SearchUtils;
import com.fasterxml.jackson.core.type.TypeReference;
import java.lang.invoke.CallSite;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;
import org.springframework.web.client.RestOperations;

@Component(value="listsService")
public class ListsService {
    private static final Logger logger = Logger.getLogger(DownloadService.class);
    @Inject
    protected RestOperations restTemplate;
    @Inject
    protected SearchUtils searchUtils;
    @Value(value="${list.tool.lookup.enabled:true}")
    private Boolean enabled;
    @Value(value="${list.tool.url:https://lists.ala.org.au}")
    private String speciesListUrl;
    private Map<String, Map<String, Set<String>>> data = (Map)RestartDataService.get((Object)this, (String)"data", (TypeReference)new /* Unavailable Anonymous Inner Class!! */, HashMap.class);
    private CountDownLatch wait = new CountDownLatch(1);

    @PostConstruct
    private void init() {
    }

    public Map<String, Map<String, Set<String>>> getValues() {
        try {
            this.wait.await();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return this.data;
    }

    @Scheduled(fixedDelay=43200000L)
    public void refreshCache() {
        if (this.data.size() > 0) {
            this.wait.countDown();
        }
        if (this.enabled.booleanValue() && StringUtils.isNotBlank((String)this.speciesListUrl)) {
            new /* Unavailable Anonymous Inner Class!! */.start();
        } else {
            this.wait.countDown();
        }
    }

    private Map<String, Set<String>> getItemsMap(Map speciesLists, boolean conservationList) throws Exception {
        List ja = (List)speciesLists.get("lists");
        HashMap<String, Set<String>> map = new HashMap<String, Set<String>>();
        for (int i = 0; i < ja.size(); ++i) {
            String name = ((Map)ja.get(i)).get("listName").toString();
            String dr = ((Map)ja.get(i)).get("dataResourceUid").toString();
            List items = this.getListItems(dr, Boolean.valueOf(conservationList));
            for (SpeciesListItemDTO item : items) {
                HashSet<CallSite> existing = (HashSet<CallSite>)map.get(item.lsid);
                if (existing == null) {
                    existing = new HashSet<CallSite>();
                }
                Object status = "";
                if (item.kvpValues != null) {
                    for (SpeciesListItemDTO.KvpDTO m : item.kvpValues) {
                        if (m.key == null || !"status".equalsIgnoreCase(m.key)) continue;
                        status = ": " + m.value;
                    }
                }
                existing.add((CallSite)((Object)(name + (String)status)));
                map.put(item.lsid, existing);
            }
        }
        return map;
    }

    @Cacheable(value={"speciesListItems"})
    public List<SpeciesListItemDTO> getListItems(String dataResourceUid, Boolean includeKvp) throws Exception {
        ArrayList<SpeciesListItemDTO> list = new ArrayList<SpeciesListItemDTO>();
        boolean hasAnotherPage = true;
        int max = 400;
        int offset = 0;
        while (hasAnotherPage) {
            List speciesListItems = (List)this.restTemplate.getForObject(new URI(this.speciesListUrl + "/ws/speciesListItems/" + dataResourceUid + "?max=" + max + "&offset=" + offset + "&includeKVP=" + includeKvp), SpeciesListItemsDTO.class);
            offset += max;
            hasAnotherPage = speciesListItems.size() == max;
            for (SpeciesListItemDTO s : speciesListItems) {
                if (s.lsid == null) continue;
                list.add(s);
            }
        }
        return list;
    }

    @Cacheable(value={"speciesKvp"})
    public List<Kvp> getKvp(String dataResourceUid) {
        ArrayList<Kvp> list = new ArrayList<Kvp>();
        boolean hasAnotherPage = true;
        int max = 400;
        int offset = 0;
        try {
            while (hasAnotherPage) {
                SpeciesListItemsDTO speciesListItems = (SpeciesListItemsDTO)this.restTemplate.getForObject(new URI(this.speciesListUrl + "/ws/speciesListItems/" + dataResourceUid + "?includeKVP=true&max=" + max + "&offset=" + offset), SpeciesListItemsDTO.class);
                offset += max;
                hasAnotherPage = speciesListItems.size() == max;
                for (SpeciesListItemDTO item : speciesListItems) {
                    String fq;
                    if (item.lsid == null || !(fq = this.searchUtils.getTaxonSearch(item.lsid)[0]).startsWith("lft:[")) continue;
                    ArrayList<String> keys = new ArrayList<String>();
                    ArrayList<String> values = new ArrayList<String>();
                    for (SpeciesListItemDTO.KvpDTO kvp : item.kvpValues) {
                        keys.add(kvp.key);
                        values.add(kvp.value);
                    }
                    long lft = Long.parseLong(fq.replaceAll("(.*\\[| TO.*)", ""));
                    long rgt = Long.parseLong(fq.replaceAll("(.*TO |\\].*)", ""));
                    Kvp kvp = new Kvp(lft, rgt, keys, values);
                    list.add(kvp);
                }
            }
        }
        catch (Exception e) {
            logger.error((Object)("failed to get species list kvp for list: " + dataResourceUid), (Throwable)e);
        }
        if (list.size() > 0) {
            list.sort(Kvp.KvpComparator);
            return list;
        }
        return null;
    }

    public List<String> getTypes() {
        try {
            this.wait.await();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return new ArrayList<String>(this.data.keySet());
    }

    public Set<String> get(String type, String lsid) {
        try {
            this.wait.await();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return (Set)((Map)this.data.get(type)).get(lsid);
    }

    @Cacheable(value={"speciesListItems"})
    public SpeciesListSearchDTO.SpeciesListDTO getListInfo(String dr) throws URISyntaxException {
        SpeciesListSearchDTO.SpeciesListDTO speciesList = (SpeciesListSearchDTO.SpeciesListDTO)this.restTemplate.getForObject(new URI(this.speciesListUrl + "/ws/speciesList/" + dr), SpeciesListSearchDTO.SpeciesListDTO.class);
        return speciesList;
    }

    public List<String> getKvpNames(String dr, List<Kvp> kvps) {
        ArrayList<String> names = new ArrayList<String>();
        try {
            SpeciesListSearchDTO.SpeciesListDTO listInfo = this.getListInfo(dr);
            if (kvps != null && kvps.size() > 0) {
                for (String key : kvps.get((int)0).keys) {
                    names.add(listInfo.listName + " - " + key);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return names;
    }

    public List<String> getKvpFields(String dr, List<Kvp> kvps) {
        ArrayList<String> fields = new ArrayList<String>();
        if (kvps != null && kvps.size() > 0) {
            int keyIdx = 0;
            for (String key : kvps.get((int)0).keys) {
                fields.add(dr + "." + keyIdx);
                ++keyIdx;
            }
        }
        return fields;
    }

    public String getKvpValue(int idx, List<Kvp> kvps, Kvp lftrgt) {
        Kvp kvp;
        String value = "";
        if (kvps != null && kvps.size() > idx && (kvp = this.find(kvps, lftrgt)) != null) {
            value = (String)kvp.values.get(idx);
        }
        return value;
    }

    public Kvp find(List<Kvp> kvps, Kvp lftrgt) {
        int idx = Collections.binarySearch(kvps, lftrgt, Kvp.KvpComparator);
        if (idx >= 0) {
            return kvps.get(idx);
        }
        for (idx = Math.min(idx * -1, kvps.size() - 1); idx >= 0; --idx) {
            if (!kvps.get(idx).contains(lftrgt)) continue;
            return kvps.get(idx);
        }
        return null;
    }
}

