/*
 * Decompiled with CFR 0.152.
 */
package au.org.ala.biocache.service;

import jakarta.mail.Address;
import jakarta.mail.Message;
import jakarta.mail.Session;
import jakarta.mail.Transport;
import jakarta.mail.internet.InternetAddress;
import jakarta.mail.internet.MimeMessage;
import java.util.Date;
import java.util.Properties;
import javax.annotation.PostConstruct;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component(value="emailService")
public class EmailService {
    @Value(value="${email.sender:support@ala.org.au}")
    private String sender;
    private static final Logger logger = Logger.getLogger(EmailService.class);
    private Properties properties = new Properties();
    @Value(value="${mail.smtp.host:localhost}")
    private String host;
    @Value(value="${mail.smtp.port:25}")
    private String port;
    @Value(value="${mail.smtp.starttls.enable:false}")
    private boolean starttls;
    @Value(value="${mail.smtp.username:}")
    private String username;
    @Value(value="${mail.smtp.password:}")
    private String password;

    @PostConstruct
    protected void init() {
        this.properties.put("mail.smtp.host", this.host);
        this.properties.put("mail.smtp.port", this.port);
        this.properties.put("mail.smtp.starttls.enable", (Object)this.starttls);
    }

    public void sendEmail(String recipient, String copy, String subject, String content, String sender) {
        logger.debug((Object)("Send email to : " + recipient));
        Session session = Session.getDefaultInstance((Properties)this.properties);
        try {
            MimeMessage message = new MimeMessage(session);
            message.setFrom((Address)new InternetAddress(sender));
            message.setSentDate(new Date());
            message.addRecipient(Message.RecipientType.TO, (Address)new InternetAddress(recipient));
            if (copy != null) {
                message.addRecipient(Message.RecipientType.CC, (Address)new InternetAddress(copy));
            }
            message.setSubject(subject);
            message.setContent((Object)content, "text/html");
            if (StringUtils.isNotBlank((CharSequence)this.username)) {
                Transport.send((Message)message, (String)this.username, (String)this.password);
            } else {
                Transport.send((Message)message);
            }
        }
        catch (Exception e) {
            logger.error((Object)("Unable to send email to " + recipient + ".\n" + content), (Throwable)e);
        }
    }

    public void sendEmail(String recipient, String subject, String content) {
        this.sendEmail(recipient, null, subject, content, this.sender);
    }

    public void sendEmail(String recipient, String copy, String subject, String content) {
        this.sendEmail(recipient, copy, subject, content, this.sender);
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public String getPort() {
        return this.port;
    }

    public void setPort(String port) {
        this.port = port;
    }

    public String getSender() {
        return this.sender;
    }

    public void setSender(String sender) {
        this.sender = sender;
    }

    public boolean getStarttls() {
        return this.starttls;
    }

    public void setStarttls(boolean starttls) {
        this.starttls = starttls;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }
}

