/*
 * Decompiled with CFR 0.152.
 */
package au.org.ala.biocache.service;

import au.org.ala.biocache.dto.DownloadRequestDTO;
import au.org.ala.biocache.service.AuthService;
import au.org.ala.biocache.util.AlaUnvalidatedProfile;
import au.org.ala.ws.security.profile.AlaUserProfile;
import au.org.ala.ws.tokens.TokenService;
import jakarta.mail.internet.AddressException;
import jakarta.mail.internet.InternetAddress;
import java.security.Principal;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import javax.inject.Inject;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringUtils;
import org.ehcache.core.EhcacheManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.stereotype.Component;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestOperations;

@Component(value="authService")
public class AuthServiceImpl
implements AuthService {
    private static final Logger log = LoggerFactory.getLogger(AuthServiceImpl.class);
    private static final org.apache.log4j.Logger logger = org.apache.log4j.Logger.getLogger(AuthServiceImpl.class);
    @Inject
    protected RestOperations restTemplate;
    @Value(value="${auth.user.details.url:}")
    protected String userDetailsUrl = null;
    @Value(value="${caches.auth.enabled:true}")
    protected Boolean enabled = true;
    @Value(value="${auth.legacy.emailonly.downloads.enabled:true}")
    protected Boolean emailOnlyEnabled = true;
    EhcacheManager ehCacheManager;
    @Inject
    private TokenService tokenService;

    public String substituteEmailAddress(String raw) {
        return raw == null ? raw : raw.replaceAll("\\@\\w+", "@..");
    }

    private Map<String, ?> getUserByEmailOrId(String emailOrId) {
        Map userDetails = new HashMap();
        if (StringUtils.isNotBlank((String)this.userDetailsUrl)) {
            try {
                String jsonUri = this.userDetailsUrl + "getUserDetails?userName=" + emailOrId;
                logger.info((Object)("authCache requesting: " + jsonUri));
                HttpHeaders requestHeaders = new HttpHeaders();
                requestHeaders.set("Authorization", this.tokenService.getAuthToken(false).toAuthorizationHeader());
                HttpEntity request = new HttpEntity(null, (MultiValueMap)requestHeaders);
                userDetails = (Map)this.restTemplate.postForObject(jsonUri, (Object)request, Map.class, new Object[0]);
            }
            catch (Exception e) {
                logger.error((Object)("Failed to get user details: " + e.getMessage()));
            }
        }
        return userDetails;
    }

    public Optional<AlaUserProfile> getDownloadUser(DownloadRequestDTO downloadRequestDTO, HttpServletRequest request) {
        Principal userPrincipal = request.getUserPrincipal();
        if (userPrincipal != null && userPrincipal instanceof AlaUserProfile) {
            return Optional.of((AlaUserProfile)userPrincipal);
        }
        if (this.emailOnlyEnabled.booleanValue() && downloadRequestDTO.getEmail() != null) {
            try {
                new InternetAddress(downloadRequestDTO.getEmail()).validate();
                return this.lookupAuthUser(downloadRequestDTO.getEmail(), false);
            }
            catch (AddressException e) {
                logger.info((Object)("Email only download request failed - invalid email " + downloadRequestDTO.getEmail()));
            }
        } else if (!this.emailOnlyEnabled.booleanValue() && downloadRequestDTO.getEmail() != null) {
            return Optional.of(new AlaUnvalidatedProfile(downloadRequestDTO.getEmail()));
        }
        return Optional.empty();
    }

    public Optional<AlaUserProfile> getRecordViewUser(HttpServletRequest request) {
        Principal userPrincipal = request.getUserPrincipal();
        if (userPrincipal != null && userPrincipal instanceof AlaUserProfile) {
            return Optional.of((AlaUserProfile)userPrincipal);
        }
        return Optional.empty();
    }

    @Cacheable(value={"lookupAuthUser"})
    public Optional<AlaUserProfile> lookupAuthUser(String userIdOrEmail, boolean getRoles) {
        Map userDetails = this.getUserByEmailOrId(userIdOrEmail);
        if (userDetails == null || userDetails.isEmpty()) {
            return Optional.empty();
        }
        String userId = userDetails.getOrDefault("userid", userDetails.getOrDefault("userId", null));
        boolean activated = userDetails.getOrDefault("activated", false);
        boolean locked = userDetails.getOrDefault("locked", true);
        String firstName = userDetails.getOrDefault("firstName", "");
        String lastName = userDetails.getOrDefault("lastName", "");
        String email = userDetails.getOrDefault("email", "");
        HashSet userRoles = new HashSet(Collections.emptySet());
        if (getRoles) {
            userRoles.addAll(userDetails.getOrDefault("roles", Collections.EMPTY_LIST));
        }
        if (email != null && activated && !locked) {
            return Optional.of(new /* Unavailable Anonymous Inner Class!! */);
        }
        log.info("Download request with API key failed - email  " + email + " , activated " + activated + " , locked " + locked);
        return Optional.empty();
    }
}

