/*
 * Decompiled with CFR 0.152.
 */
package au.org.ala.biocache.dto;

import au.org.ala.biocache.dto.FacetThemes;
import au.org.ala.biocache.dto.OccurrenceIndex;
import au.org.ala.biocache.util.converter.FqField;
import au.org.ala.biocache.validate.ValidSpatialParams;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.ArrayList;
import java.util.List;
import javax.validation.constraints.Pattern;

@Schema(name="Spatial search parameters")
@ValidSpatialParams
public class SpatialSearchRequestParams {
    @Parameter(name="q", description="Main search query. Examples 'q=Kangaroo' or 'q=vernacularName:red'")
    protected String q = "*:*";
    @FqField
    @Parameter(name="fq", description="Filter queries. Examples 'fq=state:Victoria&fq=state:Queensland")
    protected String[] fq = new String[0];
    @Parameter(name="qId", description="Query ID for persisted queries")
    protected Long qId = null;
    @Parameter(name="fl", description="Fields to return in the search response. Optional")
    protected String fl = OccurrenceIndex.defaultFields;
    @Parameter(name="facets", description="The facets to be included by the search")
    protected String[] facets = FacetThemes.getAllFacetsLimited();
    @Parameter(name="flimit", description="The limit for the number of facet values to return")
    protected Integer flimit = 30;
    @Parameter(name="fsort", description="The sort order in which to return the facets.  Either 'count' or 'index'")
    protected String fsort = "";
    @Parameter(name="foffset", description="The offset of facets to return.  Used in conjunction to flimit")
    protected Integer foffset = 0;
    @Parameter(name="fprefix", description="The prefix to limit facet values")
    protected String fprefix = "";
    @Parameter(name="start", description="Paging start index")
    protected Integer start;
    @Parameter(name="startIndex", description="Deprecated  - Paging start index", deprecated=true)
    protected Integer startIndex;
    @Parameter(name="pageSize", description="The prefix to limit facet values")
    protected Integer pageSize = 10;
    @Parameter(name="sort", description="The sort field to use")
    protected String sort = "score";
    @Parameter(name="dir", description="Direction of sort")
    @Pattern(regexp="(asc|desc)")
    protected @Pattern(regexp="(asc|desc)") String dir = "asc";
    @Parameter(name="includeMultivalues", description="Include multi values")
    protected Boolean includeMultivalues = false;
    protected Boolean includeUnfilteredFacetValues = false;
    @Parameter(name="qc", description="The query context to be used for the search. This will be used to generate extra query filters.")
    protected String qc = "";
    @Parameter(name="facet", description="Enable/disable facets")
    protected Boolean facet = FacetThemes.getFacetDefault();
    @Parameter(name="qualityProfile", description="The quality profile to use, null for default")
    protected String qualityProfile;
    @Parameter(name="disableAllQualityFilters", description="Disable all default filters")
    protected boolean disableAllQualityFilters = false;
    @Parameter(name="disableQualityFilter", description="Default filters to disable (currently can only disable on category, so it's a list of disabled category name)")
    protected List<String> disableQualityFilter = new ArrayList();
    @Parameter(name="radius", description="Radius for a spatial search")
    protected Float radius = null;
    @Parameter(name="lat", description="Decimal latitude for the spatial search")
    protected Float lat = null;
    @Parameter(name="lon", description="Decimal longitude for the spatial search")
    protected Float lon = null;
    @Parameter(name="wkt", description="Well Known Text for the spatial search")
    protected String wkt = "";

    public String getQ() {
        return this.q;
    }

    public String[] getFq() {
        return this.fq;
    }

    public Long getQId() {
        return this.qId;
    }

    public String getFl() {
        return this.fl;
    }

    public String[] getFacets() {
        return this.facets;
    }

    public Integer getFlimit() {
        return this.flimit;
    }

    public String getFsort() {
        return this.fsort;
    }

    public Integer getFoffset() {
        return this.foffset;
    }

    public String getFprefix() {
        return this.fprefix;
    }

    public Integer getStart() {
        return this.start;
    }

    public Integer getStartIndex() {
        return this.startIndex;
    }

    public Integer getPageSize() {
        return this.pageSize;
    }

    public String getSort() {
        return this.sort;
    }

    public String getDir() {
        return this.dir;
    }

    public Boolean getIncludeMultivalues() {
        return this.includeMultivalues;
    }

    public Boolean getIncludeUnfilteredFacetValues() {
        return this.includeUnfilteredFacetValues;
    }

    public String getQc() {
        return this.qc;
    }

    public Boolean getFacet() {
        return this.facet;
    }

    public String getQualityProfile() {
        return this.qualityProfile;
    }

    public boolean isDisableAllQualityFilters() {
        return this.disableAllQualityFilters;
    }

    public List<String> getDisableQualityFilter() {
        return this.disableQualityFilter;
    }

    public Float getRadius() {
        return this.radius;
    }

    public Float getLat() {
        return this.lat;
    }

    public Float getLon() {
        return this.lon;
    }

    public String getWkt() {
        return this.wkt;
    }

    public void setQ(String q) {
        this.q = q;
    }

    public void setFq(String[] fq) {
        this.fq = fq;
    }

    public void setQId(Long qId) {
        this.qId = qId;
    }

    public void setFl(String fl) {
        this.fl = fl;
    }

    public void setFacets(String[] facets) {
        this.facets = facets;
    }

    public void setFlimit(Integer flimit) {
        this.flimit = flimit;
    }

    public void setFsort(String fsort) {
        this.fsort = fsort;
    }

    public void setFoffset(Integer foffset) {
        this.foffset = foffset;
    }

    public void setFprefix(String fprefix) {
        this.fprefix = fprefix;
    }

    public void setStart(Integer start) {
        this.start = start;
    }

    public void setStartIndex(Integer startIndex) {
        this.startIndex = startIndex;
    }

    public void setPageSize(Integer pageSize) {
        this.pageSize = pageSize;
    }

    public void setSort(String sort) {
        this.sort = sort;
    }

    public void setDir(String dir) {
        this.dir = dir;
    }

    public void setIncludeMultivalues(Boolean includeMultivalues) {
        this.includeMultivalues = includeMultivalues;
    }

    public void setIncludeUnfilteredFacetValues(Boolean includeUnfilteredFacetValues) {
        this.includeUnfilteredFacetValues = includeUnfilteredFacetValues;
    }

    public void setQc(String qc) {
        this.qc = qc;
    }

    public void setFacet(Boolean facet) {
        this.facet = facet;
    }

    public void setQualityProfile(String qualityProfile) {
        this.qualityProfile = qualityProfile;
    }

    public void setDisableAllQualityFilters(boolean disableAllQualityFilters) {
        this.disableAllQualityFilters = disableAllQualityFilters;
    }

    public void setDisableQualityFilter(List<String> disableQualityFilter) {
        this.disableQualityFilter = disableQualityFilter;
    }

    public void setRadius(Float radius) {
        this.radius = radius;
    }

    public void setLat(Float lat) {
        this.lat = lat;
    }

    public void setLon(Float lon) {
        this.lon = lon;
    }

    public void setWkt(String wkt) {
        this.wkt = wkt;
    }
}

