/*
 * Decompiled with CFR 0.152.
 */
package au.org.ala.biocache.dto;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonIgnore;
import io.swagger.v3.oas.annotations.media.Schema;
import java.lang.reflect.Field;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.time.DateFormatUtils;
import org.apache.log4j.Logger;
import org.codehaus.jackson.map.ObjectMapper;

@Schema(name="OccurrenceIndex", description="Represents a single record search result")
public class OccurrenceIndex {
    public static final String MISC = "dynamicProperties";
    protected static final Logger logger = Logger.getLogger(OccurrenceIndex.class);
    public static final String COUNTRY = "country";
    public static final String STATE = "stateProvince";
    public static final String PROVENANCE = "provenance";
    public static final String OCCURRENCE_YEAR_INDEX_FIELD = "occurrenceYear";
    public static final String TAXON_NAME = "scientificName";
    public static final String RAW_TAXON_NAME = "raw_scientificName";
    public static final String RAW_RECORDED_BY = "raw_recordedBy";
    public static final String TAXON_RANK = "taxonRank";
    public static final String LATITUDE = "decimalLatitude";
    public static final String LONGITUDE = "decimalLongitude";
    public static final String DATA_RESOURCE_NAME = "dataResourceName";
    public static final String COORDINATE_UNCERTAINTY = "coordinateUncertaintyInMeters";
    public static final String COMMON_NAME = "vernacularName";
    public static final String STATE_CONSERVATION = "stateConservation";
    public static final String RAW_STATE_CONSERVATION = "raw_stateConservation";
    public static final String YEAR = "year";
    public static final String BASIS_OF_RECORD = "basisOfRecord";
    public static final String TYPE_STATUS = "typeStatus";
    public static final String MULTIMEDIA = "multimedia";
    public static final String COLLECTOR = "recordedBy";
    public static final String OCCURRENCE_STATUS = "occurrenceStatus";
    public static final String ALA_USER_ID = "userId";
    public static final String ASSERTION_USER_ID = "assertionUserId";
    public static final String OUTLIER_LAYER = "outlierLayer";
    public static final String OUTLIER_LAYER_COUNT = "outlierLayerCount";
    public static final String TAXONOMIC_ISSUE = "taxonomicIssues";
    public static final String OCCURRENCE_DATE = "eventDate";
    public static final String RECORD_NUMBER = "recordNumber";
    public static final String CATALOGUE_NUMBER = "catalogNumber";
    public static final String COORDINATE_PRECISION = "coordinatePrecision";
    public static final String TAXON_RANK_ID = "taxonRankID";
    public static final String TAXON_CONCEPT_ID = "taxonConceptID";
    public static final String SPECIESID = "speciesID";
    public static final String GENUSID = "genusID";
    public static final String DATA_HUB_UID = "dataHubUid";
    public static final String COLLECTION_UID = "collectionUid";
    public static final String INSTITUTION_UID = "institutionUid";
    public static final String DATA_PROVIDER_UID = "dataProviderUid";
    public static final String DATA_RESOURCE_UID = "dataResourceUid";
    public static final String LICENSE = "license";
    public static final String LOCALITY = "locality";
    public static final String BIOME = "biome";
    @org.apache.solr.client.solrj.beans.Field(value="id")
    @Schema(description="Atlas persistent UUID for this record")
    String uuid;
    @org.apache.solr.client.solrj.beans.Field(value="occurrenceID")
    @Schema(description="http://rs.tdwg.org/dwc/terms/occurrenceID")
    String occurrenceID;
    @org.apache.solr.client.solrj.beans.Field(value="dataHubUid")
    @Schema(description="UIDs of the associated data hubs")
    String[] dataHubUid;
    @org.apache.solr.client.solrj.beans.Field(value="dataHubName")
    @Schema(description="Names of the associated data hubs")
    String[] dataHub;
    @org.apache.solr.client.solrj.beans.Field(value="institutionUid")
    @Schema(description="Atlas ID for this Institution")
    String institutionUid;
    @org.apache.solr.client.solrj.beans.Field(value="institutionCode")
    @Schema(description="http://rs.tdwg.org/dwc/terms/institutionCode")
    String raw_institutionCode;
    @org.apache.solr.client.solrj.beans.Field(value="institutionName")
    @Schema(description="Institution name")
    String institutionName;
    @org.apache.solr.client.solrj.beans.Field(value="collectionCode")
    @Schema(description="http://rs.tdwg.org/dwc/terms/collectionCode")
    String raw_collectionCode;
    @org.apache.solr.client.solrj.beans.Field(value="collectionUid")
    @Schema(description="Atlas ID for this Collection")
    String collectionUid;
    @org.apache.solr.client.solrj.beans.Field(value="collectionName")
    @Schema(description="Collection name")
    String collectionName;
    @org.apache.solr.client.solrj.beans.Field(value="catalogNumber")
    @Schema(description="http://rs.tdwg.org/dwc/terms/catalogNumber")
    String raw_catalogNumber;
    @org.apache.solr.client.solrj.beans.Field(value="taxonConceptID")
    @Schema(description="http://rs.tdwg.org/dwc/terms/taxonConceptID")
    String taxonConceptID;
    @org.apache.solr.client.solrj.beans.Field(value="eventDate")
    @JsonFormat(shape=JsonFormat.Shape.NUMBER)
    @Schema(description="Event date in unix time format")
    Date eventDate;
    @org.apache.solr.client.solrj.beans.Field(value="eventDateEnd")
    @JsonFormat(shape=JsonFormat.Shape.NUMBER)
    @Schema(description="Event date end in unix time format")
    Date eventDateEnd;
    @org.apache.solr.client.solrj.beans.Field(value="scientificName")
    @Schema(description="http://rs.tdwg.org/dwc/terms/scientificName")
    String scientificName;
    @org.apache.solr.client.solrj.beans.Field(value="vernacularName")
    @Schema(description="http://rs.tdwg.org/dwc/terms/vernacularName")
    String vernacularName;
    @org.apache.solr.client.solrj.beans.Field(value="taxonRank")
    @Schema(description="http://rs.tdwg.org/dwc/terms/taxonRank")
    String taxonRank;
    @org.apache.solr.client.solrj.beans.Field(value="taxonRankID")
    @Schema(description="http://rs.tdwg.org/dwc/terms/taxonRankID")
    Integer taxonRankID;
    @org.apache.solr.client.solrj.beans.Field(value="raw_countryCode")
    @Schema(description="http://rs.tdwg.org/dwc/terms/countryCode")
    String raw_countryCode;
    @org.apache.solr.client.solrj.beans.Field(value="country")
    @Schema(description="http://rs.tdwg.org/dwc/terms/country")
    String country;
    @org.apache.solr.client.solrj.beans.Field(value="kingdom")
    @Schema(description="http://rs.tdwg.org/dwc/terms/kingdom")
    String kingdom;
    @org.apache.solr.client.solrj.beans.Field(value="phylum")
    @Schema(description="http://rs.tdwg.org/dwc/terms/phylum")
    String phylum;
    @org.apache.solr.client.solrj.beans.Field(value="class")
    @Schema(description="http://rs.tdwg.org/dwc/terms/class")
    String classs;
    @org.apache.solr.client.solrj.beans.Field(value="order")
    @Schema(description="http://rs.tdwg.org/dwc/terms/order")
    String order;
    @org.apache.solr.client.solrj.beans.Field(value="family")
    @Schema(description="http://rs.tdwg.org/dwc/terms/family")
    String family;
    @org.apache.solr.client.solrj.beans.Field(value="genus")
    @Schema(description="http://rs.tdwg.org/dwc/terms/genus")
    String genus;
    @org.apache.solr.client.solrj.beans.Field(value="genusID")
    String genusGuid;
    @org.apache.solr.client.solrj.beans.Field(value="species")
    @Schema(description="Species name")
    String species;
    @org.apache.solr.client.solrj.beans.Field(value="speciesID")
    @Schema(description="Species ID")
    String speciesGuid;
    @org.apache.solr.client.solrj.beans.Field(value="subspecies")
    String subspecies;
    @org.apache.solr.client.solrj.beans.Field(value="subspeciesID")
    String subspeciesGuid;
    @org.apache.solr.client.solrj.beans.Field(value="stateProvince")
    @Schema(description="http://rs.tdwg.org/dwc/terms/stateProvince")
    String stateProvince;
    @org.apache.solr.client.solrj.beans.Field(value="decimalLatitude")
    @Schema(description="http://rs.tdwg.org/dwc/terms/decimalLatitude")
    Double decimalLatitude;
    @org.apache.solr.client.solrj.beans.Field(value="decimalLongitude")
    @Schema(description="http://rs.tdwg.org/dwc/terms/decimalLongitude")
    Double decimalLongitude;
    @org.apache.solr.client.solrj.beans.Field(value="coordinateUncertaintyInMeters")
    @Schema(description="http://rs.tdwg.org/dwc/terms/coordinateUncertaintyInMeters")
    Double coordinateUncertaintyInMeters;
    @org.apache.solr.client.solrj.beans.Field(value="year")
    @Schema(description="http://rs.tdwg.org/dwc/terms/year")
    Integer year;
    @org.apache.solr.client.solrj.beans.Field(value="month")
    @Schema(description="http://rs.tdwg.org/dwc/terms/month")
    Integer month;
    @org.apache.solr.client.solrj.beans.Field(value="basisOfRecord")
    @Schema(description="http://rs.tdwg.org/dwc/terms/basisOfRecord")
    String basisOfRecord;
    @org.apache.solr.client.solrj.beans.Field(value="typeStatus")
    @Schema(description="http://rs.tdwg.org/dwc/terms/typeStatus")
    String[] typeStatus;
    @org.apache.solr.client.solrj.beans.Field(value="locationRemarks")
    @Schema(description="http://rs.tdwg.org/dwc/terms/locationRemarks")
    String raw_locationRemarks;
    @org.apache.solr.client.solrj.beans.Field(value="occurrenceRemarks")
    @Schema(description="http://rs.tdwg.org/dwc/terms/occurrenceRemarks")
    String raw_occurrenceRemarks;
    @org.apache.solr.client.solrj.beans.Field(value="dataProviderUid")
    String dataProviderUid;
    @org.apache.solr.client.solrj.beans.Field(value="dataProviderName")
    @Schema(description="Data provider name")
    String dataProviderName;
    @org.apache.solr.client.solrj.beans.Field(value="dataResourceUid")
    String dataResourceUid;
    @org.apache.solr.client.solrj.beans.Field(value="dataResourceName")
    @Schema(description="Data resource name")
    String dataResourceName;
    @org.apache.solr.client.solrj.beans.Field(value="assertions")
    @Schema(description="Array of quality assertion flags")
    String[] assertions;
    @org.apache.solr.client.solrj.beans.Field(value="userAssertions")
    String userAssertions;
    @org.apache.solr.client.solrj.beans.Field(value="hasUserAssertions")
    @Schema(description="Indicates if users have supplied assertions for this occurrence")
    Boolean hasUserAssertions;
    @org.apache.solr.client.solrj.beans.Field(value="speciesGroup")
    @Schema(description="Higher leve species groups associated with this taxon e.g. Birds")
    String[] speciesGroups;
    @org.apache.solr.client.solrj.beans.Field(value="imageID")
    String image;
    @org.apache.solr.client.solrj.beans.Field(value="imageIDs")
    @Schema(description="Array of identifiers for images")
    String[] images;
    @org.apache.solr.client.solrj.beans.Field(value="soundIDs")
    @Schema(description="Array of identifiers for sounds")
    String[] sounds;
    @org.apache.solr.client.solrj.beans.Field(value="videoIDs")
    @Schema(description="Array of identifiers for videos")
    String[] videos;
    @org.apache.solr.client.solrj.beans.Field(value="spatiallyValid")
    @Schema(description="Set to false if certain geospatial issues have been identified")
    Boolean spatiallyValid;
    @org.apache.solr.client.solrj.beans.Field(value="recordedBy")
    @Schema(description="http://rs.tdwg.org/dwc/terms/recordedBy")
    String[] recordedBy;
    @org.apache.solr.client.solrj.beans.Field(value="recordedBy")
    @Schema(description="The recordedBy value tokenized into separate agents")
    String[] collectors;
    @org.apache.solr.client.solrj.beans.Field(value="raw_scientificName")
    @Schema(description="http://rs.tdwg.org/dwc/terms/scientificName")
    String raw_scientificName;
    @org.apache.solr.client.solrj.beans.Field(value="raw_basisOfRecord")
    @Schema(description="http://rs.tdwg.org/dwc/terms/basisOfRecord")
    String raw_basisOfRecord;
    @org.apache.solr.client.solrj.beans.Field(value="raw_typeStatus")
    @Schema(description="http://rs.tdwg.org/dwc/terms/typeStatus")
    String raw_typeStatus;
    @org.apache.solr.client.solrj.beans.Field(value="raw_vernacularName")
    @Schema(description="http://rs.tdwg.org/dwc/terms/vernacularName")
    String raw_vernacularName;
    @org.apache.solr.client.solrj.beans.Field(value="multimedia")
    @Schema(description="Array of identifiers for multimedia objects associated with this occurrence")
    String[] multimedia;
    @org.apache.solr.client.solrj.beans.Field(value="license")
    @Schema(description="http://purl.org/dc/elements/1.1/license")
    String license;
    @org.apache.solr.client.solrj.beans.Field(value="identificationVerificationStatus")
    @Schema(description="http://rs.tdwg.org/dwc/terms/identificationVerificationStatus")
    String identificationVerificationStatus;
    @org.apache.solr.client.solrj.beans.Field(value="countryConservation")
    @Schema(description="Country conservation status associated with taxon for this record")
    String countryConservation;
    @org.apache.solr.client.solrj.beans.Field(value="stateConservation")
    @Schema(description="State conservation status associated with taxon for this record")
    String stateConservation;
    @org.apache.solr.client.solrj.beans.Field(value="countryInvasive")
    @Schema(description="Country invasive status associated with taxon for this record")
    String countryInvasive;
    @org.apache.solr.client.solrj.beans.Field(value="stateInvasive")
    @Schema(description="State invasive status associated with taxon for this record")
    String stateInvasive;
    @org.apache.solr.client.solrj.beans.Field(value="sensitive")
    @Schema(description="Sensitive status of this record")
    String sensitive;
    @org.apache.solr.client.solrj.beans.Field(value="recordNumber")
    String recordNumber;
    @org.apache.solr.client.solrj.beans.Field(value="references")
    @Schema(description="http://purl.org/dc/elements/1.1/references")
    String references;
    @org.apache.solr.client.solrj.beans.Field(value="rights")
    @Schema(description="http://purl.org/dc/elements/1.1/rights")
    String rights;
    String gridReference;
    @Schema(description="Metadata for the images associated with this occurrence")
    List<Map<String, Object>> imageMetadata;
    @Schema(description="URL for the first image associated with this record")
    String imageUrl;
    @Schema(description="URL for the first large version of an image associated with this record")
    String largeImageUrl;
    @Schema(description="URL for the first small version of an image associated with this record")
    String smallImageUrl;
    @Schema(description="URL for the first image thumbnail associated with this record")
    String thumbnailUrl;
    @Schema(description="All URLs for the images associated with this record")
    String[] imageUrls;
    Date occurrenceYear;
    @Deprecated
    @org.apache.solr.client.solrj.beans.Field(value="spatiallyValid")
    @Schema(deprecated=true)
    Boolean geospatialKosher;
    @Deprecated
    String taxonomicKosher;
    @Deprecated
    @org.apache.solr.client.solrj.beans.Field(value="lat_long")
    String latLong;
    @Deprecated
    @org.apache.solr.client.solrj.beans.Field(value="point-1")
    String point1;
    @Deprecated
    @org.apache.solr.client.solrj.beans.Field(value="point-0.1")
    String point01;
    @Deprecated
    @org.apache.solr.client.solrj.beans.Field(value="point-0.01")
    String point001;
    @Deprecated
    @org.apache.solr.client.solrj.beans.Field(value="point-0.001")
    String point0001;
    @Deprecated
    @org.apache.solr.client.solrj.beans.Field(value="point-0.0001")
    String point00001;
    @Deprecated
    @org.apache.solr.client.solrj.beans.Field(value="recordedBy")
    String[] collector;
    @Deprecated
    @org.apache.solr.client.solrj.beans.Field(value="references")
    String occurrenceDetails;
    @Deprecated
    String photographer;
    @Deprecated
    @org.apache.solr.client.solrj.beans.Field(value="countryConservation")
    @Schema(deprecated=true)
    String austConservation;
    @Deprecated
    @org.apache.solr.client.solrj.beans.Field(value="names_and_lsid")
    @Schema(deprecated=true)
    String namesLsid;
    @Deprecated
    @org.apache.solr.client.solrj.beans.Field(value="lft")
    @Schema(description="Nested set left value used for taxonomy navigation", deprecated=true)
    Integer left;
    @Deprecated
    @org.apache.solr.client.solrj.beans.Field(value="rgt")
    @Schema(description="Nested set left value used for taxonomy navigation", deprecated=true)
    Integer right;
    @Deprecated
    @org.apache.solr.client.solrj.beans.Field(value="*_s")
    @Schema(deprecated=true)
    Map<String, Object> miscStringProperties;
    @Deprecated
    @org.apache.solr.client.solrj.beans.Field(value="*_i")
    @Schema(deprecated=true)
    Map<String, Object> miscIntProperties;
    @Deprecated
    @org.apache.solr.client.solrj.beans.Field(value="*_d")
    @Schema(deprecated=true)
    Map<String, Object> miscDoubleProperties;
    @Deprecated
    @org.apache.solr.client.solrj.beans.Field(value="*_dt")
    @Schema(deprecated=true)
    Map<String, Object> miscDateProperties;
    @org.apache.solr.client.solrj.beans.Field(value="*")
    Map<String, Object> otherProperties;
    public static final Set<String> ANNOTATED_FIELDS = Collections.newSetFromMap(new ConcurrentHashMap());
    public static final String EVENT_DATE = "eventDate";
    public static final String EVENT_DATE_END = "eventDateEnd";
    public static final String GRID_REFERENCE = "gridReference";
    public static final String DAY = "day";
    public static final String EVENT_ID = "eventID";
    public static final String FOOTPRINT_WKT = "footprintWKT";
    public static final String[] sensitiveSOLRHdr;
    public static final String[] notSensitiveSOLRHdr;
    public static final String CONTAINS_SENSITIVE_PATTERN;
    public static final String NAMES_AND_LSID = "names_and_lsid";
    public static final String COMMON_NAME_AND_LSID = "common_name_and_lsid";
    public static final String DECADE_FACET_NAME = "decade";
    public static final String spatialField = "geohash";
    public static final String spatialFieldWMS = "quad";
    public static final String DUPLICATE_OF = "isDuplicateOf";
    public static final String DUPLICATE_STATUS = "duplicateStatus";
    public static final String DUPLICATE_REASONS = "duplicateType";
    public static final String DUPLICATE_JUSTIFICATION = "duplicateJustification";
    public static final String ID = "id";
    public static final String SPECIES_SUBGROUP = "speciesSubgroup";
    public static final String SPECIES_GROUP = "speciesGroup";
    public static final String IMAGE_URL = "imageID";
    public static final String LAT_LNG = "lat_long";
    public static final String RAW_NAME = "raw_scientificName";
    public static final String LFT = "lft";
    public static final String MONTH = "month";
    public static final String ASSERTIONS = "assertions";
    public static final String SUBSPECIES_NAME = "subspecies";
    public static final String SPECIES = "species";
    public static final String GENUS = "genus";
    public static final String FAMILY = "family";
    public static final String ORDER = "order";
    public static final String CLASS = "class";
    public static final String PHYLUM = "phylum";
    public static final String KINGDOM = "kingdom";
    public static final String SENSITIVE = "sensitive";
    public static final String RGT = "rgt";
    @JsonIgnore
    public static final String defaultFields;

    private void addToMapIfNotNull(Map<String, String> map, String key, String value) {
        if (value != null && value != "") {
            map.put(key, value);
        }
    }

    private String safeDblToString(Double d) {
        if (d != null) {
            return d.toString();
        }
        return null;
    }

    private String safeIntToString(Integer d) {
        if (d != null) {
            return d.toString();
        }
        return null;
    }

    private String arrToString(String[] arr) {
        try {
            if (arr != null) {
                ObjectMapper o = new ObjectMapper();
                return o.writeValueAsString((Object)arr);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    @JsonIgnore
    public Map<String, String> toMap() {
        HashMap<String, String> map = new HashMap<String, String>();
        for (Field f : OccurrenceIndex.class.getDeclaredFields()) {
            org.apache.solr.client.solrj.beans.Field annotation = f.getAnnotation(org.apache.solr.client.solrj.beans.Field.class);
            if (annotation == null || annotation.value().contains("*")) continue;
            try {
                String value = null;
                if (f.getType() == Integer.class) {
                    value = this.safeIntToString((Integer)f.get(this));
                } else if (f.getType() == Double.class) {
                    value = this.safeDblToString((Double)f.get(this));
                } else if (f.getType() == Date.class) {
                    value = DateFormatUtils.format((Date)((Date)f.get(this)), (String)"yyyy-MM-dd");
                } else if (f.getType() == String.class) {
                    value = (String)f.get(this);
                } else if (f.getType() == new String[0].getClass()) {
                    value = this.arrToString((String[])f.get(this));
                } else {
                    logger.error((Object)new Exception("Field type not yet implemented in OccurrenceIndex.toMap: " + f.getType().getName() + " " + f.getName()));
                }
                this.addToMapIfNotNull(map, annotation.value(), value);
            }
            catch (IllegalAccessException e) {
                logger.error((Object)e);
            }
        }
        return map;
    }

    @JsonIgnore
    public Map<String, String> indexToJsonMap() {
        HashMap<String, String> map = new HashMap<String, String>();
        for (Field f : OccurrenceIndex.class.getDeclaredFields()) {
            org.apache.solr.client.solrj.beans.Field annotation = f.getAnnotation(org.apache.solr.client.solrj.beans.Field.class);
            if (annotation == null || annotation.value().contains("*")) continue;
            map.put(annotation.value(), f.getName());
        }
        return map;
    }

    public String getUuid() {
        return this.uuid;
    }

    public void setUuid(String uuid) {
        this.uuid = uuid;
    }

    public String getOccurrenceID() {
        return this.occurrenceID;
    }

    public void setOccurrenceID(String occurrenceID) {
        this.occurrenceID = occurrenceID;
    }

    public String[] getDataHubUid() {
        return this.dataHubUid;
    }

    public void setDataHubUid(String[] dataHubUid) {
        this.dataHubUid = dataHubUid;
    }

    public String[] getDataHub() {
        return this.dataHub;
    }

    public void setDataHub(String[] dataHub) {
        this.dataHub = dataHub;
    }

    public String getInstitutionUid() {
        return this.institutionUid;
    }

    public void setInstitutionUid(String institutionUid) {
        this.institutionUid = institutionUid;
    }

    public String getRaw_institutionCode() {
        return this.raw_institutionCode;
    }

    public void setRaw_institutionCode(String institutionCode) {
        this.raw_institutionCode = institutionCode;
    }

    public String getInstitutionName() {
        return this.institutionName;
    }

    public void setInstitutionName(String institutionName) {
        this.institutionName = institutionName;
    }

    public String getCollectionUid() {
        return this.collectionUid;
    }

    public void setCollectionUid(String collectionUid) {
        this.collectionUid = collectionUid;
    }

    public String getRaw_collectionCode() {
        return this.raw_collectionCode;
    }

    public void setRaw_collectionCode(String collectionCode) {
        this.raw_collectionCode = collectionCode;
    }

    public String getCollectionName() {
        return this.collectionName;
    }

    public void setCollectionName(String collectionName) {
        this.collectionName = collectionName;
    }

    public String getRaw_catalogNumber() {
        return this.raw_catalogNumber;
    }

    public void setRaw_catalogNumber(String catalogNumber) {
        this.raw_catalogNumber = catalogNumber;
    }

    public String getTaxonConceptID() {
        return this.taxonConceptID;
    }

    public void setTaxonConceptID(String taxonConceptID) {
        this.taxonConceptID = taxonConceptID;
    }

    public Date getEventDate() {
        return this.eventDate;
    }

    public void setEventDate(Date eventDate) {
        this.eventDate = eventDate;
    }

    public Date getEventDateEnd() {
        return this.eventDateEnd;
    }

    public void setEventDateEnd(Date eventDateEnd) {
        this.eventDateEnd = eventDateEnd;
    }

    public Date getOccurrenceYear() {
        return this.occurrenceYear;
    }

    public void setOccurrenceYear(Date occurrenceYear) {
        this.occurrenceYear = occurrenceYear;
    }

    public String getScientificName() {
        return this.scientificName;
    }

    public void setScientificName(String scientificName) {
        this.scientificName = scientificName;
    }

    public String getVernacularName() {
        return this.vernacularName;
    }

    public void setVernacularName(String vernacularName) {
        this.vernacularName = vernacularName;
    }

    public String getTaxonRank() {
        return this.taxonRank;
    }

    public void setTaxonRank(String taxonRank) {
        this.taxonRank = taxonRank;
    }

    public Integer getTaxonRankID() {
        return this.taxonRankID;
    }

    public void setTaxonRankID(Integer taxonRankID) {
        this.taxonRankID = taxonRankID;
    }

    public String getRaw_countryCode() {
        return this.raw_countryCode;
    }

    public void setRaw_countryCode(String raw_countryCode) {
        this.raw_countryCode = raw_countryCode;
    }

    public String getCountry() {
        return this.country;
    }

    public void setCountry(String country) {
        this.country = country;
    }

    public String getKingdom() {
        return this.kingdom;
    }

    public void setKingdom(String kingdom) {
        this.kingdom = kingdom;
    }

    public String getPhylum() {
        return this.phylum;
    }

    public void setPhylum(String phylum) {
        this.phylum = phylum;
    }

    public String getClasss() {
        return this.classs;
    }

    public void setClasss(String classs) {
        this.classs = classs;
    }

    public String getOrder() {
        return this.order;
    }

    public void setOrder(String order) {
        this.order = order;
    }

    public String getFamily() {
        return this.family;
    }

    public void setFamily(String family) {
        this.family = family;
    }

    public String getGenus() {
        return this.genus;
    }

    public void setGenus(String genus) {
        this.genus = genus;
    }

    public String getGenusGuid() {
        return this.genusGuid;
    }

    public void setGenusGuid(String genusGuid) {
        this.genusGuid = genusGuid;
    }

    public String getSpecies() {
        return this.species;
    }

    public void setSpecies(String species) {
        this.species = species;
    }

    public String getSpeciesGuid() {
        return this.speciesGuid;
    }

    public void setSpeciesGuid(String speciesGuid) {
        this.speciesGuid = speciesGuid;
    }

    public String getSubspecies() {
        return this.subspecies;
    }

    public void setSubspecies(String subspecies) {
        this.subspecies = subspecies;
    }

    public String getSubspeciesGuid() {
        return this.subspeciesGuid;
    }

    public void setSubspeciesGuid(String subspeciesGuid) {
        this.subspeciesGuid = subspeciesGuid;
    }

    public String getStateProvince() {
        return this.stateProvince;
    }

    public void setStateProvince(String stateProvince) {
        this.stateProvince = stateProvince;
    }

    public Double getDecimalLatitude() {
        return this.decimalLatitude;
    }

    public void setDecimalLatitude(Double decimalLatitude) {
        this.decimalLatitude = decimalLatitude;
    }

    public Double getDecimalLongitude() {
        return this.decimalLongitude;
    }

    public void setDecimalLongitude(Double decimalLongitude) {
        this.decimalLongitude = decimalLongitude;
    }

    public Double getCoordinateUncertaintyInMeters() {
        return this.coordinateUncertaintyInMeters;
    }

    public void setCoordinateUncertaintyInMeters(Double coordinateUncertaintyInMeters) {
        this.coordinateUncertaintyInMeters = coordinateUncertaintyInMeters;
    }

    public Integer getYear() {
        return this.year;
    }

    public void setYear(Integer year) {
        this.year = year;
    }

    public String getMonth() {
        return this.month != null ? String.format("%02d", this.month) : null;
    }

    public void setMonth(String month) {
        this.month = Integer.decode(month);
    }

    public String getBasisOfRecord() {
        return this.basisOfRecord;
    }

    public void setBasisOfRecord(String basisOfRecord) {
        this.basisOfRecord = basisOfRecord;
    }

    public String[] getTypeStatus() {
        return this.typeStatus;
    }

    public void setTypeStatus(String[] typeStatus) {
        this.typeStatus = typeStatus;
    }

    public String getRaw_locationRemarks() {
        return this.raw_locationRemarks;
    }

    public void setRaw_locationRemarks(String locationRemarks) {
        this.raw_locationRemarks = locationRemarks;
    }

    public String getRaw_occurrenceRemarks() {
        return this.raw_occurrenceRemarks;
    }

    public void setRaw_occurrenceRemarks(String occurrenceRemarks) {
        this.raw_occurrenceRemarks = occurrenceRemarks;
    }

    public Integer getLeft() {
        return this.left;
    }

    public void setLeft(Integer left) {
        this.left = left;
    }

    public Integer getRight() {
        return this.right;
    }

    public void setRight(Integer right) {
        this.right = right;
    }

    public String getDataProviderUid() {
        return this.dataProviderUid;
    }

    public void setDataProviderUid(String dataProviderUid) {
        this.dataProviderUid = dataProviderUid;
    }

    public String getDataProviderName() {
        return this.dataProviderName;
    }

    public void setDataProviderName(String dataProviderName) {
        this.dataProviderName = dataProviderName;
    }

    public String getDataResourceUid() {
        return this.dataResourceUid;
    }

    public void setDataResourceUid(String dataResourceUid) {
        this.dataResourceUid = dataResourceUid;
    }

    public String getDataResourceName() {
        return this.dataResourceName;
    }

    public void setDataResourceName(String dataResourceName) {
        this.dataResourceName = dataResourceName;
    }

    public String[] getAssertions() {
        return this.assertions;
    }

    public void setAssertions(String[] assertions) {
        this.assertions = assertions;
    }

    public String getUserAssertions() {
        return this.userAssertions;
    }

    public void setUserAssertions(String userAssertions) {
        this.userAssertions = userAssertions;
    }

    public Boolean getHasUserAssertions() {
        return this.hasUserAssertions;
    }

    public void setHasUserAssertions(Boolean hasUserAssertions) {
        this.hasUserAssertions = hasUserAssertions;
    }

    public String[] getSpeciesGroups() {
        return this.speciesGroups;
    }

    public void setSpeciesGroups(String[] speciesGroups) {
        this.speciesGroups = speciesGroups;
    }

    public String getImage() {
        return this.image;
    }

    public void setImage(String image) {
        this.image = image;
    }

    public String[] getImages() {
        return this.images;
    }

    public void setImages(String[] images) {
        this.images = images;
    }

    public String[] getVideos() {
        return this.videos;
    }

    public void setVideos(String[] videos) {
        this.videos = videos;
    }

    public String[] getSounds() {
        return this.sounds;
    }

    public void setSounds(String[] sounds) {
        this.sounds = sounds;
    }

    public String getGeospatialKosher() {
        return this.geospatialKosher != null ? this.geospatialKosher.toString() : null;
    }

    public void setGeospatialKosher(String geospatialKosher) {
        this.geospatialKosher = Boolean.getBoolean(geospatialKosher);
    }

    public String getTaxonomicKosher() {
        return this.taxonomicKosher;
    }

    public void setTaxonomicKosher(String taxonomicKosher) {
        this.taxonomicKosher = taxonomicKosher;
    }

    public String[] getCollector() {
        return this.collector;
    }

    public void setCollector(String[] collector) {
        this.collector = collector;
    }

    public String getRaw_scientificName() {
        return this.raw_scientificName;
    }

    public void setRaw_scientificName(String raw_scientificName) {
        this.raw_scientificName = raw_scientificName;
    }

    public String getRaw_basisOfRecord() {
        return this.raw_basisOfRecord;
    }

    public void setRaw_basisOfRecord(String raw_basisOfRecord) {
        this.raw_basisOfRecord = raw_basisOfRecord;
    }

    public String getRaw_typeStatus() {
        return this.raw_typeStatus;
    }

    public void setRaw_typeStatus(String raw_typeStatus) {
        this.raw_typeStatus = raw_typeStatus;
    }

    public String getRaw_vernacularName() {
        return this.raw_vernacularName;
    }

    public void setRaw_vernacularName(String raw_vernacularName) {
        this.raw_vernacularName = raw_vernacularName;
    }

    public String getLatLong() {
        return this.latLong;
    }

    public void setLatLong(String latLong) {
        this.latLong = latLong;
    }

    public String getPoint1() {
        return this.point1;
    }

    public void setPoint1(String point1) {
        this.point1 = point1;
    }

    public String getPoint01() {
        return this.point01;
    }

    public void setPoint01(String point01) {
        this.point01 = point01;
    }

    public String getPoint001() {
        return this.point001;
    }

    public void setPoint001(String point001) {
        this.point001 = point001;
    }

    public String getPoint0001() {
        return this.point0001;
    }

    public void setPoint0001(String point0001) {
        this.point0001 = point0001;
    }

    public String getPoint00001() {
        return this.point00001;
    }

    public void setPoint00001(String point00001) {
        this.point00001 = point00001;
    }

    public String getNamesLsid() {
        return this.namesLsid;
    }

    public void setNamesLsid(String namesLsid) {
        this.namesLsid = namesLsid;
    }

    public String[] getMultimedia() {
        return this.multimedia;
    }

    public void setMultimedia(String[] multimedia) {
        this.multimedia = multimedia;
    }

    public String getAustConservation() {
        return this.austConservation;
    }

    public void setAustConservation(String austConservation) {
        this.austConservation = austConservation;
    }

    public String getStateConservation() {
        return this.stateConservation;
    }

    public void setStateConservation(String stateConservation) {
        this.stateConservation = stateConservation;
    }

    public String getSensitive() {
        return this.sensitive;
    }

    public void setSensitive(String sensitive) {
        this.sensitive = sensitive;
    }

    public String[] getCollectors() {
        return this.collectors;
    }

    public void setCollectors(String[] collectors) {
        this.collectors = collectors;
    }

    public String getRecordNumber() {
        return this.recordNumber;
    }

    public void setRecordNumber(String recordNumber) {
        this.recordNumber = recordNumber;
    }

    public String getOccurrenceDetails() {
        return this.occurrenceDetails;
    }

    public void setOccurrenceDetails(String occurrenceDetails) {
        this.occurrenceDetails = occurrenceDetails;
    }

    public String getRights() {
        return this.rights;
    }

    public void setRights(String rights) {
        this.rights = rights;
    }

    public String getPhotographer() {
        return this.photographer;
    }

    public void setPhotographer(String photographer) {
        this.photographer = photographer;
    }

    public List<Map<String, Object>> getImageMetadata() {
        return this.imageMetadata;
    }

    public void setImageMetadata(List<Map<String, Object>> imageMetadata) {
        this.imageMetadata = imageMetadata;
    }

    public Map<String, Object> getMiscStringProperties() {
        return this.miscStringProperties;
    }

    public void setMiscStringProperties(Map<String, Object> miscStringProperties) {
        this.miscStringProperties = miscStringProperties;
    }

    public Map<String, Object> getMiscIntProperties() {
        return this.miscIntProperties;
    }

    public void setMiscIntProperties(Map<String, Object> miscIntProperties) {
        this.miscIntProperties = miscIntProperties;
    }

    public Map<String, Object> getMiscDoubleProperties() {
        return this.miscDoubleProperties;
    }

    public void setMiscDoubleProperties(Map<String, Object> miscDoubleProperties) {
        this.miscDoubleProperties = miscDoubleProperties;
    }

    public String getGridReference() {
        return this.gridReference;
    }

    public void setGridReference(String gridReference) {
        this.gridReference = gridReference;
    }

    public Map<String, Object> getMiscDateProperties() {
        return this.miscDateProperties;
    }

    public void setMiscDateProperties(Map<String, Object> miscDateProperties) {
        this.miscDateProperties = miscDateProperties;
    }

    public String getLicense() {
        return this.license;
    }

    public void setLicense(String license) {
        this.license = license;
    }

    public String getIdentificationVerificationStatus() {
        return this.identificationVerificationStatus;
    }

    public void setIdentificationVerificationStatus(String identificationVerificationStatus) {
        this.identificationVerificationStatus = identificationVerificationStatus;
    }

    public String getImageUrl() {
        return this.imageUrl;
    }

    public void setImageUrl(String imageUrl) {
        this.imageUrl = imageUrl;
    }

    public String getLargeImageUrl() {
        return this.largeImageUrl;
    }

    public void setLargeImageUrl(String largeImageUrl) {
        this.largeImageUrl = largeImageUrl;
    }

    public String getSmallImageUrl() {
        return this.smallImageUrl;
    }

    public void setSmallImageUrl(String smallImageUrl) {
        this.smallImageUrl = smallImageUrl;
    }

    public String getThumbnailUrl() {
        return this.thumbnailUrl;
    }

    public void setThumbnailUrl(String thumbnailUrl) {
        this.thumbnailUrl = thumbnailUrl;
    }

    public String[] getImageUrls() {
        return this.imageUrls;
    }

    public void setImageUrls(String[] imageUrls) {
        this.imageUrls = imageUrls;
    }

    public Boolean getSpatiallyValid() {
        return this.spatiallyValid;
    }

    public void setSpatiallyValid(Boolean spatiallyValid) {
        this.spatiallyValid = spatiallyValid;
    }

    public String[] getRecordedBy() {
        return this.recordedBy;
    }

    public void setRecordedBy(String[] recordedBy) {
        this.recordedBy = recordedBy;
    }

    public String getCountryConservation() {
        return this.countryConservation;
    }

    public void setCountryConservation(String countryConservation) {
        this.countryConservation = countryConservation;
    }

    public String getCountryInvasive() {
        return this.countryInvasive;
    }

    public void setCountryInvasive(String countryInvasive) {
        this.countryInvasive = countryInvasive;
    }

    public String getStateInvasive() {
        return this.stateInvasive;
    }

    public void setStateInvasive(String stateInvasive) {
        this.stateInvasive = stateInvasive;
    }

    public String getReferences() {
        return this.references;
    }

    public void setReferences(String references) {
        this.references = references;
    }

    public Map<String, Object> getOtherProperties() {
        if (this.otherProperties != null) {
            this.otherProperties.entrySet().removeIf(entry -> ANNOTATED_FIELDS.contains(entry.getKey()) || ((String)entry.getKey()).startsWith("sensitive_") || ((String)entry.getKey()).endsWith("_s") || ((String)entry.getKey()).endsWith("_i") || ((String)entry.getKey()).endsWith("_d") || ((String)entry.getKey()).endsWith("_dt"));
            return this.otherProperties.isEmpty() ? null : this.otherProperties;
        }
        return null;
    }

    public void setOtherProperties(Map<String, Object> otherProperties) {
        this.otherProperties = otherProperties;
    }

    static {
        for (Field field : OccurrenceIndex.class.getDeclaredFields()) {
            org.apache.solr.client.solrj.beans.Field annotation = field.getAnnotation(org.apache.solr.client.solrj.beans.Field.class);
            if (annotation == null || annotation.value().contains("*")) continue;
            ANNOTATED_FIELDS.add(annotation.value());
        }
        sensitiveSOLRHdr = new String[]{"sensitive_raw_decimalLongitude", "sensitive_raw_decimalLatitude", "sensitive_decimalLongitude", "sensitive_decimalLatitude", "sensitive_raw_locality", "sensitive_locality", "sensitive_eventDate", "sensitive_eventDateEnd", "sensitive_gridReference", "sensitive_coordinateUncertaintyInMeters", "sensitive_day", "sensitive_eventID", "sensitive_eventTime", "sensitive_footprintWKT", "sensitive_locationRemarks", "sensitive_month", "sensitive_verbatimCoordinates", "sensitive_verbatimEventDate", "sensitive_verbatimLatitude", "sensitive_verbatimLocality", "sensitive_verbatimLongitude"};
        notSensitiveSOLRHdr = new String[]{LONGITUDE, LATITUDE, LOCALITY, "eventDate", EVENT_DATE_END, GRID_REFERENCE, COORDINATE_UNCERTAINTY, DAY, EVENT_ID, FOOTPRINT_WKT};
        CONTAINS_SENSITIVE_PATTERN = ".*(" + StringUtils.join((Object[])sensitiveSOLRHdr, (String)"|") + ").*";
        defaultFields = org.apache.commons.lang3.StringUtils.join(new OccurrenceIndex().indexToJsonMap().keySet(), (String)",");
    }
}

