/*
 * Decompiled with CFR 0.152.
 */
package au.org.ala.biocache.dao;

import au.org.ala.biocache.dao.PersistentQueueDAO;
import au.org.ala.biocache.dto.DownloadDetailsDTO;
import au.org.ala.biocache.dto.DownloadRequestDTO;
import au.org.ala.biocache.util.AlaUserProfileDeserializer;
import au.org.ala.ws.security.profile.AlaUserProfile;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.module.SimpleModule;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Queue;
import java.util.UUID;
import java.util.concurrent.LinkedBlockingQueue;
import javax.annotation.PostConstruct;
import org.apache.commons.io.FileUtils;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component(value="persistentQueueDao")
public class JsonPersistentQueueDAOImpl
implements PersistentQueueDAO {
    private static final Logger logger = Logger.getLogger(JsonPersistentQueueDAOImpl.class);
    @Value(value="${download.cache.dir:/data/cache/downloads}")
    protected String cacheDirectory = "/data/cache/downloads";
    private static final String FILE_PREFIX = "offline";
    @Value(value="${download.dir:/data/biocache-download}")
    protected String biocacheDownloadDir;
    private final ObjectMapper jsonMapper = new ObjectMapper();
    private final Queue<DownloadDetailsDTO> offlineDownloadList = new LinkedBlockingQueue();

    @PostConstruct
    public void init() {
        this.jsonMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        SimpleModule module = new SimpleModule();
        module.addDeserializer(AlaUserProfile.class, (JsonDeserializer)new AlaUserProfileDeserializer());
        this.jsonMapper.registerModule((Module)module);
        File file = new File(this.cacheDirectory);
        try {
            FileUtils.forceMkdir((File)file);
        }
        catch (IOException e) {
            logger.error((Object)"Unable to construct cache directory with correct permissions.", (Throwable)e);
        }
        this.refreshFromPersistent();
    }

    private File getFile(long key) {
        return new File(this.cacheDirectory + File.separator + FILE_PREFIX + key + ".json");
    }

    public void add(DownloadDetailsDTO download) throws IOException {
        File f = this.getFile(download.getStartTime());
        this.jsonMapper.writeValue(f, (Object)download);
        UUID emailUUID = UUID.nameUUIDFromBytes(download.getRequestParams().getEmail().getBytes(StandardCharsets.UTF_8));
        long startTime = download.getStartTime();
        DownloadRequestDTO requestParams = download.getRequestParams();
        String file = requestParams.getFile();
        download.setFileLocation(this.biocacheDownloadDir + File.separator + String.valueOf(emailUUID) + File.separator + startTime + File.separator + file + ".zip");
        this.offlineDownloadList.add(download);
    }

    public boolean remove(DownloadDetailsDTO download) {
        logger.debug((Object)"Removing the download from the queue");
        try {
            this.offlineDownloadList.remove(download);
            File f = this.getFile(download.getStartTime());
            if (f.exists()) {
                if (logger.isInfoEnabled()) {
                    logger.info((Object)("Deleting " + f.getAbsolutePath() + " " + f.exists()));
                }
                FileUtils.deleteQuietly((File)f);
                return true;
            }
        }
        catch (Exception e) {
            logger.error((Object)("failed to delete: " + download.getStartTime() + ", " + e.getMessage()));
        }
        return false;
    }

    public List<DownloadDetailsDTO> getAllDownloads() {
        ArrayList result = new ArrayList(this.offlineDownloadList);
        return Collections.unmodifiableList(result);
    }

    public Queue<DownloadDetailsDTO> refreshFromPersistent() {
        LinkedBlockingQueue<DownloadDetailsDTO> fromPersistent = new LinkedBlockingQueue<DownloadDetailsDTO>();
        File file = new File(this.cacheDirectory);
        File[] files = file.listFiles();
        if (files != null) {
            Arrays.sort(files, new /* Unavailable Anonymous Inner Class!! */);
            for (File f : files) {
                if (!f.isFile()) continue;
                try {
                    DownloadDetailsDTO dd = (DownloadDetailsDTO)this.jsonMapper.readValue(f, DownloadDetailsDTO.class);
                    String previousFileLocation = dd.getFileLocation();
                    dd.setFileLocation(null);
                    if (previousFileLocation != null) {
                        FileUtils.deleteQuietly((File)new File(previousFileLocation));
                    }
                    fromPersistent.add(dd);
                }
                catch (Exception e) {
                    logger.error((Object)("Unable to load cached download " + f.getAbsolutePath()), (Throwable)e);
                }
            }
        }
        return fromPersistent;
    }

    public DownloadDetailsDTO isInQueue(DownloadDetailsDTO dd) {
        for (DownloadDetailsDTO d : this.offlineDownloadList) {
            if (!d.getRequestParams().getEmail().equalsIgnoreCase(d.getRequestParams().getEmail()) || !d.getRequestParams().toString().equalsIgnoreCase(dd.getRequestParams().toString())) continue;
            return d;
        }
        return null;
    }
}

