/*
 * Decompiled with CFR 0.152.
 */
package au.org.ala.ws.config;

import au.org.ala.ws.tokens.TokenClient;
import au.org.ala.ws.tokens.TokenInterceptor;
import au.org.ala.ws.tokens.TokenService;
import org.pac4j.core.profile.ProfileManager;
import org.pac4j.oidc.config.OidcConfiguration;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
class AlaWsConfig {
    @Value(value="${webservice.client-id}")
    String clientId;
    @Value(value="${webservice.client-secret}")
    String clientSecret;
    @Value(value="${webservice.jwt-scopes}")
    String jwtScopes;
    @Value(value="${webservices.cache-tokens:true}")
    boolean cacheTokens;

    AlaWsConfig() {
    }

    @Bean
    TokenClient tokenClient(@Autowired(required=false) OidcConfiguration oidcConfiguration) {
        return new TokenClient(oidcConfiguration);
    }

    @Bean
    TokenService tokenService(@Autowired(required=false) OidcConfiguration oidcConfiguration, @Autowired(required=false) ProfileManager profileManager, @Autowired TokenClient tokenClient) {
        return new TokenService(oidcConfiguration, profileManager, tokenClient, this.clientId, this.clientSecret, this.jwtScopes, this.cacheTokens);
    }

    @ConditionalOnProperty(prefix="webservice", name={"jwt"})
    @ConditionalOnMissingBean(name={"jwtInterceptor"})
    @Bean
    TokenInterceptor jwtInterceptor(@Autowired TokenService tokenService) {
        return new TokenInterceptor(tokenService);
    }
}

