/*
 * Decompiled with CFR 0.152.
 */
package au.org.ala.biocache.web;

import au.org.ala.biocache.dao.StoreDAO;
import au.org.ala.biocache.dto.UserProperty;
import au.org.ala.biocache.web.AbstractSecureController;
import au.org.ala.ws.security.profile.AlaM2MUserProfile;
import au.org.ala.ws.security.profile.AlaUserProfile;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.Parameters;
import io.swagger.v3.oas.annotations.enums.ParameterIn;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.ExampleObject;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.security.SecurityRequirement;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.security.Principal;
import java.util.HashMap;
import java.util.Map;
import javax.inject.Inject;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.server.ResponseStatusException;

@RestController
public class UserPropertiesController
extends AbstractSecureController {
    private static final Logger logger = Logger.getLogger(UserPropertiesController.class);
    @Inject
    private StoreDAO storeDao;
    @Value(value="${user.properties.max:50}")
    private int maxUserProperties;

    @Tag(name="User Properties", description="User saved properties")
    @Operation(summary="Retrieve a property", tags={"User Properties"}, description="Get a property value for a user. Required scopes: 'users/read' or User JWT.")
    @Parameters(value={@Parameter(name="alaId", description="The user's ALA ID", in=ParameterIn.QUERY, required=true), @Parameter(name="name", description="The name of the property to get", in=ParameterIn.QUERY, required=false), @Parameter(name="accept", description="Must be application/json", in=ParameterIn.HEADER, required=true)})
    @ApiResponse(responseCode="200", description="User properties. Values are type String.", content={@Content(mediaType="application/json", schema=@Schema(implementation=Map.class), examples={@ExampleObject(value="{ \"name\": \"value\" }")})})
    @SecurityRequirement(name="JWT")
    @RequestMapping(value={"/user/property"}, method={RequestMethod.GET}, produces={"application/json"})
    @ResponseBody
    public Object get(@RequestParam(value="alaId") String alaId, @RequestParam(value="name", required=false) String name, HttpServletRequest request) throws Exception {
        String validAlaId = this.getValidUser(alaId, request, "users/read");
        UserProperty prop = this.storeDao.get(UserProperty.class, validAlaId).orElse(null);
        if (prop != null && prop.getProperties() != null) {
            if (name != null) {
                return this.mapOfProperty(name, (String)prop.getProperties().get(name));
            }
            return prop.getProperties();
        }
        return null;
    }

    @Tag(name="User Properties", description="User saved properties")
    @Operation(summary="Save a property", tags={"User Properties"}, description="Saves a property value for a user. Required scopes: 'users/write' or User JWT.")
    @Parameters(value={@Parameter(name="alaId", description="The user's ALA ID", in=ParameterIn.QUERY, required=true), @Parameter(name="name", description="The name of the property to set", in=ParameterIn.QUERY, required=true), @Parameter(name="value", description="The value as a String", in=ParameterIn.QUERY, required=true), @Parameter(name="accept", description="Must be application/json", in=ParameterIn.HEADER, required=true)})
    @ApiResponse(responseCode="200", description="The saved property. Values are type String.", content={@Content(mediaType="application/json", schema=@Schema(implementation=Map.class), examples={@ExampleObject(value="{ \"name\": \"value\" }")})})
    @SecurityRequirement(name="JWT")
    @RequestMapping(value={"/user/property"}, method={RequestMethod.POST}, produces={"application/json", "text/plain"})
    @ResponseBody
    public Object save(@RequestParam(value="alaId") String alaId, @RequestParam(value="name") String name, @RequestParam(value="value") String value, HttpServletRequest request) throws Exception {
        String validAlaId = this.getValidUser(alaId, request, "users/write");
        UserProperty prop = this.storeDao.get(UserProperty.class, validAlaId).orElse(null);
        if (prop == null) {
            prop = new UserProperty();
            prop.setAlaId(validAlaId);
            prop.setProperties(new HashMap());
        } else if (prop.getProperties().size() >= this.maxUserProperties && !prop.getProperties().containsKey(name)) {
            throw new ResponseStatusException(HttpStatus.BAD_REQUEST, "User has reached the maximum number of properties");
        }
        if (StringUtils.isEmpty((CharSequence)value)) {
            prop.getProperties().remove(name);
        } else {
            prop.getProperties().put(name, value);
        }
        this.storeDao.put(validAlaId, (Object)prop);
        if (prop.getProperties() != null) {
            return this.mapOfProperty(name, (String)prop.getProperties().get(name));
        }
        return null;
    }

    private String getValidUser(String alaId, HttpServletRequest request, String m2mScope) {
        String validAlaId = null;
        Principal userPrincipal = request.getUserPrincipal();
        if (userPrincipal != null) {
            if (userPrincipal instanceof AlaUserProfile && alaId != null && alaId.equals(((AlaUserProfile)userPrincipal).getUserId())) {
                validAlaId = alaId;
            } else if (userPrincipal instanceof AlaM2MUserProfile && ((AlaM2MUserProfile)userPrincipal).getRoles().contains(m2mScope)) {
                validAlaId = alaId;
            }
        }
        if (validAlaId == null) {
            throw new ResponseStatusException(HttpStatus.UNAUTHORIZED, "User not authorized to access this resource");
        }
        return validAlaId;
    }

    private Map mapOfProperty(String name, String value) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put(name, value);
        return map;
    }
}

