/*
 * Decompiled with CFR 0.152.
 */
package au.org.ala.biocache.web;

import java.io.IOException;
import java.time.Instant;
import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.function.Supplier;
import java.util.stream.Stream;
import javax.inject.Inject;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.cache.Cache;
import org.springframework.cache.CacheManager;
import org.springframework.security.web.util.matcher.IpAddressMatcher;

public class AbstractSecureController {
    protected Supplier<Stream<IpAddressMatcher>> excludedNetworkStream;
    protected Supplier<Stream<IpAddressMatcher>> includedNetworkStream;
    @Value(value="${ratelimit.window.seconds:300}")
    protected int rateLimitWindowSeconds;
    @Value(value="${ratelimit.count:5}")
    protected int rateLimitCount;
    @Inject
    protected CacheManager cacheManager;

    @Value(value="${ratelimit.network.exclude:#{null}}")
    void setExcludedNetworks(String[] networks) {
        if (networks != null) {
            this.excludedNetworkStream = () -> Arrays.stream(networks).map(IpAddressMatcher::new);
        }
    }

    @Value(value="${ratelimit.network.include:#{null}}")
    void setIncludedNetworks(String[] networks) {
        if (networks != null) {
            this.includedNetworkStream = () -> Arrays.stream(networks).map(IpAddressMatcher::new);
        }
    }

    protected String getIPAddress(HttpServletRequest request) {
        String[] ips;
        String ipAddress = request.getHeader("X-Forwarded-For");
        if (ipAddress == null) {
            ipAddress = request.getRemoteAddr();
        }
        return (ips = ipAddress.split(",")).length > 0 ? ips[0].trim() : null;
    }

    protected String getUserAgent(HttpServletRequest request) {
        return request.getHeader("user-agent");
    }

    public boolean rateLimitRequest(HttpServletRequest request) throws IOException {
        String ipAddress = this.getIPAddress(request);
        boolean ratelimitIp = true;
        if (this.excludedNetworkStream != null) {
            ratelimitIp &= ((Stream)this.excludedNetworkStream.get()).noneMatch(networkMatcher -> networkMatcher.matches(ipAddress));
        }
        if (this.includedNetworkStream != null) {
            ratelimitIp |= ((Stream)this.includedNetworkStream.get()).anyMatch(networkMatcher -> networkMatcher.matches(ipAddress));
        }
        if (!ratelimitIp) {
            return false;
        }
        if (this.rateLimitWindowSeconds > 0 && this.rateLimitCount > 0) {
            ArrayDeque accessTimes;
            Cache cache = this.cacheManager.getCache("rateLimit");
            Cache.ValueWrapper valueWrapper = cache.get((Object)ipAddress);
            if (valueWrapper == null) {
                accessTimes = new ArrayDeque();
            } else {
                accessTimes = (ArrayDeque)valueWrapper.get();
                Instant windowStart = Instant.now().minusSeconds(this.rateLimitWindowSeconds);
                Instant oldestAccessTime = (Instant)accessTimes.getFirst();
                while (oldestAccessTime != null && oldestAccessTime.isBefore(windowStart)) {
                    accessTimes.removeFirst();
                    oldestAccessTime = (Instant)accessTimes.getFirst();
                }
            }
            if (accessTimes.size() < this.rateLimitCount) {
                accessTimes.addLast(Instant.now());
                cache.put((Object)ipAddress, (Object)accessTimes);
                return false;
            }
        }
        return true;
    }

    public boolean shouldPerformOperation(HttpServletRequest request, HttpServletResponse response) throws Exception {
        return request.getUserPrincipal() != null && !response.isCommitted();
    }
}

