/*
 * Decompiled with CFR 0.152.
 */
package au.org.ala.biocache.service;

import java.util.ArrayList;
import java.util.Set;
import javax.annotation.PostConstruct;
import org.apache.log4j.Logger;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component(value="sensitiveService")
public class SensitiveService {
    protected static final Logger logger = Logger.getLogger(SensitiveService.class);
    @Value(value="${download.auth.sensitive:false}")
    private Boolean downloadAuthSensitive;
    @Value(value="${sensitiveAccessRoles20:{\n\n\"ROLE_SDS_ACT\" : \"sensitive:\\\"generalised\\\" AND (cl927:\\\"Australian Captial Territory\\\" OR cl927:\\\"Jervis Bay Territory\\\") AND -(dataResourceUid:dr359 OR dataResourceUid:dr571 OR dataResourceUid:dr570)\"\n\"ROLE_SDS_NSW\" : \"sensitive:\\\"generalised\\\" AND cl927:\\\"New South Wales (including Coastal Waters)\\\" AND -(dataResourceUid:dr359 OR dataResourceUid:dr571 OR dataResourceUid:dr570)\",\n\"ROLE_SDS_NZ\" : \"sensitive:\\\"generalised\\\" AND (dataResourceUid:dr2707 OR dataResourceUid:dr812 OR dataResourceUid:dr814 OR dataResourceUid:dr808 OR dataResourceUid:dr806 OR dataResourceUid:dr815 OR dataResourceUid:dr802 OR dataResourceUid:dr805 OR dataResourceUid:dr813) AND -cl927:* AND -(dataResourceUid:dr359 OR dataResourceUid:dr571 OR dataResourceUid:dr570)\",\n\"ROLE_SDS_NT\" : \"sensitive:\\\"generalised\\\" AND cl927:\\\"Northern Territory (including Coastal Waters)\\\" AND -(dataResourceUid:dr359 OR dataResourceUid:dr571 OR dataResourceUid:dr570)\",\n\"ROLE_SDS_QLD\" : \"sensitive:\\\"generalised\\\" AND cl927:\\\"Queensland (including Coastal Waters)\\\" AND -(dataResourceUid:dr359 OR dataResourceUid:dr571 OR dataResourceUid:dr570)\",\n\"ROLE_SDS_SA\" : \"sensitive:\\\"generalised\\\" AND cl927:\\\"South Australia (including Coastal Waters)\\\" AND -(dataResourceUid:dr359 OR dataResourceUid:dr571 OR dataResourceUid:dr570)\",\n\"ROLE_SDS_TAS\" : \"sensitive:\\\"generalised\\\" AND cl927:\\\"Tasmania (including Coastal Waters)\\\" AND -(dataResourceUid:dr359 OR dataResourceUid:dr571 OR dataResourceUid:dr570)\",\n\"ROLE_SDS_VIC\" : \"sensitive:\\\"generalised\\\" AND cl927:\\\"Victoria (including Coastal Waters)\\\" AND -(dataResourceUid:dr359 OR dataResourceUid:dr571 OR dataResourceUid:dr570)\",\n\"ROLE_SDS_WA\" : \"sensitive:\\\"generalised\\\" AND cl927:\\\"Western Australia (including Coastal Waters)\\\" AND -(dataResourceUid:dr359 OR dataResourceUid:dr571 OR dataResourceUid:dr570)\",\n\"ROLE_SDS_BIRDLIFE\" : \"sensitive:\\\"generalised\\\" AND (dataResourceUid:dr359 OR dataResourceUid:dr571 OR dataResourceUid:dr570)\"\n\n}}")
    protected String sensitiveAccessRoles20 = "{}";
    private JSONObject sensitiveAccessRolesToSolrFilters20;

    @PostConstruct
    public void init() throws ParseException {
        this.sensitiveAccessRolesToSolrFilters20 = (JSONObject)new JSONParser().parse(this.sensitiveAccessRoles20);
    }

    public String getSensitiveFq(Set<String> userRoles) {
        if (this.downloadAuthSensitive == null || !this.downloadAuthSensitive.booleanValue()) {
            return null;
        }
        ArrayList sensitiveRoles = new ArrayList(this.sensitiveAccessRolesToSolrFilters20.keySet());
        sensitiveRoles.retainAll(userRoles);
        Object sensitiveFq = "";
        for (String sensitiveRole : sensitiveRoles) {
            if (((String)sensitiveFq).length() > 0) {
                sensitiveFq = (String)sensitiveFq + " OR ";
            }
            sensitiveFq = (String)sensitiveFq + "(" + this.sensitiveAccessRolesToSolrFilters20.get((Object)sensitiveRole) + ")";
        }
        if (((String)sensitiveFq).length() == 0) {
            return null;
        }
        return sensitiveFq;
    }
}

