/*
 * Decompiled with CFR 0.152.
 */
package au.org.ala.biocache.service;

import au.org.ala.biocache.dto.SpeciesCountDTO;
import au.org.ala.biocache.dto.SpeciesImageDTO;
import au.org.ala.biocache.service.ImageMetadataService;
import au.org.ala.biocache.service.LayersService;
import au.org.ala.biocache.service.SpeciesCountsService;
import au.org.ala.biocache.service.SpeciesImageService;
import au.org.ala.biocache.service.SpeciesSearchService;
import au.org.ala.biocache.util.OccurrenceUtils;
import au.org.ala.names.ws.client.ALANameUsageMatchServiceClient;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.inject.Inject;
import org.apache.log4j.Logger;
import org.apache.solr.client.solrj.util.ClientUtils;

public class NameMatchSpeciesSearchService
implements SpeciesSearchService {
    private static final Logger logger = Logger.getLogger(NameMatchSpeciesSearchService.class);
    @Inject
    private ALANameUsageMatchServiceClient nameUsageMatchService = null;
    @Inject
    protected SpeciesCountsService speciesCountsService;
    @Inject
    protected LayersService layersService;
    @Inject
    protected SpeciesImageService speciesImageService;
    @Inject
    protected ImageMetadataService imageMetadataService;
    @Inject
    protected OccurrenceUtils occurrenceUtils;

    public Map search(String query, String[] filterQuery, int max, boolean includeSynonyms, boolean includeAll, boolean includeCounts) {
        int maxFind = includeAll ? max : max + 1000;
        List results = this.nameUsageMatchService.autocomplete(ClientUtils.escapeQueryChars((String)query), Integer.valueOf(maxFind), Boolean.valueOf(includeSynonyms));
        ArrayList<Object> output = new ArrayList<Object>();
        SpeciesCountDTO countlist = includeCounts ? this.speciesCountsService.getCounts(filterQuery) : null;
        Collections.sort(results, new /* Unavailable Anonymous Inner Class!! */);
        int resultsTotal = 0;
        for (int i = 0; i < results.size(); ++i) {
            Map nsr = (Map)results.get(i);
            try {
                long l;
                long l2 = l = includeCounts ? this.speciesCountsService.getCount(countlist, Long.parseLong(nsr.get("left").toString()), Long.parseLong(nsr.get("right").toString())) : 0L;
                if (this.speciesCountsService.isEnabled() && includeCounts) {
                    if (l <= 0L && !includeAll) continue;
                    if (includeCounts) {
                        nsr.put("count", l);
                        nsr.put("distributionsCount", this.layersService.getDistributionsCount(nsr.get("lsid").toString()));
                        nsr.put("checklistsCount", this.layersService.getChecklistsCount(nsr.get("lsid").toString()));
                        nsr.put("tracksCount", this.layersService.getTracksCount(nsr.get("lsid").toString()));
                    }
                    nsr.put("images", this.speciesImageService.get(Long.parseLong((String)nsr.get("left")), Long.parseLong((String)nsr.get("right"))));
                    if (output.size() <= max) {
                        output.add(nsr);
                    }
                    ++resultsTotal;
                    continue;
                }
                ++resultsTotal;
                output.add(nsr);
                continue;
            }
            catch (Exception exception) {
                logger.error((Object)("Error thrown in autocomplete: " + exception.getMessage()), (Throwable)exception);
            }
        }
        ArrayList<Map> formatted = new ArrayList<Map>();
        for (Map map : output) {
            formatted.add(this.format(map, query));
        }
        HashMap<String, Object> wrapper = new HashMap<String, Object>();
        wrapper.put("pageSize", max);
        wrapper.put("startIndex", 0);
        wrapper.put("totalRecords", resultsTotal);
        wrapper.put("sort", "score");
        wrapper.put("dir", "desc");
        wrapper.put("status", "OK");
        wrapper.put("query", query);
        wrapper.put("results", formatted);
        HashMap<String, HashMap<String, Object>> hashMap = new HashMap<String, HashMap<String, Object>>();
        hashMap.put("searchResults", wrapper);
        return hashMap;
    }

    private Map format(Map m, String searchTerm) {
        Set commonNames;
        int pos;
        Object highlight;
        HashMap<String, Object> formatted = new HashMap<String, Object>();
        String guid = (String)m.get("lsid");
        formatted.put("guid", guid);
        formatted.put("linkIdentifier", guid);
        formatted.put("name", m.get("name"));
        formatted.put("idxType", "TAXON");
        formatted.put("score", m.get("score"));
        formatted.put("left", m.get("left"));
        formatted.put("right", m.get("right"));
        Map cl = (Map)m.get("cl");
        String parentUid = null;
        if (cl != null) {
            if (guid.equals(cl.get("sid"))) {
                parentUid = (String)cl.get("gid");
            }
            if (guid.equals(cl.get("gid"))) {
                parentUid = (String)cl.get("fid");
            }
            if (guid.equals(cl.get("fid"))) {
                parentUid = (String)cl.get("oid");
            }
            if (guid.equals(cl.get("oid"))) {
                parentUid = (String)cl.get("cid");
            }
            if (guid.equals(cl.get("cid"))) {
                parentUid = (String)cl.get("pid");
            }
            if (guid.equals(cl.get("pid"))) {
                parentUid = (String)cl.get("kid");
            }
            formatted.put("parentGuid", parentUid);
            formatted.put("kingdom", cl.get("kingdom"));
            formatted.put("phylum", cl.get("phylum"));
            formatted.put("classs", cl.get("klass"));
            formatted.put("order", cl.get("order"));
            formatted.put("family", cl.get("family"));
            formatted.put("genus", cl.get("genus"));
            formatted.put("author", cl.get("authorship"));
        }
        formatted.put("hasChildren", false);
        String rank = (String)m.get("rank");
        formatted.put("rank", (rank != null ? rank : "").toLowerCase());
        formatted.put("rankId", m.get("rankId"));
        formatted.put("rawRank", m.get("rank"));
        formatted.put("isAustralian", "recorded");
        boolean scientificNameMatch = "scientificName".equals(m.get("match"));
        Object object = highlight = scientificNameMatch ? (String)m.get("name") : (String)m.get("commonname");
        if (highlight == null) {
            Map syn;
            Iterator iterator = ((List)m.get("synonymMatch")).iterator();
            while (iterator.hasNext() && (highlight = (scientificNameMatch = "scientificName".equals((syn = (Map)iterator.next()).get("match"))) ? (String)syn.get("name") : (String)syn.get("commonname")) == null) {
            }
        }
        if (highlight != null && (pos = ((String)highlight).toLowerCase().indexOf(searchTerm.toLowerCase())) >= 0) {
            highlight = ((String)highlight).substring(0, pos) + "<strong>" + ((String)highlight).substring(pos, pos + searchTerm.length()) + "</strong>" + ((String)highlight).substring(pos + searchTerm.length(), ((String)highlight).length());
        }
        formatted.put("highlight", highlight);
        if (m.get("commonname") == null && !(commonNames = this.nameUsageMatchService.getCommonNamesForLSID((String)m.get("lsid"), Integer.valueOf(1000))).isEmpty()) {
            m.put("commonname", commonNames.iterator().next());
            m.put("commonnames", commonNames);
        }
        if (m.get("commonname") != null) {
            formatted.put("commonName", m.get("commonnames"));
            formatted.put("commonNameSingle", m.get("commonname"));
        }
        formatted.put("nameComplete", m.get("name"));
        formatted.put("occCount", m.get("count"));
        formatted.put("distributionsCount", m.get("distributionsCount"));
        formatted.put("checklistsCount", m.get("checklistsCount"));
        formatted.put("tracksCount", m.get("tracksCount"));
        SpeciesImageDTO speciesImage = (SpeciesImageDTO)m.get("images");
        if (speciesImage != null && speciesImage.getImage() != null) {
            try {
                Map im = this.occurrenceUtils.getImageFormats(speciesImage.getImage());
                formatted.put("imageSource", speciesImage.getDataResourceUid());
                formatted.put("imageCount", speciesImage.getCount());
                formatted.put("image", im.get("raw"));
                formatted.put("thumbnail", im.get("thumbnail"));
                formatted.put("imageUrl", im.get("raw"));
                formatted.put("smallImageUrl", im.get("small"));
                formatted.put("largeImageUrl", im.get("large"));
                formatted.put("thumbnailUrl", im.get("thumbnail"));
                formatted.put("imageMetadataUrl", this.imageMetadataService.getUrlFor(speciesImage.getImage()));
            }
            catch (Exception ex) {
                logger.warn((Object)("Unable to get image formats for " + speciesImage.getImage() + ": " + ex.getMessage()));
                formatted.put("imageCount", 0);
            }
        } else {
            formatted.put("imageCount", 0);
        }
        formatted.put("isExcluded", false);
        return formatted;
    }
}

