/*
 * Decompiled with CFR 0.152.
 */
package au.org.ala.biocache.service;

import au.org.ala.biocache.service.LayersService;
import au.org.ala.biocache.service.ListsService;
import au.org.ala.biocache.service.SpeciesLookupService;
import au.org.ala.names.ws.api.NameUsageMatch;
import au.org.ala.names.ws.client.ALANameUsageMatchServiceClient;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.context.support.AbstractMessageSource;

public class NameMatchSpeciesLookupService
implements SpeciesLookupService {
    private static final Logger logger = Logger.getLogger(NameMatchSpeciesLookupService.class);
    private AbstractMessageSource messageSource;
    @Inject
    protected ListsService listsService;
    @Inject
    protected LayersService layersService;
    @Inject
    private ALANameUsageMatchServiceClient nameUsageMatchService = null;
    private String[] baseHeader;
    private String[] countBaseHeader;
    private String[] synonymHeader;
    private String[] countSynonymHeader;

    @Cacheable(value={"namematching"})
    public String getGuidForName(String name) {
        String lsid = null;
        try {
            lsid = this.nameUsageMatchService.searchForLSID(name);
        }
        catch (Exception e) {
            logger.debug((Object)("Error searching for name: " + name + " -  " + e.getMessage()), (Throwable)e);
        }
        return lsid;
    }

    @Cacheable(value={"namematching"})
    public String getAcceptedNameForGuid(String guid) {
        return this.nameUsageMatchService.getName(guid, Boolean.valueOf(true));
    }

    @Cacheable(value={"namematching"})
    public List<String[]> getSpeciesDetails(List<String> guids, List<Long> counts, boolean includeCounts, boolean includeSynonyms, boolean includeLists) {
        ArrayList<String[]> results = new ArrayList<String[]>(guids.size());
        List guidsFiltered = guids.stream().map(g -> {
            if (g != null && StringUtils.countMatches((CharSequence)g, (char)'|') == 4) {
                g = g.split("\\|", 6)[1];
            }
            return g;
        }).collect(Collectors.toList());
        List matches = this.nameUsageMatchService.getAll(guidsFiltered, Boolean.valueOf(true));
        for (int i = 0; i < matches.size(); ++i) {
            NameUsageMatch nsr = (NameUsageMatch)matches.get(i);
            String guid = guids.get(i);
            Object[] result = null;
            ArrayList<String> lsids = new ArrayList<String>();
            if (nsr != null && nsr.isSuccess()) {
                lsids.add(nsr.getGenusID());
                lsids.add(nsr.getFamilyID());
                lsids.add(nsr.getSpeciesID());
                result = new String[]{guid, nsr.getScientificName(), nsr.getScientificNameAuthorship(), nsr.getRank(), nsr.getKingdom(), nsr.getPhylum(), nsr.getClasss(), nsr.getOrder(), nsr.getFamily(), nsr.getGenus(), nsr.getVernacularName()};
            } else if (StringUtils.countMatches((CharSequence)guid, (CharSequence)"|") == 4) {
                if (guid.startsWith("\"") && guid.endsWith("\"") && guid.length() > 2) {
                    guid = guid.substring(1, guid.length() - 1);
                }
                String[] split = guid.split("\\|", 6);
                lsids.add(split[1]);
                result = new String[]{guid, split[0], "", "", split[3], "", "", "", split[4], "", split[2]};
            } else {
                result = new String[]{"unmatched", "", "", "", "", "", "", "", "", "", ""};
            }
            if (includeCounts) {
                result = (String[])ArrayUtils.add((Object[])result, (Object)counts.get(i).toString());
            }
            if (includeLists) {
                List types = this.listsService.getTypes();
                String[] row = new String[result.length + types.size()];
                System.arraycopy(result, 0, row, 0, result.length);
                HashSet listMatches = new HashSet();
                for (int j = 0; j < types.size(); ++j) {
                    listMatches.clear();
                    for (String lsid : lsids) {
                        Set found = this.listsService.get(types.get(j).toString(), lsid);
                        if (found == null) continue;
                        listMatches.addAll(found);
                    }
                    row[result.length + j] = "";
                    for (String match : listMatches) {
                        if (row[result.length + j].length() > 0) {
                            int n = result.length + j;
                            row[n] = row[n] + " | ";
                        }
                        int n = result.length + j;
                        row[n] = row[n] + match;
                    }
                }
                result = row;
            }
            results.add((String[])result);
        }
        return results;
    }

    public String[] getHeaderDetails(String field, boolean includeCounts, boolean includeSynonyms) {
        if (this.baseHeader == null) {
            this.initHeaders();
        }
        Object[] startArray = this.baseHeader;
        if (includeCounts) {
            startArray = includeSynonyms ? this.countSynonymHeader : this.countBaseHeader;
        } else if (includeSynonyms) {
            startArray = this.synonymHeader;
        }
        return (String[])ArrayUtils.add((Object[])startArray, (int)0, (Object)this.messageSource.getMessage("facet." + field, null, field, null));
    }

    private void initHeaders() {
        this.baseHeader = new String[]{this.messageSource.getMessage("species.name", null, "Species Name", null), this.messageSource.getMessage("species.author", null, "Scientific Name Author", null), this.messageSource.getMessage("species.rank", null, "Taxon Rank", null), this.messageSource.getMessage("species.kingdom", null, "Kingdom", null), this.messageSource.getMessage("species.phylum", null, "Phylum", null), this.messageSource.getMessage("species.class", null, "Class", null), this.messageSource.getMessage("species.order", null, "Order", null), this.messageSource.getMessage("species.family", null, "Family", null), this.messageSource.getMessage("species.genus", null, "Genus", null), this.messageSource.getMessage("species.common", null, "Vernacular Name", null)};
        this.countBaseHeader = (String[])ArrayUtils.add((Object[])this.baseHeader, (Object)this.messageSource.getMessage("species.count", null, "Number of Records", null));
        this.synonymHeader = (String[])ArrayUtils.add((Object[])this.baseHeader, (Object)this.messageSource.getMessage("species.synonyms", null, "Synonyms", null));
        this.countSynonymHeader = (String[])ArrayUtils.add((Object[])this.synonymHeader, (Object)this.messageSource.getMessage("species.count", null, "Number of Records", null));
    }

    @Cacheable(value={"namematching"})
    public List<String> getGuidsForTaxa(List<String> taxaQueries) {
        return this.nameUsageMatchService.getGuidsForTaxa(taxaQueries);
    }

    public void setMessageSource(AbstractMessageSource messageSource) {
        this.messageSource = messageSource;
    }
}

