/*
 * Decompiled with CFR 0.152.
 */
package au.org.ala.biocache.service;

import au.org.ala.biocache.dto.SpatialObjectDTO;
import au.org.ala.biocache.service.LayersService;
import au.org.ala.biocache.service.RestartDataService;
import com.fasterxml.jackson.core.type.TypeReference;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.zip.ZipInputStream;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.http.converter.FormHttpMessageConverter;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.util.StreamUtils;
import org.springframework.web.client.RestOperations;
import org.springframework.web.client.RestTemplate;

@Component(value="layersService")
public class AlaLayersService
implements LayersService {
    private static final Logger logger = LoggerFactory.getLogger(AlaLayersService.class);
    private Map<String, String> idToNameMap = (Map)RestartDataService.get((Object)this, (String)"idToNameMap", (TypeReference)new /* Unavailable Anonymous Inner Class!! */, HashMap.class);
    private List<Map<String, Object>> layers = (List)RestartDataService.get((Object)this, (String)"layers", (TypeReference)new /* Unavailable Anonymous Inner Class!! */, ArrayList.class);
    private Map<String, String> extraLayers = new HashMap();
    @Value(value="${caches.layers.enabled:true}")
    protected Boolean enabled = null;
    @Value(value="${spatial.layers.url:https://spatial.ala.org.au/ws/fields}")
    protected String spatialUrl;
    @Value(value="${layers.service.download.sample:true}")
    protected Boolean layersServiceAnalysisLayers;
    @Value(value="${layers.service.url:https://spatial.ala.org.au/ws}")
    protected String layersServiceUrl;
    protected Map<String, Integer> distributions = (Map)RestartDataService.get((Object)this, (String)"distributions", (TypeReference)new /* Unavailable Anonymous Inner Class!! */, HashMap.class);
    protected Map<String, Integer> checklists = (Map)RestartDataService.get((Object)this, (String)"checklists", (TypeReference)new /* Unavailable Anonymous Inner Class!! */, HashMap.class);
    protected Map<String, Integer> tracks = (Map)RestartDataService.get((Object)this, (String)"tracks", (TypeReference)new /* Unavailable Anonymous Inner Class!! */, HashMap.class);
    @Inject
    private RestOperations restTemplate;
    private CountDownLatch wait = new CountDownLatch(1);

    public Map<String, String> getLayerNameMap() {
        try {
            this.wait.await();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return this.idToNameMap;
    }

    @Scheduled(fixedDelay=43200000L)
    public void refreshCache() {
        this.init();
    }

    @PostConstruct
    public void init() {
        ((RestTemplate)this.restTemplate).getMessageConverters().add(new FormHttpMessageConverter());
        if (this.layers.size() > 0) {
            this.wait.countDown();
        }
        if (this.enabled.booleanValue()) {
            new /* Unavailable Anonymous Inner Class!! */.start();
        } else {
            this.wait.countDown();
        }
    }

    public String getName(String code) {
        try {
            this.wait.await();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return (String)this.idToNameMap.get(code);
    }

    public String findAnalysisLayerName(String analysisLayer, String layersServiceUrl) {
        String url = this.layersServiceUrl;
        if (org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)layersServiceUrl)) {
            url = layersServiceUrl;
        }
        if (!this.layersServiceAnalysisLayers.booleanValue()) {
            return null;
        }
        if (this.extraLayers.containsKey(analysisLayer)) {
            return (String)this.extraLayers.get(analysisLayer);
        }
        String found = null;
        if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)url)) {
            String intersectUrl = null;
            try {
                intersectUrl = url + "/intersect/" + URLEncoder.encode(analysisLayer, "UTF-8") + "/1/1";
                List json = (List)this.restTemplate.getForObject(intersectUrl, List.class, new Object[0]);
                if (json != null && json.size() > 0) {
                    found = (String)((Map)json.get(0)).get("layername");
                }
                this.extraLayers.put(analysisLayer, found);
            }
            catch (Exception ex) {
                logger.error("RestTemplate error for " + url + ": " + ex.getMessage(), (Throwable)ex);
            }
        }
        return found;
    }

    public Integer getDistributionsCount(String lsid) {
        try {
            this.wait.await();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        Integer count = (Integer)this.distributions.get(lsid);
        return count != null ? count : 0;
    }

    public Integer getChecklistsCount(String lsid) {
        try {
            this.wait.await();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        Integer count = (Integer)this.checklists.get(lsid);
        return count != null ? count : 0;
    }

    public Integer getTracksCount(String lsid) {
        try {
            this.wait.await();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        Integer count = (Integer)this.tracks.get(lsid);
        return count != null ? count : 0;
    }

    private Map initDistribution(String type) {
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        String url = this.layersServiceUrl + "/" + type;
        try {
            List json;
            if (StringUtils.isNotBlank((String)this.layersServiceUrl) && (json = (List)this.restTemplate.getForObject(url, List.class, new Object[0])) != null) {
                for (int i = 0; i < json.size(); ++i) {
                    String s = (String)((Map)json.get(i)).get("lsid");
                    if (!org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)s)) continue;
                    Integer count = (Integer)map.get(s);
                    if (count == null) {
                        count = 0;
                    }
                    count = count + 1;
                    map.put(s, count);
                }
            }
        }
        catch (Exception ex) {
            if (!"tracks".equals(type)) {
                logger.error("RestTemplate error for " + url, (Throwable)ex);
            }
            logger.warn("RestTemplate warning for " + url + ". This is not fatal", (Throwable)ex);
        }
        return map;
    }

    public String getLayersServiceUrl() {
        return this.layersServiceUrl;
    }

    public Reader sample(String url, String[] analysisLayers, double[][] points) {
        long sleepTime = 1000L;
        try {
            HttpHeaders requestHeaders = new HttpHeaders();
            requestHeaders.setContentType(MediaType.APPLICATION_FORM_URLENCODED);
            HttpEntity request = new HttpEntity((Object)this.sampleBody(analysisLayers, points), (MultiValueMap)requestHeaders);
            Map status = (Map)this.restTemplate.postForObject(url + "/intersect/batch", (Object)request, Map.class, new Object[0]);
            while (status.containsKey("statusUrl")) {
                Thread.sleep(sleepTime);
                status = (Map)this.restTemplate.getForObject((String)status.get("statusUrl"), Map.class, new Object[0]);
            }
            if (status.containsKey("downloadUrl")) {
                URLConnection connection = new URL((String)status.get("downloadUrl")).openConnection();
                ZipInputStream zis = new ZipInputStream(connection.getInputStream());
                zis.getNextEntry();
                return new InputStreamReader(zis);
            }
        }
        catch (Exception e) {
            logger.error("layer sampling failed: " + url + ", " + e.getMessage());
        }
        return null;
    }

    private MultiValueMap<String, String> sampleBody(String[] analysisLayers, double[][] points) {
        int i;
        LinkedMultiValueMap response = new LinkedMultiValueMap();
        StringBuilder sb = new StringBuilder();
        for (i = 0; i < analysisLayers.length; ++i) {
            if (i > 0) {
                sb.append(",");
            }
            sb.append(analysisLayers[i]);
        }
        response.add((Object)"fids", (Object)sb.toString());
        sb = new StringBuilder();
        for (i = 0; i < points.length; ++i) {
            if (i > 0) {
                sb.append(",");
            }
            sb.append(points[i][1]).append(",").append(points[i][0]);
        }
        response.add((Object)"points", (Object)sb.toString());
        return response;
    }

    @Cacheable(value={"spatialObject"})
    public SpatialObjectDTO getObject(String spatialObjectId) {
        String url = this.layersServiceUrl + "/object/" + Integer.parseInt(spatialObjectId);
        return (SpatialObjectDTO)this.restTemplate.getForObject(url, SpatialObjectDTO.class, new Object[0]);
    }

    @Cacheable(value={"wkt"})
    public String getObjectWkt(String spatialObjectId) {
        String url = this.layersServiceUrl + "/shape/wkt/" + Integer.parseInt(spatialObjectId);
        try {
            URLConnection con = new URL(url).openConnection();
            return StreamUtils.copyToString((InputStream)con.getInputStream(), (Charset)Charset.defaultCharset());
        }
        catch (Exception e) {
            return null;
        }
    }
}

