/*
 * Decompiled with CFR 0.152.
 */
package au.org.ala.biocache.dto;

import au.org.ala.biocache.dto.SpatialSearchRequestParams;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.Schema;
import javax.validation.constraints.Pattern;

@Schema(name="Download parameters")
public class DownloadRequestParams
extends SpatialSearchRequestParams {
    @Parameter(name="email", description="The email address to sent the download email once complete.")
    String email = "";
    @Parameter(name="reason", description="Reason for download")
    String reason = "";
    @Parameter(name="file", description="Download File name")
    String file = "data";
    @Parameter(name="fields", description="Fields to download")
    String fields = "";
    @Parameter(name="extra", description="CSV list of extra fields to be added to the download")
    String extra = "";
    @Parameter(name="qa", description="the CSV list of issue types to include in the download, defaults to all. Also supports none")
    String qa = "all";
    @Parameter(name="sep", description="Field delimiter", schema=@Schema(type="string", allowableValues={",", "\t"}))
    Character sep = Character.valueOf(',');
    @Parameter(name="esc", description="Field escape", schema=@Schema(type="string", defaultValue="\""))
    Character esc = Character.valueOf('\"');
    @Parameter(name="dwcHeaders", description="Use darwin core headers", schema=@Schema(type="boolean", defaultValue="false"))
    Boolean dwcHeaders = false;
    @Parameter(name="includeMisc", description="Include miscellaneous properties", schema=@Schema(type="boolean", defaultValue="false"))
    Boolean includeMisc = false;
    @Parameter(name="reasonTypeId", description="Logger reason ID See https://logger.ala.org.au/service/logger/reasons", schema=@Schema(type="string", defaultValue="10"))
    Integer reasonTypeId = null;
    @Parameter(name="sourceTypeId", description="Source ID See https://logger.ala.org.au/service/logger/sources", schema=@Schema(type="string", defaultValue="0"))
    Integer sourceTypeId = null;
    @Parameter(name="fileType", description="File type. CSV or TSV", schema=@Schema(type="string", allowableValues={"csv", "tsv"}))
    @Pattern(regexp="(csv|tsv)")
    @Pattern(regexp="(csv|tsv)") String fileType = "csv";
    @Parameter(name="layersServiceUrl", description="URL to layersService to include intersections with layers that are not indexed", hidden=true)
    String layersServiceUrl = "";
    @Parameter(name="customHeader", description="Override header names with a CSV with 'requested field','header' pairs")
    String customHeader = "";
    @Parameter(name="mintDoi", description="Request to generate a DOI for the download or not. Default false")
    Boolean mintDoi = false;
    @Parameter(name="emailNotify", description="Send notification email.")
    boolean emailNotify = true;

    public String getEmail() {
        return this.email;
    }

    public String getReason() {
        return this.reason;
    }

    public String getFile() {
        return this.file;
    }

    public String getFields() {
        return this.fields;
    }

    public String getExtra() {
        return this.extra;
    }

    public String getQa() {
        return this.qa;
    }

    public Character getSep() {
        return this.sep;
    }

    public Character getEsc() {
        return this.esc;
    }

    public Boolean getDwcHeaders() {
        return this.dwcHeaders;
    }

    public Boolean getIncludeMisc() {
        return this.includeMisc;
    }

    public Integer getReasonTypeId() {
        return this.reasonTypeId;
    }

    public Integer getSourceTypeId() {
        return this.sourceTypeId;
    }

    public String getFileType() {
        return this.fileType;
    }

    public String getLayersServiceUrl() {
        return this.layersServiceUrl;
    }

    public String getCustomHeader() {
        return this.customHeader;
    }

    public Boolean getMintDoi() {
        return this.mintDoi;
    }

    public boolean isEmailNotify() {
        return this.emailNotify;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public void setReason(String reason) {
        this.reason = reason;
    }

    public void setFile(String file) {
        this.file = file;
    }

    public void setFields(String fields) {
        this.fields = fields;
    }

    public void setExtra(String extra) {
        this.extra = extra;
    }

    public void setQa(String qa) {
        this.qa = qa;
    }

    public void setSep(Character sep) {
        this.sep = sep;
    }

    public void setEsc(Character esc) {
        this.esc = esc;
    }

    public void setDwcHeaders(Boolean dwcHeaders) {
        this.dwcHeaders = dwcHeaders;
    }

    public void setIncludeMisc(Boolean includeMisc) {
        this.includeMisc = includeMisc;
    }

    public void setReasonTypeId(Integer reasonTypeId) {
        this.reasonTypeId = reasonTypeId;
    }

    public void setSourceTypeId(Integer sourceTypeId) {
        this.sourceTypeId = sourceTypeId;
    }

    public void setFileType(String fileType) {
        this.fileType = fileType;
    }

    public void setLayersServiceUrl(String layersServiceUrl) {
        this.layersServiceUrl = layersServiceUrl;
    }

    public void setCustomHeader(String customHeader) {
        this.customHeader = customHeader;
    }

    public void setMintDoi(Boolean mintDoi) {
        this.mintDoi = mintDoi;
    }

    public void setEmailNotify(boolean emailNotify) {
        this.emailNotify = emailNotify;
    }
}

