/*
 * Decompiled with CFR 0.152.
 */
package au.org.ala.biocache.dto;

import au.org.ala.biocache.dto.DownloadDetailsDTO;
import au.org.ala.biocache.dto.DownloadRequestDTO;
import au.org.ala.ws.security.profile.AlaUserProfile;
import com.fasterxml.jackson.annotation.JsonIgnore;
import io.swagger.v3.oas.annotations.media.Schema;
import java.nio.charset.StandardCharsets;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import javax.validation.constraints.NotNull;

@Schema(name="DownloadDetails")
public class DownloadDetailsDTO {
    private DownloadRequestDTO requestParams;
    private DownloadType downloadType;
    private String ipAddress;
    private String userAgent;
    private AlaUserProfile alaUser;
    private String fileLocation;
    private Map<String, String> headerMap = null;
    private String[] miscFields = null;
    private Date startDate;
    private Date lastUpdate;
    private long totalRecords = 0L;
    private final AtomicLong recordsDownloaded = new AtomicLong(0L);
    private String processingThreadName = null;
    private AtomicBoolean interrupt = new AtomicBoolean(false);

    public DownloadDetailsDTO() {
    }

    public DownloadDetailsDTO(@NotNull DownloadRequestDTO params, AlaUserProfile alaUser, String ipAddress, String userAgent, DownloadType type) {
        this.requestParams = params;
        this.alaUser = alaUser;
        this.ipAddress = ipAddress;
        this.userAgent = userAgent;
        this.downloadType = type;
        this.startDate = new Date();
        this.lastUpdate = new Date();
    }

    public Date getLastUpdate() {
        return this.lastUpdate;
    }

    public void setLastUpdate(Date lastUpdate) {
        this.lastUpdate = lastUpdate;
    }

    @JsonIgnore
    public long getStartTime() {
        return this.startDate.getTime();
    }

    public String getStartDateString() {
        return this.startDate.toString();
    }

    public String getStartDateString(String format) {
        return new SimpleDateFormat(format).format(this.startDate);
    }

    public Date getStartDate() {
        return this.startDate;
    }

    public void setStartDate(Date startDate) {
        this.startDate = startDate;
    }

    public AtomicLong getRecordsDownloaded() {
        return this.recordsDownloaded;
    }

    public String getIpAddress() {
        return this.ipAddress;
    }

    public String getUserAgent() {
        return this.userAgent;
    }

    public DownloadType getDownloadType() {
        return this.downloadType;
    }

    public void setDownloadType(DownloadType downloadType) {
        this.downloadType = downloadType;
    }

    public void updateCounts(int number) {
        this.recordsDownloaded.addAndGet(number);
        this.lastUpdate = new Date();
    }

    public void setTotalRecords(long total) {
        this.totalRecords = total;
    }

    public long getTotalRecords() {
        return this.totalRecords;
    }

    public String getFileLocation() {
        return this.fileLocation;
    }

    public void setFileLocation(String fileLocation) {
        this.fileLocation = fileLocation;
    }

    public DownloadRequestDTO getRequestParams() {
        return this.requestParams;
    }

    public void setRequestParams(DownloadRequestDTO requestParams) {
        this.requestParams = requestParams;
    }

    public void setMiscFields(String[] miscFields) {
        this.miscFields = miscFields;
    }

    public String[] getMiscFields() {
        return this.miscFields;
    }

    public void setIpAddress(String ipAddress) {
        this.ipAddress = ipAddress;
    }

    public void setUserAgent(String userAgent) {
        this.userAgent = userAgent;
    }

    @JsonIgnore
    public Map<String, String> getHeaderMap() {
        return this.headerMap;
    }

    public String getUniqueId() {
        return UUID.nameUUIDFromBytes(this.requestParams.getEmail().getBytes(StandardCharsets.UTF_8)) + "-" + this.getStartTime();
    }

    public void setHeaderMap(Map<String, String> headerMap) {
        this.headerMap = headerMap;
    }

    public String getProcessingThreadName() {
        return this.processingThreadName;
    }

    public void setProcessingThreadName(String processingThreadName) {
        this.processingThreadName = processingThreadName;
    }

    public AlaUserProfile getAlaUser() {
        return this.alaUser;
    }

    public void setAlaUser(AlaUserProfile alaUser) {
        this.alaUser = alaUser;
    }

    public void setInterrupt(Boolean interrupt) {
        this.interrupt.set(interrupt);
    }

    public Boolean getInterrupt() {
        return this.interrupt.get();
    }

    public void resetCounts() {
        this.recordsDownloaded.set(0L);
        this.lastUpdate = new Date();
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("DownloadDetailsDTO [downloadType=").append(this.downloadType).append(", startDate=").append(this.startDate).append(", lastUpdate=").append(this.lastUpdate).append(", totalRecords=").append(this.totalRecords).append(", recordsDownloaded=").append(this.recordsDownloaded).append(", downloadParams=").append(this.requestParams.toString()).append(", ipAddress=").append(this.ipAddress).append(", email=").append(this.requestParams.getEmail()).append(", requestParams=").append(this.requestParams).append("]");
        return builder.toString();
    }
}

