/*
 * Decompiled with CFR 0.152.
 */
package au.org.ala.biocache.config;

import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.info.Info;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.boot.builder.SpringApplicationBuilder;
import org.springframework.boot.web.servlet.support.SpringBootServletInitializer;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.ImportResource;

@SpringBootApplication
@ImportResource(value={"classpath:spring.xml"})
@ComponentScan(value={"au.org.ala.biocache.*", "au.org.ala.ws.config"})
public class Application
extends SpringBootServletInitializer {
    protected SpringApplicationBuilder configure(SpringApplicationBuilder application) {
        return application.sources(new Class[]{Application.class});
    }

    @Bean
    public OpenAPI customOpenAPI(@Value(value="${application-title}") String appTitle, @Value(value="${application-description}") String appDescription, @Value(value="${application-version}") String appVersion, @Value(value="${application-terms-url}") String appTermsUrl) {
        return new OpenAPI().info(new Info().title(appTitle).version(appVersion).description(appDescription).termsOfService(appTermsUrl));
    }

    public static void main(String[] args) {
        SpringApplication.run(Application.class, (String[])args);
    }
}

