/*
 * Decompiled with CFR 0.152.
 */
package au.org.ala.biocache.web;

import au.com.bytecode.opencsv.CSVWriter;
import au.org.ala.biocache.dao.IndexDAO;
import au.org.ala.biocache.dao.QidCacheDAO;
import au.org.ala.biocache.dao.SearchDAO;
import au.org.ala.biocache.dao.SearchDAOImpl;
import au.org.ala.biocache.dto.AssertionCodes;
import au.org.ala.biocache.dto.Comparison;
import au.org.ala.biocache.dto.DownloadDetailsDTO;
import au.org.ala.biocache.dto.DownloadRequestDTO;
import au.org.ala.biocache.dto.DownloadRequestParams;
import au.org.ala.biocache.dto.ErrorCode;
import au.org.ala.biocache.dto.FacetResultDTO;
import au.org.ala.biocache.dto.FacetThemes;
import au.org.ala.biocache.dto.FieldResultDTO;
import au.org.ala.biocache.dto.IndexFieldDTO;
import au.org.ala.biocache.dto.MediaDTO;
import au.org.ala.biocache.dto.NativeDTO;
import au.org.ala.biocache.dto.OccurrenceIndex;
import au.org.ala.biocache.dto.OccurrenceSourceDTO;
import au.org.ala.biocache.dto.SearchRequestDTO;
import au.org.ala.biocache.dto.SearchResultDTO;
import au.org.ala.biocache.dto.SpatialSearchRequestDTO;
import au.org.ala.biocache.dto.SpatialSearchRequestParams;
import au.org.ala.biocache.dto.UserAssertions;
import au.org.ala.biocache.service.AssertionService;
import au.org.ala.biocache.service.AuthService;
import au.org.ala.biocache.service.DataQualityService;
import au.org.ala.biocache.service.DownloadService;
import au.org.ala.biocache.service.ImageMetadataService;
import au.org.ala.biocache.service.LayersService;
import au.org.ala.biocache.service.LoggerService;
import au.org.ala.biocache.service.SpeciesLookupService;
import au.org.ala.biocache.util.OccurrenceUtils;
import au.org.ala.biocache.util.QidSizeException;
import au.org.ala.biocache.util.SearchUtils;
import au.org.ala.biocache.util.converter.FqField;
import au.org.ala.biocache.web.AbstractSecureController;
import au.org.ala.biocache.web.OccurrenceController;
import au.org.ala.ws.security.profile.AlaUserProfile;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import io.swagger.annotations.ApiParam;
import io.swagger.v3.oas.annotations.Hidden;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.enums.SecuritySchemeType;
import io.swagger.v3.oas.annotations.security.SecurityRequirement;
import io.swagger.v3.oas.annotations.security.SecurityScheme;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.lang.constant.Constable;
import java.lang.invoke.CallSite;
import java.nio.charset.StandardCharsets;
import java.time.Instant;
import java.time.LocalDate;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import net.sf.json.JSONArray;
import org.ala.client.model.LogEventType;
import org.ala.client.model.LogEventVO;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.output.CloseShieldOutputStream;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.apache.solr.common.SolrDocument;
import org.apache.solr.common.SolrDocumentList;
import org.gbif.dwc.terms.DwcTerm;
import org.springdoc.api.annotations.ParameterObject;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.support.AbstractMessageSource;
import org.springframework.security.access.annotation.Secured;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.validation.BindingResult;
import org.springframework.validation.ObjectError;
import org.springframework.validation.Validator;
import org.springframework.web.bind.WebDataBinder;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.InitBinder;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller(value="Occurrence")
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@SecurityScheme(name="JWT", type=SecuritySchemeType.HTTP, scheme="bearer", bearerFormat="JWT")
public class OccurrenceController
extends AbstractSecureController {
    private static final Logger logger = Logger.getLogger(OccurrenceController.class);
    public static final String LEGACY_REPRESENTATIVE_RECORD_VALUE = "R";
    public static final String LEGACY_DUPLICATE_RECORD_VALUE = "D";
    public static final String RAW_FIELD_PREFIX = "raw_";
    public static final String DYNAMIC_PROPERTIES_PREFIX = "dynamicProperties_";
    @Inject
    protected SearchDAO searchDAO;
    @Inject
    protected IndexDAO indexDao;
    @Inject
    protected SearchUtils searchUtils;
    @Inject
    protected SpeciesLookupService speciesLookupService;
    @Inject
    protected AuthService authService;
    @Inject
    protected OccurrenceUtils occurrenceUtils;
    @Inject
    protected DownloadService downloadService;
    @Inject
    protected LoggerService loggerService;
    @Inject
    private AbstractMessageSource messageSource;
    @Inject
    private ImageMetadataService imageMetadataService;
    @Inject
    protected Validator validator;
    @Inject
    protected QidCacheDAO qidCacheDao;
    @Inject
    private LayersService layersService;
    @Inject
    private AssertionService assertionService;
    @Inject
    private DataQualityService dataQualityService;
    private final String VALIDATION_ERROR = "error/validationError";
    @Value(value="${webservices.root:http://localhost:8080/biocache-service}")
    protected String webservicesRoot;
    @Value(value="${media.store.url:}")
    private String remoteMediaStoreUrl;
    @Value(value="${taxon.id.pattern:urn:lsid:biodiversity.org.au[a-zA-Z0-9\\.:-]*|http://id.biodiversity.org.au/[a-zA-Z0-9/]*}")
    protected String taxonIDPatternString;
    @Value(value="${native.country:Australia}")
    protected String nativeCountry;
    protected Pattern taxonIDPattern;
    @Value(value="${solr.fieldlist:*,[child],annotations}")
    protected String fieldListExpression;
    @Value(value="${media.url:https://biocache.ala.org.au/biocache-media/}")
    protected String biocacheMediaUrl;
    @Value(value="${facet.config:/data/biocache/config/facets.json}")
    protected String facetConfig;
    @Value(value="${facets.max:4}")
    public Integer facetsMax;
    @Value(value="${facets.defaultmax:0}")
    public Integer facetsDefaultMax;
    @Value(value="${facet.default:true}")
    public Boolean facetDefault;
    @Value(value="${online.downloadquery.maxthreads:30}")
    protected Integer maxOnlineDownloadThreads = 30;
    @Value(value="${occurrence.cache.cachecontrol.publicorprivate:public}")
    private String occurrenceCacheControlHeaderPublicOrPrivate;
    @Value(value="${occurrence.cache.cachecontrol.maxage:86400}")
    private String occurrenceCacheControlHeaderMaxAge;
    @Value(value="${occurrence.log.enabled:true}")
    private boolean occurrenceLogEnabled = true;
    private final AtomicReference<String> occurrenceETag = new AtomicReference<String>(UUID.randomUUID().toString());
    private ExecutorService executor;

    @PostConstruct
    public void init() throws Exception {
        logger.debug((Object)"Initialising OccurrenceController");
        String nameFormat = "occurrencecontroller-pool-%d";
        this.executor = Executors.newFixedThreadPool(this.maxOnlineDownloadThreads, new ThreadFactoryBuilder().setNameFormat(nameFormat).setPriority(1).build());
        Set indexedFields = this.indexDao.getIndexedFields();
        if (indexedFields != null) {
            new FacetThemes(this.facetConfig, indexedFields, this.facetsMax.intValue(), this.facetsDefaultMax.intValue(), this.facetDefault.booleanValue());
        }
    }

    private Pattern getTaxonIDPattern() {
        if (this.taxonIDPattern == null) {
            this.taxonIDPattern = Pattern.compile(this.taxonIDPatternString);
        }
        return this.taxonIDPattern;
    }

    @InitBinder
    protected void initBinder(WebDataBinder binder) {
        binder.setValidator(this.validator);
    }

    @Hidden
    @RequestMapping(value={"/upload/dynamicFacets", "/upload/dynamicFacets.json"}, method={RequestMethod.GET}, produces={"application/json"})
    @ResponseBody
    public Map emptyJson() {
        HashMap map = new HashMap();
        return map;
    }

    @Secured(value={"ROLE_ADMIN"})
    @SecurityRequirement(name="JWT")
    @Operation(summary="Get list of current downloads", tags={"Monitoring"})
    @Tag(name="Monitoring", description="Admin services for monitoring the application, download stats, and index. Protected APIs require administrative role for access.")
    @RequestMapping(value={"/active/download/stats"}, method={RequestMethod.GET}, produces={"application/json"})
    @ResponseBody
    public List<DownloadDetailsDTO> getCurrentDownloads() {
        return this.downloadService.getCurrentDownloads();
    }

    @Deprecated
    @Operation(summary="List available facets", tags={"Deprecated"})
    @RequestMapping(value={"/search/facets"}, method={RequestMethod.GET}, produces={"application/json"})
    @ResponseBody
    public String[] listAllFacets() {
        return new SearchRequestDTO().getFacets();
    }

    @Operation(summary="List available facets with grouping", tags={"Search"})
    @Tag(name="Search", description="Services for the retrieval of search facets")
    @RequestMapping(value={"/search/grouped/facets"}, method={RequestMethod.GET}, produces={"application/json"})
    @ResponseBody
    public List groupFacets() throws IOException {
        return FacetThemes.getAllThemes();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Operation(summary="List available facets with grouping", tags={"i18n"})
    @Tag(name="i18n", description="Services for retrieval of i18n facets")
    @RequestMapping(value={"/facets/i18n", "/facets/i18n/{qualifier}", "/facets/i18n{qualifier:.*}*"}, method={RequestMethod.GET})
    public void writei18nPropertiesFile(@PathVariable(name="qualifier", required=false) String qualifier, HttpServletRequest request, HttpServletResponse response) throws Exception {
        response.setHeader("Content-Type", "text/plain; charset=UTF-8");
        response.setCharacterEncoding("UTF-8");
        response.setHeader("Cache-Control", this.occurrenceCacheControlHeaderPublicOrPrivate + ", max-age=" + this.occurrenceCacheControlHeaderMaxAge);
        response.setHeader("ETag", (String)this.occurrenceETag.get());
        qualifier = StringUtils.isNotEmpty((String)qualifier) ? qualifier : ".properties";
        logger.debug((Object)("qualifier = " + qualifier));
        File f = new File("/data/biocache/config/messages" + qualifier);
        try (InputStream is = f.exists() && f.isFile() && f.canRead() ? FileUtils.openInputStream((File)f) : request.getSession().getServletContext().getResourceAsStream("/WEB-INF/messages" + qualifier);
             ServletOutputStream os = response.getOutputStream();){
            if (is != null) {
                int bytesRead;
                byte[] buffer = new byte[1024];
                while ((bytesRead = is.read(buffer)) != -1) {
                    os.write(buffer, 0, bytesRead);
                }
            }
            if (StringUtils.isNotEmpty((String)this.layersService.getLayersServiceUrl())) {
                try {
                    Map fields = this.layersService.getLayerNameMap();
                    for (Map.Entry field : fields.entrySet()) {
                        os.write(("\nfield." + (String)field.getKey() + "=" + (String)field.getValue()).getBytes(StandardCharsets.UTF_8));
                        os.write(("\nfacet." + (String)field.getKey() + "=" + (String)field.getValue()).getBytes(StandardCharsets.UTF_8));
                    }
                }
                catch (Exception e) {
                    logger.error((Object)("failed to add layer names from url: " + this.layersService.getLayersServiceUrl()), (Throwable)e);
                }
            }
            os.flush();
        }
    }

    @Operation(summary="List indexed fields", tags={"Search"})
    @RequestMapping(value={"index/fields", "index/fields.json"}, method={RequestMethod.GET}, produces={"application/json"})
    @ResponseBody
    public Collection<IndexFieldDTO> getIndexedFields(@RequestParam(value="fl", required=false) String fields, @RequestParam(value="indexed", required=false) Boolean indexed, @RequestParam(value="stored", required=false) Boolean stored, @RequestParam(value="multivalue", required=false) Boolean multivalue, @RequestParam(value="dataType", required=false) String dataType, @RequestParam(value="classs", required=false) String classs, @RequestParam(value="isMisc", required=false, defaultValue="false") Boolean isMisc, @RequestParam(value="deprecated", required=false, defaultValue="false") Boolean isDeprecated, @RequestParam(value="isDwc", required=false) Boolean isDwc) throws Exception {
        Set<Object> result = fields == null ? this.indexDao.getIndexedFields() : this.indexDao.getIndexFieldDetails(fields.split(","));
        if (indexed != null || stored != null || multivalue != null || dataType != null || classs != null || !isMisc.booleanValue()) {
            HashSet<IndexFieldDTO> filtered = new HashSet<IndexFieldDTO>();
            HashSet<String> dataTypes = dataType == null ? null : new HashSet<String>(Arrays.asList(dataType.split(",")));
            HashSet<String> classss = classs == null ? null : new HashSet<String>(Arrays.asList(classs.split(",")));
            for (IndexFieldDTO i : result) {
                if (indexed != null && i.isIndexed() != indexed.booleanValue() || stored != null && i.isStored() != stored.booleanValue() || multivalue != null && i.isMultivalue() != multivalue.booleanValue() || dataType != null && !dataTypes.contains(i.getDataType()) || classs != null && !classss.contains(i.getClasss()) || !isMisc.booleanValue() && i.getName().startsWith(DYNAMIC_PROPERTIES_PREFIX) || !isDeprecated.booleanValue() && i.isDeprecated() || isDwc != null && isDwc != StringUtils.isNotEmpty((String)i.getDwcTerm())) continue;
                filtered.add(i);
            }
            result = filtered;
        }
        ArrayList<IndexFieldDTO> myList = new ArrayList<IndexFieldDTO>(result);
        Collections.sort(myList, new /* Unavailable Anonymous Inner Class!! */);
        return myList;
    }

    @Operation(summary="Download a list of indexed fields", tags={"Download"})
    @RequestMapping(value={"index/fields.csv"}, method={RequestMethod.GET}, produces={"text/csv", "text/plain"})
    public void getIndexedFields(@RequestParam(value="fl", required=false) String fields, @RequestParam(value="indexed", required=false) Boolean indexed, @RequestParam(value="stored", required=false) Boolean stored, @RequestParam(value="multivalue", required=false) Boolean multivalue, @RequestParam(value="dataType", required=false) String dataType, @RequestParam(value="classs", required=false) String classs, @RequestParam(value="isMisc", required=false, defaultValue="false") Boolean isMisc, @RequestParam(value="deprecated", required=false, defaultValue="false") Boolean isDeprecated, @RequestParam(value="isDwc", required=false) Boolean isDwc, HttpServletResponse response) throws Exception {
        Collection indexedFields = this.getIndexedFields(fields, indexed, stored, multivalue, dataType, classs, isMisc, isDeprecated, isDwc);
        response.setHeader("Cache-Control", "must-revalidate");
        response.setHeader("Pragma", "must-revalidate");
        response.setHeader("Content-Disposition", "attachment;filename=index-fields.csv");
        response.setContentType("text/csv");
        CSVWriter csvWriter = new CSVWriter((Writer)new OutputStreamWriter((OutputStream)response.getOutputStream()));
        csvWriter.writeNext(new String[]{"name", "dwc term", "dwc category", "info", "dataType", "description", "download name", "download description", "json name", "stored", "indexed", "multivalue", "deprecated", "newFieldName"});
        for (IndexFieldDTO indexField : indexedFields) {
            csvWriter.writeNext(new String[]{indexField.getName(), indexField.getDwcTerm(), indexField.getClasss(), indexField.getInfo(), indexField.getDataType(), indexField.getDescription(), indexField.getDownloadName(), indexField.getDownloadDescription(), indexField.getJsonName(), Boolean.toString(indexField.isStored()), Boolean.toString(indexField.isIndexed()), Boolean.toString(indexField.isMultivalue()), Boolean.toString(indexField.isDeprecated()), indexField.getNewFieldName()});
        }
        csvWriter.flush();
        csvWriter.close();
    }

    @Secured(value={"ROLE_ADMIN"})
    @SecurityRequirement(name="JWT")
    @Operation(summary="Show index version information", tags={"Monitoring"})
    @RequestMapping(value={"index/version"}, method={RequestMethod.GET}, produces={"application/json"})
    @ResponseBody
    public Map getIndexedFields(@RequestParam(value="force", required=false, defaultValue="false") Boolean force, HttpServletRequest request, HttpServletResponse response) throws Exception {
        Long version = this.shouldPerformOperation(request, response) ? this.indexDao.getIndexVersion(force) : this.indexDao.getIndexVersion(Boolean.valueOf(false));
        return Collections.singletonMap("version", version);
    }

    @Secured(value={"ROLE_ADMIN"})
    @SecurityRequirement(name="JWT")
    @Operation(summary="Show configured max boolean clauses", tags={"Monitoring"})
    @RequestMapping(value={"index/maxBooleanClauses"}, method={RequestMethod.GET})
    @ResponseBody
    public Map getIndexedFields() {
        int m = this.searchDAO.getMaxBooleanClauses();
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        map.put("maxBooleanClauses", m);
        return map;
    }

    @Secured(value={"ROLE_ADMIN"})
    @SecurityRequirement(name="JWT", scopes={"ROLE_ADMIN"})
    @Operation(summary="Show configuration", tags={"Monitoring"}, description=" Public service that reports limits and other useful config for clients.")
    @RequestMapping(value={"config"}, method={RequestMethod.GET}, produces={"application/json"})
    @ResponseBody
    public Map getConfig() {
        HashMap<String, Constable> map = new HashMap<String, Constable>();
        map.put("maxBooleanClauses", Integer.valueOf(this.searchDAO.getMaxBooleanClauses()));
        map.put("facet.default", this.facetDefault);
        map.put("facets.defaultmax", this.facetsDefaultMax);
        map.put("facets.max", this.facetsMax);
        if (this.searchDAO instanceof SearchDAOImpl) {
            SearchDAOImpl dao = (SearchDAOImpl)this.searchDAO;
            map.put("download.max", dao.MAX_DOWNLOAD_SIZE);
            map.put("download.unzipped.limit", dao.unzippedLimit);
        }
        map.put("citations.enabled", this.downloadService.citationsEnabled);
        map.put("headings.enabled", this.downloadService.headingsEnabled);
        map.put("zip.file.size.mb.max", this.downloadService.maxMB);
        map.put("download.offline.max.size", this.downloadService.dowloadOfflineMaxSize);
        return map;
    }

    @Operation(summary="Get distinct facet counts", tags={"Occurrence"}, description="Can be used to retrieve distinct counts in a query. e.g. the distinct number of scientificName values where stateProvince:Queensland")
    @Tag(name="Occurrence", description="Specimen & observation data searching")
    @RequestMapping(value={"occurrences/facets"}, method={RequestMethod.GET}, produces={"application/json"})
    @ResponseBody
    public List<FacetResultDTO> getOccurrenceFacetDetails(@Valid @ParameterObject SpatialSearchRequestParams params) throws Exception {
        return this.searchDAO.getFacetCounts(SpatialSearchRequestDTO.create((SpatialSearchRequestParams)params));
    }

    @Deprecated
    @Operation(summary="Deprecated - use /occurrences/facets", tags={"Deprecated"})
    @RequestMapping(value={"occurrence/facets.json", "occurrence/facets"}, method={RequestMethod.GET}, produces={"application/json"})
    @ResponseBody
    public List<FacetResultDTO> getOccurrenceFacetDetailsDeprecated(@Valid @ParameterObject SpatialSearchRequestParams params) throws Exception {
        return this.searchDAO.getFacetCounts(SpatialSearchRequestDTO.create((SpatialSearchRequestParams)params));
    }

    @Operation(summary="Show a list of images associated with records for a taxon", tags={"Images"}, description="Returns a list of image urls for the supplied taxon uuid.An empty list is returned when no images are available.")
    @Tag(name="Images", description="Services for the retrieval of taxon image data")
    @RequestMapping(value={"/images/taxon/{taxonConceptID}"}, method={RequestMethod.GET}, produces={"application/json"})
    @ResponseBody
    public List<String> getImages(@PathVariable(name="taxonConceptID") String taxonConceptID) throws Exception {
        SpatialSearchRequestDTO srp = new SpatialSearchRequestDTO();
        srp.setQ("taxonConceptID:" + taxonConceptID);
        srp.setPageSize(Integer.valueOf(0));
        srp.setFacets(new String[]{"imageID"});
        SearchResultDTO results = this.searchDAO.findByFulltextSpatialQuery(srp, false, null);
        if (results.getFacetResults().size() > 0) {
            List fieldResults = ((FacetResultDTO)results.getFacetResults().iterator().next()).getFieldResult();
            ArrayList<String> images = new ArrayList<String>(fieldResults.size());
            for (FieldResultDTO fr : fieldResults) {
                images.add(fr.getLabel());
            }
            return images;
        }
        return Collections.EMPTY_LIST;
    }

    @Operation(summary="Checks to see if the supplied GUID represents an native species", tags={"Taxonomy"}, description="Checks to see if the supplied GUID represents an native species.")
    @RequestMapping(value={"/native/taxon/{taxonConceptID}"}, method={RequestMethod.GET}, produces={"application/json"})
    @ResponseBody
    public NativeDTO isNative(@PathVariable(name="taxonConceptID") String taxonConceptID) throws Exception {
        NativeDTO adto = new NativeDTO();
        if (taxonConceptID != null) {
            adto = this.getIsNativeForGuid(taxonConceptID);
        }
        return adto;
    }

    @Deprecated
    @Operation(summary="Checks to see if the supplied GUIDs represents native species", tags={"Deprecated"})
    @RequestMapping(value={"/native/taxa"}, method={RequestMethod.GET}, produces={"application/json"})
    @ResponseBody
    public List<NativeDTO> isNativeForList(@RequestParam(value="guids") String guids) throws Exception {
        ArrayList<NativeDTO> nativeDTOs = new ArrayList<NativeDTO>();
        String[] guidArray = StringUtils.split((String)guids, (char)',');
        if (guidArray != null) {
            for (String guid : guidArray) {
                nativeDTOs.add(this.getIsNativeForGuid(guid));
                logger.debug((Object)("guid = " + guid));
            }
        }
        return nativeDTOs;
    }

    private NativeDTO getIsNativeForGuid(String taxonConceptID) throws Exception {
        SpatialSearchRequestDTO requestParams = new SpatialSearchRequestDTO();
        requestParams.setPageSize(Integer.valueOf(0));
        requestParams.setFacets(new String[0]);
        String query = "taxonConceptID:" + taxonConceptID + " AND (country:\"" + this.nativeCountry + "\" OR stateProvince:[* TO *])";
        requestParams.setQ(query);
        NativeDTO adto = new NativeDTO();
        adto.setTaxonGuid(taxonConceptID);
        SearchResultDTO results = this.searchDAO.findByFulltextSpatialQuery(requestParams, false, null);
        adto.setHasOccurrenceRecords(results.getTotalRecords() > 0L);
        adto.setIsNSL(this.getTaxonIDPattern().matcher(taxonConceptID).matches());
        if (adto.isHasOccurrences()) {
            requestParams.setQ("taxonConceptID:" + taxonConceptID + " AND (provenance:\"Published dataset\")");
            results = this.searchDAO.findByFulltextSpatialQuery(requestParams, false, null);
            adto.setHasCSOnly(results.getTotalRecords() == 0L);
        }
        return adto;
    }

    @Operation(summary="Search for records for a specific taxon", tags={"Taxonomy"})
    @RequestMapping(value={"/occurrences/taxon/{taxonConceptID}", "/occurrences/taxa/{taxonConceptID}"}, method={RequestMethod.GET}, produces={"application/json"})
    @ResponseBody
    public SearchResultDTO occurrenceSearchByTaxon(@NotNull @PathVariable(name="taxonConceptID") String taxonConceptID, @Valid @ParameterObject SpatialSearchRequestParams requestParams) throws Exception {
        requestParams.setQ("taxonConceptID:" + taxonConceptID);
        SpatialSearchRequestDTO dto = SpatialSearchRequestDTO.create((SpatialSearchRequestParams)requestParams);
        SearchUtils.setDefaultParams((SearchRequestDTO)dto);
        return this.occurrenceSearch(requestParams);
    }

    @Operation(summary="List the data resources with counts of records for a specific taxon", tags={"Deprecated"})
    @RequestMapping(value={"/occurrences/taxon/source/**"}, method={RequestMethod.GET}, produces={"application/json"})
    @Deprecated
    @ResponseBody
    public List<OccurrenceSourceDTO> sourceByTaxon(SpatialSearchRequestParams requestParams, HttpServletRequest request) throws Exception {
        SpatialSearchRequestDTO dto = SpatialSearchRequestDTO.create((SpatialSearchRequestParams)requestParams);
        String guid = this.searchUtils.getGuidFromPath(request);
        requestParams.setQ("taxonConceptID:" + guid);
        Map sources = this.searchDAO.getSourcesForQuery(dto);
        return this.searchUtils.getSourceInformation(sources);
    }

    @Hidden
    @Operation(summary="Occurrence search for a given collection, institution, data_resource or data_provider.", tags={"Deprecated"})
    @RequestMapping(value={"/occurrences/collections/{uid}", "/occurrences/collections/{uid}.json", "/occurrences/institutions/{uid}", "/occurrences/institutions/{uid}.json", "/occurrences/dataResources/{uid}", "/occurrences/dataResources/{uid}.json", "/occurrences/dataProviders/{uid}", "/occurrences/dataProviders/{uid}.json", "/occurrences/dataHubs/{uid}", "/occurrences/dataHubs/{uid}.json"}, method={RequestMethod.GET}, produces={"application/json"})
    @Deprecated
    @ApiParam(value="uid", required=true)
    @ResponseBody
    public SearchResultDTO occurrenceSearchForUID(@Valid @ParameterObject SpatialSearchRequestParams requestParams, @PathVariable(value="uid") String uid) throws Exception {
        SearchResultDTO searchResult = new SearchResultDTO();
        if (StringUtils.isEmpty((String)uid)) {
            return searchResult;
        }
        SpatialSearchRequestDTO dto = SpatialSearchRequestDTO.create((SpatialSearchRequestParams)requestParams);
        SearchUtils.setDefaultParams((SearchRequestDTO)dto);
        this.searchUtils.updateCollectionSearchString((SearchRequestDTO)dto, uid);
        logger.debug((Object)("solr query: " + requestParams));
        return this.occurrenceSearch(requestParams);
    }

    private SearchResultDTO occurrenceSearch(SpatialSearchRequestParams requestParams) throws Exception {
        return this.occurrenceSearch(requestParams, Boolean.valueOf(false), null);
    }

    @Deprecated
    @Operation(summary="Deprecated - use /occurrences/search", tags={"Deprecated"})
    @RequestMapping(value={"/occurrences/search.json*", "/occurrence/search"}, method={RequestMethod.GET}, produces={"application/json"})
    @ResponseBody
    public SearchResultDTO occurrenceSearchDeprecated(@Valid @ParameterObject SpatialSearchRequestParams requestParams, @Parameter(description="Include image metadata") @RequestParam(value="im", required=false, defaultValue="false") Boolean lookupImageMetadata, HttpServletRequest request) throws Exception {
        return this.occurrenceSearch(requestParams, lookupImageMetadata, request);
    }

    @SecurityRequirement(name="JWT")
    @Operation(summary="Occurrence search", description="Occurrence search service that supports facets", tags={"Occurrence"})
    @RequestMapping(value={"/occurrences/search"}, method={RequestMethod.GET}, produces={"application/json"})
    @ResponseBody
    public SearchResultDTO occurrenceSearch(@Valid @ParameterObject SpatialSearchRequestParams requestParams, @Parameter(description="Include image metadata") @RequestParam(value="im", required=false, defaultValue="false") Boolean lookupImageMetadata, HttpServletRequest request) throws Exception {
        Map map;
        SpatialSearchRequestDTO dto = SpatialSearchRequestDTO.create((SpatialSearchRequestParams)requestParams);
        SearchUtils.setDefaultParams((SearchRequestDTO)dto);
        Map map2 = map = request != null ? SearchUtils.getExtraParams((Map)request.getParameterMap()) : null;
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("occurrence search params = " + requestParams + " extra params = " + map));
        }
        SearchResultDTO srtdto = null;
        srtdto = request.getUserPrincipal() != null && request.isUserInRole("ROLE_ADMIN") ? this.searchDAO.findByFulltextSpatialQuery(dto, true, map) : this.searchDAO.findByFulltextSpatialQuery(dto, false, map);
        if (srtdto.getTotalRecords() > 0L && lookupImageMetadata.booleanValue()) {
            ArrayList<String> occurrenceIDs = new ArrayList<String>();
            for (OccurrenceIndex oi : srtdto.getOccurrences()) {
                occurrenceIDs.add(oi.getUuid());
            }
            Map imageMap = this.imageMetadataService.getImageMetadataForOccurrences(occurrenceIDs);
            for (OccurrenceIndex oi : srtdto.getOccurrences()) {
                List imageMetadata = (List)imageMap.get(oi.getUuid());
                oi.setImageMetadata(imageMetadata);
            }
        }
        return srtdto;
    }

    @Secured(value={"ROLE_ADMIN"})
    @SecurityRequirement(name="JWT")
    @Operation(summary="Refresh caches", tags={"Monitoring"})
    @RequestMapping(value={"/cache/refresh"}, method={RequestMethod.GET}, produces={"application/json"})
    @ResponseBody
    public String refreshCache() throws Exception {
        this.searchDAO.refreshCaches();
        new FacetThemes(this.facetConfig, this.indexDao.getIndexedFields(), this.facetsMax.intValue(), this.facetsDefaultMax.intValue(), this.facetDefault.booleanValue());
        this.cacheManager.getCacheNames().forEach(cacheName -> this.cacheManager.getCache(cacheName).clear());
        this.dataQualityService.clearCache();
        this.regenerateETag();
        return null;
    }

    private void regenerateETag() {
        this.occurrenceETag.set(UUID.randomUUID().toString());
    }

    @Operation(summary="Downloads the complete list of values in the supplied facet", tags={"Download", "Occurrence"}, description="Downloads the complete list of values in the supplied e.g. complete list of distinct scientificNames matching a query")
    @RequestMapping(value={"/occurrences/facets/download"}, method={RequestMethod.GET}, produces={"text/csv", "text/plain"})
    public void downloadFacet(@Valid @ParameterObject DownloadRequestParams requestParams, @RequestParam(value="count", required=false, defaultValue="false") boolean includeCount, @RequestParam(value="lookup", required=false, defaultValue="false") boolean lookupName, @RequestParam(value="synonym", required=false, defaultValue="false") boolean includeSynonyms, @RequestParam(value="lists", required=false, defaultValue="false") boolean includeLists, HttpServletRequest request, HttpServletResponse response) {
        DownloadRequestDTO dto = DownloadRequestDTO.create((DownloadRequestParams)requestParams, (HttpServletRequest)request);
        Optional downloadUser = this.authService.getDownloadUser(dto, request);
        if (dto.getFacets().length > 0) {
            try {
                String filename = dto.getFile() != null ? dto.getFile() : dto.getFacets()[0];
                response.setHeader("Cache-Control", "must-revalidate");
                response.setHeader("Pragma", "must-revalidate");
                response.setHeader("Content-Disposition", "attachment;filename=" + filename + ".csv");
                response.setContentType("text/csv");
                this.searchDAO.writeFacetToStream((SpatialSearchRequestDTO)dto, includeCount, lookupName, includeSynonyms, includeLists, (OutputStream)response.getOutputStream(), null);
            }
            catch (Exception e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
        }
    }

    @Operation(summary="Webservice to support bulk downloads for a long list of queries for a single field.", tags={"Occurrence"})
    @RequestMapping(value={"/occurrences/batchSearch"}, method={RequestMethod.POST}, params={"action=Download"})
    public void batchDownload(@ParameterObject DownloadRequestParams requestParams, @RequestParam(value="queries", required=true, defaultValue="") String queries, @RequestParam(value="field", required=true, defaultValue="") String field, @RequestParam(value="separator", defaultValue="\n") String separator, @RequestParam(value="title", required=false) String title, HttpServletResponse response, HttpServletRequest request) throws Exception {
        logger.info((Object)"/occurrences/batchSearch with action=Download Records");
        Long qid = this.getQidForBatchSearch(queries, field, separator, title);
        DownloadRequestDTO downloadRequestDTO = DownloadRequestDTO.create((DownloadRequestParams)requestParams, (HttpServletRequest)request);
        if (qid != null) {
            if ("*:*".equals(downloadRequestDTO.getQ())) {
                downloadRequestDTO.setQ("qid:" + qid);
            } else {
                downloadRequestDTO.setQ("(" + downloadRequestDTO.getQ() + ") AND qid:" + qid);
            }
            String webservicesRoot = request.getSession().getServletContext().getInitParameter("webservicesRoot");
            response.sendRedirect(webservicesRoot + "/occurrences/download?" + downloadRequestDTO.getEncodedParams());
        } else {
            response.sendError(400);
        }
    }

    @Hidden
    @Operation(summary="Webservice to support bulk downloads for a long list of queries for a single field.", tags={"Occurrence"})
    @RequestMapping(value={"/occurrences/download/batchFile"}, method={RequestMethod.GET})
    public String batchDownload(@Valid @ParameterObject DownloadRequestParams requestParams, BindingResult result, @RequestParam(value="file", required=true) String filepath, @RequestParam(value="directory", required=true, defaultValue="/data/biocache-exports") String directory, HttpServletRequest request, HttpServletResponse response, Model model) throws Exception {
        if (result.hasErrors()) {
            if (logger.isInfoEnabled()) {
                logger.info((Object)("validation failed  " + result.getErrorCount() + " checks"));
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)result.toString());
                }
            }
            model.addAttribute("errorMessage", (Object)this.getValidationErrorMessage(result));
            return "error/validationError";
        }
        DownloadRequestDTO dto = DownloadRequestDTO.create((DownloadRequestParams)requestParams, (HttpServletRequest)request);
        Optional downloadUser = this.authService.getDownloadUser(dto, request);
        if (!downloadUser.isPresent()) {
            response.sendError(401, "No authentication");
            return null;
        }
        File file = new File(filepath);
        SpeciesLookupService mySpeciesLookupService = this.speciesLookupService;
        DownloadDetailsDTO dd = new DownloadDetailsDTO(dto, (AlaUserProfile)downloadUser.get(), this.getIPAddress(request), this.getUserAgent(request), DownloadDetailsDTO.DownloadType.RECORDS_INDEX);
        if (file.exists()) {
            2 t = new /* Unavailable Anonymous Inner Class!! */;
            this.executor.submit((Runnable)t);
        }
        return null;
    }

    @Operation(summary="Given a list of queries for a single field, return an AJAX response with the qid (cached query id).", tags={"Occurrence"})
    @RequestMapping(value={"/occurrences/batchSearch"}, method={RequestMethod.POST}, params={"action=Search"})
    public void batchSearch(HttpServletResponse response, @RequestParam(value="redirectBase", required=true, defaultValue="") String redirectBase, @RequestParam(value="queries", required=true, defaultValue="") String queries, @RequestParam(value="field", required=true, defaultValue="") String field, @RequestParam(value="separator", defaultValue="\n") String separator, @RequestParam(value="title", required=false) String title) throws Exception {
        logger.info((Object)"/occurrences/batchSearch with action=Search");
        Long qid = this.getQidForBatchSearch(queries, field, separator, title);
        if (qid != null && StringUtils.isNotBlank((String)redirectBase)) {
            response.sendRedirect(redirectBase + "?q=qid:" + qid);
        } else {
            response.sendError(400, "");
        }
    }

    private Long getQidForBatchSearch(String listOfNames, String field, String separator, String title) throws IOException, QidSizeException {
        String[] rawParts = listOfNames.split(separator);
        StringBuilder sb = new StringBuilder();
        int terms = 0;
        for (String part : rawParts) {
            String normalised = StringUtils.trimToNull((String)part);
            if (normalised == null) continue;
            if (terms == 0) {
                if (sb.length() > 0) {
                    sb.append(" OR ");
                }
                sb.append("(");
            } else {
                sb.append(" OR ");
            }
            String[] fields = field.split(",");
            ArrayList<CallSite> fieldQ = new ArrayList<CallSite>();
            for (String f : fields) {
                fieldQ.add((CallSite)((Object)(f + ":\"" + normalised + "\"")));
            }
            sb.append(String.join((CharSequence)" OR ", fieldQ));
            if (++terms < this.searchDAO.getMaxBooleanClauses()) continue;
            sb.append(")");
            terms = 0;
        }
        if (terms > 0) {
            sb.append(")");
        }
        String q = sb.toString();
        title = title == null ? q : title;
        String qid = this.qidCacheDao.put(q, title, null, null, null, -1L, null);
        logger.info((Object)("batchSearch: qid = " + qid));
        return Long.parseLong(qid);
    }

    @Operation(summary="Report the occurrence counts for the supplied list of taxa", tags={"Occurrence"})
    @RequestMapping(value={"/occurrences/taxaCount"}, method={RequestMethod.POST, RequestMethod.GET}, produces={"application/json"})
    @ResponseBody
    public Map<String, Integer> occurrenceSpeciesCounts(@Parameter(description="taxonConceptIDs, newline separated (by default)") @RequestParam(name="guids") String listOfGuids, @FqField @RequestParam(value="fq", required=false) String[] filterQueries, @RequestParam(defaultValue="\n") String separator, HttpServletResponse response) throws Exception {
        if (StringUtils.isBlank((String)listOfGuids)) {
            response.sendError(400, "Provide a non-empty guids parameter");
            return null;
        }
        String[] rawGuids = listOfGuids.split(separator);
        ArrayList<String> guids = new ArrayList<String>();
        for (String guid : rawGuids) {
            String normalised = StringUtils.trimToNull((String)guid);
            if (normalised == null) continue;
            guids.add(normalised);
        }
        response.setHeader("Cache-Control", this.occurrenceCacheControlHeaderPublicOrPrivate + ", max-age=" + this.occurrenceCacheControlHeaderMaxAge);
        response.setHeader("ETag", (String)this.occurrenceETag.get());
        return this.searchDAO.getOccurrenceCountsForTaxa(guids, filterQueries);
    }

    @Deprecated
    @SecurityRequirement(name="JWT")
    @Operation(summary="Download occurrence service - Synchronous", tags={"Deprecated"}, security={@SecurityRequirement(name="JWT")})
    @GetMapping(value={"/occurrences/download"})
    public void occurrenceDownload(@Valid @ParameterObject DownloadRequestParams downloadParams, @RequestParam(required=false, defaultValue="true") Boolean zip, BindingResult result, Model model, HttpServletResponse response, HttpServletRequest request) throws Exception {
        if (result.hasErrors()) {
            logger.info((Object)("Validation failed  " + result.getErrorCount() + " checks"));
            logger.debug((Object)result.toString());
            model.addAttribute("errorMessage", (Object)this.getValidationErrorMessage(result));
            return;
        }
        DownloadRequestDTO downloadRequestDTO = DownloadRequestDTO.create((DownloadRequestParams)downloadParams, (HttpServletRequest)request);
        Optional downloadUser = this.authService.getDownloadUser(downloadRequestDTO, request);
        if (!downloadUser.isPresent()) {
            response.sendError(403, "A valid registered email is required");
            return;
        }
        if (this.rateLimitRequest(request)) {
            response.sendError(403, "Request is rate limited");
            return;
        }
        if (downloadRequestDTO.getQ().isEmpty() && downloadRequestDTO.getFormattedQuery().isEmpty()) {
            response.sendError(400, "No query specified");
            return;
        }
        try {
            ServletOutputStream out = response.getOutputStream();
            this.downloadService.writeQueryToStream(downloadRequestDTO, response, (AlaUserProfile)downloadUser.get(), this.getIPAddress(request), this.getUserAgent(request), (OutputStream)new CloseShieldOutputStream((OutputStream)out), zip.booleanValue(), this.executor);
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    private Double distInMetres(Double lat1, Double lon1, Double lat2, Double lon2) {
        Double R = 6371000.0;
        double dLat = Math.toRadians(lat2 - lat1);
        double dLon = Math.toRadians(lon2 - lon1);
        double lat1Rad = Math.toRadians(lat1);
        double lat2Rad = Math.toRadians(lat2);
        double a = Math.sin(dLat / 2.0) * Math.sin(dLat / 2.0) + Math.sin(dLon / 2.0) * Math.sin(dLon / 2.0) * Math.cos(lat1Rad) * Math.cos(lat2Rad);
        Double c = 2.0 * Math.atan2(Math.sqrt(a), Math.sqrt(1.0 - a));
        return R * c;
    }

    @Hidden
    @Operation(summary="Utility method for retrieving a list of occurrences", tags={"Deprecated"})
    @RequestMapping(value={"/occurrences/nearest", "/occurrences/nearest.json"}, method={RequestMethod.GET})
    @Deprecated
    @ResponseBody
    public Map<String, Object> nearestOccurrence(SpatialSearchRequestParams requestParams) throws Exception {
        SpatialSearchRequestDTO dto = SpatialSearchRequestDTO.create((SpatialSearchRequestParams)requestParams);
        logger.debug((Object)String.format("Received lat: %f, lon:%f, radius:%f", requestParams.getLat(), requestParams.getLon(), requestParams.getRadius()));
        if (requestParams.getLat() == null || requestParams.getLon() == null) {
            return new HashMap<String, Object>();
        }
        requestParams.setDir("asc");
        requestParams.setFacet(Boolean.valueOf(false));
        SearchResultDTO searchResult = this.searchDAO.findByFulltextSpatialQuery(dto, false, null);
        List ocs = searchResult.getOccurrences();
        if (!ocs.isEmpty()) {
            HashMap<String, Object> results = new HashMap<String, Object>();
            OccurrenceIndex oc = (OccurrenceIndex)ocs.get(0);
            Double decimalLatitude = oc.getDecimalLatitude();
            Double decimalLongitude = oc.getDecimalLongitude();
            Double distance = this.distInMetres(Double.valueOf(requestParams.getLat().doubleValue()), Double.valueOf(requestParams.getLon().doubleValue()), decimalLatitude, decimalLongitude);
            results.put("distanceInMeters", distance);
            results.put("occurrence", oc);
            return results;
        }
        return new HashMap<String, Object>();
    }

    @Deprecated
    @Operation(summary="Dumps the distinct latitudes and longitudes that are used in the connected index (to 4 decimal places)", tags={"Deprecated"})
    @RequestMapping(value={"/occurrences/coordinates"}, method={RequestMethod.GET, RequestMethod.POST})
    public void dumpDistinctLatLongs(SpatialSearchRequestParams requestParams, HttpServletResponse response) throws Exception {
        SpatialSearchRequestDTO dto = SpatialSearchRequestDTO.create((SpatialSearchRequestParams)requestParams);
        requestParams.setFacets(new String[]{"lat_long"});
        requestParams.setFacet(Boolean.valueOf(true));
        if (requestParams.getQ().length() < 1) {
            requestParams.setQ("*:*");
        }
        try {
            ServletOutputStream out = response.getOutputStream();
            this.searchDAO.writeCoordinatesToStream(dto, (OutputStream)out);
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    @Deprecated
    @Operation(summary="Deprecated - use /occurrences/compare/{recordUuid}", tags={"Deprecated"})
    @RequestMapping(value={"/occurrence/compare.json*", "/occurrence/compare/{recordUuid}.json", "/occurrence/compare/{recordUuid}"}, method={RequestMethod.GET})
    @ApiParam(value="recordUuid", required=true)
    @ResponseBody
    public Object showOccurrenceDeprecated(@PathVariable(value="recordUuid") String recordUuid, HttpServletResponse response) throws Exception {
        return this.showOccurrence(recordUuid, response);
    }

    @Deprecated
    @Operation(summary="Deprecated - use /occurrences/compare/{recordUuid}", tags={"Deprecated"})
    @RequestMapping(value={"/occurrence/compare"}, method={RequestMethod.GET})
    @ApiParam(value="recordUuid", required=true)
    @ResponseBody
    public Object showOccurrenceNonRestDeprecated(@RequestParam(value="uuid") String uuid, HttpServletResponse response) throws Exception {
        return this.showOccurrence(uuid, response);
    }

    @Operation(summary="Returns a data structure allowing comparison of verbatim vs interpreted values", tags={"Occurrence"})
    @RequestMapping(value={"/occurrences/compare/{recordUuid}"}, method={RequestMethod.GET}, produces={"application/json"})
    @ApiParam(value="recordUuid", required=true)
    @ResponseBody
    public Object showOccurrence(@PathVariable(value="recordUuid") String recordUuid, HttpServletResponse response) throws Exception {
        SpatialSearchRequestDTO idRequest = new SpatialSearchRequestDTO();
        idRequest.setQ("id:\"" + recordUuid + "\"");
        idRequest.setFl(StringUtils.join(this.indexDao.getIndexedFieldsMap().keySet(), (String)","));
        idRequest.setFacet(Boolean.valueOf(false));
        SolrDocumentList sdl = this.searchDAO.findByFulltext(idRequest);
        if (sdl == null || sdl.isEmpty() || ((SolrDocument)sdl.get(0)).get((Object)"id") == null) {
            response.sendError(404, "Unrecognised ID");
            return null;
        }
        SolrDocument sd = (SolrDocument)sdl.get(0);
        Map fullRecord = this.mapAsFullRecord(sd, Boolean.valueOf(false), Boolean.valueOf(false));
        Map rawGroups = (Map)fullRecord.get("raw");
        Map processedGroups = (Map)fullRecord.get("processed");
        HashSet groupKeys = new HashSet();
        groupKeys.addAll(rawGroups.keySet());
        groupKeys.addAll(processedGroups.keySet());
        groupKeys.remove("el");
        groupKeys.remove("cl");
        groupKeys.remove("queryAssertions");
        groupKeys.remove("miscProperties");
        HashMap groups = new HashMap();
        for (Object groupKey : groupKeys) {
            Object raw = rawGroups.get(groupKey);
            Object processed = processedGroups.get(groupKey);
            if (raw == null || processed == null || !(raw instanceof Map) || !(processed instanceof Map)) continue;
            Map rawMap = (Map)raw;
            Map processedMap = (Map)processed;
            HashSet keys = new HashSet();
            keys.addAll(rawMap.keySet());
            keys.addAll(processedMap.keySet());
            ArrayList<Comparison> comparison = new ArrayList<Comparison>();
            for (Object key : keys) {
                Object r = rawMap.get(key);
                Object p = processedMap.get(key);
                if (r == null && p == null) continue;
                Comparison c = new Comparison();
                c.setName((String)key);
                if (r instanceof String && !StringUtils.isEmpty((String)((String)r))) {
                    c.setRaw(this.authService.substituteEmailAddress((String)r));
                } else if (r != null) {
                    c.setRaw(r.toString());
                } else {
                    c.setRaw("");
                }
                if (p instanceof String && !StringUtils.isEmpty((String)((String)p))) {
                    c.setProcessed(this.authService.substituteEmailAddress((String)p));
                } else if (p != null) {
                    c.setProcessed(p.toString());
                } else {
                    c.setProcessed("");
                }
                comparison.add(c);
            }
            groups.put(StringUtils.capitalize((String)((String)groupKey)), comparison);
        }
        return groups;
    }

    private void sendCustomJSONResponse(HttpServletResponse response, int statusCode, Map<String, String> content) throws IOException {
        response.resetBuffer();
        response.setStatus(statusCode);
        response.setHeader("Content-Type", "application/json");
        response.getOutputStream().print(new ObjectMapper().writeValueAsString(content));
        response.flushBuffer();
    }

    @SecurityRequirement(name="JWT")
    @Operation(summary="Retrieve full record details", tags={"Occurrence"}, description="If an JWT is supplied, and the user has the appropriate permissions the ")
    @RequestMapping(value={"/occurrences/{recordUuid}"}, method={RequestMethod.GET}, produces={"application/json"})
    @ApiParam(value="recordUuid", required=true)
    @ResponseBody
    public Object showOccurrence(@PathVariable(value="recordUuid") String recordUuid, @Parameter(description="Include image metadata") @RequestParam(value="im", required=false, defaultValue="false") Boolean im, HttpServletRequest request, HttpServletResponse response) throws Exception {
        Optional alaUser = this.authService.getRecordViewUser(request);
        Object responseObject = this.getOccurrenceInformation(recordUuid, im, request, alaUser);
        if (responseObject == null) {
            this.sendCustomJSONResponse(response, 404, (Map)new /* Unavailable Anonymous Inner Class!! */);
        }
        return responseObject;
    }

    @Deprecated
    @SecurityRequirement(name="JWT")
    @Operation(summary="Deprecated - use /occurrences/{recordUuid}", tags={"Deprecated"})
    @RequestMapping(value={"/occurrence/{recordUuid:.+}.json", "/occurrences/{recordUuid:.+}.json", "/occurrence/{recordUuid}"}, method={RequestMethod.GET}, produces={"application/json"})
    @ApiParam(value="recordUuid", required=true)
    @ResponseBody
    public Object showOccurrenceDeprecated(@PathVariable(value="recordUuid") String recordUuid, @Parameter(description="Include image metadata") @RequestParam(value="im", required=false, defaultValue="false") Boolean im, HttpServletRequest request, HttpServletResponse response) throws Exception {
        return this.showOccurrence(recordUuid, im, request, response);
    }

    private Object getOccurrenceInformation(String uuid, Boolean includeImageMetadata, HttpServletRequest request, Optional<AlaUserProfile> authenticatedUser) throws Exception {
        logger.debug((Object)("Retrieving occurrence record with guid: '" + uuid + "'"));
        String ip = this.getIPAddress(request);
        SolrDocumentList sdl = null;
        Boolean includeSensitive = false;
        if (!authenticatedUser.isPresent() || authenticatedUser.get().getRoles().isEmpty()) {
            SpatialSearchRequestDTO idRequest = this.createRecirdQuery(uuid);
            sdl = this.searchDAO.findByFulltext(idRequest);
        } else {
            SpatialSearchRequestDTO idRequest;
            String sensitiveFq = this.downloadService.getSensitiveFq(authenticatedUser.get().getRoles());
            if (StringUtils.isNotEmpty((String)sensitiveFq)) {
                idRequest = this.createRecirdQuery(uuid);
                idRequest.setFq(new String[]{sensitiveFq});
                sdl = this.searchDAO.findByFulltext(idRequest);
            }
            if (sdl == null || sdl.isEmpty()) {
                idRequest = this.createRecirdQuery(uuid);
                idRequest.setFq(new String[0]);
                sdl = this.searchDAO.findByFulltext(idRequest);
            } else {
                includeSensitive = true;
            }
        }
        if (sdl == null || sdl.isEmpty()) {
            return null;
        }
        SolrDocument sd = (SolrDocument)sdl.get(0);
        HashSet keys = new HashSet();
        keys.addAll(sd.keySet());
        for (String key : keys) {
            Object value = sd.getFieldValue(key);
            if (value == null) continue;
            boolean notJson = true;
            if (value instanceof String && ((String)value).startsWith("[")) {
                notJson = false;
                try {
                    String[] list = (String[])JSONArray.fromObject((Object)value).toArray((Object[])new String[0]);
                    boolean changed = false;
                    for (int i = 0; i < list.length; ++i) {
                        String v = list[i];
                        if (value.toString().contains("@")) {
                            list[i] = this.authService.substituteEmailAddress(value.toString());
                            changed = true;
                            continue;
                        }
                        if (!key.contains("user_id")) continue;
                        Optional profile = this.authService.lookupAuthUser(v);
                        list[i] = profile.isPresent() ? ((AlaUserProfile)profile.get()).getName() : "";
                        changed = true;
                    }
                    if (changed) {
                        sd.setField(key, (Object)JSONArray.fromObject((Object)list).toString());
                    }
                }
                catch (Exception e) {
                    notJson = true;
                }
            }
            if (!notJson) continue;
            if (value.toString().contains("@") && (key.contains("recorded") || key.startsWith("_") || key.contains("collector"))) {
                sd.setField(key, (Object)this.authService.substituteEmailAddress(value.toString()));
                continue;
            }
            if (!(value instanceof String) || !key.contains("user_id")) continue;
            Optional profile = this.authService.lookupAuthUser(value.toString());
            sd.setField(key, (Object)(profile.isPresent() ? ((AlaUserProfile)profile.get()).getName() : ""));
        }
        if (this.occurrenceLogEnabled) {
            this.logViewEvent(ip, sd, this.getUserAgent(request), null, "Viewing Occurrence Record " + uuid);
        }
        return this.mapAsFullRecord(sd, includeImageMetadata, includeSensitive);
    }

    @org.jetbrains.annotations.NotNull
    private SpatialSearchRequestDTO createRecirdQuery(String uuid) {
        SpatialSearchRequestDTO idRequest = new SpatialSearchRequestDTO();
        idRequest.setQ("id:\"" + uuid + "\"");
        idRequest.setFacet(Boolean.valueOf(false));
        idRequest.setFl(this.fieldListExpression);
        idRequest.setPageSize(Integer.valueOf(1));
        return idRequest;
    }

    private boolean isSensitive(SolrDocument doc) {
        String sensitiveValue = (String)doc.getFieldValue("sensitive");
        return sensitiveValue != null && (sensitiveValue.equals("generalised") || sensitiveValue.equals("alreadyGeneralised"));
    }

    private Map mapAsFullRecord(SolrDocument sd, Boolean includeImageMetadata, Boolean includeSensitive) throws Exception {
        Set schemaFields = this.indexDao.getSchemaFields();
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        Map raw = this.fullRecord(sd, fieldName -> schemaFields.contains(RAW_FIELD_PREFIX + fieldName) ? RAW_FIELD_PREFIX + fieldName : fieldName);
        Map processed = this.fullRecord(sd, fieldName -> schemaFields.contains(RAW_FIELD_PREFIX + fieldName) ? fieldName : null);
        this.addInstant(sd, raw, "lastModifiedTime", "lastLoadDate");
        this.addInstant(sd, processed, "lastModifiedTime", "lastProcessedDate");
        processed.put("el", this.extractLayerValues(sd, "el"));
        processed.put("cl", this.extractLayerValues(sd, "cl"));
        Map location = (Map)processed.get("location");
        location.put("marine", "Marine".equalsIgnoreCase(String.valueOf(sd.getFieldValue("biome"))));
        location.put("terrestrial", "Terrestrial".equalsIgnoreCase(String.valueOf(sd.getFieldValue("biome"))));
        Map occurrence = (Map)processed.get("occurrence");
        String duplicateStatus = (String)sd.getFieldValue("duplicateStatus");
        occurrence.put("duplicateStatus", duplicateStatus);
        if ("REPRESENTATIVE".equals(duplicateStatus)) {
            occurrence.put("duplicationStatus", LEGACY_REPRESENTATIVE_RECORD_VALUE);
        } else if ("ASSOCIATED".equals(duplicateStatus)) {
            occurrence.put("duplicationStatus", LEGACY_DUPLICATE_RECORD_VALUE);
        }
        Collection outlierLayer = sd.getFieldValues("outlierLayer");
        if (outlierLayer != null) {
            occurrence.put("outlierForLayers", outlierLayer);
        }
        raw.put("miscProperties", this.extractMiscProperties(sd));
        map.put("raw", raw);
        map.put("processed", processed);
        map.put("systemAssertions", this.systemAssertions(sd));
        map.put("userAssertions", this.userAssertions(sd));
        map.put("alaUserId", sd.getFieldValue("userId"));
        boolean bSensitive = this.isSensitive(sd);
        map.put("sensitive", bSensitive);
        if (includeSensitive.booleanValue() && bSensitive) {
            Map rawLocation = (Map)raw.get("location");
            Map rawEvent = (Map)raw.get("event");
            this.addField(sd, rawLocation, "dataGeneralizations", "sensitive_dataGeneralizations");
            this.addField(sd, rawLocation, "decimalLatitude", "sensitive_decimalLatitude");
            this.addField(sd, rawLocation, "decimalLongitude", "sensitive_decimalLongitude");
            this.addField(sd, rawLocation, "footprintWKT", "sensitive_footprintWKT");
            this.addField(sd, rawLocation, "locality", "sensitive_locality");
            this.addField(sd, rawLocation, "locationRemarks", "sensitive_locationRemarks");
            this.addField(sd, rawLocation, "verbatimCoordinates", "sensitive_verbatimCoordinates");
            this.addField(sd, rawLocation, "verbatimLatitude", "sensitive_verbatimLatitude");
            this.addField(sd, rawLocation, "verbatimLocality", "sensitive_verbatimLocality");
            this.addField(sd, rawLocation, "verbatimLongitude", "sensitive_verbatimLongitude");
            this.addField(sd, rawEvent, "day", "sensitive_day");
            this.addField(sd, rawEvent, "eventDate", "sensitive_eventDate");
            this.addField(sd, rawEvent, "eventID", "sensitive_eventID");
            this.addField(sd, rawEvent, "eventTime", "sensitive_eventTime");
            this.addField(sd, rawEvent, "month", "sensitive_month");
            this.addField(sd, rawEvent, "verbatimEventDate", "sensitive_verbatimEventDate");
        }
        this.addImages(sd, map, "imageIDs", "images", includeImageMetadata.booleanValue());
        this.addSounds(sd, map, "soundIDs", "sounds");
        Collection annotations = sd.getFieldValues("annotations");
        map.put("referencedPublications", annotations);
        return map;
    }

    private Map<String, Object> extractMiscProperties(SolrDocument sd) {
        HashMap<String, Object> miscProperties = new HashMap<String, Object>();
        try {
            ObjectMapper om = new ObjectMapper();
            Map jsonProperties = (Map)om.readValue((String)sd.getFieldValue(DwcTerm.dynamicProperties.simpleName()), Map.class);
            miscProperties.putAll(jsonProperties);
        }
        catch (Exception om) {
            // empty catch block
        }
        List dynamicProperties = sd.getFieldNames().stream().filter(fieldName -> fieldName.startsWith(DYNAMIC_PROPERTIES_PREFIX)).collect(Collectors.toList());
        for (String property : dynamicProperties) {
            String fieldName2 = property.replaceAll(DYNAMIC_PROPERTIES_PREFIX, "");
            miscProperties.put(fieldName2, sd.get((Object)property));
        }
        return miscProperties;
    }

    private Map extractLayerValues(SolrDocument sd, String key) {
        HashMap map = new HashMap();
        String regex = "^" + key + "[0-9]+$";
        for (Map.Entry es : sd.entrySet()) {
            if (!((String)es.getKey()).matches(regex)) continue;
            map.put(es.getKey(), es.getValue());
        }
        return map;
    }

    private void addField(SolrDocument sd, Map map, String fieldName, Function<String, String> getFieldName) {
        this.addField(sd, map, fieldName, getFieldName.apply(fieldName));
    }

    private void addField(SolrDocument sd, Map map, String fieldNameToUser, String fieldName) {
        map.put(fieldNameToUser, sd.getFieldValue(fieldName));
    }

    private void addAll(SolrDocument sd, Map map, String fieldName, Function<String, String> getFieldName) {
        map.put(fieldName, StringUtils.join((Collection)sd.getFieldValues(getFieldName.apply(fieldName)), (String)"|"));
    }

    private void addLocalDate(SolrDocument sd, Map map, String fieldName, Function<String, String> getFieldName) {
        this.addLocalDate(sd, map, fieldName, getFieldName.apply(fieldName));
    }

    private void addLocalDate(SolrDocument sd, Map map, String fieldNameToUse, String fieldName) {
        Object value = sd.getFieldValue(fieldName);
        if (value != null && value instanceof Date) {
            LocalDate localDate = ((Date)value).toInstant().atZone(ZoneId.systemDefault()).toLocalDate();
            map.put(fieldNameToUse, localDate.toString());
        } else if (value != null) {
            this.addField(sd, map, fieldNameToUse, fieldName);
        }
    }

    private void addInstant(SolrDocument sd, Map map, String fieldNameToUse, String fieldName) {
        Object value = sd.getFieldValue(fieldName);
        if (value != null && value instanceof Date) {
            Instant instant = ((Date)value).toInstant();
            map.put(fieldNameToUse, instant.toString());
        }
    }

    private void addSounds(SolrDocument sd, Map map, String srcKey, String dstKey) {
        Collection value = sd.getFieldValues(srcKey);
        if (value != null && !value.isEmpty()) {
            List strings = value.stream().map(object -> Objects.toString(object, null)).collect(Collectors.toList());
            if (value != null) {
                ArrayList<MediaDTO> mediaDTOs = new ArrayList<MediaDTO>();
                for (String soundID : strings) {
                    MediaDTO m = new MediaDTO();
                    m.getAlternativeFormats().put("audio/mpeg", this.remoteMediaStoreUrl + "/image/proxyImage?imageId=" + soundID);
                    mediaDTOs.add(m);
                }
                map.put(dstKey, mediaDTOs);
            }
        }
    }

    private void addImageUrls(SolrDocument sd, Map map, String srcKey, String dstKey) {
        Collection value = sd.getFieldValues(srcKey);
        if (value != null && !value.isEmpty()) {
            List imageIds = value.stream().map(object -> Objects.toString(object, null)).filter(str -> str != null).map(imageId -> this.remoteMediaStoreUrl + "/image/proxyImage?imageId=" + imageId).collect(Collectors.toList());
            map.put(dstKey, imageIds);
        }
    }

    private void addImages(SolrDocument sd, Map map, String srcKey, String dstKey, boolean lookupImageMetadata) {
        Collection value = sd.getFieldValues(srcKey);
        if (value != null && !value.isEmpty()) {
            List strings = value.stream().map(object -> Objects.toString(object, null)).collect(Collectors.toList());
            if (value != null) {
                String id = (String)sd.getFieldValue("id");
                List mediaDTOs = this.setupImageUrls(id, strings, lookupImageMetadata);
                map.put(dstKey, mediaDTOs);
            }
        }
    }

    private List<Map<String, Object>> userAssertions(SolrDocument sd) throws IOException {
        String occurrenceId = (String)sd.getFieldValue("id");
        UserAssertions userAssertions = this.assertionService.getAssertions(occurrenceId);
        if (userAssertions == null) {
            return new ArrayList<Map<String, Object>>();
        }
        return userAssertions.stream().map(qa -> {
            4 userAssertion = new /* Unavailable Anonymous Inner Class!! */;
            if (qa.getUserId().contains("@")) {
                String email = qa.getUserId();
                Optional profile = this.authService.lookupAuthUser(email);
                String userId = profile.isPresent() ? ((AlaUserProfile)profile.get()).getUserId() : "";
                userAssertion.put("userId", userId);
                userAssertion.put("userEmail", this.authService.substituteEmailAddress(email));
                userAssertion.put("userDisplayName", profile.isPresent() ? ((AlaUserProfile)profile.get()).getName() : "");
            }
            return userAssertion;
        }).collect(Collectors.toList());
    }

    Map fullRecord(SolrDocument sd, Function<String, String> getFieldName) {
        LinkedHashMap<String, Object> fullRecord = new LinkedHashMap<String, Object>();
        fullRecord.put("rowKey", sd.getFieldValue("id"));
        fullRecord.put("uuid", sd.getFieldValue("id"));
        HashMap occurrence = new HashMap();
        fullRecord.put("occurrence", occurrence);
        this.addField(sd, occurrence, "occurrenceID", getFieldName);
        this.addField(sd, occurrence, "accessRights", getFieldName);
        this.addField(sd, occurrence, "associatedMedia", getFieldName);
        this.addField(sd, occurrence, "associatedOccurrences", getFieldName);
        this.addField(sd, occurrence, "associatedOrganisms", getFieldName);
        this.addField(sd, occurrence, "associatedReferences", getFieldName);
        this.addField(sd, occurrence, "associatedSequences", getFieldName);
        this.addField(sd, occurrence, "associatedTaxa", getFieldName);
        this.addField(sd, occurrence, "basisOfRecord", getFieldName);
        this.addField(sd, occurrence, "behavior", getFieldName);
        this.addField(sd, occurrence, "bibliographicCitation", getFieldName);
        this.addField(sd, occurrence, "catalogNumber", getFieldName);
        this.addField(sd, occurrence, "collectionCode", getFieldName);
        this.addField(sd, occurrence, "collectionID", getFieldName);
        this.addField(sd, occurrence, "dataGeneralizations", getFieldName);
        this.addField(sd, occurrence, "datasetID", getFieldName);
        this.addField(sd, occurrence, "datasetName", getFieldName);
        this.addField(sd, occurrence, "disposition", getFieldName);
        this.addField(sd, occurrence, "establishmentMeans", getFieldName);
        this.addField(sd, occurrence, "fieldNotes", getFieldName);
        this.addField(sd, occurrence, "fieldNumber", getFieldName);
        this.addField(sd, occurrence, "individualCount", getFieldName);
        this.addField(sd, occurrence, "informationWithheld", getFieldName);
        this.addField(sd, occurrence, "institutionCode", getFieldName);
        this.addField(sd, occurrence, "institutionID", getFieldName);
        this.addField(sd, occurrence, "language", getFieldName);
        this.addField(sd, occurrence, "lifeStage", getFieldName);
        this.addField(sd, occurrence, "modified", getFieldName);
        this.addField(sd, occurrence, "occurrenceAttributes", getFieldName);
        this.addField(sd, occurrence, "occurrenceDetails", getFieldName);
        this.addField(sd, occurrence, "occurrenceRemarks", getFieldName);
        this.addField(sd, occurrence, "occurrenceStatus", getFieldName);
        this.addField(sd, occurrence, "organismName", getFieldName);
        this.addField(sd, occurrence, "organismQuantity", getFieldName);
        this.addField(sd, occurrence, "organismQuantityType", getFieldName);
        this.addField(sd, occurrence, "organismRemarks", getFieldName);
        this.addField(sd, occurrence, "organismScope", getFieldName);
        this.addField(sd, occurrence, "organismID", getFieldName);
        this.addField(sd, occurrence, "otherCatalogNumbers", getFieldName);
        this.addField(sd, occurrence, "ownerInstitutionCode", getFieldName);
        this.addAll(sd, occurrence, "preparations", getFieldName);
        this.addField(sd, occurrence, "previousIdentifications", getFieldName);
        this.addField(sd, occurrence, "recordNumber", getFieldName);
        this.addField(sd, occurrence, "relatedResourceID", getFieldName);
        this.addField(sd, occurrence, "relationshipAccordingTo", getFieldName);
        this.addField(sd, occurrence, "relationshipEstablishedDate", getFieldName);
        this.addField(sd, occurrence, "relationshipOfResource", getFieldName);
        this.addField(sd, occurrence, "relationshipRemarks", getFieldName);
        this.addField(sd, occurrence, "reproductiveCondition", getFieldName);
        this.addField(sd, occurrence, "resourceID", getFieldName);
        this.addField(sd, occurrence, "resourceRelationshipID", getFieldName);
        this.addField(sd, occurrence, "rights", getFieldName);
        this.addField(sd, occurrence, "rightsHolder", getFieldName);
        this.addField(sd, occurrence, "samplingProtocol", getFieldName);
        this.addField(sd, occurrence, "samplingEffort", getFieldName);
        this.addField(sd, occurrence, "sex", getFieldName);
        this.addField(sd, occurrence, "source", getFieldName);
        this.addField(sd, occurrence, "userId", getFieldName);
        this.addField(sd, occurrence, "type", getFieldName);
        this.addField(sd, occurrence, "collectorFieldNumber", getFieldName);
        this.addField(sd, occurrence, "cultivated", getFieldName);
        this.addField(sd, occurrence, "duplicates", getFieldName);
        this.addField(sd, occurrence, "duplicatesOriginalInstitutionID", getFieldName);
        this.addField(sd, occurrence, "duplicatesOriginalUnitID", getFieldName);
        this.addField(sd, occurrence, "loanIdentifier", getFieldName);
        this.addField(sd, occurrence, "loanSequenceNumber", getFieldName);
        this.addField(sd, occurrence, "loanDestination", getFieldName);
        this.addField(sd, occurrence, "loanForBotanist", getFieldName);
        this.addField(sd, occurrence, "loanDate", getFieldName);
        this.addField(sd, occurrence, "loanReturnDate", getFieldName);
        this.addField(sd, occurrence, "phenology", getFieldName);
        this.addField(sd, occurrence, "preferredFlag", getFieldName);
        this.addField(sd, occurrence, "secondaryCollectors", getFieldName);
        this.addField(sd, occurrence, "naturalOccurrence", getFieldName);
        this.addField(sd, occurrence, "validDistribution", getFieldName);
        this.addField(sd, occurrence, "sounds", "soundIDs");
        this.addField(sd, occurrence, "videos", "videoIDs");
        this.addImageUrls(sd, occurrence, "imageIDs", "images");
        this.addField(sd, occurrence, "interactions", getFieldName);
        this.addField(sd, occurrence, "countryConservation", getFieldName);
        this.addField(sd, occurrence, "stateConservation", getFieldName);
        this.addField(sd, occurrence, "globalConservation", getFieldName);
        this.addField(sd, occurrence, "photographer", getFieldName);
        this.addField(sd, occurrence, "stateInvasive", getFieldName);
        this.addField(sd, occurrence, "countryInvasive", getFieldName);
        this.addField(sd, occurrence, "recordedBy", getFieldName);
        this.addAll(sd, occurrence, "recordedByID", getFieldName);
        this.addAll(sd, occurrence, "identifiedByID", getFieldName);
        HashMap classification = new HashMap();
        fullRecord.put("classification", classification);
        this.addField(sd, classification, "scientificName", getFieldName);
        this.addField(sd, classification, "scientificNameAuthorship", getFieldName);
        this.addField(sd, classification, "scientificNameID", getFieldName);
        this.addField(sd, classification, "taxonConceptID", getFieldName);
        this.addField(sd, classification, "taxonID", getFieldName);
        this.addField(sd, classification, "kingdom", getFieldName);
        this.addField(sd, classification, "phylum", getFieldName);
        this.addField(sd, classification, "classs", getFieldName.apply("class"));
        this.addField(sd, classification, "order", getFieldName);
        this.addField(sd, classification, "superfamily", getFieldName);
        this.addField(sd, classification, "family", getFieldName);
        this.addField(sd, classification, "subfamily", getFieldName);
        this.addField(sd, classification, "genus", getFieldName);
        this.addField(sd, classification, "subgenus", getFieldName);
        this.addField(sd, classification, "species", getFieldName);
        this.addField(sd, classification, "specificEpithet", getFieldName);
        this.addField(sd, classification, "subspecies", getFieldName);
        this.addField(sd, classification, "infraspecificEpithet", getFieldName);
        this.addField(sd, classification, "infraspecificMarker", getFieldName);
        this.addField(sd, classification, "cultivarName", getFieldName);
        this.addField(sd, classification, "higherClassification", getFieldName);
        this.addField(sd, classification, "parentNameUsage", getFieldName);
        this.addField(sd, classification, "parentNameUsageID", getFieldName);
        this.addField(sd, classification, "acceptedNameUsage", getFieldName);
        this.addField(sd, classification, "acceptedNameUsageID", getFieldName);
        this.addField(sd, classification, "originalNameUsage", getFieldName);
        this.addField(sd, classification, "originalNameUsageID", getFieldName);
        this.addField(sd, classification, "taxonRank", getFieldName);
        this.addField(sd, classification, "taxonomicStatus", getFieldName);
        this.addField(sd, classification, "taxonRemarks", getFieldName);
        this.addField(sd, classification, "verbatimTaxonRank", getFieldName);
        this.addField(sd, classification, "vernacularName", getFieldName);
        this.addField(sd, classification, "nameAccordingTo", getFieldName);
        this.addField(sd, classification, "nameAccordingToID", getFieldName);
        this.addField(sd, classification, "namePublishedIn", getFieldName);
        this.addField(sd, classification, "namePublishedInYear", getFieldName);
        this.addField(sd, classification, "namePublishedInID", getFieldName);
        this.addField(sd, classification, "nomenclaturalCode", getFieldName);
        this.addField(sd, classification, "nomenclaturalStatus", getFieldName);
        this.addField(sd, classification, "scientificNameWithoutAuthor", getFieldName);
        this.addField(sd, classification, "scientificNameAddendum", getFieldName);
        this.addField(sd, classification, "taxonRankID", getFieldName);
        this.addField(sd, classification, "kingdomID", getFieldName);
        this.addField(sd, classification, "phylumID", getFieldName);
        this.addField(sd, classification, "classID", getFieldName);
        this.addField(sd, classification, "orderID", getFieldName);
        this.addField(sd, classification, "familyID", getFieldName);
        this.addField(sd, classification, "genusID", getFieldName);
        this.addField(sd, classification, "subgenusID", getFieldName);
        this.addField(sd, classification, "speciesID", getFieldName);
        this.addField(sd, classification, "subspeciesID", getFieldName);
        this.addField(sd, classification, "left", getFieldName.apply("lft"));
        this.addField(sd, classification, "right", getFieldName.apply("rgt"));
        this.addField(sd, classification, "speciesGroups", getFieldName);
        this.addField(sd, classification, "matchType", getFieldName);
        this.addField(sd, classification, "taxonomicIssues", getFieldName);
        this.addField(sd, classification, "nameType", getFieldName);
        HashMap<String, Boolean> location = new HashMap<String, Boolean>();
        fullRecord.put("location", location);
        this.addField(sd, location, "continent", getFieldName);
        this.addField(sd, location, "coordinatePrecision", getFieldName);
        this.addField(sd, location, "coordinateUncertaintyInMeters", getFieldName);
        this.addField(sd, location, "country", getFieldName);
        this.addField(sd, location, "countryCode", getFieldName);
        this.addField(sd, location, "county", getFieldName);
        this.addField(sd, location, "decimalLatitude", getFieldName);
        this.addField(sd, location, "decimalLongitude", getFieldName);
        this.addField(sd, location, "footprintSpatialFit", getFieldName);
        this.addField(sd, location, "footprintWKT", getFieldName);
        this.addField(sd, location, "footprintSRS", getFieldName);
        this.addField(sd, location, "geodeticDatum", getFieldName);
        this.addField(sd, location, "georeferencedBy", getFieldName);
        this.addField(sd, location, "georeferencedDate", getFieldName);
        this.addField(sd, location, "georeferenceProtocol", getFieldName);
        this.addField(sd, location, "georeferenceRemarks", getFieldName);
        this.addField(sd, location, "georeferenceSources", getFieldName);
        this.addField(sd, location, "georeferenceVerificationStatus", getFieldName);
        this.addField(sd, location, "habitat", getFieldName);
        this.addField(sd, location, "biome", getFieldName);
        this.addField(sd, location, "higherGeography", getFieldName);
        this.addField(sd, location, "higherGeographyID", getFieldName);
        this.addField(sd, location, "island", getFieldName);
        this.addField(sd, location, "islandGroup", getFieldName);
        this.addField(sd, location, "locality", getFieldName);
        this.addField(sd, location, "locationAccordingTo", getFieldName);
        this.addField(sd, location, "locationAttributes", getFieldName);
        this.addField(sd, location, "locationID", getFieldName);
        this.addField(sd, location, "locationRemarks", getFieldName);
        this.addField(sd, location, "maximumDepthInMeters", getFieldName);
        this.addField(sd, location, "maximumDistanceAboveSurfaceInMeters", getFieldName);
        this.addField(sd, location, "maximumElevationInMeters", getFieldName);
        this.addField(sd, location, "minimumDepthInMeters", getFieldName);
        this.addField(sd, location, "minimumDistanceAboveSurfaceInMeters", getFieldName);
        this.addField(sd, location, "minimumElevationInMeters", getFieldName);
        this.addField(sd, location, "municipality", getFieldName);
        this.addField(sd, location, "pointRadiusSpatialFit", getFieldName);
        this.addField(sd, location, "stateProvince", getFieldName);
        this.addField(sd, location, "verbatimCoordinates", getFieldName);
        this.addField(sd, location, "verbatimCoordinateSystem", getFieldName);
        this.addField(sd, location, "verbatimDepth", getFieldName);
        this.addField(sd, location, "verbatimElevation", getFieldName);
        this.addField(sd, location, "verbatimLatitude", getFieldName);
        this.addField(sd, location, "verbatimLocality", getFieldName);
        this.addField(sd, location, "verbatimLongitude", getFieldName);
        this.addField(sd, location, "verbatimSRS", getFieldName);
        this.addField(sd, location, "waterBody", getFieldName);
        this.addField(sd, location, "lga", getFieldName);
        this.addField(sd, location, "generalisedLocality", getFieldName);
        this.addField(sd, location, "nearNamedPlaceRelationTo", getFieldName);
        this.addField(sd, location, "australianHerbariumRegion", getFieldName);
        this.addField(sd, location, "distanceOutsideExpertRange", getFieldName);
        this.addField(sd, location, "easting", getFieldName);
        this.addField(sd, location, "northing", getFieldName);
        this.addField(sd, location, "zone", getFieldName);
        this.addField(sd, location, "gridReference", getFieldName);
        this.addField(sd, location, "bbox", getFieldName);
        location.put("marine", "Marine".equalsIgnoreCase(String.valueOf(sd.getFieldValue("biome"))));
        location.put("terrestrial", "Terrestrial".equalsIgnoreCase(String.valueOf(sd.getFieldValue("biome"))));
        HashMap event = new HashMap();
        fullRecord.put("event", event);
        this.addField(sd, event, "eventID", getFieldName);
        this.addField(sd, event, "parentEventID", getFieldName);
        this.addField(sd, event, "datasetName", getFieldName);
        this.addField(sd, event, "day", getFieldName);
        this.addField(sd, event, "endDayOfYear", getFieldName);
        this.addField(sd, event, "eventAttributes", getFieldName);
        this.addLocalDate(sd, event, "eventDate", getFieldName);
        this.addLocalDate(sd, event, "eventDateEnd", getFieldName);
        this.addField(sd, event, "eventRemarks", getFieldName);
        this.addField(sd, event, "eventTime", getFieldName);
        this.addField(sd, event, "verbatimEventDate", getFieldName);
        this.addField(sd, event, "year", getFieldName);
        this.addField(sd, event, "month", getFieldName);
        this.addField(sd, event, "startDayOfYear", getFieldName);
        this.addField(sd, event, "startYear", getFieldName);
        this.addField(sd, event, "endYear", getFieldName);
        this.addField(sd, event, "datePrecision", getFieldName);
        HashMap attribution = new HashMap();
        fullRecord.put("attribution", attribution);
        this.addField(sd, attribution, "dataResourceName", getFieldName);
        this.addField(sd, attribution, "dataResourceUid", "dataResourceUid");
        this.addField(sd, attribution, "dataProviderUid", getFieldName);
        this.addField(sd, attribution, "dataProviderName", getFieldName);
        this.addField(sd, attribution, "collectionUid", getFieldName);
        this.addField(sd, attribution, "institutionUid", getFieldName);
        this.addField(sd, attribution, "dataHubUid", getFieldName);
        this.addField(sd, attribution, "dataHubName", getFieldName);
        this.addField(sd, attribution, "institutionName", getFieldName);
        this.addField(sd, attribution, "collectionName", getFieldName);
        this.addField(sd, attribution, "citation", getFieldName);
        this.addField(sd, attribution, "provenance", getFieldName);
        this.addField(sd, attribution, "license", getFieldName);
        HashMap identification = new HashMap();
        fullRecord.put("identification", identification);
        this.addField(sd, identification, "dateIdentified", getFieldName);
        this.addField(sd, identification, "identificationAttributes", getFieldName);
        this.addField(sd, identification, "identificationID", getFieldName);
        this.addField(sd, identification, "identificationQualifier", getFieldName);
        this.addField(sd, identification, "identificationReferences", getFieldName);
        this.addField(sd, identification, "identificationRemarks", getFieldName);
        this.addField(sd, identification, "identificationVerificationStatus", getFieldName);
        this.addField(sd, identification, "identifiedBy", getFieldName);
        this.addField(sd, identification, "identifierRole", getFieldName);
        this.addField(sd, identification, "typeStatus", getFieldName);
        this.addField(sd, identification, "abcdTypeStatus", getFieldName);
        this.addField(sd, identification, "typeStatusQualifier", getFieldName);
        this.addField(sd, identification, "typifiedName", getFieldName);
        this.addField(sd, identification, "verbatimDateIdentified", getFieldName);
        this.addField(sd, identification, "verifier", getFieldName);
        this.addField(sd, identification, "verificationDate", getFieldName);
        this.addField(sd, identification, "verificationNotes", getFieldName);
        this.addField(sd, identification, "abcdIdentificationQualifier", getFieldName);
        this.addField(sd, identification, "abcdIdentificationQualifierInsertionPoint", getFieldName);
        HashMap measurement = new HashMap();
        fullRecord.put("measurement", measurement);
        this.addField(sd, measurement, "measurementAccuracy", getFieldName);
        this.addField(sd, measurement, "measurementDeterminedBy", getFieldName);
        this.addField(sd, measurement, "measurementDeterminedDate", getFieldName);
        this.addField(sd, measurement, "measurementID", getFieldName);
        this.addField(sd, measurement, "measurementMethod", getFieldName);
        this.addField(sd, measurement, "measurementRemarks", getFieldName);
        this.addField(sd, measurement, "measurementType", getFieldName);
        this.addField(sd, measurement, "measurementUnit", getFieldName);
        this.addField(sd, measurement, "measurementValue", getFieldName);
        this.addField(sd, fullRecord, "assertions", getFieldName);
        HashMap miscProperties = new HashMap();
        fullRecord.put("miscProperties", miscProperties);
        this.addField(sd, miscProperties, "references", getFieldName);
        this.addField(sd, miscProperties, "numIdentificationAgreements", getFieldName);
        HashMap queryAssertions = new HashMap();
        fullRecord.put("queryAssertions", queryAssertions);
        this.addField(sd, fullRecord, "userQualityAssertion", getFieldName);
        this.addField(sd, fullRecord, "hasUserAssertions", getFieldName);
        this.addField(sd, fullRecord, "userAssertionStatus", getFieldName.apply("userAssertions"));
        this.addField(sd, fullRecord, "assertionUserId", getFieldName);
        this.addField(sd, fullRecord, "locationDetermined", getFieldName);
        this.addField(sd, fullRecord, "defaultValuesUsed", getFieldName);
        this.addField(sd, fullRecord, "spatiallyValid", getFieldName);
        fullRecord.put("geospatiallyKosher", (Boolean)sd.getFieldValue("spatiallyValid"));
        fullRecord.put("taxonomicallyKosher", "");
        fullRecord.put("deleted", false);
        this.addField(sd, fullRecord, "userVerified", getFieldName);
        this.addInstant(sd, fullRecord, "firstLoaded", getFieldName.apply("firstLoadedDate"));
        this.addInstant(sd, fullRecord, "lastUserAssertionDate", getFieldName.apply("lastAssertionDate"));
        fullRecord.put("dateDeleted", "");
        return fullRecord;
    }

    private Map systemAssertions(SolrDocument sd) {
        List assertions = (List)sd.getFieldValue("assertions");
        ArrayList<ErrorCode> unchecked = new ArrayList<ErrorCode>();
        List<Object> warning = new ArrayList();
        List<Object> missing = new ArrayList<ErrorCode>();
        List<Object> passed = new ArrayList();
        ArrayList<ErrorCode> allErrorCodes = new ArrayList<ErrorCode>(Arrays.asList(AssertionCodes.getAll()));
        ArrayList<ErrorCode> flaggedErrors = new ArrayList<ErrorCode>();
        if (assertions != null) {
            for (Object assertion : assertions) {
                ErrorCode ec = AssertionCodes.getByName((String)((String)assertion));
                if (ec == null) continue;
                flaggedErrors.add(ec);
                if (ErrorCode.Category.Missing.toString().equalsIgnoreCase(ec.getCategory()) || ec.getName().toLowerCase(Locale.ROOT).startsWith("missing")) {
                    missing.add(ec);
                    continue;
                }
                warning.add(ec);
            }
        }
        for (ErrorCode errorCode : allErrorCodes) {
            if (flaggedErrors.contains(errorCode)) continue;
            if (this.hasRequiredTerms(errorCode, sd)) {
                passed.add(errorCode);
                continue;
            }
            unchecked.add(errorCode);
        }
        passed = passed.stream().sorted((o1, o2) -> o1.getName().compareTo(o2.getName())).collect(Collectors.toList());
        warning = warning.stream().sorted(new /* Unavailable Anonymous Inner Class!! */).collect(Collectors.toList());
        missing = missing.stream().sorted((o1, o2) -> o1.getName().compareTo(o2.getName())).collect(Collectors.toList());
        HashMap<String, List<Object>> systemAssertions = new HashMap<String, List<Object>>();
        systemAssertions.put("missing", missing);
        systemAssertions.put("passed", passed);
        systemAssertions.put("warning", warning);
        systemAssertions.put("unchecked", unchecked);
        return systemAssertions;
    }

    boolean hasRequiredTerms(ErrorCode errorCode, SolrDocument sd) {
        if (errorCode.getTermsRequiredToTest().isEmpty()) {
            return true;
        }
        for (String term : errorCode.getTermsRequiredToTest()) {
            Object termValue = sd.getFieldValue(term);
            Object rawTermValue = sd.getFieldValue(RAW_FIELD_PREFIX + term);
            if (Objects.nonNull(termValue) && termValue instanceof String) {
                if (StringUtils.isNotBlank((String)((String)termValue))) {
                    return true;
                }
                return true;
            }
            if (!Objects.nonNull(rawTermValue) || !(rawTermValue instanceof String)) continue;
            if (StringUtils.isNotBlank((String)((String)rawTermValue))) {
                return true;
            }
            return true;
        }
        return false;
    }

    private void logViewEvent(String ip, SolrDocument occ, String userAgent, String email, String reason) {
        ConcurrentHashMap<String, AtomicInteger> uidStats = new ConcurrentHashMap<String, AtomicInteger>();
        String collectionUid = (String)occ.getFieldValue("collectionUid");
        String institutionUid = (String)occ.getFieldValue("institutionUid");
        String dataProviderUid = (String)occ.getFieldValue("dataProviderUid");
        String dataResourceUid = (String)occ.getFieldValue("dataResourceUid");
        if (StringUtils.isNotEmpty((String)collectionUid)) {
            uidStats.put(collectionUid, new AtomicInteger(1));
        }
        if (StringUtils.isNotEmpty((String)institutionUid)) {
            uidStats.put(institutionUid, new AtomicInteger(1));
        }
        if (StringUtils.isNotEmpty((String)dataProviderUid)) {
            uidStats.put(dataProviderUid, new AtomicInteger(1));
        }
        if (StringUtils.isNotEmpty((String)dataResourceUid)) {
            uidStats.put(dataResourceUid, new AtomicInteger(1));
        }
        if (uidStats != null) {
            ArrayList<String> toRemove = new ArrayList<String>();
            for (String key : uidStats.keySet()) {
                if (((AtomicInteger)uidStats.get(key)).get() >= 0) continue;
                toRemove.add(key);
            }
            for (String key : toRemove) {
                uidStats.remove(key);
            }
        }
        LogEventVO vo = new LogEventVO(LogEventType.OCCURRENCE_RECORDS_VIEWED, email, reason, ip, uidStats);
        vo.setUserAgent(userAgent);
        this.loggerService.logEvent(vo);
    }

    private String getValidationErrorMessage(BindingResult result) {
        StringBuilder sb = new StringBuilder();
        List errors = result.getAllErrors();
        for (ObjectError error : errors) {
            logger.debug((Object)("Code: " + error.getCode()));
            logger.debug((Object)StringUtils.join((Object[])error.getCodes(), (String)"@#$^"));
            String code = error.getCodes() != null && error.getCodes().length > 0 ? error.getCodes()[0] : null;
            logger.debug((Object)("The code in use:" + code));
            sb.append(this.messageSource.getMessage(code, null, error.getDefaultMessage(), null)).append("<br/>");
        }
        return sb.toString();
    }

    private List<MediaDTO> setupImageUrls(String uuid, List<String> imageIDs, boolean lookupImageMetadata) {
        if (imageIDs != null && !imageIDs.isEmpty()) {
            ArrayList<MediaDTO> ml = new ArrayList<MediaDTO>();
            HashMap<String, Object> metadata = new HashMap<String, Object>();
            if (lookupImageMetadata) {
                try {
                    List list = (List)this.imageMetadataService.getImageMetadataForOccurrences(Arrays.asList(uuid)).get(uuid);
                    if (list != null) {
                        for (Object m : list) {
                            metadata.put(String.valueOf(m.get("imageId")), m);
                        }
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            for (String fileNameOrID : imageIDs) {
                try {
                    Object m;
                    m = new MediaDTO();
                    Map urls = this.occurrenceUtils.getImageFormats(fileNameOrID);
                    m.getAlternativeFormats().put("thumbnailUrl", (String)urls.get("thumb"));
                    m.getAlternativeFormats().put("smallImageUrl", (String)urls.get("small"));
                    m.getAlternativeFormats().put("largeImageUrl", (String)urls.get("large"));
                    m.getAlternativeFormats().put("imageUrl", (String)urls.get("raw"));
                    m.setFilePath(fileNameOrID);
                    m.setMetadataUrl(this.imageMetadataService.getUrlFor(fileNameOrID));
                    if (metadata != null && metadata.get(fileNameOrID) != null) {
                        m.setMetadata((Map)metadata.get(fileNameOrID));
                    }
                    ml.add((MediaDTO)m);
                }
                catch (Exception ex) {
                    logger.warn((Object)("Unable to get image data for " + fileNameOrID + ": " + ex.getMessage()));
                }
            }
            return ml;
        }
        return null;
    }
}

