/*
 * Decompiled with CFR 0.152.
 */
package au.org.ala.biocache.web;

import au.org.ala.biocache.dao.PersistentQueueDAO;
import au.org.ala.biocache.dao.SearchDAO;
import au.org.ala.biocache.dto.DownloadDetailsDTO;
import au.org.ala.biocache.dto.DownloadRequestDTO;
import au.org.ala.biocache.dto.DownloadRequestParams;
import au.org.ala.biocache.dto.DownloadStatusDTO;
import au.org.ala.biocache.dto.SpatialSearchRequestDTO;
import au.org.ala.biocache.service.AuthService;
import au.org.ala.biocache.service.DownloadService;
import au.org.ala.biocache.web.AbstractSecureController;
import au.org.ala.biocache.web.ScatterplotController;
import au.org.ala.ws.security.profile.AlaUserProfile;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectWriter;
import io.swagger.annotations.ApiParam;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.Parameters;
import io.swagger.v3.oas.annotations.enums.ParameterIn;
import io.swagger.v3.oas.annotations.media.ArraySchema;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.parameters.RequestBody;
import io.swagger.v3.oas.annotations.security.SecurityRequirement;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.validation.Valid;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.solr.common.SolrDocumentList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.security.access.annotation.Secured;
import org.springframework.stereotype.Controller;
import org.springframework.util.StreamUtils;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class DownloadController
extends AbstractSecureController {
    private static final Logger log = LoggerFactory.getLogger(DownloadController.class);
    private static final org.apache.log4j.Logger logger = org.apache.log4j.Logger.getLogger(ScatterplotController.class);
    @Inject
    protected SearchDAO searchDAO;
    @Inject
    protected PersistentQueueDAO persistentQueueDAO;
    @Inject
    protected AuthService authService;
    @Inject
    protected DownloadService downloadService;
    @Value(value="${auth.legacy.emailonly.downloads.enabled:true}")
    protected Boolean emailOnlyEnabled = true;

    @Deprecated
    @SecurityRequirement(name="JWT")
    @Secured(value={"ROLE_ADMIN"})
    @Operation(summary="Retrieves all the downloads that are on the queue", tags={"Monitoring"})
    @RequestMapping(value={"occurrences/offline/download/stats"}, method={RequestMethod.GET}, produces={"application/json"})
    @ResponseBody
    public Map<String, List<DownloadStatusDTO>> getCurrentDownloads() throws Exception {
        return this.allOccurrenceDownloadStatus();
    }

    @Operation(summary="Asynchronous occurrence download", tags={"Download"})
    @Parameters(value={@Parameter(name="email", description="The email address to sent the download email once complete.", in=ParameterIn.QUERY, required=true), @Parameter(name="reason", description="Reason for download.", in=ParameterIn.QUERY), @Parameter(name="file", description="Download File name.", in=ParameterIn.QUERY), @Parameter(name="fields", description="Fields to download.", in=ParameterIn.QUERY, required=true), @Parameter(name="extra", description="CSV list of extra fields to be added to the download.", in=ParameterIn.QUERY), @Parameter(name="qa", description="the CSV list of issue types to include in the download, defaults to 'all'. Also supports 'none'", in=ParameterIn.QUERY), @Parameter(name="sep", description="Field delimiter for fileType='csv', defaults to ','", in=ParameterIn.QUERY, schema=@Schema(type="char", allowableValues={",", "\t"})), @Parameter(name="esc", description="Field escape for fileType='csv', defaults to '\"'", schema=@Schema(type="char", defaultValue="\""), in=ParameterIn.QUERY), @Parameter(name="dwcHeaders", description="Use darwin core headers, defaults to false", schema=@Schema(type="boolean", defaultValue="false"), in=ParameterIn.QUERY), @Parameter(name="includeMisc", description="Include miscellaneous properties, defaults to false", schema=@Schema(type="boolean", defaultValue="false"), in=ParameterIn.QUERY), @Parameter(name="reasonTypeId", description="Logger reason ID See https://logger.ala.org.au/service/logger/reasons", required=true, schema=@Schema(type="string", defaultValue="10"), in=ParameterIn.QUERY), @Parameter(name="sourceTypeId", description="Source ID See https://logger.ala.org.au/service/logger/sources", schema=@Schema(type="string", defaultValue="0"), in=ParameterIn.QUERY), @Parameter(name="fileType", description="File type. CSV or TSV. Defaults to CSV", schema=@Schema(type="string", allowableValues={"csv", "tsv"}), in=ParameterIn.QUERY), @Parameter(name="customHeader", description="Override header names with a CSV with 'requested field','header' pairs", in=ParameterIn.QUERY), @Parameter(name="mintDoi", description="Request to generate a DOI for the download or not. Default false", schema=@Schema(type="boolean", defaultValue="false"), in=ParameterIn.QUERY), @Parameter(name="emailNotify", description="Send notification email. Default true", schema=@Schema(type="boolean", defaultValue="true"), in=ParameterIn.QUERY), @Parameter(name="q", description="Main search query. Examples 'q=Kangaroo' or 'q=vernacularName:red'", in=ParameterIn.QUERY), @Parameter(name="fq", description="Filter queries. Examples 'fq=state:Victoria&fq=state:Queensland", array=@ArraySchema(schema=@Schema(type="string")), in=ParameterIn.QUERY), @Parameter(name="qId", description="Query ID for persisted queries", in=ParameterIn.QUERY), @Parameter(name="qc", description="The query context to be used for the search. This will be used to generate extra query filters.", in=ParameterIn.QUERY), @Parameter(name="qualityProfile", description="The quality profile to use, null for default", in=ParameterIn.QUERY), @Parameter(name="disableAllQualityFilters", description="Disable all default filters", in=ParameterIn.QUERY), @Parameter(name="disableQualityFilter", description="Default filters to disable (currently can only disable on category, so it's a list of disabled category name)", array=@ArraySchema(schema=@Schema(type="string")), in=ParameterIn.QUERY), @Parameter(name="radius", description="Radius for a spatial search. Use together with lat and lon.", schema=@Schema(type="float"), in=ParameterIn.QUERY), @Parameter(name="lat", description="Decimal latitude for the spatial search. Use together with radius and lon.", schema=@Schema(type="float"), in=ParameterIn.QUERY), @Parameter(name="lon", description="Decimal longitude for the spatial search. Use together with radius and lat.", schema=@Schema(type="float"), in=ParameterIn.QUERY), @Parameter(name="wkt", description="Well Known Text for the spatial search. Large WKT will be simplified.", in=ParameterIn.QUERY)})
    @RequestBody(description="parameters in the body as application/x-www-form-urlencoded or a JSON object", content={@Content(mediaType="application/json"), @Content(mediaType="application/x-www-form-urlencoded")})
    @Tag(name="Download", description="Services for downloading occurrences and specimen data")
    @RequestMapping(value={"occurrences/offline/download"}, method={RequestMethod.GET, RequestMethod.POST})
    @ResponseBody
    public DownloadStatusDTO occurrenceDownload(@Valid @Parameter(hidden=true) DownloadRequestParams requestParams, @Parameter(description="Original IP making the request") @RequestParam(value="ip", required=false) String ip, HttpServletRequest request, HttpServletResponse response) throws Exception {
        DownloadRequestDTO downloadRequestDTO;
        if (request.getContentType() != null && request.getContentType().toLowerCase().contains("application/json")) {
            ObjectMapper om = new ObjectMapper();
            om.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
            String input = StreamUtils.copyToString((InputStream)request.getInputStream(), (Charset)StandardCharsets.UTF_8);
            DownloadRequestParams jsonParams = (DownloadRequestParams)om.readValue(input, DownloadRequestParams.class);
            downloadRequestDTO = DownloadRequestDTO.create((DownloadRequestParams)jsonParams, (HttpServletRequest)request);
        } else {
            downloadRequestDTO = DownloadRequestDTO.create((DownloadRequestParams)requestParams, (HttpServletRequest)request);
        }
        Optional downloadUser = this.authService.getDownloadUser(downloadRequestDTO, request);
        if (!downloadUser.isPresent()) {
            response.sendError(400, "No valid email");
            return null;
        }
        return this.download(downloadRequestDTO, (AlaUserProfile)downloadUser.get(), ip, request.getHeader("user-agent"), request, response, DownloadDetailsDTO.DownloadType.RECORDS_INDEX);
    }

    private DownloadStatusDTO download(DownloadRequestDTO requestParams, AlaUserProfile alaUser, String ip, String userAgent, HttpServletRequest request, HttpServletResponse response, DownloadDetailsDTO.DownloadType downloadType) throws Exception {
        if (alaUser == null || StringUtils.isEmpty((String)alaUser.getEmail())) {
            response.sendError(412, "Unable to perform an offline download without an email address");
            return null;
        }
        ip = ip == null ? request.getRemoteAddr() : ip;
        DownloadDetailsDTO dd = new DownloadDetailsDTO(requestParams, alaUser, ip, userAgent, downloadType);
        requestParams.setPageSize(Integer.valueOf(0));
        requestParams.setFacet(Boolean.valueOf(false));
        SolrDocumentList result = this.searchDAO.findByFulltext((SpatialSearchRequestDTO)requestParams);
        dd.setTotalRecords(result.getNumFound());
        DownloadStatusDTO status = new DownloadStatusDTO();
        DownloadDetailsDTO d = this.persistentQueueDAO.isInQueue(dd);
        status = this.getQueueStatus(d);
        if (d != null) {
            status.setMessage("Already in queue.");
            status.setStatus(DownloadStatusDTO.DownloadStatus.IN_QUEUE);
        } else if (dd.getTotalRecords() > (long)this.downloadService.dowloadOfflineMaxSize.intValue()) {
            File file = new File(this.downloadService.biocacheDownloadDir + File.separator + UUID.nameUUIDFromBytes(dd.getRequestParams().getEmail().getBytes(StandardCharsets.UTF_8)) + File.separator + dd.getStartTime() + File.separator + "tooLarge");
            FileUtils.forceMkdir((File)file.getParentFile());
            FileUtils.writeStringToFile((File)file, (String)requestParams.toString(), (String)"UTF-8");
            status.setDownloadUrl(this.downloadService.biocacheDownloadUrl);
            status.setStatus(DownloadStatusDTO.DownloadStatus.TOO_LARGE);
            status.setMessage(this.downloadService.downloadOfflineMsg);
            status.setError("Requested to many records (" + dd.getTotalRecords() + "). The maximum is (" + this.downloadService.dowloadOfflineMaxSize + ")");
            this.writeStatusFile(dd.getUniqueId(), status);
        } else {
            this.downloadService.add(dd);
            status = this.getQueueStatus(dd);
            this.writeStatusFile(dd.getUniqueId(), status);
        }
        return status;
    }

    @SecurityRequirement(name="JWT")
    @Secured(value={"ROLE_ADMIN"})
    @Operation(summary="List all occurrence downloads", tags={"Monitoring"})
    @RequestMapping(value={"occurrences/offline/status/all"}, method={RequestMethod.GET}, produces={"application/json"})
    @ResponseBody
    public Map<String, List<DownloadStatusDTO>> allOccurrenceDownloadStatus() {
        Map<String, List<DownloadStatusDTO>> downloads = this.persistentQueueDAO.getAllDownloads().stream().collect(Collectors.groupingBy(dd -> dd.getAlaUser().getEmail(), Collectors.mapping(arg_0 -> this.getQueueStatusAdmin(arg_0), Collectors.toList())));
        return downloads;
    }

    @SecurityRequirement(name="JWT")
    @Secured(value={"ROLE_USER"})
    @Operation(summary="List all occurrence downloads by the current user", tags={"Monitoring"})
    @RequestMapping(value={"occurrences/offline/status"}, method={RequestMethod.GET}, produces={"application/json"})
    @ResponseBody
    public Map<String, List<DownloadStatusDTO>> allOccurrenceDownloadStatusForUser(HttpServletRequest request) throws Exception {
        Optional alaUserProfile = this.authService.getRecordViewUser(request);
        Map<String, List<DownloadStatusDTO>> downloads = this.persistentQueueDAO.getAllDownloads().stream().filter(dd -> dd.getAlaUser().getUserId().equals(((AlaUserProfile)alaUserProfile.get()).getUserId())).collect(Collectors.groupingBy(dd -> dd.getAlaUser().getEmail(), Collectors.mapping(arg_0 -> this.getQueueStatus(arg_0), Collectors.toList())));
        return downloads;
    }

    private void writeStatusFile(String id, DownloadStatusDTO status) throws IOException {
        File statusDir = new File(this.downloadService.biocacheDownloadDir + "/" + id.replaceAll("-([0-9]*)$", "/$1"));
        statusDir.mkdirs();
        ObjectWriter ow = new ObjectMapper().writer();
        String json = ow.writeValueAsString((Object)status);
        FileUtils.writeStringToFile((File)new File(statusDir.getPath() + "/status.json"), (String)json, (String)"UTF-8");
    }

    @Operation(summary="Get the status of download", tags={"Download"})
    @RequestMapping(value={"occurrences/offline/status/{id}"}, method={RequestMethod.GET}, produces={"application/json"})
    @ApiParam(value="id", required=true)
    @ResponseBody
    public DownloadStatusDTO occurrenceDownloadStatus(@PathVariable(value="id") String id) {
        List downloads = this.persistentQueueDAO.getAllDownloads();
        for (DownloadDetailsDTO dd : downloads) {
            if (!id.equals(dd.getUniqueId())) continue;
            return this.getQueueStatus(dd);
        }
        String cleanId = id.replaceAll("[^a-z\\-0-9]", "");
        return this.getOtherStatus(cleanId);
    }

    private DownloadStatusDTO getQueueStatusAdmin(DownloadDetailsDTO dd) {
        return this.getQueueStatus(dd, true);
    }

    private DownloadStatusDTO getQueueStatus(DownloadDetailsDTO dd) {
        return this.getQueueStatus(dd, false);
    }

    private DownloadStatusDTO getQueueStatus(DownloadDetailsDTO dd, boolean isAdmin) {
        DownloadStatusDTO status = new DownloadStatusDTO();
        if (dd != null) {
            Optional profile;
            String id = dd.getUniqueId();
            if (dd.getRecordsDownloaded().get() == 0L) {
                status.setStatus(DownloadStatusDTO.DownloadStatus.IN_QUEUE);
                status.setQueueSize(Integer.valueOf(this.downloadService.getDownloadsForUserId(dd.getAlaUser().getUserId()).size()));
            } else {
                status.setStatus(DownloadStatusDTO.DownloadStatus.RUNNING);
                status.setRecords(Long.valueOf(dd.getRecordsDownloaded().longValue()));
            }
            status.setTotalRecords(Long.valueOf(dd.getTotalRecords()));
            status.setStatusUrl(this.downloadService.webservicesRoot + "/occurrences/offline/status/" + id);
            if (isAdmin && (profile = this.authService.lookupAuthUser(dd.getRequestParams().getEmail())).isPresent()) {
                status.setUserId(((AlaUserProfile)profile.get()).getUserId());
            }
            status.setSearchUrl(this.downloadService.generateSearchUrl(dd.getRequestParams()));
            status.setCancelUrl(this.downloadService.webservicesRoot + "/occurrences/offline/cancel/" + dd.getUniqueId());
        }
        return status;
    }

    private DownloadStatusDTO getOtherStatus(String id) {
        File dir;
        DownloadStatusDTO status = new DownloadStatusDTO();
        File statusFile = new File(this.downloadService.biocacheDownloadDir + File.separator + id.replaceAll("-([0-9]*)$", "/$1") + "/status.json");
        if (status.getStatus() == null && statusFile.exists()) {
            ObjectMapper om = new ObjectMapper();
            try {
                status = (DownloadStatusDTO)om.readValue(statusFile, DownloadStatusDTO.class);
            }
            catch (IOException e) {
                logger.error((Object)("failed to read file: " + statusFile.getPath() + ", " + e.getMessage()));
            }
        }
        if ((status.getStatus() == null || status.getStatus() == DownloadStatusDTO.DownloadStatus.RUNNING || status.getStatus() == DownloadStatusDTO.DownloadStatus.IN_QUEUE) && (dir = new File(this.downloadService.biocacheDownloadDir + File.separator + id.replaceAll("-([0-9]*)$", "/$1"))).isDirectory() && dir.exists()) {
            for (File file : dir.listFiles()) {
                if (file.isFile() && file.getPath().endsWith(".zip") && file.length() > 0L) {
                    status.setStatus(DownloadStatusDTO.DownloadStatus.FINISHED);
                    try {
                        status.setDownloadUrl(this.downloadService.biocacheDownloadUrl + File.separator + URLEncoder.encode(file.getPath().replace(this.downloadService.biocacheDownloadDir + "/", ""), "UTF-8").replace("%2F", "/").replace("+", "%20"));
                    }
                    catch (UnsupportedEncodingException e) {
                        logger.error((Object)("Failed to URLEncode for id:" + id + ", " + e.getMessage()));
                    }
                }
                if (!file.isFile() || !"tooLarge".equals(file.getName())) continue;
                status.setStatus(DownloadStatusDTO.DownloadStatus.TOO_LARGE);
                status.setMessage(this.downloadService.downloadOfflineMsg);
                status.setDownloadUrl(this.downloadService.dowloadOfflineMaxUrl);
                status.setError("requested to many records. The upper limit is (" + this.downloadService.dowloadOfflineMaxSize + ")");
            }
        }
        if (status.getStatus() != null) {
            try {
                this.writeStatusFile(id, status);
            }
            catch (IOException e) {
                logger.error((Object)("failed to write status file for id=" + id + ", " + e.getMessage()));
            }
        }
        return status;
    }

    @SecurityRequirement(name="JWT")
    @Secured(value={"ROLE_USER"})
    @Operation(summary="Cancel an offline download", tags={"Monitoring"})
    @RequestMapping(value={"occurrences/offline/cancel/{id}"}, method={RequestMethod.GET})
    @ApiParam(value="id", required=true)
    @ResponseBody
    public DownloadStatusDTO occurrenceDownloadCancel(@PathVariable(value="id") String id, HttpServletRequest request) throws Exception {
        List downloads = this.persistentQueueDAO.getAllDownloads();
        for (DownloadDetailsDTO dd : downloads) {
            if (!id.equals(dd.getUniqueId())) continue;
            AlaUserProfile alaUserProfile = (AlaUserProfile)this.authService.getRecordViewUser(request).get();
            if (!dd.getAlaUser().getUserId().equals(alaUserProfile.getUserId()) && !alaUserProfile.getRoles().contains("ROLE_ADMIN")) continue;
            DownloadStatusDTO status = this.getQueueStatus(dd);
            this.downloadService.cancel(dd);
            status.setStatus(DownloadStatusDTO.DownloadStatus.CANCELLED);
            this.writeStatusFile(dd.getUniqueId(), status);
            return status;
        }
        return null;
    }
}

