/*
 * Decompiled with CFR 0.152.
 */
package au.org.ala.biocache.web;

import au.org.ala.biocache.util.QidMissingException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.solr.common.SolrException;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.handler.SimpleMappingExceptionResolver;

public class CustomExceptionResolver
extends SimpleMappingExceptionResolver {
    protected ModelAndView doResolveException(HttpServletRequest request, HttpServletResponse response, Object handler, Exception ex) {
        String viewName = this.determineViewName(ex, request);
        if (viewName != null) {
            Integer statusCode = this.determineStatusCode(request, viewName, ex);
            if (statusCode != null) {
                this.applyStatusCodeIfPossible(request, response, statusCode.intValue());
            }
            return this.getModelAndView(viewName, ex, request);
        }
        return null;
    }

    protected Integer determineStatusCode(HttpServletRequest request, String viewName, Exception ex) {
        if (ex instanceof SolrException) {
            return ((SolrException)ex).code();
        }
        if (ex instanceof QidMissingException) {
            return 400;
        }
        return this.determineStatusCode(request, viewName);
    }

    protected ModelAndView getModelAndView(String viewName, Exception ex) {
        ModelAndView mv = new ModelAndView(viewName);
        mv.addObject("message", (Object)ex.getMessage());
        String errorType = "Server error";
        if (ex instanceof SolrException) {
            errorType = "Solr error";
        } else if (ex instanceof QidMissingException) {
            errorType = "Qid not found";
        }
        mv.addObject("errorType", (Object)errorType);
        return mv;
    }
}

