/*
 * Decompiled with CFR 0.152.
 */
package au.org.ala.biocache.web;

import au.org.ala.biocache.dao.SearchDAO;
import au.org.ala.biocache.dto.BreakdownRequestDTO;
import au.org.ala.biocache.dto.BreakdownRequestParams;
import au.org.ala.biocache.dto.TaxaRankCountDTO;
import com.fasterxml.jackson.annotation.JsonInclude;
import io.swagger.annotations.ApiParam;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import javax.inject.Inject;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.springdoc.api.annotations.ParameterObject;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class BreakdownController {
    @Inject
    protected SearchDAO searchDAO;

    @Operation(summary="Taxonomic breakdown based on a collection", tags={"Taxonomy"})
    @Tag(name="Taxonomy", description="Suppply breakdown information on occurrence records and taxa")
    @RequestMapping(value={"/breakdown/collections/{uid}"}, method={RequestMethod.GET})
    @ApiParam(value="uid", required=true)
    @ResponseBody
    public TaxaRankCountDTO breakdownByCollection(@ParameterObject BreakdownRequestParams breakdownParams, @PathVariable(value="uid") String uid, HttpServletResponse response) throws Exception {
        return this.performBreakdown("collectionUid", uid, breakdownParams, response);
    }

    @Operation(summary="Taxonomic breakdown based on a institution", tags={"Taxonomy"})
    @RequestMapping(value={"/breakdown/institutions/{uid}"}, method={RequestMethod.GET})
    @ApiParam(value="uid", required=true)
    @ResponseBody
    public TaxaRankCountDTO breakdownByInstitution(@ParameterObject BreakdownRequestParams breakdownParams, @PathVariable(value="uid") String uid, HttpServletResponse response) throws Exception {
        return this.performBreakdown("institutionUid", uid, breakdownParams, response);
    }

    @Operation(summary="Taxonomic breakdown based on a data resource", tags={"Taxonomy"})
    @RequestMapping(value={"/breakdown/dataResources/{uid}"}, method={RequestMethod.GET})
    @ApiParam(value="uid", required=true)
    @ResponseBody
    public TaxaRankCountDTO breakdownByDataResource(@ParameterObject BreakdownRequestParams breakdownParams, @PathVariable(value="uid") String uid, HttpServletResponse response) throws Exception {
        return this.performBreakdown("dataResourceUid", uid, breakdownParams, response);
    }

    @Operation(summary="Taxonomic breakdown based on a data provider", tags={"Taxonomy"})
    @RequestMapping(value={"/breakdown/dataProviders/{uid}"}, method={RequestMethod.GET})
    @ApiParam(value="uid", required=true)
    @ResponseBody
    public TaxaRankCountDTO breakdownByDataProvider(@ParameterObject BreakdownRequestParams breakdownParams, @PathVariable(value="uid") String uid, HttpServletResponse response) throws Exception {
        return this.performBreakdown("dataProviderUid", uid, breakdownParams, response);
    }

    @Operation(summary="Taxonomic breakdown based on a data hub", tags={"Taxonomy"})
    @RequestMapping(value={"/breakdown/dataHubs/{uid}"}, method={RequestMethod.GET})
    @ApiParam(value="uid", required=true)
    @ResponseBody
    public TaxaRankCountDTO breakdownByDataHub(@ParameterObject BreakdownRequestParams requestParams, @PathVariable(value="uid") String uid, HttpServletResponse response) throws Exception {
        return this.performBreakdown("dataHubUid", uid, requestParams, response);
    }

    @Operation(summary="A breakdown based on taxon rank", tags={"Taxonomy"})
    @RequestMapping(value={"/breakdown", "/breakdown.json*"}, method={RequestMethod.GET})
    @ResponseBody
    public TaxaRankCountDTO breakdownByQuery(@ParameterObject BreakdownRequestParams breakdownParams, HttpServletResponse response) throws Exception {
        if (StringUtils.isNotEmpty((String)breakdownParams.getQ())) {
            if (breakdownParams.getMax() != null || StringUtils.isNotEmpty((String)breakdownParams.getRank()) || StringUtils.isNotEmpty((String)breakdownParams.getLevel())) {
                return this.searchDAO.calculateBreakdown(BreakdownRequestDTO.create((BreakdownRequestParams)breakdownParams));
            }
            response.sendError(400, "No context provided for breakdown.  Please supply either max, rank or level as a minimum");
        } else {
            response.sendError(400, "No query provided for breakdown");
        }
        return null;
    }

    private TaxaRankCountDTO performBreakdown(String source, String uid, BreakdownRequestParams requestParams, HttpServletResponse response) throws Exception {
        StringBuilder sb = new StringBuilder("(");
        for (String u : uid.split(",")) {
            if (sb.length() > 1) {
                sb.append(" OR ");
            }
            sb.append(source).append(":").append(u);
        }
        sb.append(")");
        requestParams.setQ(sb.toString());
        return this.breakdownByQuery(requestParams, response);
    }
}

