/*
 * Decompiled with CFR 0.152.
 */
package au.org.ala.biocache.util.solr;

import au.org.ala.biocache.util.solr.FieldMappingUtil;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.log4j.Logger;
import org.apache.solr.common.params.ModifiableSolrParams;
import org.apache.solr.common.params.SolrParams;

public class FieldMappedSolrParams
extends SolrParams {
    private static final Logger logger = Logger.getLogger(FieldMappedSolrParams.class);
    final SolrParams originalParams;
    ModifiableSolrParams translatedSolrParams;
    Map<String, Map<String, String[]>> paramsInverseTranslations = new HashMap();

    public FieldMappedSolrParams(FieldMappingUtil fieldMappingUtil, SolrParams solrParams) {
        this.originalParams = solrParams;
        this.translateSolrParams(fieldMappingUtil, solrParams);
    }

    private void translateSolrParams(FieldMappingUtil fieldMappingUtil, SolrParams solrParams) {
        logger.debug((Object)("before translation: " + solrParams.toQueryString()));
        this.translatedSolrParams = new ModifiableSolrParams();
        solrParams.getParameterNamesIterator().forEachRemaining(paramName -> {
            HashMap inverseTranslations = new HashMap();
            Consumer<Pair> addParamTranslation = mapping -> {
                String[] old = inverseTranslations.put((String)mapping.getRight(), new String[]{(String)mapping.getLeft()});
                if (old != null) {
                    String[] both = new String[old.length + 1];
                    System.arraycopy(old, 0, both, 0, old.length);
                    both[old.length] = (String)mapping.getLeft();
                    inverseTranslations.put((String)mapping.getRight(), both);
                }
            };
            switch (paramName) {
                case "q": 
                case "fq": {
                    this.translatedSolrParams.set(paramName, (String[])Arrays.stream(solrParams.getParams(paramName)).map(param -> fieldMappingUtil.translateQueryFields(addParamTranslation, param)).toArray(String[]::new));
                    break;
                }
                case "fl": {
                    this.translatedSolrParams.set(paramName, fieldMappingUtil.translateFieldList(addParamTranslation, solrParams.getParams(paramName)));
                    break;
                }
                case "sort": {
                    String[] translatedParams = (String[])Arrays.stream(solrParams.getParams(paramName)).map(sortFields -> Arrays.stream(sortFields.split(",")).map(sortField -> {
                        String[] sortParams = sortField.split("\\s+", 2);
                        if (sortParams.length < 2) {
                            return sortField;
                        }
                        String translatedField = fieldMappingUtil.translateFieldName(sortParams[0]);
                        return translatedField + " " + sortParams[1];
                    }).collect(Collectors.joining(","))).toArray(String[]::new);
                    this.translatedSolrParams.set(paramName, translatedParams);
                    break;
                }
                case "facet.field": 
                case "facet.range": 
                case "facet.pivot": 
                case "stats.facet": {
                    this.translatedSolrParams.set(paramName, fieldMappingUtil.translateFieldArray(addParamTranslation, solrParams.getParams(paramName)));
                    break;
                }
                default: {
                    this.translatedSolrParams.set(paramName, solrParams.getParams(paramName));
                }
            }
            if (inverseTranslations.size() > 0) {
                this.paramsInverseTranslations.put(paramName, inverseTranslations);
            }
        });
        logger.debug((Object)("after translation: " + this.translatedSolrParams.toQueryString()));
    }

    public String get(String s) {
        return this.translatedSolrParams.get(s);
    }

    public String[] getParams(String s) {
        return this.translatedSolrParams.getParams(s);
    }

    public Iterator<String> getParameterNamesIterator() {
        return this.translatedSolrParams.getParameterNamesIterator();
    }
}

