/*
 * Decompiled with CFR 0.152.
 */
package au.org.ala.biocache.util;

import au.org.ala.biocache.dto.OccurrenceSourceDTO;
import au.org.ala.biocache.dto.SearchRequestDTO;
import au.org.ala.biocache.dto.SpatialSearchRequestDTO;
import au.org.ala.biocache.util.CollectionsCache;
import au.org.ala.biocache.util.SearchUtils;
import au.org.ala.names.ws.api.NameSearch;
import au.org.ala.names.ws.api.NameUsageMatch;
import au.org.ala.names.ws.client.ALANameUsageMatchServiceClient;
import java.lang.reflect.Field;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.inject.Inject;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.time.DateFormatUtils;
import org.apache.log4j.Logger;
import org.apache.solr.client.solrj.util.ClientUtils;
import org.apache.solr.common.util.SimpleOrderedMap;
import org.gbif.api.vocabulary.Rank;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.MessageSource;
import org.springframework.stereotype.Component;
import org.springframework.util.AntPathMatcher;
import org.springframework.util.CollectionUtils;
import org.springframework.web.servlet.HandlerMapping;

/*
 * Exception performing whole class analysis ignored.
 */
@Component(value="searchUtils")
public class SearchUtils {
    private static final Pattern DUD_URL_PATTERN;
    private static final Logger logger;
    @Inject
    private CollectionsCache collectionCache;
    @Value(value="${auth.substitution.fields:}")
    protected String authServiceFields = "";
    public Set<String> authIndexFields = new HashSet();
    @Inject
    private MessageSource messageSource;
    @Inject
    private ALANameUsageMatchServiceClient nameUsageMatchService;
    protected static List<String> defaultParams;
    private final List<String> ranks = CollectionUtils.arrayToList((Object)new String[]{"kingdom", "phylum", "class", "order", "family", "genus", "species"});

    public static Object getVal(Object input, Object ... filters) {
        Object item = SearchUtils.getItem((Object)input, (Object[])ArrayUtils.subarray((Object[])filters, (int)0, (int)(filters.length - 1)));
        Object lastFilter = filters[filters.length - 1];
        if (item == null) {
            return item;
        }
        if (lastFilter instanceof Integer) {
            return ((SimpleOrderedMap)item).getVal(((Integer)lastFilter).intValue());
        }
        return ((SimpleOrderedMap)item).get((String)lastFilter);
    }

    public static List<SimpleOrderedMap> getList(Object input, Object ... filters) {
        ArrayList list = SearchUtils.getItem((Object)input, (Object[])filters);
        if (list == null) {
            list = new ArrayList();
        }
        return list;
    }

    public static SimpleOrderedMap getMap(Object input, Object ... filters) {
        return (SimpleOrderedMap)SearchUtils.getItem((Object)input, (Object[])filters);
    }

    public static Object getItem(Object input, Object ... filters) {
        Object item = input;
        for (int i = 0; item != null && i < filters.length; ++i) {
            Object filter = filters[i];
            if (filter instanceof String) {
                item = ((SimpleOrderedMap)item).get((String)filter);
                continue;
            }
            if (!(filter instanceof Number)) continue;
            item = ((List)item).get((Integer)filter);
        }
        return item;
    }

    public boolean updateCollectionSearchString(SearchRequestDTO searchParams, String uid) {
        try {
            String[] uids = uid.split(",");
            searchParams.setQ(this.getUIDSearchString(uids));
            return true;
        }
        catch (Exception e) {
            logger.error((Object)("Problem contacting the collectory: " + e.getMessage()), (Throwable)e);
            return false;
        }
    }

    public String getUIDSearchString(String[] uids) {
        StringBuilder sb = new StringBuilder();
        for (String uid : uids) {
            if (sb.length() > 0) {
                sb.append(" OR ");
            }
            sb.append(this.getUidSearchField(uid));
            sb.append(":");
            sb.append(uid);
        }
        return sb.toString();
    }

    public static String stripEscapedQuotes(String uid) {
        if (uid == null) {
            return null;
        }
        if (uid.startsWith("\"") && uid.endsWith("\"") && uid.length() > 2) {
            return uid.substring(1, uid.length() - 1);
        }
        if (uid.startsWith("\\\"") && uid.endsWith("\\\"") && uid.length() > 4) {
            return uid.substring(2, uid.length() - 2);
        }
        return uid;
    }

    public String getUidDisplayString(String fieldName, String uid) {
        return this.getUidDisplayString(fieldName, uid, true);
    }

    public String getUidDisplayString(String fieldName, String uid, boolean includeField) {
        if (uid == null) {
            return null;
        }
        if ((uid = SearchUtils.stripEscapedQuotes((String)uid)).startsWith("in") && this.collectionCache.getInstitutions().containsKey(uid)) {
            if (includeField) {
                return "Institution: " + (String)this.collectionCache.getInstitutions().get(uid);
            }
            return (String)this.collectionCache.getInstitutions().get(uid);
        }
        if (uid.startsWith("co") && this.collectionCache.getCollections().containsKey(uid)) {
            if (includeField) {
                return "Collection: " + (String)this.collectionCache.getCollections().get(uid);
            }
            return (String)this.collectionCache.getCollections().get(uid);
        }
        if (uid.startsWith("drt") && this.collectionCache.getTempDataResources().containsKey(uid)) {
            if (includeField) {
                return "Temporary Data resource: " + (String)this.collectionCache.getTempDataResources().get(uid);
            }
            return (String)this.collectionCache.getTempDataResources().get(uid);
        }
        if (uid.startsWith("dr") && this.collectionCache.getDataResources().containsKey(uid) && fieldName.startsWith("annotation")) {
            if (includeField) {
                return "Publication: " + (String)this.collectionCache.getDataResources().get(uid);
            }
            return (String)this.collectionCache.getDataResources().get(uid);
        }
        if (uid.startsWith("dr") && this.collectionCache.getDataResources().containsKey(uid)) {
            if (includeField) {
                return "Data resource: " + (String)this.collectionCache.getDataResources().get(uid);
            }
            return (String)this.collectionCache.getDataResources().get(uid);
        }
        if (uid.startsWith("dp") && this.collectionCache.getDataProviders().containsKey(uid)) {
            if (includeField) {
                return "Data provider: " + (String)this.collectionCache.getDataProviders().get(uid);
            }
            return (String)this.collectionCache.getDataProviders().get(uid);
        }
        if (uid.startsWith("dh") && this.collectionCache.getDataHubs().containsKey(uid)) {
            if (includeField) {
                return "Data hub: " + (String)this.collectionCache.getDataHubs().get(uid);
            }
            return (String)this.collectionCache.getDataHubs().get(uid);
        }
        String value = StringUtils.remove((String)uid, (String)"\"");
        return this.messageSource.getMessage(fieldName + "." + value, null, uid, null);
    }

    public String convertRankAndName(String query) {
        Pattern rankAndName = Pattern.compile("([a-z]{1,})\\:([A-Za-z \\(\\)\\.]{1,})");
        int position = 0;
        Matcher m = rankAndName.matcher(query);
        if (m.find(position) && m.groupCount() == 2) {
            String rank = m.group(1);
            String scientificName = m.group(2);
            Rank rankType = Rank.valueOf((String)rank.toUpperCase());
            if (rankType != null) {
                try {
                    NameUsageMatch nameUsageMatch = this.nameUsageMatchService.match(NameSearch.builder().rank(rankType.name().toLowerCase()).scientificName(scientificName).build());
                    if (nameUsageMatch != null && nameUsageMatch.isSuccess()) {
                        return "lft:[" + nameUsageMatch.getLft() + " TO " + nameUsageMatch.getRgt() + "]";
                    }
                }
                catch (Exception e) {
                    logger.error((Object)e.getMessage(), (Throwable)e);
                }
            }
        }
        return query;
    }

    public String[] getTaxonSearch(String taxonId) {
        try {
            NameUsageMatch nameUsageMatch = this.nameUsageMatchService.get(taxonId);
            if (nameUsageMatch != null && nameUsageMatch.isSuccess()) {
                String rank = nameUsageMatch.getRank() != null ? nameUsageMatch.getRank() : "Unknown Rank";
                String scientificName = nameUsageMatch.getScientificName() != null ? nameUsageMatch.getScientificName() : null;
                StringBuffer dispSB = new StringBuffer(rank + ": " + scientificName);
                StringBuilder sb = new StringBuilder("lft:[");
                int lft = nameUsageMatch.getLft() != null ? nameUsageMatch.getLft() : 0;
                int rgt = nameUsageMatch.getRgt() != null ? nameUsageMatch.getRgt() : 0;
                sb.append(lft).append(" TO ").append(rgt).append("]");
                return new String[]{sb.toString(), dispSB.toString()};
            }
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        return new String[]{"taxonConceptID:\"" + ClientUtils.escapeQueryChars((String)taxonId) + "\"", "taxonConceptID:\"" + taxonId + "\""};
    }

    public String getGuidFromPath(HttpServletRequest request) {
        Matcher duds;
        Object guid = new AntPathMatcher().extractPathWithinPattern((String)request.getAttribute(HandlerMapping.BEST_MATCHING_PATTERN_ATTRIBUTE), request.getServletPath());
        if (((String)guid).endsWith(".json")) {
            guid = ((String)guid).substring(0, ((String)guid).length() - 5);
        }
        if ((duds = DUD_URL_PATTERN.matcher((CharSequence)guid)).matches()) {
            guid = duds.group(1) + "/" + duds.group(2);
        }
        return guid;
    }

    public String getUidSearchField(String uid) {
        if (uid.startsWith("co")) {
            return "collectionUid";
        }
        if (uid.startsWith("in")) {
            return "institutionUid";
        }
        if (uid.startsWith("dr")) {
            return "dataResourceUid";
        }
        if (uid.startsWith("dp")) {
            return "dataProviderUid";
        }
        if (uid.startsWith("dh")) {
            return "dataHubUid";
        }
        return null;
    }

    public List<String> getNextRanks(String rank, boolean includeSuppliedRank) {
        int start;
        int n = start = includeSuppliedRank ? this.ranks.indexOf(rank) : this.ranks.indexOf(rank) + 1;
        if (start > 0) {
            return this.ranks.subList(start, this.ranks.size());
        }
        return this.ranks;
    }

    public List<String> getRanks() {
        return this.ranks;
    }

    public List<OccurrenceSourceDTO> getSourceInformation(Map<String, Integer> sources) {
        Set<String> keys = sources.keySet();
        logger.debug((Object)("Listing the source information for : " + keys));
        ArrayList<OccurrenceSourceDTO> lsources = new ArrayList<OccurrenceSourceDTO>();
        try {
            Iterator<String> iterator = keys.iterator();
            while (iterator.hasNext()) {
                String key;
                String name = key = iterator.next();
                if (key.startsWith("co")) {
                    name = (String)this.collectionCache.getCollections().get(key);
                } else if (key.startsWith("in")) {
                    name = (String)this.collectionCache.getInstitutions().get(key);
                } else if (key.startsWith("drt")) {
                    name = (String)this.collectionCache.getTempDataResources().get(key);
                } else if (key.startsWith("dr")) {
                    name = (String)this.collectionCache.getDataResources().get(key);
                } else if (key.startsWith("dp")) {
                    name = (String)this.collectionCache.getDataProviders().get(key);
                } else if (key.startsWith("dh")) {
                    name = (String)this.collectionCache.getDataHubs().get(key);
                }
                lsources.add(new OccurrenceSourceDTO(name, key, sources.get(key).intValue()));
            }
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage());
        }
        Collections.sort(lsources, new /* Unavailable Anonymous Inner Class!! */);
        return lsources;
    }

    public static void setDefaultParams(SearchRequestDTO requestParams) {
        SearchRequestDTO blankRequestParams = new SearchRequestDTO();
        logger.debug((Object)("requestParams = " + requestParams));
        if (requestParams.getStart() == null) {
            requestParams.setStart(blankRequestParams.getStart());
        }
        if (requestParams.getPageSize() == null) {
            requestParams.setPageSize(blankRequestParams.getPageSize());
        }
        if (requestParams.getSort() == null || requestParams.getSort().isEmpty()) {
            requestParams.setSort(blankRequestParams.getSort());
        }
        if (requestParams.getDir() == null || requestParams.getDir().isEmpty()) {
            requestParams.setDir(blankRequestParams.getDir());
        }
        if (requestParams.getFacet() == null) {
            requestParams.setFacet(blankRequestParams.getFacet());
        }
        if (requestParams.getFacets() == null) {
            requestParams.setFacets(blankRequestParams.getFacets());
        }
    }

    public static Map<String, String[]> getExtraParams(Map map) {
        HashMap<String, String[]> extraParams = new HashMap<String, String[]>(map);
        for (String field : defaultParams) {
            extraParams.remove(field);
        }
        return extraParams;
    }

    public String substituteLsidsForNames(String fieldValue) {
        NameUsageMatch nameUsageMatch = this.nameUsageMatchService.get(fieldValue);
        if (nameUsageMatch != null && nameUsageMatch.isSuccess()) {
            return nameUsageMatch.getScientificName();
        }
        return fieldValue;
    }

    public String substituteMonthNamesForNums(String fv) {
        try {
            String monthStr = new String(fv);
            int m = Integer.parseInt(monthStr.replaceAll("\"", ""));
            Month month = Month.get((int)(m - 1));
            return month.name();
        }
        catch (Exception exception) {
            return fv;
        }
    }

    public String substituteYearsForDates(String fieldValue) {
        Object dateRange = URLDecoder.decode(fieldValue);
        String formattedDate = StringUtils.replaceChars((String)dateRange, (String)"[]\\", (String)"");
        String[] dates = formattedDate.split(" TO ");
        if (dates != null && dates.length > 1) {
            dateRange = StringUtils.substring((String)dates[0], (int)0, (int)4) + "-" + StringUtils.substring((String)dates[1], (int)0, (int)4);
        }
        return dateRange;
    }

    public Set<String> getAuthIndexFields() {
        if (this.authIndexFields.size() == 0) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Auth substitution fields to use: " + this.authServiceFields));
            }
            HashSet set = new HashSet();
            CollectionUtils.mergeArrayIntoCollection((Object)this.authServiceFields.split(","), set);
            this.authIndexFields = set;
        }
        return this.authIndexFields;
    }

    public static String formatValue(Object value) {
        if (value instanceof Date) {
            return value == null ? "" : DateFormatUtils.format((Date)((Date)value), (String)"yyyy-MM-dd");
        }
        return value == null ? "" : value.toString();
    }

    static {
        Field[] fields;
        DUD_URL_PATTERN = Pattern.compile("([a-z]+:/)([^/].*)");
        logger = Logger.getLogger(SearchUtils.class);
        defaultParams = new ArrayList();
        for (Field field : fields = (Field[])ArrayUtils.addAll((Object[])SpatialSearchRequestDTO.class.getDeclaredFields(), (Object[])SearchRequestDTO.class.getDeclaredFields())) {
            defaultParams.add(field.getName());
        }
    }
}

