/*
 * Decompiled with CFR 0.152.
 */
package au.org.ala.biocache.stream;

import au.org.ala.biocache.dao.SearchDAOImpl;
import au.org.ala.biocache.dto.DownloadDetailsDTO;
import au.org.ala.biocache.dto.SpatialSearchRequestDTO;
import au.org.ala.biocache.stream.ProcessInterface;
import au.org.ala.biocache.writer.CSVRecordWriter;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.io.output.CloseShieldOutputStream;
import org.apache.commons.lang.ArrayUtils;
import org.apache.log4j.Logger;
import org.apache.solr.client.solrj.io.Tuple;

public class StreamFacet
implements ProcessInterface {
    private static final Logger logger = Logger.getLogger(StreamFacet.class);
    private static final String[] lsidFields = new String[]{"taxonConceptID", "kingdomID", "classID", "phylumID", "orderID", "familyID", "genusID", "speciesID", "subspeciesID", "raw_taxonConceptID", "raw_kingdomID", "raw_classID", "raw_phylumID", "raw_orderID", "raw_familyID", "raw_genusID", "raw_speciesID"};
    SearchDAOImpl searchDAO;
    DownloadDetailsDTO downloadDetails;
    SpatialSearchRequestDTO request;
    boolean includeCount;
    boolean includeSynonyms;
    boolean includeLists;
    OutputStream out;
    CSVRecordWriter writer;
    boolean shouldLookupAttribution;
    List<String> guids = null;
    List<Long> counts = null;
    long missingCount;

    public StreamFacet(SearchDAOImpl searchDAO, DownloadDetailsDTO downloadDetails, SpatialSearchRequestDTO request, boolean lookupName, boolean includeCount, boolean includeSynonyms, boolean includeLists, long missingCount, OutputStream out) {
        this.out = out;
        this.downloadDetails = downloadDetails;
        this.request = request;
        this.searchDAO = searchDAO;
        this.includeCount = includeCount;
        this.includeSynonyms = includeSynonyms;
        this.includeLists = includeLists;
        this.missingCount = missingCount;
        String facetName = request.getFacets()[0];
        boolean isGuid = request.getFacets()[0].contains("_guid");
        for (String field : lsidFields) {
            if (!field.equals(request.getFacets()[0])) continue;
            isGuid = true;
            break;
        }
        boolean isLsid = request.getFacets()[0].contains("_lsid") || request.getFacets()[0].contains("taxonConceptID");
        boolean shouldLookupTaxon = lookupName && (isLsid || isGuid);
        boolean isUid = request.getFacets()[0].contains("_uid") || request.getFacets()[0].endsWith("Uid");
        this.shouldLookupAttribution = lookupName && isUid;
        Object[] header = new String[]{facetName};
        if (shouldLookupTaxon) {
            header = searchDAO.speciesLookupService.getHeaderDetails(searchDAO.fieldMappingUtil.translateFieldName(facetName), includeCount, includeSynonyms);
        } else if (this.shouldLookupAttribution) {
            header = (String[])ArrayUtils.addAll((Object[])header, (Object[])new String[]{"name", "count"});
        } else if (includeCount) {
            header = (String[])ArrayUtils.add((Object[])header, (Object)"count");
        }
        if (includeLists) {
            header = (String[])ArrayUtils.addAll((Object[])header, (Object[])searchDAO.listsService.getTypes().toArray(new String[0]));
        }
        this.writer = new CSVRecordWriter((OutputStream)new CloseShieldOutputStream(out), (String[])header);
        this.writer.initialise();
        if (shouldLookupTaxon) {
            this.guids = new ArrayList();
            this.counts = new ArrayList();
        }
    }

    public boolean process(Tuple tuple) {
        String name = null;
        Long count = 0L;
        for (Object value : tuple.getMap().values()) {
            if (value instanceof String) {
                name = (String)value;
                continue;
            }
            count = (Long)value;
        }
        try {
            if (this.guids != null) {
                this.guids.add(name);
                if (this.includeCount) {
                    this.counts.add(count);
                }
                if (this.guids.size() == 30) {
                    try {
                        this.searchDAO.writeTaxonDetailsToStream(this.guids, this.counts, this.includeCount, this.includeSynonyms, this.includeLists, this.writer);
                    }
                    catch (Exception e) {
                        logger.error((Object)("failed to write taxon details to stream: " + e.getMessage()), (Throwable)e);
                    }
                    this.guids.clear();
                    this.counts.clear();
                }
            } else if (this.shouldLookupAttribution) {
                String[] stringArray;
                if (this.includeCount) {
                    String[] stringArray2 = new String[3];
                    stringArray2[0] = name;
                    stringArray2[1] = this.searchDAO.collectionCache.getNameForCode(name);
                    stringArray = stringArray2;
                    stringArray2[2] = Long.toString(count);
                } else {
                    String[] stringArray3 = new String[1];
                    stringArray = stringArray3;
                    stringArray3[0] = name;
                }
                this.writer.write(stringArray);
            } else {
                String[] stringArray;
                if (this.includeCount) {
                    String[] stringArray4 = new String[2];
                    stringArray4[0] = name;
                    stringArray = stringArray4;
                    stringArray4[1] = Long.toString(count);
                } else {
                    String[] stringArray5 = new String[1];
                    stringArray = stringArray5;
                    stringArray5[0] = name;
                }
                this.writer.write(stringArray);
            }
            if (this.downloadDetails != null) {
                this.downloadDetails.updateCounts(1);
            }
        }
        catch (Exception e) {
            logger.error((Object)e);
        }
        return true;
    }

    public boolean flush() {
        if (this.guids != null) {
            if (this.missingCount > 0L) {
                this.guids.add("");
                this.counts.add(this.missingCount);
            }
            try {
                this.searchDAO.writeTaxonDetailsToStream(this.guids, this.counts, this.includeCount, this.includeSynonyms, this.includeLists, this.writer);
            }
            catch (Exception e) {
                logger.error((Object)e);
            }
        } else if (this.missingCount > 0L) {
            String[] stringArray;
            if (this.includeCount) {
                String[] stringArray2 = new String[2];
                stringArray2[0] = "";
                stringArray = stringArray2;
                stringArray2[1] = Long.toString(this.missingCount);
            } else {
                String[] stringArray3 = new String[1];
                stringArray = stringArray3;
                stringArray3[0] = "";
            }
            this.writer.write(stringArray);
        }
        this.writer.finalise();
        return true;
    }
}

