/*
 * Decompiled with CFR 0.152.
 */
package au.org.ala.biocache.stream;

import au.com.bytecode.opencsv.CSVWriter;
import au.org.ala.biocache.dto.SpatialSearchRequestDTO;
import au.org.ala.biocache.stream.ProcessInterface;
import au.org.ala.biocache.util.solr.FieldMappingUtil;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.apache.solr.client.solrj.io.Tuple;

public class StreamAsCSV
implements ProcessInterface {
    private static final Logger logger = Logger.getLogger(StreamAsCSV.class);
    FieldMappingUtil fieldMappingUtil;
    CSVWriter csvWriter;
    SpatialSearchRequestDTO requestParams;
    String[] row;
    byte[] bComma;
    byte[] bNewLine;
    byte[] bDblQuote;
    int count = 0;
    List<String> header = new ArrayList();
    List<String> responseHeader = new ArrayList();

    public StreamAsCSV(FieldMappingUtil fieldMappingUtil, OutputStream stream, SpatialSearchRequestDTO requestParams) {
        this.fieldMappingUtil = fieldMappingUtil;
        this.csvWriter = new CSVWriter((Writer)new OutputStreamWriter(stream));
        this.requestParams = requestParams;
        try {
            this.bComma = ",".getBytes(StandardCharsets.UTF_8);
            this.bNewLine = "\n".getBytes(StandardCharsets.UTF_8);
            this.bDblQuote = "\"".getBytes(StandardCharsets.UTF_8);
        }
        catch (Exception e) {
            logger.error((Object)e);
        }
    }

    public boolean process(Tuple tuple) {
        if (this.count == 0) {
            if (StringUtils.isNotEmpty((String)this.requestParams.getFl())) {
                this.header = Arrays.asList(this.requestParams.getFl().split(","));
                this.responseHeader = new ArrayList(this.header.size());
                for (int i = 0; i < this.header.size(); ++i) {
                    this.responseHeader.add(this.fieldMappingUtil.translateFieldName((String)this.header.get(i)));
                }
            } else {
                this.header = new ArrayList(tuple.getMap().keySet());
            }
            this.csvWriter.writeNext(this.header.toArray(new String[0]));
            this.row = new String[this.header.size()];
        }
        ++this.count;
        for (int j = 0; j < this.header.size(); ++j) {
            String field = (String)this.responseHeader.get(j);
            this.row[j] = this.format(field, tuple.get((Object)field));
        }
        this.csvWriter.writeNext(this.row);
        return true;
    }

    String format(String field, Object item) {
        if (item == null) {
            return "";
        }
        Object formatted = null;
        if (item instanceof List) {
            if (this.requestParams.getIncludeMultivalues().booleanValue()) {
                for (Object o : (List)item) {
                    if (!((String)formatted).isEmpty()) {
                        formatted = (String)formatted + "|";
                    }
                    formatted = (String)formatted + this.fieldMappingUtil.translateFieldValue(field, String.valueOf(o));
                }
                formatted = StringUtils.join((Collection)((List)item), (char)'|');
            } else if (((List)item).size() > 0) {
                formatted = this.fieldMappingUtil.translateFieldValue(field, String.valueOf(((List)item).get(0)));
            }
        } else {
            formatted = this.fieldMappingUtil.translateFieldValue(field, String.valueOf(item));
        }
        if (StringUtils.isEmpty((String)formatted)) {
            return "";
        }
        return formatted;
    }

    public boolean flush() {
        try {
            this.csvWriter.flush();
        }
        catch (IOException e) {
            logger.error((Object)e);
        }
        return true;
    }
}

