/*
 * Decompiled with CFR 0.152.
 */
package au.org.ala.biocache.service;

import au.org.ala.biocache.service.ImageMetadataService;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.util.EntityUtils;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component(value="imageMetadataService")
public class AlaImageMetadataService
implements ImageMetadataService {
    private static final Logger logger = Logger.getLogger(AlaImageMetadataService.class);
    @Value(value="${media.store.url:http://images-dev.ala.org.au}")
    protected String imageServiceUrl;

    public String getUrlFor(String imageId) {
        if (StringUtils.isNotBlank((CharSequence)this.imageServiceUrl)) {
            return this.imageServiceUrl + "/ws/image/" + imageId;
        }
        return null;
    }

    public Map<String, List<Map<String, Object>>> getImageMetadataForOccurrences(List<String> occurrenceIDs) throws Exception {
        if (StringUtils.isBlank((CharSequence)this.imageServiceUrl) || occurrenceIDs == null || occurrenceIDs.isEmpty()) {
            return new HashMap<String, List<Map<String, Object>>>();
        }
        logger.debug((Object)("Retrieving the image metadata for " + occurrenceIDs.size() + " records"));
        HashMap<String, Object> payload = new HashMap<String, Object>();
        payload.put("key", "occurrenceid");
        payload.put("values", occurrenceIDs);
        HttpClientBuilder httpClientBuilder = HttpClientBuilder.create();
        try (CloseableHttpClient httpClient = httpClientBuilder.build();){
            HttpPost post = new HttpPost(this.imageServiceUrl + "/ws/findImagesByMetadata");
            ObjectMapper om = new ObjectMapper();
            post.setEntity((HttpEntity)new StringEntity(om.writeValueAsString(payload), ContentType.APPLICATION_JSON));
            try (CloseableHttpResponse httpResponse = httpClient.execute((HttpUriRequest)post);){
                if (httpResponse.getStatusLine().getStatusCode() == 200 && ContentType.APPLICATION_JSON.getMimeType().equals(ContentType.getOrDefault((HttpEntity)httpResponse.getEntity()).getMimeType())) {
                    String jsonResponseString = EntityUtils.toString((HttpEntity)httpResponse.getEntity());
                    Map jsonResponse = (Map)om.readValue(jsonResponseString, Map.class);
                    Map imageMetadata = (Map)jsonResponse.get("images");
                    logger.debug((Object)("Obtained image metadata for " + imageMetadata.size() + " records"));
                    Map map = imageMetadata;
                    return map;
                }
            }
        }
        return new HashMap<String, List<Map<String, Object>>>();
    }
}

