/*
 * Decompiled with CFR 0.152.
 */
package au.org.ala.biocache.dto;

import au.org.ala.biocache.dto.AssertionCodes;
import au.org.ala.biocache.dto.ErrorCode;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;
import java.util.UUID;

public class QualityAssertion {
    String uuid = UUID.randomUUID().toString();
    String dataResourceUid;
    String referenceRowKey;
    String name;
    Integer code;
    String relatedUuid;
    Integer qaStatus = 0;
    String relatedRecordId;
    String relatedRecordReason;
    String comment;
    String value;
    String userId;
    String userEmail;
    String userDisplayName;
    String userRole;
    String userEntityUid;
    String userEntityName;
    String created;
    String snapshot;
    Boolean problemAsserted = false;

    public QualityAssertion() {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
        simpleDateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
        this.created = simpleDateFormat.format(new Date());
    }

    public QualityAssertion(ErrorCode errorCode, String comment) {
        this();
        this.name = errorCode.name;
        this.code = errorCode.code;
        this.comment = comment;
    }

    public QualityAssertion(ErrorCode errorCode, Integer qaStatus) {
        this();
        this.name = errorCode.name;
        this.code = errorCode.code;
        this.qaStatus = qaStatus;
    }

    public String getUuid() {
        return this.uuid;
    }

    public void setUuid(String uuid) {
        this.uuid = uuid;
    }

    public String getReferenceRowKey() {
        return this.referenceRowKey;
    }

    public void setReferenceRowKey(String referenceRowKey) {
        this.referenceRowKey = referenceRowKey;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Integer getCode() {
        return this.code;
    }

    public void setCode(Integer code) {
        ErrorCode errorCode;
        this.code = code;
        if (this.name == null && code != null && (errorCode = AssertionCodes.getByCode((int)code)) != null) {
            this.name = errorCode.getName();
        }
    }

    public String getRelatedUuid() {
        return this.relatedUuid;
    }

    public void setRelatedUuid(String relatedUuid) {
        this.relatedUuid = relatedUuid;
    }

    public Integer getQaStatus() {
        return this.qaStatus;
    }

    public void setQaStatus(Integer qaStatus) {
        this.qaStatus = qaStatus;
    }

    public String getComment() {
        return this.comment;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public String getUserId() {
        return this.userId;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public String getUserEmail() {
        return this.userEmail;
    }

    public void setUserEmail(String userEmail) {
        this.userEmail = userEmail;
    }

    public String getUserDisplayName() {
        return this.userDisplayName;
    }

    public void setUserDisplayName(String userDisplayName) {
        this.userDisplayName = userDisplayName;
    }

    public String getUserRole() {
        return this.userRole;
    }

    public void setUserRole(String userRole) {
        this.userRole = userRole;
    }

    public String getUserEntityUid() {
        return this.userEntityUid;
    }

    public void setUserEntityUid(String userEntityUid) {
        this.userEntityUid = userEntityUid;
    }

    public String getUserEntityName() {
        return this.userEntityName;
    }

    public void setUserEntityName(String userEntityName) {
        this.userEntityName = userEntityName;
    }

    public String getCreated() {
        return this.created;
    }

    public void setCreated(String created) {
        this.created = created;
    }

    public String getSnapshot() {
        return this.snapshot;
    }

    public void setSnapshot(String snapshot) {
        this.snapshot = snapshot;
    }

    public Boolean getProblemAsserted() {
        return this.problemAsserted;
    }

    public void setProblemAsserted(Boolean problemAsserted) {
        this.problemAsserted = problemAsserted;
    }

    public String getDataResourceUid() {
        return this.dataResourceUid;
    }

    public void setDataResourceUid(String dataResourceUid) {
        this.dataResourceUid = dataResourceUid;
    }

    public String getRelatedRecordId() {
        return this.relatedRecordId;
    }

    public void setRelatedRecordId(String relatedRecordId) {
        this.relatedRecordId = relatedRecordId;
    }

    public String getRelatedRecordReason() {
        return this.relatedRecordReason;
    }

    public void setRelatedRecordReason(String relatedRecordReason) {
        this.relatedRecordReason = relatedRecordReason;
    }
}

