/*
 * Decompiled with CFR 0.152.
 */
package au.org.ala.biocache.dao;

import au.org.ala.biocache.dao.IndexDAO;
import au.org.ala.biocache.dao.SolrIndexDAOImpl;
import au.org.ala.biocache.dto.AssertionStatus;
import au.org.ala.biocache.dto.IndexFieldDTO;
import au.org.ala.biocache.dto.OccurrenceIndex;
import au.org.ala.biocache.service.LayersService;
import au.org.ala.biocache.service.RestartDataService;
import au.org.ala.biocache.stream.ProcessInterface;
import au.org.ala.biocache.util.DwCTerms;
import au.org.ala.biocache.util.DwcTermDetails;
import au.org.ala.biocache.util.QueryFormatUtils;
import au.org.ala.biocache.util.solr.FieldMappedSolrClient;
import au.org.ala.biocache.util.solr.FieldMappingUtil;
import com.fasterxml.jackson.core.type.TypeReference;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.http.client.HttpClient;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.cache.CacheConfig;
import org.apache.http.impl.client.cache.CachingHttpClientBuilder;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.log4j.Logger;
import org.apache.solr.client.solrj.SolrClient;
import org.apache.solr.client.solrj.SolrQuery;
import org.apache.solr.client.solrj.SolrRequest;
import org.apache.solr.client.solrj.SolrServerException;
import org.apache.solr.client.solrj.impl.CloudHttp2SolrClient;
import org.apache.solr.client.solrj.impl.CloudSolrClient;
import org.apache.solr.client.solrj.impl.ConcurrentUpdateSolrClient;
import org.apache.solr.client.solrj.impl.Http2SolrClient;
import org.apache.solr.client.solrj.impl.HttpSolrClient;
import org.apache.solr.client.solrj.io.SolrClientCache;
import org.apache.solr.client.solrj.io.Tuple;
import org.apache.solr.client.solrj.io.stream.AlaCloudSolrStream;
import org.apache.solr.client.solrj.io.stream.SolrStream;
import org.apache.solr.client.solrj.io.stream.StreamContext;
import org.apache.solr.client.solrj.io.stream.TupleStream;
import org.apache.solr.client.solrj.request.AbstractUpdateRequest;
import org.apache.solr.client.solrj.request.UpdateRequest;
import org.apache.solr.client.solrj.request.schema.SchemaRequest;
import org.apache.solr.client.solrj.response.FieldStatsInfo;
import org.apache.solr.client.solrj.response.QueryResponse;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.SolrInputDocument;
import org.apache.solr.common.params.ModifiableSolrParams;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.common.util.NamedList;
import org.eclipse.jetty.util.ConcurrentHashSet;
import org.gbif.dwc.terms.DcTerm;
import org.gbif.dwc.terms.DwcTerm;
import org.slf4j.MDC;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.support.AbstractMessageSource;
import org.springframework.stereotype.Component;

@Component(value="indexDao")
public class SolrIndexDAOImpl
implements IndexDAO {
    private static final Logger logger = Logger.getLogger(SolrIndexDAOImpl.class);
    @Inject
    protected LayersService layersService;
    private volatile long solrIndexVersion = 0L;
    private volatile long solrIndexVersionTime = 0L;
    private final Object solrIndexVersionLock = new Object();
    @Inject
    private FieldMappingUtil fieldMappingUtil;
    private final List<String> header = Arrays.asList("userAssertions", "hasUserAssertions", "userVerified", "lastAssertionDate");
    private final Map<String, Object[]> fieldProperties = new /* Unavailable Anonymous Inner Class!! */;
    @Value(value="${index.fields.tohide:_version_}")
    protected String indexFieldsToHide;
    protected Pattern layersPattern = Pattern.compile("(el|cl)[0-9abc]+");
    @Inject
    protected QueryFormatUtils queryFormatUtils;
    @Value(value="${dwc.url:http://rs.tdwg.org/dwc/terms/}")
    protected String dwcUrl = "http://rs.tdwg.org/dwc/terms/";
    @Value(value="${solr.usehttp2:false}")
    protected Boolean usehttp2;
    @Value(value="${solr.server.retry.max:1}")
    protected int maxRetries = 1;
    @Value(value="${solr.server.retry.wait:1000}")
    protected long retryWait = 1000L;
    @Value(value="${solr.collection:biocache}")
    protected String solrCollection;
    @Value(value="${solr.connection.pool.size:50}")
    protected Integer solrConnectionPoolSize;
    @Value(value="${solr.connection.maxperroute:50}")
    protected Integer solrConnectionMaxPerRoute;
    @Value(value="${solr.connection.connecttimeout:30000}")
    private Integer solrConnectionConnectTimeout;
    @Value(value="${solr.connection.requesttimeout:30000}")
    private Integer solrConnectionRequestTimeout;
    @Value(value="${solr.connection.sockettimeout:30000}")
    private Integer solrConnectionSocketTimeout;
    @Value(value="${solr.connection.cache.entries:500}")
    private Integer solrConnectionCacheEntries;
    @Value(value="${solr.connection.cache.object.size:262144}")
    private Integer solrConnectionCacheObjectSize;
    @Value(value="${biocache.useragent:Biocache}")
    private String userAgent;
    @Value(value="${solr.update.threads:4}")
    Integer solrUpdateThreads;
    @Value(value="${solr.batch.size:1000}")
    Integer solrBatchSize;
    @Value(value="${solr.legacyFieldNameSupport:true}")
    Boolean legacyFieldNameSupport;
    @Value(value="${solr.server.indexVersion.refresh:300000}")
    protected int solrIndexVersionRefreshTime = 300000;
    @Value(value="${solr.home:}")
    protected String solrHome;
    SolrClient solrClient;
    CloseableHttpClient httpClient;
    SolrClientCache solrClientCache;
    private volatile Set<IndexFieldDTO> indexFields = new ConcurrentHashSet();
    private volatile Map<String, IndexFieldDTO> indexFieldMap = (Map)RestartDataService.get((Object)this, (String)"indexFieldMap", (TypeReference)new /* Unavailable Anonymous Inner Class!! */, HashMap.class);
    private volatile Set<String> schemaFields = new HashSet();
    @Inject
    protected AbstractMessageSource messageSource;

    @PostConstruct
    public void init() {
        if (this.solrClient == null) {
            Http2SolrClient solrClient = null;
            PoolingHttpClientConnectionManager poolingConnectionPoolManager = new PoolingHttpClientConnectionManager();
            poolingConnectionPoolManager.setMaxTotal(this.solrConnectionPoolSize.intValue());
            poolingConnectionPoolManager.setDefaultMaxPerRoute(this.solrConnectionMaxPerRoute.intValue());
            CacheConfig cacheConfig = CacheConfig.custom().setMaxCacheEntries(this.solrConnectionCacheEntries.intValue()).setMaxObjectSize((long)this.solrConnectionCacheObjectSize.intValue()).setSharedCache(false).build();
            RequestConfig requestConfig = RequestConfig.custom().setConnectTimeout(this.solrConnectionConnectTimeout.intValue()).setConnectionRequestTimeout(this.solrConnectionRequestTimeout.intValue()).setSocketTimeout(this.solrConnectionSocketTimeout.intValue()).build();
            this.httpClient = CachingHttpClientBuilder.create().setCacheConfig(cacheConfig).setDefaultRequestConfig(requestConfig).setConnectionManager((HttpClientConnectionManager)poolingConnectionPoolManager).setMaxConnPerRoute(this.solrConnectionMaxPerRoute.intValue()).setUserAgent(this.userAgent).useSystemProperties().build();
            this.solrClientCache = new SolrClientCache();
            if (this.usehttp2.booleanValue()) {
                if (!this.solrHome.startsWith("http")) {
                    String[] zkHosts = this.solrHome.split(",");
                    ArrayList<String> hosts = new ArrayList<String>();
                    for (String zkHost : zkHosts) {
                        hosts.add(zkHost.trim());
                    }
                    CloudHttp2SolrClient.Builder builder = new CloudHttp2SolrClient.Builder(hosts, Optional.empty());
                    CloudHttp2SolrClient client = builder.build();
                    client.setDefaultCollection(this.solrCollection);
                    solrClient = client;
                } else {
                    Http2SolrClient.Builder builder = new Http2SolrClient.Builder(this.solrHome);
                    builder.connectionTimeout(this.solrConnectionConnectTimeout.intValue());
                    builder.maxConnectionsPerHost(this.solrConnectionMaxPerRoute.intValue());
                    solrClient = builder.build();
                }
            } else {
                logger.info((Object)("Initialising the solr server " + this.solrHome));
                if (!this.solrHome.startsWith("http://")) {
                    if (this.solrHome.contains(":")) {
                        CloudSolrClient cloudServer = ((CloudSolrClient.Builder)new CloudSolrClient.Builder().withZkHost(this.solrHome).withHttpClient((HttpClient)this.httpClient)).build();
                        cloudServer.setDefaultCollection(this.solrCollection);
                        solrClient = cloudServer;
                        try {
                            solrClient.ping();
                        }
                        catch (Exception e) {
                            logger.error((Object)"ping failed", (Throwable)e);
                        }
                    } else {
                        logger.error((Object)("Failed to initialise connection to SOLR server with solrHome: " + this.solrHome));
                    }
                } else {
                    logger.info((Object)("Initialising connection to SOLR server..... with solrHome:  " + this.solrHome));
                    solrClient = new ConcurrentUpdateSolrClient.Builder(this.solrHome).withThreadCount(this.solrUpdateThreads.intValue()).withQueueSize(this.solrBatchSize.intValue()).build();
                    logger.info((Object)"Initialising connection to SOLR server - done.");
                }
            }
            if (solrClient != null) {
                this.solrClient = new FieldMappedSolrClient(this.fieldMappingUtil, (SolrClient)solrClient);
            }
        }
    }

    public void destroy() {
        try {
            this.solrClient.close();
        }
        catch (IOException e) {
            logger.error((Object)"failed to close solrClient", (Throwable)e);
        }
    }

    public QueryResponse query(SolrParams query) throws Exception {
        int retry = 0;
        QueryResponse qr = null;
        while (retry < this.maxRetries && qr == null) {
            ++retry;
            try {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("SOLR query:" + query.toString()));
                }
                qr = this.solrClient.query(query, SolrRequest.METHOD.POST);
            }
            catch (SolrServerException e) {
                if (retry < this.maxRetries && (e.getMessage().contains("IOException") || e.getMessage().contains("Proxy Error"))) {
                    if (this.retryWait <= 0L) continue;
                    try {
                        Thread.sleep(this.retryWait);
                        continue;
                    }
                    catch (InterruptedException ex) {
                        Thread.currentThread().interrupt();
                        throw e;
                    }
                }
                throw e;
            }
            catch (SolrException e) {
                if (this.solrClient instanceof CloudSolrClient && e.getMessage().contains("Could not load collection")) {
                    this.logError(query, "query failed, attempting to reconnect: ", e.getMessage());
                    try {
                        ((CloudSolrClient)this.solrClient).getClusterStateProvider().close();
                    }
                    catch (IOException ex) {
                        // empty catch block
                    }
                    ((CloudSolrClient)this.solrClient).getClusterStateProvider().connect();
                    try {
                        this.solrClient.close();
                    }
                    catch (IOException ex) {
                        // empty catch block
                    }
                    ((CloudSolrClient)this.solrClient).connect();
                    if (retry < this.maxRetries) {
                        if (this.retryWait <= 0L) continue;
                        try {
                            Thread.sleep(this.retryWait);
                            continue;
                        }
                        catch (InterruptedException ex) {
                            Thread.currentThread().interrupt();
                            throw e;
                        }
                    }
                    throw e;
                }
                this.logError(query, "query failed-1", e.getMessage());
                throw e;
            }
            catch (IOException ioe) {
                this.logError(query, "query failed-IOException ", ioe.getMessage());
                throw new SolrServerException((Throwable)ioe);
            }
            catch (Exception ioe) {
                this.logError(query, "query failed-SolrServerException ", ioe.getMessage());
                throw new SolrServerException((Throwable)ioe);
            }
        }
        return qr;
    }

    private void logError(SolrParams query, String message, String exceptionMessage) {
        String requestID = MDC.get((String)"X-Request-ID");
        if (requestID != null) {
            logger.error((Object)("RequestID:" + requestID + ", " + message + " - SOLRQuery: " + query.toString() + ", Error : " + exceptionMessage));
        } else {
            logger.error((Object)(message + " - SOLRQuery: " + query.toString() + " : " + exceptionMessage));
        }
    }

    private void parseLukeResponse(QueryResponse qr, Map<String, IndexFieldDTO> indexFieldMap) {
        NamedList response = qr.getResponse();
        this.solrIndexVersion = (Long)((NamedList)response.get("index")).get("version");
        this.solrIndexVersionTime = System.currentTimeMillis();
        Map indexToJsonMap = new OccurrenceIndex().indexToJsonMap();
        NamedList fields = (NamedList)response.get("fields");
        fields.forEach((fieldName, fieldInfo) -> {
            if (StringUtils.isNotEmpty((String)fieldName) && fieldInfo != null) {
                IndexFieldDTO indexField = (IndexFieldDTO)indexFieldMap.get(fieldName);
                if (indexField == null) {
                    Integer distinctCount;
                    String schema;
                    String fieldType = fieldInfo.get("type").toString();
                    indexField = this.formatIndexField(fieldName, fieldType, schema = fieldInfo.get("schema").toString(), distinctCount = (Integer)fieldInfo.get("distinct"), indexToJsonMap);
                    if (indexField != null) {
                        indexFieldMap.put((String)fieldName, indexField);
                    }
                } else {
                    indexField.setNumberDistinctValues((Integer)fieldInfo.get("distinct"));
                }
            }
        });
    }

    private void parseSchemaResponse(QueryResponse qr, Map<String, IndexFieldDTO> indexFieldMap) {
        Map indexToJsonMap = new OccurrenceIndex().indexToJsonMap();
        NamedList response = qr.getResponse();
        NamedList fields = (NamedList)((NamedList)response.get("schema")).get("fields");
        fields.forEach((fieldName, fieldInfo) -> {
            if (StringUtils.isNotEmpty((String)fieldName) && fieldInfo != null) {
                String schema;
                String fieldType;
                IndexFieldDTO indexField = (IndexFieldDTO)indexFieldMap.get(fieldName);
                if (indexField == null && (indexField = this.formatIndexField(fieldName, fieldType = fieldInfo.get("type").toString(), schema = fieldInfo.get("flags").toString(), null, indexToJsonMap)) != null) {
                    indexFieldMap.put((String)fieldName, indexField);
                }
                ArrayList copySources = (ArrayList)fieldInfo.get("copySources");
                if (indexField != null && copySources != null && copySources.size() > 0) {
                    indexField.setSourceFields((Collection)copySources);
                }
            }
        });
    }

    public Set<IndexFieldDTO> getIndexFieldDetails(String ... fields) throws Exception {
        ModifiableSolrParams params = new ModifiableSolrParams();
        params.set("qt", new String[]{"/admin/luke"});
        params.set("tr", new String[]{"luke.xsl"});
        if (fields != null) {
            params.set("fl", new String[]{String.join((CharSequence)",", fields)});
            params.set("numTerms", new String[]{"1"});
        } else {
            params.set("numTerms", new String[]{"0"});
        }
        QueryResponse response = this.query((SolrParams)params);
        Hashtable<String, IndexFieldDTO> indexFieldMap = new Hashtable<String, IndexFieldDTO>();
        this.parseLukeResponse(response, indexFieldMap);
        params = new ModifiableSolrParams();
        params.set("qt", new String[]{"/admin/luke"});
        params.set("show", new String[]{"schema"});
        response = this.query((SolrParams)params);
        this.parseSchemaResponse(response, indexFieldMap);
        this.fieldMappingUtil.getFieldMappingStream().forEach(fieldMapping -> {
            IndexFieldDTO deprecatedFields = new IndexFieldDTO();
            deprecatedFields.setName((String)fieldMapping.getKey());
            deprecatedFields.setDeprecated(true);
            if (fieldMapping.getValue() != null) {
                deprecatedFields.setNewFieldName((String)fieldMapping.getValue());
            }
            indexFieldMap.put(deprecatedFields.getName(), deprecatedFields);
        });
        for (String indexFieldToHide : this.indexFieldsToHide.split(",")) {
            indexFieldMap.remove(indexFieldToHide);
        }
        Map layerNameMap = this.layersService.getLayerNameMap();
        for (Map.Entry item : layerNameMap.entrySet()) {
            IndexFieldDTO field = new IndexFieldDTO();
            field.setDocvalue(true);
            field.setIndexed(true);
            field.setStored(true);
            field.setDescription((String)item.getValue());
            field.setName((String)item.getKey());
            field.setDownloadName((String)item.getKey());
            if (((String)item.getKey()).startsWith("cl")) {
                field.setDataType("string");
            } else {
                field.setDataType("float");
            }
            indexFieldMap.put((String)item.getKey(), field);
        }
        if (fields != null && fields.length > 0) {
            return Arrays.stream(fields).map(fieldName -> (IndexFieldDTO)indexFieldMap.get(fieldName)).filter(indexField -> indexField != null).collect(Collectors.toSet());
        }
        return indexFieldMap.entrySet().stream().map(Map.Entry::getValue).collect(Collectors.toSet());
    }

    public Set<String> getSchemaFields() throws Exception {
        return this.getSchemaFields(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<String> getSchemaFields(boolean update) throws Exception {
        HashSet<String> result = this.schemaFields;
        if (result.size() == 0 || update) {
            Object object = this.solrIndexVersionLock;
            synchronized (object) {
                result = this.schemaFields;
                if (result.size() == 0 || update) {
                    ModifiableSolrParams params = new ModifiableSolrParams();
                    params.set("qt", new String[]{"/admin/luke"});
                    params.set("show", new String[]{"schema"});
                    QueryResponse response = this.query((SolrParams)params);
                    NamedList schemaFields = (NamedList)((NamedList)response.getResponse().get("schema")).get("fields");
                    Iterator iter = schemaFields.iterator();
                    result = new HashSet<String>();
                    while (iter.hasNext()) {
                        result.add((String)((Map.Entry)iter.next()).getKey());
                    }
                    if (result != null && result.size() > 0) {
                        this.schemaFields = result;
                    }
                }
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Long getIndexVersion(Boolean force) {
        2 t = null;
        Object object = this.solrIndexVersionLock;
        synchronized (object) {
            boolean immediately;
            boolean bl = immediately = this.solrIndexVersionTime == 0L;
            if (force.booleanValue() || this.solrIndexVersionTime < System.currentTimeMillis() - (long)this.solrIndexVersionRefreshTime) {
                this.solrIndexVersionTime = System.currentTimeMillis();
                t = new /* Unavailable Anonymous Inner Class!! */;
                if (immediately) {
                    t.start();
                    try {
                        t.join();
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                        logger.error((Object)"Failed to update solrIndexVersion", (Throwable)e);
                    }
                } else if (!force.booleanValue()) {
                    t.start();
                }
            }
        }
        if (force.booleanValue() && t != null) {
            t.start();
            try {
                t.join();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                logger.error((Object)"Failed to update solrIndexVersion", (Throwable)e);
            }
        }
        return this.solrIndexVersion;
    }

    private IndexFieldDTO formatIndexField(String fieldName, String fieldType, String schema, Integer distinctCount, Map indexToJsonMap) {
        if (StringUtils.isNotEmpty((String)fieldName) && !fieldName.startsWith("sensitive_") && schema != null) {
            IndexFieldDTO f = new IndexFieldDTO();
            f.setName(fieldName);
            if (fieldType != null) {
                f.setDataType(fieldType);
            } else {
                f.setDataType("string");
            }
            if (distinctCount != null) {
                f.setNumberDistinctValues(distinctCount);
            }
            if (schema != null) {
                f.setIndexed(schema.contains("I"));
                f.setStored(schema.contains("S"));
                f.setMultivalue(schema.contains("M"));
                f.setDocvalue(schema.contains("D"));
            }
            if (this.layersPattern.matcher(fieldName).matches()) {
                f.setDownloadName(fieldName);
                String description = (String)this.layersService.getLayerNameMap().get(fieldName);
                f.setDescription(description);
                f.setDownloadDescription(description);
                f.setInfo(this.layersService.getLayersServiceUrl() + "/layers/view/more/" + fieldName);
                if (fieldName.startsWith("el")) {
                    f.setClasss("Environmental");
                } else {
                    f.setClasss("Contextual");
                }
            } else {
                String wikiLink;
                String classs;
                String i18nValues;
                String json;
                String description;
                String downloadField = fieldName;
                if (downloadField != null) {
                    f.setDownloadName(downloadField);
                }
                fieldName = this.fieldMappingUtil.translateFieldName(fieldName);
                String downloadFieldDescription = this.messageSource.getMessage(downloadField = this.fieldMappingUtil.translateFieldName(downloadField), null, "", Locale.getDefault());
                if (downloadFieldDescription.length() > 0) {
                    f.setDownloadDescription(downloadFieldDescription);
                    f.setDescription(downloadFieldDescription);
                }
                if ((description = this.messageSource.getMessage("facet." + fieldName, null, "", Locale.getDefault())).length() > 0) {
                    f.setDescription(description);
                } else if (downloadField != null && (description = this.messageSource.getMessage(downloadField, null, "", Locale.getDefault())).length() > 0) {
                    f.setDescription(description);
                }
                Object info = this.messageSource.getMessage("description." + fieldName, null, "", Locale.getDefault());
                if (((String)info).length() > 0) {
                    f.setInfo((String)info);
                } else if (downloadField != null && ((String)(info = this.messageSource.getMessage("description." + downloadField, null, "", Locale.getDefault()))).length() > 0) {
                    f.setInfo((String)info);
                }
                DwcTerm term = null;
                try {
                    term = DwcTerm.valueOf((String)fieldName);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
                boolean dcterm = false;
                try {
                    term = DcTerm.valueOf((String)fieldName);
                    dcterm = true;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
                if (term == null) {
                    String dwcTerm = this.messageSource.getMessage("dwc." + fieldName, null, "", Locale.getDefault());
                    if (downloadField != null) {
                        dwcTerm = this.messageSource.getMessage("dwc." + downloadField, null, "", Locale.getDefault());
                    }
                    if (dwcTerm.length() > 0) {
                        f.setDwcTerm(dwcTerm);
                        try {
                            DwcTermDetails dwcTermDetails;
                            term = DwcTerm.valueOf((String)dwcTerm);
                            if (term != null) {
                                f.setClasss(term.getGroup());
                            }
                            if ((dwcTermDetails = DwCTerms.getInstance().getDwCTermDetails(term.simpleName())) != null) {
                                if (f.getInfo() == null) {
                                    f.setInfo(dwcTermDetails.comment);
                                }
                                if (f.getDescription() == null) {
                                    f.setDescription(dwcTermDetails.label);
                                }
                            }
                        }
                        catch (IllegalArgumentException dwcTermDetails) {}
                    }
                } else {
                    f.setDwcTerm(term.simpleName());
                    if (term instanceof DwcTerm) {
                        f.setClasss(term.getGroup());
                    } else {
                        f.setClasss("Record");
                        f.setDwcTerm("dcterms:" + term.simpleName());
                    }
                    DwcTermDetails dwcTermDetails = DwCTerms.getInstance().getDwCTermDetails(term.simpleName());
                    if (dwcTermDetails != null) {
                        if (f.getInfo() == null) {
                            f.setInfo(dwcTermDetails.comment);
                        }
                        if (f.getDescription() == null) {
                            f.setDescription(dwcTermDetails.label);
                        }
                    }
                }
                if (!dcterm && f.getDwcTerm() != null && !f.getDwcTerm().isEmpty() && StringUtils.isNotEmpty((String)this.dwcUrl)) {
                    if (((String)info).length() > 0) {
                        info = (String)info + " ";
                    }
                    f.setInfo((String)info + this.dwcUrl + f.getDwcTerm());
                }
                if ((json = (String)indexToJsonMap.get(fieldName)) != null) {
                    f.setJsonName(json);
                }
                if ((i18nValues = this.messageSource.getMessage("i18nvalues." + fieldName, null, "", Locale.getDefault())).length() > 0) {
                    f.setI18nValues(Boolean.valueOf("true".equalsIgnoreCase(i18nValues)));
                }
                if ((classs = this.messageSource.getMessage("class." + fieldName, null, "", Locale.getDefault())).length() > 0) {
                    f.setClasss(classs);
                }
                if ((wikiLink = this.messageSource.getMessage("wiki." + fieldName, null, "", Locale.getDefault())).length() > 0) {
                    f.setInfoUrl(wikiLink);
                }
            }
            return f;
        }
        return null;
    }

    public Set<IndexFieldDTO> getIndexedFields() throws Exception {
        return this.getIndexedFields(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<IndexFieldDTO> getIndexedFields(boolean update) throws Exception {
        Set result = this.indexFields;
        if (result.size() == 0 || update) {
            Object object = this.solrIndexVersionLock;
            synchronized (object) {
                result = this.indexFields;
                if ((result.size() == 0 || update) && (result = this.getIndexFieldDetails(new String[0])) != null && result.size() > 0) {
                    HashMap<String, IndexFieldDTO> resultMap = new HashMap<String, IndexFieldDTO>();
                    for (IndexFieldDTO field : result) {
                        resultMap.put(field.getName(), field);
                    }
                    this.indexFields = result;
                    this.indexFieldMap = resultMap;
                }
            }
        }
        return result;
    }

    public Map<String, IndexFieldDTO> getIndexedFieldsMap() throws Exception {
        this.getIndexedFields();
        return this.indexFieldMap;
    }

    public Map<String, FieldStatsInfo> getStatistics(String field) throws Exception {
        try {
            SolrQuery solrQuery = new SolrQuery();
            solrQuery.addGetFieldStatistics(new String[]{field});
            solrQuery.setQuery("*:*");
            solrQuery.setRows(Integer.valueOf(0));
            QueryResponse qr = this.runSolrQuery(solrQuery);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)qr.getFieldStatsInfo());
            }
            return qr.getFieldStatsInfo();
        }
        catch (SolrServerException ex) {
            String requestID = MDC.get((String)"X-Request-ID");
            if (requestID != null) {
                logger.error((Object)("Problem communicating with SOLR server. RequestID:" + requestID + " Error:" + ex.getMessage()), (Throwable)ex);
            } else {
                logger.error((Object)("Problem communicating with SOLR server. Error:" + ex.getMessage()), (Throwable)ex);
            }
            return null;
        }
    }

    public QueryResponse runSolrQuery(SolrQuery solrQuery) throws Exception {
        if (MDC.get((String)"X-Request-ID") != null) {
            solrQuery.setParam("XRequestID", new String[]{MDC.get((String)"X-Request-ID")});
        }
        solrQuery.setFacetMissing(Boolean.valueOf(true));
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Solr query: " + solrQuery.toString()));
        }
        QueryResponse qr = this.query((SolrParams)solrQuery);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("qtime:" + qr.getQTime()));
            if (qr.getResults() == null) {
                logger.debug((Object)"no results");
            } else {
                logger.debug((Object)("Matched records: " + qr.getResults().getNumFound()));
            }
        }
        return qr;
    }

    private List<Object> getValues(Map<String, Object> map) {
        String userAssertionStatus = (String)map.getOrDefault("userAssertions", String.valueOf(AssertionStatus.QA_NONE));
        if (userAssertionStatus.equals(String.valueOf(AssertionStatus.QA_NONE))) {
            userAssertionStatus = null;
        }
        boolean hasUserAssertions = (Boolean)map.getOrDefault("hasUserAssertions", false);
        boolean userVerified = (Boolean)map.getOrDefault("userVerified", false);
        Date lastAssertionDate = map.getOrDefault("lastAssertionDate", null);
        return Arrays.asList(userAssertionStatus, hasUserAssertions, userVerified, lastAssertionDate);
    }

    public void indexFromMap(List<Map<String, Object>> maps) throws IOException, SolrServerException {
        ArrayList<SolrInputDocument> batch = new ArrayList<SolrInputDocument>();
        for (Map<String, Object> map : maps) {
            if (map.containsKey("record_uuid")) {
                SolrInputDocument doc = new SolrInputDocument(new String[0]);
                doc.addField("id", map.get("record_uuid"));
                List values = this.getValues(map);
                if (values.size() > 0 && values.size() != this.header.size()) {
                    logger.error((Object)"Values don't match headers");
                    return;
                }
                for (int i = 0; i < this.header.size(); ++i) {
                    String key = (String)this.header.get(i);
                    Object value = values.get(i);
                    doc.addField(key, (Object)new /* Unavailable Anonymous Inner Class!! */);
                }
                doc.addField("assertionUserId", (Object)new /* Unavailable Anonymous Inner Class!! */);
                doc.addField("_version_", (Object)1);
                this.syncDocFieldsWithSOLR(doc);
                logger.debug((Object)("Added solr doc for record: " + doc.get((Object)"id") + " to updateRequest"));
                batch.add(doc);
            }
            if (batch.size() != this.solrBatchSize.intValue()) continue;
            this.updateBatch(batch);
            batch.clear();
        }
        this.updateBatch(batch);
    }

    private void updateBatch(List<SolrInputDocument> batch) {
        if (!batch.isEmpty()) {
            UpdateRequest updateRequest = new UpdateRequest();
            updateRequest.setAction(AbstractUpdateRequest.ACTION.COMMIT, false, false);
            updateRequest.add(batch);
            logger.debug((Object)(batch.size() + " solr docs being updated"));
            try {
                updateRequest.process(this.solrClient);
            }
            catch (Exception e) {
                logger.error((Object)("Failed to update solr doc, error message: " + e.getMessage()), (Throwable)e);
            }
        }
    }

    private void syncDocFieldsWithSOLR(SolrInputDocument doc) {
        doc.getFieldNames().forEach(fieldName -> {
            if (!this.schemaFields.contains(fieldName)) {
                Object[] properties = (Object[])this.fieldProperties.get(fieldName);
                this.addFieldToSolr(fieldName, (String)properties[0], (Boolean)properties[1], (Boolean)properties[2], (Boolean)properties[3], (Boolean)properties[4]);
                this.schemaFields.add(fieldName);
            }
        });
    }

    private void addFieldToSolr(String name, String fieldType, Boolean multiValued, Boolean docValues, Boolean indexed, Boolean stored) {
        try {
            SchemaRequest.Field fieldRequest = new SchemaRequest.Field(name);
            fieldRequest.process(this.solrClient);
        }
        catch (Exception e) {
            logger.info((Object)("Field not in schema: " + name));
            HashMap<String, Object> field = new HashMap<String, Object>();
            field.put("name", name);
            field.put("type", fieldType);
            field.put("multiValued", multiValued);
            field.put("docValues", docValues);
            field.put("indexed", indexed);
            field.put("stored", stored);
            SchemaRequest.AddField addField = new SchemaRequest.AddField(field);
            try {
                logger.info((Object)("Adding field: " + name));
                addField.process(this.solrClient);
            }
            catch (Exception e1) {
                logger.error((Object)("Failed to add a new field '" + name + "' to SOLR schema. " + e1.getMessage()));
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private TupleStream openStream(SolrParams params) throws IOException {
        SolrStream solrStream = null;
        if (!this.solrHome.startsWith("http://")) {
            if (!this.solrHome.contains(":")) {
                logger.error((Object)("Badly formatted solrHome configuration: " + this.solrHome));
                return null;
            }
            solrStream = new AlaCloudSolrStream(this.solrHome, this.solrCollection, params);
        } else {
            solrStream = new SolrStream(this.solrHome, params);
        }
        StreamContext streamContext = new StreamContext();
        streamContext.setSolrClientCache(this.solrClientCache);
        solrStream.setStreamContext(streamContext);
        solrStream.open();
        return solrStream;
    }

    public int streamingQuery(SolrQuery query, ProcessInterface procSearch, ProcessInterface procFacet, SolrQuery endemicFacetSuperset) throws SolrServerException {
        int tupleCount = 0;
        try {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("SOLR query:" + query.toString()));
            }
            if (procSearch != null && query.getRows() != 0) {
                try (TupleStream solrStream = this.openStream((SolrParams)this.buildSearchExpr(query));){
                    while (true) {
                        Tuple tuple = solrStream.read();
                        if (tuple.EOF || tupleCount >= query.getRows() && query.getRows() >= 0) break;
                        ++tupleCount;
                        procSearch.process(tuple);
                    }
                    procSearch.flush();
                }
            }
            if (procFacet != null && query.getFacetFields() != null) {
                block15: for (TupleStream facetField : query.getFacetFields()) {
                    try (TupleStream solrStream = this.createTupleStream(query, endemicFacetSuperset, (String)facetField);){
                        while (true) {
                            Tuple tuple = solrStream.read();
                            if (tuple.EOF) continue block15;
                            procFacet.process(tuple);
                        }
                    }
                }
                procFacet.flush();
            }
        }
        catch (HttpSolrClient.RemoteSolrException e) {
            this.logError((SolrParams)query, "SolrException query failed", e.getMessage());
            throw e;
        }
        catch (IOException ioe) {
            this.logError((SolrParams)query, "IOException query failed", ioe.getMessage());
            throw new SolrServerException((Throwable)ioe);
        }
        catch (Exception ioe) {
            this.logError((SolrParams)query, "Exception - query failed", ioe.getMessage());
            throw new SolrServerException((Throwable)ioe);
        }
        return tupleCount;
    }

    private TupleStream createTupleStream(SolrQuery query, SolrQuery endemicFacetSuperset, String facetField) throws IOException {
        if (endemicFacetSuperset == null) {
            return this.openStream((SolrParams)this.buildFacetExpr(query, facetField));
        }
        return this.openStream((SolrParams)this.buildEndemicExpr(query, endemicFacetSuperset));
    }

    private ModifiableSolrParams buildSearchExpr(SolrQuery query) {
        ModifiableSolrParams solrParams = new ModifiableSolrParams();
        solrParams.set("q", new String[]{this.fieldMappingUtil.translateQueryFields(query.getQuery())});
        if (query.getFilterQueries() != null) {
            for (String fq : query.getFilterQueries()) {
                if (!StringUtils.isNotEmpty((String)fq)) continue;
                solrParams.add("fq", new String[]{this.fieldMappingUtil.translateQueryFields(fq)});
            }
        }
        Object[] fl = new String[]{"id"};
        if (StringUtils.isNotEmpty((String)query.getFields())) {
            solrParams.set("fl", new String[]{StringUtils.join((Object[])this.fieldMappingUtil.translateFieldArray(query.getFields().split(",")), (String)",")});
        } else {
            solrParams.set("fl", new String[]{"id"});
        }
        if (StringUtils.isEmpty((String)query.getSortField()) || !ArrayUtils.contains((Object[])fl, (Object)query.getSortField().split(" ")[0])) {
            solrParams.set("sort", new String[]{solrParams.get("fl").split(",")[0] + " asc"});
        } else {
            solrParams.set("sort", new String[]{"index asc"});
        }
        String qt = "/export";
        if (query.getStart() > 0 || query.getRows() > 0) {
            solrParams.set("rows", query.getRows().intValue());
            solrParams.set("start", query.getStart().intValue());
            qt = "/select";
        }
        solrParams.set("qt", new String[]{qt});
        return solrParams;
    }

    private ModifiableSolrParams buildFacetExpr(SolrQuery query, String facetName) {
        int limit;
        StringBuilder cexpr = new StringBuilder();
        cexpr.append("facet(").append(this.solrCollection).append(", q=\"").append(this.escapeDoubleQuote(this.fieldMappingUtil.translateQueryFields(query.getQuery()))).append("\"");
        if (query.getFilterQueries() != null) {
            for (String fq : query.getFilterQueries()) {
                cexpr.append(", fq=\"").append(this.escapeDoubleQuote(this.fieldMappingUtil.translateQueryFields(fq))).append("\"");
            }
        }
        cexpr.append(", buckets=\"").append(this.fieldMappingUtil.translateFieldName(facetName)).append("\"");
        if (query.getFacetSortString() != null && query.getFacetSortString().endsWith(" asc") || query.getFacetSortString().endsWith(" desc")) {
            cexpr.append(", bucketSorts=\"").append(query.getFacetSortString()).append("\"");
        } else if ("index".equals(query.getFacetSortString())) {
            cexpr.append(", bucketSorts=\"").append(facetName).append(" asc\"");
        } else {
            cexpr.append(", bucketSorts=\"count(*) desc\", count(*)");
        }
        int n = limit = query.getFacetLimit() >= 0 ? query.getFacetLimit() : -1;
        if (query.get("facet.offset") != null && limit != -1) {
            cexpr.append(", bucketSizeLimit=").append(limit + Integer.parseInt(query.get("facet.offset")));
        } else {
            cexpr.append(", bucketSizeLimit=").append(limit);
        }
        cexpr.append(")");
        String qt = "/stream";
        ModifiableSolrParams solrParams = new ModifiableSolrParams();
        solrParams.set("expr", new String[]{cexpr.toString()});
        solrParams.set("qt", new String[]{qt});
        solrParams.set("distrib", new String[]{"true"});
        return solrParams;
    }

    private ModifiableSolrParams buildEndemicExpr(SolrQuery subset, SolrQuery superset) {
        StringBuilder cexpr = new StringBuilder();
        String facetName = subset.getFacetFields()[0];
        String translatedFacetName = this.fieldMappingUtil.translateFieldName(facetName);
        cexpr.append("having(eq(count1, count(*))").append(", innerJoin(on=\"").append(translatedFacetName).append("\"").append(", select(").append("facet(").append(this.solrCollection).append(", q=\"").append(this.escapeDoubleQuote(this.fieldMappingUtil.translateQueryFields(subset.getQuery()))).append("\"");
        if (subset.getFilterQueries() != null) {
            for (String fq : subset.getFilterQueries()) {
                cexpr.append(", fq=\"").append(this.escapeDoubleQuote(this.fieldMappingUtil.translateQueryFields(fq))).append("\"");
            }
        }
        cexpr.append(", buckets=\"").append(translatedFacetName).append("\"").append(", bucketSorts=\"").append(translatedFacetName).append(" asc\"").append(", bucketSizeLimit=\"-1\")").append(",").append(translatedFacetName).append(", count(*) as count1)").append(", facet(").append(this.solrCollection).append(", q=\"").append(this.escapeDoubleQuote(this.fieldMappingUtil.translateQueryFields(superset.getQuery()))).append("\"");
        if (superset.getFilterQueries() != null) {
            for (String fq : superset.getFilterQueries()) {
                cexpr.append(", fq=\"").append(this.escapeDoubleQuote(this.fieldMappingUtil.translateQueryFields(fq))).append("\"");
            }
        }
        cexpr.append(", buckets=\"").append(translatedFacetName).append("\"").append(", bucketSorts=\"").append(translatedFacetName).append(" asc\"").append(", bucketSizeLimit=\"-1\")").append(")").append(")");
        String qt = "/stream";
        ModifiableSolrParams solrParams = new ModifiableSolrParams();
        solrParams.set("expr", new String[]{cexpr.toString()});
        solrParams.set("qt", new String[]{qt});
        solrParams.set("distrib", new String[]{"true"});
        return solrParams;
    }

    private String escapeDoubleQuote(String input) {
        return input.replaceAll("\"", "\\\\\"");
    }
}

