/*
 * Decompiled with CFR 0.152.
 */
package au.org.ala.biocache.writer;

import au.com.bytecode.opencsv.CSVWriter;
import au.org.ala.biocache.stream.OptionalZipOutputStream;
import au.org.ala.biocache.writer.RecordWriterError;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.io.output.CloseShieldOutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CSVRecordWriter
implements RecordWriterError {
    private static final Logger logger = LoggerFactory.getLogger(CSVRecordWriter.class);
    private final OutputStream outputStream;
    private final char separatorChar;
    private final char quoteChar;
    private final char escapeChar;
    private final AtomicBoolean initialised = new AtomicBoolean(false);
    private final AtomicBoolean finalised = new AtomicBoolean(false);
    private final AtomicBoolean finalisedComplete = new AtomicBoolean(false);
    private final String[] header;
    private final List<Throwable> errors = new ArrayList();
    private CSVWriter csvWriter;

    public CSVRecordWriter(OutputStream out, String[] header) {
        this.outputStream = out;
        this.separatorChar = (char)44;
        this.quoteChar = (char)34;
        this.escapeChar = (char)34;
        this.header = header;
    }

    public CSVRecordWriter(OutputStream out, String[] header, char sep, char esc) {
        this.outputStream = out;
        this.separatorChar = sep;
        this.quoteChar = (char)34;
        this.escapeChar = esc;
        this.header = header;
    }

    public void write(String[] record) {
        if (!this.initialised.get()) {
            throw new IllegalStateException("Must call initialise method before calling write.");
        }
        if (this.csvWriter == null) {
            throw new IllegalStateException("The initialise method did not create a CSVWriter instance.");
        }
        this.csvWriter.writeNext(record);
        if (this.outputStream instanceof OptionalZipOutputStream) {
            try {
                int length = record.length * "\",\"".getBytes(StandardCharsets.UTF_8).length * 2;
                for (String s : record) {
                    if (s == null) continue;
                    length += s.getBytes(StandardCharsets.UTF_8).length;
                }
                if (((OptionalZipOutputStream)this.outputStream).isNewFile((Object)this, (long)length)) {
                    this.write(this.header);
                }
            }
            catch (Exception e) {
                this.errors.add(e);
            }
        }
    }

    public boolean hasError() {
        CSVWriter toCheckCsvWriter = this.csvWriter;
        return toCheckCsvWriter != null && toCheckCsvWriter.checkError() || !this.errors.isEmpty();
    }

    public List<Throwable> getErrors() {
        return this.errors;
    }

    public void flush() {
        try {
            CSVWriter toFlushCsvWriter = this.csvWriter;
            if (toFlushCsvWriter != null) {
                toFlushCsvWriter.flush();
            }
        }
        catch (IOException e) {
            logger.debug(e.getMessage(), (Throwable)e);
            this.errors.add(e);
        }
    }

    public void initialise() {
        if (this.initialised.compareAndSet(false, true)) {
            this.csvWriter = new CSVWriter((Writer)new OutputStreamWriter((OutputStream)new CloseShieldOutputStream(this.outputStream), StandardCharsets.UTF_8), this.separatorChar, this.quoteChar, this.escapeChar);
            this.csvWriter.writeNext(this.header);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void finalise() {
        if (this.finalised.compareAndSet(false, true)) {
            try {
                this.flush();
            }
            finally {
                try {
                    CSVWriter toCloseCsvWriter = this.csvWriter;
                    if (toCloseCsvWriter != null) {
                        toCloseCsvWriter.close();
                    }
                }
                catch (IOException e) {
                    this.errors.add(e);
                }
                finally {
                    this.finalisedComplete.set(true);
                }
            }
        }
    }

    public boolean finalised() {
        return this.finalisedComplete.get();
    }

    public void close() throws IOException {
        this.finalise();
    }
}

