/*
 * Decompiled with CFR 0.152.
 */
package au.org.ala.biocache.web;

import au.org.ala.biocache.dao.SearchDAO;
import au.org.ala.biocache.dto.FacetResultDTO;
import au.org.ala.biocache.dto.SearchResultDTO;
import au.org.ala.biocache.dto.SpatialSearchRequestDTO;
import au.org.ala.biocache.util.GISPoint;
import au.org.ala.biocache.util.GISUtil;
import au.org.ala.biocache.util.GridRef;
import au.org.ala.biocache.util.GridUtil;
import au.org.ala.biocache.util.WMSUtils;
import au.org.ala.biocache.util.WmsEnv;
import au.org.ala.biocache.web.ParsedGridRef;
import au.org.ala.biocache.web.WMSImg;
import io.swagger.annotations.Api;
import io.swagger.v3.oas.annotations.Hidden;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.image.RenderedImage;
import java.io.OutputStream;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.imageio.ImageIO;
import javax.inject.Inject;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.geotools.geometry.GeneralDirectPosition;
import org.geotools.referencing.CRS;
import org.geotools.referencing.operation.DefaultCoordinateOperationFactory;
import org.opengis.geometry.DirectPosition;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.operation.CoordinateOperation;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@Api(value="Web Mapping Services - OS GRID", hidden=true)
public class WMSOSGridController {
    private static final Logger logger = Logger.getLogger(WMSOSGridController.class);
    @Inject
    protected SearchDAO searchDAO;
    @Inject
    protected WMSUtils wmsUtils;

    @Hidden
    @RequestMapping(value={"/osgrid/lookup.json"}, method={RequestMethod.GET})
    @ResponseBody
    public Map<String, Object> parseGridReference(@RequestParam(value="q", required=true) String gridReference) {
        LinkedHashMap<String, Object> response = new LinkedHashMap<String, Object>();
        if (gridReference == null || org.apache.commons.lang3.StringUtils.isBlank((CharSequence)gridReference)) {
            response.put("valid", false);
            return response;
        }
        String cleanedRef = gridReference.replaceAll("[^a-zA-Z0-9]+", "").toUpperCase();
        GISPoint point = GridUtil.processGridReference((String)cleanedRef);
        if (point != null) {
            response.put("valid", true);
            Map resolutions = GridUtil.getGridRefAsResolutions((String)cleanedRef);
            response.put("decimalLatitude", point.getLatitude());
            response.put("decimalLongitude", point.getLongitude());
            response.put("coordinateUncertaintyInMeters", point.getCoordinateUncertaintyInMeters());
            response.put("geodeticDatum", point.getDatum());
            response.put("bbox", point.getBboxString());
            response.put("easting", point.getEasting());
            response.put("northing", point.getNorthing());
            response.put("minLat", point.getMinLatitude());
            response.put("minLong", point.getMinLongitude());
            response.put("maxLat", point.getMaxLatitude());
            response.put("maxLong", point.getMaxLongitude());
            response.put("resolutions", resolutions);
        } else {
            response.put("valid", false);
        }
        return response;
    }

    @Hidden
    @RequestMapping(value={"/osgrid/feature.json"}, method={RequestMethod.GET})
    @ResponseBody
    public Map<String, Object> getFeatureInfo(SpatialSearchRequestDTO requestParams, HttpServletRequest request) throws Exception {
        try {
            String qc = requestParams.getQc();
            if (org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)qc)) {
                String[] newFqs = new String[requestParams.getFq().length + 1];
                System.arraycopy(requestParams.getFq(), 0, newFqs, 0, requestParams.getFq().length);
                newFqs[newFqs.length - 1] = qc;
                requestParams.setFq(newFqs);
                requestParams.setQc(null);
            }
            String lat = request.getParameter("lat");
            String lng = request.getParameter("lng") != null ? request.getParameter("lng") : request.getParameter("lon");
            double[] eastingNorthing = this.convertWGS84ToEastingNorthing(Double.valueOf(Double.parseDouble(lat)), Double.valueOf(Double.parseDouble(lng)));
            ParsedGridRef osGrid = this.convertEastingNorthingToOSGrid(eastingNorthing[0], eastingNorthing[1]);
            HashMap<String, Object> map = new HashMap<String, Object>();
            long count = this.getRecordCountForGridRef(requestParams, osGrid.getGridRef100(), 100, false);
            if (count > 0L) {
                map.put("gridRef", osGrid.getGridRef100());
                map.put("gridSize", 100);
                map.put("recordCount", count);
                map.put("filterQuery", this.getFilterQuery(osGrid.getGridRef100(), 100));
            }
            logger.info((Object)(osGrid.getGridRef100() + " = " + count));
            if (count == 0L && (count = this.getRecordCountForGridRef(requestParams, osGrid.getGridRef1000(), 1000, true)) > 0L) {
                map.put("gridRef", osGrid.getGridRef1000());
                map.put("gridSize", 1000);
                map.put("recordCount", count);
                map.put("filterQuery", this.getFilterQuery(osGrid.getGridRef1000(), 1000));
            }
            logger.info((Object)(osGrid.getGridRef1000() + " = " + count));
            if (count == 0L && (count = this.getRecordCountForGridRef(requestParams, osGrid.getGridRef2000(), 2000, true)) > 0L) {
                map.put("gridRef", osGrid.getGridRef2000());
                map.put("gridSize", 2000);
                map.put("recordCount", count);
                map.put("filterQuery", this.getFilterQuery(osGrid.getGridRef2000(), 2000));
            }
            logger.info((Object)(osGrid.getGridRef2000() + " = " + count));
            if (count == 0L && (count = this.getRecordCountForGridRef(requestParams, osGrid.getGridRef10000(), 10000, true)) > 0L) {
                map.put("gridRef", osGrid.getGridRef10000());
                map.put("gridSize", 10000);
                map.put("recordCount", count);
                map.put("filterQuery", this.getFilterQuery(osGrid.getGridRef10000(), 10000));
            }
            logger.info((Object)(osGrid.getGridRef10000() + " = " + count));
            if (count == 0L && (count = this.getRecordCountForGridRef(requestParams, osGrid.getGridRef100000(), 100000, true)) > 0L) {
                map.put("gridRef", osGrid.getGridRef100000());
                map.put("gridSize", 100000);
                map.put("recordCount", count);
                map.put("filterQuery", this.getFilterQuery(osGrid.getGridRef100000(), 100000));
            }
            logger.info((Object)(osGrid.getGridRef100000() + " = " + count));
            if (count > 0L) {
                int gridSize = (Integer)map.get("gridSize");
                String gridRef = (String)map.get("gridRef");
                GridRef result = GridUtil.gridReferenceToEastingNorthing((String)gridRef);
                if (result != null) {
                    int[] enForGrid = new int[]{result.getEasting(), result.getNorthing()};
                    double[] sw = this.reprojectPoint(Double.valueOf(enForGrid[0]), Double.valueOf(enForGrid[1]), GridUtil.OSGB_CRS, GISUtil.WGS84_EPSG_Code);
                    double[] se = this.reprojectPoint(Double.valueOf((double)enForGrid[0] + (double)gridSize), Double.valueOf(enForGrid[1]), GridUtil.OSGB_CRS, GISUtil.WGS84_EPSG_Code);
                    double[] nw = this.reprojectPoint(Double.valueOf(enForGrid[0]), Double.valueOf((double)enForGrid[1] + (double)gridSize), GridUtil.OSGB_CRS, GISUtil.WGS84_EPSG_Code);
                    double[] ne = this.reprojectPoint(Double.valueOf((double)enForGrid[0] + (double)gridSize), Double.valueOf((double)enForGrid[1] + (double)gridSize), GridUtil.OSGB_CRS, GISUtil.WGS84_EPSG_Code);
                    map.put("sw", sw);
                    map.put("se", se);
                    map.put("nw", nw);
                    map.put("ne", ne);
                }
            }
            return map;
        }
        catch (Exception e) {
            logger.error((Object)("Problem with getFeatureInfo request: " + e.getMessage()));
            if (logger.isDebugEnabled()) {
                logger.debug((Object)e.getMessage(), (Throwable)e);
            }
            return new HashMap<String, Object>();
        }
    }

    private long getRecordCountForGridRef(SpatialSearchRequestDTO requestParams, String gridRef, int gridSize, boolean replaceLast) {
        try {
            String[] newFqs;
            String fq = this.getFilterQuery(gridRef, gridSize);
            logger.debug((Object)("New filter query to use for record count: " + fq));
            if (replaceLast) {
                newFqs = new String[requestParams.getFq().length];
                System.arraycopy(requestParams.getFq(), 0, newFqs, 0, requestParams.getFq().length);
                newFqs[newFqs.length - 1] = fq;
                requestParams.setFq(newFqs);
            } else {
                newFqs = new String[requestParams.getFq().length + 1];
                System.arraycopy(requestParams.getFq(), 0, newFqs, 0, requestParams.getFq().length);
                newFqs[newFqs.length - 1] = fq;
                requestParams.setFq(newFqs);
            }
            requestParams.setLat(null);
            requestParams.setLon(null);
            requestParams.setFacet(Boolean.valueOf(false));
            requestParams.setPageSize(Integer.valueOf(0));
            requestParams.setFormattedQuery(null);
            logger.debug((Object)("FQs for record count: " + Arrays.toString(requestParams.getFq())));
            SearchResultDTO resultDTO = this.searchDAO.findByFulltextSpatialQuery(requestParams, false, new HashMap());
            return resultDTO.getTotalRecords();
        }
        catch (Exception e) {
            logger.error((Object)("Problem with getRecordCountForGridRef request: " + e.getMessage()));
            if (logger.isDebugEnabled()) {
                logger.debug((Object)e.getMessage(), (Throwable)e);
            }
            return 0L;
        }
    }

    private String getFilterQuery(String gridRef, int gridSize) {
        String field = "grid_ref" + (String)(gridSize > 0 ? "_" + gridSize : "");
        return field + ":" + gridRef;
    }

    @RequestMapping(value={"/osgrid/wms/reflect"}, method={RequestMethod.GET})
    public void generateWmsTile(SpatialSearchRequestDTO requestParams, @RequestParam(value="CQL_FILTER", required=false, defaultValue="") String cql_filter, @RequestParam(value="ENV", required=true, defaultValue="") String env, @RequestParam(value="SRS", required=false, defaultValue="EPSG:3857") String srs, @RequestParam(value="STYLES", required=false, defaultValue="") String styles, @RequestParam(value="BBOX", required=true, defaultValue="") String bboxString, @RequestParam(value="LAYERS", required=false, defaultValue="") String layers, @RequestParam(value="WIDTH", required=false, defaultValue="256") Integer width, @RequestParam(value="HEIGHT", required=false, defaultValue="256") Integer height, @RequestParam(value="OUTLINE", required=false, defaultValue="true") boolean outlineGrids, @RequestParam(value="OUTLINECOLOUR", required=false, defaultValue="0xff000000") String outlineColour, HttpServletRequest request, HttpServletResponse response) throws Exception {
        double tmp;
        srs = srs.split(",")[0];
        WmsEnv wmsEnv = new WmsEnv(env, styles);
        if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)bboxString)) {
            return;
        }
        if (StringUtils.trimToNull((String)cql_filter) != null) {
            requestParams.setQ(WMSUtils.getQ((String)cql_filter));
        } else if (StringUtils.trimToNull((String)layers) != null && !"ALA:Occurrences".equalsIgnoreCase(layers)) {
            requestParams.setQ(WMSUtils.convertLayersParamToQ((String)layers));
        }
        String[] bbox = bboxString.split(",");
        double minx = Double.parseDouble(bbox[0]);
        double miny = Double.parseDouble(bbox[1]);
        double maxx = Double.parseDouble(bbox[2]);
        double maxy = Double.parseDouble(bbox[3]);
        int boundingBoxSizeInKm = (int)(maxx - minx) / 1000;
        double buff = 0.0;
        String[] facets = new String[]{};
        String[] additionalFqs = new String[]{};
        logger.info((Object)("Rendering at " + boundingBoxSizeInKm));
        if ("singlegrid".equals(wmsEnv.gridres)) {
            if (boundingBoxSizeInKm >= 1000) {
                facets = new String[]{"grid_ref_100000"};
                buff = 1.0;
            } else if (boundingBoxSizeInKm > 78 && boundingBoxSizeInKm < 1000) {
                facets = new String[]{"grid_ref_10000"};
                buff = 0.75;
            } else if (boundingBoxSizeInKm > 39 && boundingBoxSizeInKm <= 78) {
                facets = new String[]{"grid_ref_2000"};
                buff = 0.05;
            } else if (boundingBoxSizeInKm > 8 && boundingBoxSizeInKm <= 39) {
                facets = new String[]{"grid_ref_1000"};
                buff = 0.05;
            } else {
                facets = new String[]{"grid_ref_100"};
                buff = 0.05;
            }
        } else if ("10kgrid".equals(wmsEnv.gridres)) {
            facets = new String[]{"grid_ref_10000"};
            buff = 0.75;
        } else if (boundingBoxSizeInKm >= 1000) {
            facets = new String[]{"grid_ref_100000"};
            buff = 1.0;
        } else if (boundingBoxSizeInKm > 39 && boundingBoxSizeInKm < 1000) {
            facets = new String[]{"grid_ref_10000"};
            buff = 0.75;
        } else if (boundingBoxSizeInKm >= 19 && boundingBoxSizeInKm <= 39) {
            buff = 0.5;
            facets = new String[]{"grid_ref_1000", "grid_ref_10000"};
        } else {
            buff = 0.1;
            facets = new String[]{"grid_ref"};
        }
        double oneUnitInRequestedProjXInPixels = (double)width.intValue() / (maxx - minx);
        double oneUnitInRequestedProjYInPixels = (double)height.intValue() / (maxy - miny);
        double[] minLatLng = this.convertProjectionToWGS84(Double.valueOf(minx), Double.valueOf(miny), srs);
        double[] maxLatLng = this.convertProjectionToWGS84(Double.valueOf(maxx), Double.valueOf(maxy), srs);
        String longitudeField = "decimalLongitude";
        String latitudeField = "decimalLatitude";
        String bboxFilterQuery = "({4}:[{0} TO {2}] AND {5}:[{1} TO {3}])";
        double minX = minLatLng[1] - buff;
        double maxX = maxLatLng[1] + buff;
        double minY = minLatLng[0] - buff;
        double maxY = maxLatLng[0] + buff;
        if (minX > maxX) {
            tmp = maxX;
            maxX = minX;
            minX = tmp;
        }
        if (minY > maxY) {
            tmp = maxY;
            maxY = minY;
            minY = tmp;
        }
        String fq = MessageFormat.format(bboxFilterQuery, minX, minY, maxX, maxY, longitudeField, latitudeField);
        String[] fqs = this.wmsUtils.getFq(requestParams);
        if (fqs == null || fqs.length == 1 && org.apache.commons.lang3.StringUtils.isBlank((CharSequence)fqs[0])) {
            fqs = new String[]{};
        }
        String[] newFqs = new String[fqs.length + 1 + additionalFqs.length];
        System.arraycopy(fqs, 0, newFqs, 0, fqs.length);
        System.arraycopy(additionalFqs, 0, newFqs, fqs.length, additionalFqs.length);
        newFqs[newFqs.length - 1] = fq;
        requestParams.setFq(newFqs);
        requestParams.setPageSize(Integer.valueOf(0));
        requestParams.setFacet(Boolean.valueOf(true));
        requestParams.setFlimit(Integer.valueOf(-1));
        requestParams.setFacets(facets);
        WMSImg wmsImg = WMSImg.create((int)width, (int)height);
        requestParams.setFq(newFqs);
        requestParams.setPageSize(Integer.valueOf(0));
        requestParams.setFacet(Boolean.valueOf(true));
        requestParams.setFlimit(Integer.valueOf(-1));
        requestParams.setFacets(facets);
        HashMap<String, Integer> gridsRefs = new HashMap<String, Integer>();
        SearchResultDTO resultsDTO2 = this.searchDAO.findByFulltextSpatialQuery(requestParams, false, new HashMap());
        List results2 = resultsDTO2.getFacetResults();
        for (FacetResultDTO result : results2) {
            for (Object fieldResult : result.getFieldResult()) {
                gridsRefs.put(fieldResult.getLabel(), (int)fieldResult.getCount());
            }
        }
        List<String> gridRefsToRender = Arrays.asList(gridsRefs.keySet().toArray(new String[0]));
        Collections.sort(gridRefsToRender, new /* Unavailable Anonymous Inner Class!! */);
        HashSet linesToRender = new HashSet();
        LinkedList renderedLinesCache = new LinkedList();
        for (String gridRef : gridRefsToRender) {
            Set renderedLines = this.renderGrid(wmsImg, gridRef, minx, miny, oneUnitInRequestedProjXInPixels, oneUnitInRequestedProjYInPixels, srs, width.intValue(), height.intValue(), wmsEnv, renderedLinesCache);
            linesToRender.addAll(renderedLines);
        }
        if (outlineGrids) {
            this.renderGridLines(wmsImg, linesToRender, outlineColour);
        }
        if (wmsImg != null && wmsImg.g != null) {
            wmsImg.g.dispose();
            try {
                ServletOutputStream outStream = response.getOutputStream();
                ImageIO.write((RenderedImage)wmsImg.img, "png", (OutputStream)outStream);
                outStream.flush();
                outStream.close();
            }
            catch (Exception e) {
                logger.error((Object)"Unable to write image", (Throwable)e);
            }
        }
    }

    public void renderGridLines(WMSImg wmsImg, Collection<int[]> linesToRender, String outlineColour) {
        for (int[] line : linesToRender) {
            wmsImg.g.setPaint(new Color(-16777216, true));
            wmsImg.g.setStroke(new BasicStroke(0.8f));
            wmsImg.g.drawLine(line[0], line[1], line[2], line[3]);
        }
    }

    private Set<int[]> renderGrid(WMSImg wmsImg, String gridRef, double minx, double miny, double oneUnitXInPixels, double oneUnitYInPixels, String targetSrs, int imageWidth, int imageHeight, WmsEnv wmsEnv, List<String> renderedLines) {
        String key4;
        String key3;
        String key2;
        if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)gridRef)) {
            return new HashSet<int[]>();
        }
        GridRef gridRefOption = GridUtil.gridReferenceToEastingNorthing((String)gridRef);
        if (gridRefOption == null) {
            return new HashSet<int[]>();
        }
        HashSet<int[]> linesToRender = new HashSet<int[]>();
        GridRef gr = gridRefOption;
        int easting = gr.getEasting();
        int northing = gr.getNorthing();
        int gridSize = gr.getCoordinateUncertainty();
        Integer minEastingOfGridCell = easting;
        Integer minNorthingOfGridCell = northing;
        Integer maxEastingOfGridCell = minEastingOfGridCell + gridSize;
        Integer maxNorthingOfGridCell = minNorthingOfGridCell + gridSize;
        double[][] polygonInMercator = this.convertEastingNorthingToTargetSRS((double[][])new double[][]{{minEastingOfGridCell.intValue(), minNorthingOfGridCell.intValue()}, {maxEastingOfGridCell.intValue(), minNorthingOfGridCell.intValue()}, {maxEastingOfGridCell.intValue(), maxNorthingOfGridCell.intValue()}, {minEastingOfGridCell.intValue(), maxNorthingOfGridCell.intValue()}}, gr.getDatum(), targetSrs);
        int[][] coordinatesForImages = this.convertUnitsToPixelOffset(polygonInMercator, minx, miny, oneUnitXInPixels, oneUnitYInPixels, imageWidth, imageHeight);
        int color = !org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)wmsEnv.gridres) && !"variablegrid".equals(wmsEnv.gridres) ? wmsEnv.colour : (gridSize == 100000 ? -256 : (gridSize == 10000 ? -256 : (gridSize == 2000 ? -16776961 : (gridSize == 1000 ? -16711936 : -65536))));
        Color polygonFill = new Color(color, true);
        wmsImg.g.setPaint(polygonFill);
        if (this.overlapping(coordinatesForImages)) {
            wmsImg.g.fillPolygon(new int[]{coordinatesForImages[0][0], coordinatesForImages[1][0], coordinatesForImages[2][0], coordinatesForImages[3][0]}, new int[]{coordinatesForImages[0][1], coordinatesForImages[1][1], coordinatesForImages[2][1], coordinatesForImages[3][1]}, 4);
        }
        Color polygonBorder = new Color(-16777216, true);
        wmsImg.g.setPaint(polygonBorder);
        String key1 = this.getLineKey(minEastingOfGridCell.intValue(), minNorthingOfGridCell.intValue(), maxEastingOfGridCell.intValue(), minNorthingOfGridCell.intValue());
        if (!renderedLines.contains(key1)) {
            linesToRender.add(new int[]{coordinatesForImages[0][0], coordinatesForImages[0][1], coordinatesForImages[1][0], coordinatesForImages[1][1]});
        }
        if (!renderedLines.contains(key2 = this.getLineKey(maxEastingOfGridCell.intValue(), minNorthingOfGridCell.intValue(), maxEastingOfGridCell.intValue(), maxNorthingOfGridCell.intValue()))) {
            linesToRender.add(new int[]{coordinatesForImages[1][0], coordinatesForImages[1][1], coordinatesForImages[2][0], coordinatesForImages[2][1]});
        }
        if (!renderedLines.contains(key3 = this.getLineKey(maxEastingOfGridCell.intValue(), maxNorthingOfGridCell.intValue(), minEastingOfGridCell.intValue(), maxNorthingOfGridCell.intValue()))) {
            linesToRender.add(new int[]{coordinatesForImages[2][0], coordinatesForImages[2][1], coordinatesForImages[3][0], coordinatesForImages[3][1]});
        }
        if (!renderedLines.contains(key4 = this.getLineKey(minEastingOfGridCell.intValue(), maxNorthingOfGridCell.intValue(), minEastingOfGridCell.intValue(), minNorthingOfGridCell.intValue()))) {
            linesToRender.add(new int[]{coordinatesForImages[3][0], coordinatesForImages[3][1], coordinatesForImages[0][0], coordinatesForImages[0][1]});
        }
        if (wmsEnv.gridlabels) {
            Color textColor = new Color(-16777216, true);
            wmsImg.g.setPaint(textColor);
            wmsImg.g.setFont(new Font("Ofliant", 0, 11));
            FontMetrics fm = wmsImg.g.getFontMetrics();
            int relativeStringWidth = fm.stringWidth(gridRef);
            String toDisplay = gridRef;
            if (relativeStringWidth + 5 <= coordinatesForImages[1][0] - coordinatesForImages[0][0]) {
                wmsImg.g.drawString(toDisplay, coordinatesForImages[0][0] + (coordinatesForImages[1][0] - coordinatesForImages[0][0]) / 2 - fm.stringWidth(gridRef) / 2, coordinatesForImages[0][1] + (coordinatesForImages[2][1] - coordinatesForImages[0][1]) / 2);
            } else {
                wmsImg.g.setFont(new Font("Ofliant", 0, 9));
                relativeStringWidth = fm.stringWidth(gridRef);
                if (relativeStringWidth + 5 <= coordinatesForImages[1][0] - coordinatesForImages[0][0]) {
                    wmsImg.g.drawString(toDisplay, coordinatesForImages[0][0] + (coordinatesForImages[1][0] - coordinatesForImages[0][0]) / 2 - fm.stringWidth(gridRef) / 2, coordinatesForImages[0][1] + (coordinatesForImages[2][1] - coordinatesForImages[0][1]) / 2);
                }
            }
        }
        return linesToRender;
    }

    public boolean overlapping(int[][] imageCoords) {
        for (int i = 0; i < imageCoords.length; ++i) {
            if (imageCoords[i][0] < 0 || imageCoords[i][1] < 0) continue;
            return true;
        }
        return false;
    }

    public String getLineKey(int x1, int y1, int x2, int y2) {
        Object key = "";
        key = x1 < x2 ? x1 + " " + x2 : x2 + " " + x1;
        key = (String)key + " ";
        key = y1 < y2 ? (String)key + y1 + " " + y2 : (String)key + y2 + " " + y1;
        return key;
    }

    ParsedGridRef convertEastingNorthingToOSGrid(double e, double n) {
        Double d;
        Double d2;
        Integer digits = 10;
        Double e100k = Math.floor(e / 100000.0);
        Double n100k = Math.floor(n / 100000.0);
        if (e100k < 0.0 || e100k > 6.0 || n100k < 0.0 || n100k > 12.0) {
            return null;
        }
        Double l1 = 19.0 - n100k - (19.0 - n100k) % 5.0 + Math.floor((e100k + 10.0) / 5.0);
        Double l2 = (19.0 - n100k) * 5.0 % 25.0 + e100k % 5.0;
        if (l1 > 7.0) {
            d2 = l1;
            d = l1 = Double.valueOf(l1 + 1.0);
        }
        if (l2 > 7.0) {
            d2 = l2;
            d = l2 = Double.valueOf(l2 + 1.0);
        }
        String letPair = "" + (char)(l1 + 65.0) + (char)(l2 + 65.0);
        e = Math.floor(e % 100000.0 / Math.pow(10.0, 5 - digits / 2));
        n = Math.floor(n % 100000.0 / Math.pow(10.0, 5 - digits / 2));
        return new ParsedGridRef(letPair, (int)e, (int)n);
    }

    double[] reprojectPoint(Double x, Double y, String sourceCRSString, String targetCRSString) {
        try {
            CoordinateReferenceSystem sourceCRS = CRS.decode((String)sourceCRSString);
            CoordinateReferenceSystem targetCRS = CRS.decode((String)targetCRSString);
            CoordinateOperation transformOp = new DefaultCoordinateOperationFactory().createOperation(sourceCRS, targetCRS);
            GeneralDirectPosition directPosition = new GeneralDirectPosition(x.doubleValue(), y.doubleValue());
            DirectPosition latLongInTargetCRS = transformOp.getMathTransform().transform((DirectPosition)directPosition, null);
            Double longitude = latLongInTargetCRS.getOrdinate(0);
            Double latitude = latLongInTargetCRS.getOrdinate(1);
            double[] coords = new double[]{longitude, latitude};
            return coords;
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            return null;
        }
    }

    double[] convertWGS84ToEastingNorthing(Double coordinate1, Double coordinate2) {
        return this.reprojectPoint(coordinate1, coordinate2, "EPSG:4326", "EPSG:27700");
    }

    double[] convertProjectionToWGS84(Double coordinate1, Double coordinate2, String sourceProjection) {
        return this.reprojectPoint(coordinate1, coordinate2, sourceProjection, "EPSG:4326");
    }

    int[][] convertUnitsToPixelOffset(double[][] polygon, double minXOfTileInMetres, double minYOfTileInMetres, double onePixelInUnitX, double onePixelInUnitY, int tileSizeInPixelsX, int tileSizeInPixelsY) {
        int[][] offsetXYWidthHeights = new int[polygon.length][2];
        for (int i = 0; i < polygon.length; ++i) {
            int x = (int)((polygon[i][0] - minXOfTileInMetres) * onePixelInUnitX);
            int y = (int)((polygon[i][1] - minYOfTileInMetres) * onePixelInUnitY);
            offsetXYWidthHeights[i] = new int[]{x, tileSizeInPixelsY - y};
        }
        return offsetXYWidthHeights;
    }

    double[][] convertEastingNorthingToTargetSRS(double[][] polygon, String sourceSrs, String targetSrs) {
        double[][] converted = new double[polygon.length][2];
        for (int i = 0; i < polygon.length; ++i) {
            converted[i] = this.reprojectPoint(Double.valueOf(polygon[i][0]), Double.valueOf(polygon[i][1]), sourceSrs, targetSrs);
        }
        return converted;
    }
}

