/*
 * Decompiled with CFR 0.152.
 */
package au.org.ala.biocache.web;

import au.org.ala.biocache.dao.QidCacheDAO;
import au.org.ala.biocache.dao.SearchDAO;
import au.org.ala.biocache.dao.TaxonDAO;
import au.org.ala.biocache.dto.DataProviderCountDTO;
import au.org.ala.biocache.dto.FacetResultDTO;
import au.org.ala.biocache.dto.HeatmapDTO;
import au.org.ala.biocache.dto.PointType;
import au.org.ala.biocache.dto.Qid;
import au.org.ala.biocache.dto.SearchResultDTO;
import au.org.ala.biocache.dto.SpatialSearchRequestDTO;
import au.org.ala.biocache.dto.SpatialSearchRequestParams;
import au.org.ala.biocache.stream.ProcessInterface;
import au.org.ala.biocache.stream.StreamAsCSV;
import au.org.ala.biocache.util.ColorUtil;
import au.org.ala.biocache.util.ImgObj;
import au.org.ala.biocache.util.LegendItem;
import au.org.ala.biocache.util.QueryFormatUtils;
import au.org.ala.biocache.util.SearchUtils;
import au.org.ala.biocache.util.WMSUtils;
import au.org.ala.biocache.util.WmsEnv;
import au.org.ala.biocache.util.converter.FqField;
import au.org.ala.biocache.util.solr.FieldMappingUtil;
import au.org.ala.biocache.web.AbstractSecureController;
import au.org.ala.biocache.web.WMSOSGridController;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Strings;
import io.swagger.annotations.ApiParam;
import io.swagger.v3.oas.annotations.Hidden;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.security.SecurityRequirement;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.RandomAccessFile;
import java.io.Writer;
import java.net.URL;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicReference;
import java.util.zip.GZIPOutputStream;
import javax.imageio.ImageIO;
import javax.inject.Inject;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.log4j.Logger;
import org.apache.solr.common.SolrDocument;
import org.apache.solr.common.SolrDocumentList;
import org.geotools.geometry.GeneralDirectPosition;
import org.geotools.referencing.CRS;
import org.geotools.referencing.operation.DefaultCoordinateOperationFactory;
import org.opengis.geometry.DirectPosition;
import org.opengis.geometry.MismatchedDimensionException;
import org.opengis.referencing.crs.CRSAuthorityFactory;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.operation.CoordinateOperation;
import org.opengis.referencing.operation.TransformException;
import org.springdoc.api.annotations.ParameterObject;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.security.access.annotation.Secured;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;

@Controller
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class WMSController
extends AbstractSecureController {
    private static final Logger logger = Logger.getLogger(WMSController.class);
    private static final String SPECIES_LIST_CSV_HEADER = "Family,Scientific name,Common name,Taxon rank,LSID,# Occurrences";
    @Inject
    protected SearchDAO searchDAO;
    @Inject
    protected QueryFormatUtils queryFormatUtils;
    @Inject
    protected TaxonDAO taxonDAO;
    @Inject
    protected SearchUtils searchUtils;
    @Inject
    protected QidCacheDAO qidCacheDAO;
    @Inject
    public FieldMappingUtil fieldMappingUtil;
    static final byte[] blankImageBytes;
    @Value(value="${webservices.root:https://biocache-ws.ala.org.au/ws}")
    protected String baseWsUrl;
    @Value(value="${biocache.ui.url:https://biocache.ala.org.au}")
    protected String baseUiUrl;
    @Value(value="${geoserver.url:https://spatial.ala.org.au/geoserver}")
    protected String geoserverUrl;
    @Value(value="${organizationName:Atlas of Living Australia}")
    protected String organizationName;
    @Value(value="${orgCity:Canberra}")
    protected String orgCity;
    @Value(value="${orgStateProvince:ACT}")
    protected String orgStateProvince;
    @Value(value="${orgPostcode:2601}")
    protected String orgPostcode;
    @Value(value="${orgCountry:Australia}")
    protected String orgCountry;
    @Value(value="${orgPhone:+61 (0) 2 6246 4400}")
    protected String orgPhone;
    @Value(value="${orgFax:+61 (0) 2 6246 4400}")
    protected String orgFax;
    @Value(value="${orgEmail:support@ala.org.au}")
    protected String orgEmail;
    @Value(value="${service.bie.ws.url:https://bie-ws.ala.org.au/ws}")
    protected String bieWebService;
    @Value(value="${service.bie.ui.url:https://bie.ala.org.au}")
    protected String bieUiUrl;
    @Value(value="${wms.capabilities.focus:latitude:[-90 TO 90] AND longitude:[-180 TO 180]}")
    protected String limitToFocusValue10;
    @Value(value="${wms.capabilities.focus.2.0:decimalLatitude:[-90 TO 90] AND decimaLongitude:[-180 TO 180]}")
    protected String limitToFocusValue20;
    @Value(value="${wms.cache.cachecontrol.publicorprivate:public}")
    private String wmsCacheControlHeaderPublicOrPrivate;
    @Value(value="${wms.cache.cachecontrol.maxage:86400}")
    private String wmsCacheControlHeaderMaxAge;
    @Value(value="${wms.image.pixel.count:36000000}")
    private int MAX_IMAGE_PIXEL_COUNT;
    private final String NULL_NAME = "Unknown";
    @Value(value="${wms.highlight.radius:6}")
    public int HIGHLIGHT_RADIUS;
    @Value(value="${wms.cache.point.width.max:15}")
    private Integer wmsMaxPointWidth;
    @Value(value="${wms.uncertainty.grouping:0,1000,2000,4000,8000,16000,30000}")
    private String uncertaintyGroupingStr;
    int additionalBuffer = 2;
    private double[] uncertaintyGrouping;
    private final AtomicReference<String> wmsETag = new AtomicReference<String>(UUID.randomUUID().toString());
    @Inject
    protected WMSOSGridController wmsosGridController;

    private double[] getUncertaintyGrouping() {
        if (this.uncertaintyGrouping == null) {
            try {
                this.uncertaintyGrouping = Arrays.stream(this.uncertaintyGroupingStr.split(",")).mapToDouble(a -> Double.parseDouble(a)).toArray();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return this.uncertaintyGrouping;
    }

    @Operation(summary="Create a query ID", tags={"Query ID"}, description="Add query details to a cache to reduce the size of the query params that are being passed around. This is particularly useful if you requests are too large for a GET.\n\nReturns a text identification for the query that has been cached. This identification can be used as part of the value for a search q. ie q=qid:")
    @Tag(name="Query ID", description="Services for creation and retrieval of queries and query ids in a cache for occurrence search")
    @RequestMapping(value={"/qid"}, method={RequestMethod.POST})
    public void storeParams(@ParameterObject SpatialSearchRequestParams params, @RequestParam(value="bbox", required=false, defaultValue="false") String bbox, @RequestParam(value="title", required=false) String title, @RequestParam(value="maxage", required=false, defaultValue="-1") Long maxage, @RequestParam(value="source", required=false) String source, HttpServletResponse response) throws Exception {
        String qid;
        SpatialSearchRequestDTO requestParams = SpatialSearchRequestDTO.create((SpatialSearchRequestParams)params);
        requestParams.setFl("");
        requestParams.setFacets(new String[0]);
        requestParams.setStart(Integer.valueOf(0));
        requestParams.setFacet(Boolean.valueOf(false));
        requestParams.setFlimit(Integer.valueOf(0));
        requestParams.setPageSize(Integer.valueOf(0));
        requestParams.setSort("score");
        requestParams.setDir("asc");
        requestParams.setFoffset(Integer.valueOf(0));
        requestParams.setFprefix("");
        requestParams.setFsort("");
        requestParams.setIncludeMultivalues(Boolean.valueOf(false));
        if (StringUtils.isNotEmpty((String)requestParams.getQc())) {
            this.queryFormatUtils.addFqs(new String[]{requestParams.getQc()}, requestParams);
            requestParams.setQc("");
        }
        if (requestParams.getLat() != null) {
            String fq = this.queryFormatUtils.buildSpatialQueryString(requestParams);
            this.queryFormatUtils.addFqs(new String[]{fq}, requestParams);
            requestParams.setLat(null);
            requestParams.setLon(null);
            requestParams.setRadius(null);
        }
        if ((qid = this.qidCacheDAO.generateQid(requestParams, bbox, title, maxage, source)) == null) {
            if (StringUtils.isEmpty((String)requestParams.getWkt())) {
                response.sendError(400, "Unable to generate QID for query");
            } else {
                response.sendError(400, "WKT provided failed to be simplified.");
            }
        } else {
            response.setContentType("text/plain");
            this.writeBytes(response, qid.getBytes());
        }
    }

    @Deprecated
    @Operation(summary="Deprecated  - use /qid", tags={"Deprecated"})
    @RequestMapping(value={"/webportal/params", "/mapping/params"}, method={RequestMethod.POST})
    public void storeParamsDeprecated(@ParameterObject SpatialSearchRequestParams params, @RequestParam(value="bbox", required=false, defaultValue="false") String bbox, @RequestParam(value="title", required=false) String title, @RequestParam(value="maxage", required=false, defaultValue="-1") Long maxage, @RequestParam(value="source", required=false) String source, HttpServletResponse response) throws Exception {
        this.storeParams(params, bbox, title, maxage, source, response);
    }

    @Operation(summary="Lookup a query ID", tags={"Query ID"}, description="Lookup a cached query based on its query id")
    @RequestMapping(value={"/qid/{queryID}"}, method={RequestMethod.GET}, produces={"application/json"})
    @ApiParam(value="queryID", required=true)
    @ResponseBody
    public Qid showQid(@PathVariable(value="queryID") Long id) throws Exception {
        return this.qidCacheDAO.get(String.valueOf(id));
    }

    @Deprecated
    @Operation(summary="Deprecated use /qid/{queryID}", tags={"Deprecated"})
    @RequestMapping(value={"/mapping/qid/{queryID}", "/mapping/qid/{queryID}.json", "/webportal/params/details/{queryID}", "/mapping/params/details/{queryID}"}, method={RequestMethod.GET}, produces={"application/json"})
    @ApiParam(value="queryID", required=true)
    @ResponseBody
    public Qid showQidDeprecated(@PathVariable(value="queryID") Long id) throws Exception {
        return this.showQid(id);
    }

    @Operation(summary="JSON web service that returns a list of species and record counts for a given location search", tags={"Mapping"})
    @RequestMapping(value={"/mapping/species"}, method={RequestMethod.GET}, produces={"application/json"})
    public void listSpecies(@ParameterObject SpatialSearchRequestParams params, HttpServletResponse response) throws Exception {
        response.setContentType("application/json");
        this.searchDAO.findAllSpeciesJSON(SpatialSearchRequestDTO.create((SpatialSearchRequestParams)params), (OutputStream)response.getOutputStream());
    }

    @Operation(summary="Download a set of counts for the supplied query", tags={"Download"})
    @RequestMapping(value={"/mapping/species.csv"}, method={RequestMethod.GET}, produces={"text/csv", "text/plain"})
    public void listSpeciesCsv(@ParameterObject SpatialSearchRequestParams requestParams, HttpServletResponse response) throws Exception {
        SpatialSearchRequestDTO dto = SpatialSearchRequestDTO.create((SpatialSearchRequestParams)requestParams);
        response.setContentType("application/json");
        this.searchDAO.findAllSpeciesCSV(dto, (OutputStream)response.getOutputStream());
    }

    @Deprecated
    @Operation(summary="Download a set of counts for the supplied query. Deprecated use /mapping/species.csv", tags={"Deprecated"})
    @RequestMapping(value={"/webportal/species.csv"}, method={RequestMethod.GET}, produces={"text/csv", "text/plain"})
    public void listSpeciesCsvDeprecated(@ParameterObject SpatialSearchRequestParams requestParams, HttpServletResponse response) throws Exception {
        this.listSpeciesCsv(requestParams, response);
    }

    @Operation(summary="Get legend for a query and facet field (colourMode).", tags={"Mapping"})
    @Tag(name="Mapping", description="Services for creating maps with WMS services, static heat maps")
    @RequestMapping(value={"/mapping/legend"}, method={RequestMethod.GET}, produces={"application/json", "text/plain"})
    @ResponseBody
    public List<LegendItem> legend(@ParameterObject SpatialSearchRequestParams params, @RequestParam(value="cm", required=false, defaultValue="") String colourMode, @RequestParam(value="type", required=false, defaultValue="application/csv") String returnType, HttpServletRequest request, HttpServletResponse response) throws Exception {
        SpatialSearchRequestDTO dto = SpatialSearchRequestDTO.create((SpatialSearchRequestParams)params);
        String[] acceptableTypes = new String[]{"application/json", "application/json; charset=UTF-8", "application/csv"};
        String accepts = request.getHeader("Accept");
        String string = returnType = StringUtils.isNotEmpty((String)accepts) && !accepts.contains(",") ? accepts : returnType;
        if (!Arrays.asList(acceptableTypes).contains(returnType)) {
            response.sendError(406, "Unable to produce a legend in the supplied \"Accept\" format: " + returnType);
            return null;
        }
        boolean isCsv = returnType.equals("application/csv");
        String[] colourModes = colourMode.split(",");
        String[] cutpoints = null;
        if (colourModes.length > 1) {
            cutpoints = new String[colourModes.length - 1];
            System.arraycopy(colourModes, 1, cutpoints, 0, cutpoints.length);
        }
        dto.setFormattedQuery(null);
        List legend = this.searchDAO.getLegend(dto, colourModes[0], cutpoints);
        StringBuilder sb = new StringBuilder();
        if (isCsv) {
            sb.append("name,red,green,blue,count");
            for (int i = 0; i < legend.size(); ++i) {
                LegendItem li = (LegendItem)legend.get(i);
                String name = li.getName();
                if (StringUtils.isEmpty((String)name)) {
                    name = "Unknown";
                }
                sb.append("\n\"").append(name.replace("\"", "\"\"")).append("\",").append(ColorUtil.getRGB((int)li.getColour())).append(",").append(((LegendItem)legend.get(i)).getCount());
            }
        }
        response.setHeader("Cache-Control", this.wmsCacheControlHeaderPublicOrPrivate + ", max-age=" + this.wmsCacheControlHeaderMaxAge);
        response.setHeader("ETag", (String)this.wmsETag.get());
        if (Arrays.asList("application/json", "application/json; charset=UTF-8").contains(returnType)) {
            return legend;
        }
        this.writeBytes(response, sb.toString().getBytes(StandardCharsets.UTF_8));
        return null;
    }

    @Deprecated
    @Operation(summary="Get legend for a query and facet field (colourMode). Deprecated use /mapping/legend", tags={"Deprecated"})
    @RequestMapping(value={"/webportal/legend"}, method={RequestMethod.GET}, produces={"application/json", "text/plain"})
    @ResponseBody
    public List<LegendItem> legendDeprecated(@ParameterObject SpatialSearchRequestParams params, @RequestParam(value="cm", required=false, defaultValue="") String colourMode, @RequestParam(value="type", required=false, defaultValue="application/csv") String returnType, HttpServletRequest request, HttpServletResponse response) throws Exception {
        return this.legend(params, colourMode, returnType, request, response);
    }

    @Hidden
    @RequestMapping(value={"/mapping/dataProviders"}, method={RequestMethod.GET}, produces={"application/json"})
    @ResponseBody
    public List<DataProviderCountDTO> queryInfo(@ParameterObject SpatialSearchRequestParams requestParams) throws Exception {
        return this.searchDAO.getDataProviderList(SpatialSearchRequestDTO.create((SpatialSearchRequestParams)requestParams));
    }

    @Deprecated
    @RequestMapping(value={"/webportal/dataProviders", "/mapping/dataProviders.json", "/webportal/dataProviders"}, method={RequestMethod.GET}, produces={"application/json"})
    @ResponseBody
    public List<DataProviderCountDTO> queryInfoDeprecated(@ParameterObject SpatialSearchRequestParams requestParams) throws Exception {
        return this.queryInfo(requestParams);
    }

    @Operation(summary="Get query bounding box as csv containing: min longitude, min latitude, max longitude, max latitude", tags={"Mapping"})
    @RequestMapping(value={"/mapping/bbox"}, method={RequestMethod.GET}, produces={"text/plain"})
    public void boundingBox(@ParameterObject SpatialSearchRequestParams requestParams, HttpServletResponse response) throws Exception {
        response.setHeader("Cache-Control", this.wmsCacheControlHeaderPublicOrPrivate + ", max-age=" + this.wmsCacheControlHeaderMaxAge);
        response.setHeader("ETag", (String)this.wmsETag.get());
        double[] bbox = this.searchDAO.getBBox(SpatialSearchRequestDTO.create((SpatialSearchRequestParams)requestParams));
        this.writeBytes(response, (bbox[0] + "," + bbox[1] + "," + bbox[2] + "," + bbox[3]).getBytes(StandardCharsets.UTF_8));
    }

    @Deprecated
    @Operation(summary="Get query bounding box as csv containing: min longitude, min latitude, max longitude, max latitude - Deprecated use /mapping/bbox", tags={"Deprecated"})
    @RequestMapping(value={"/webportal/bbox"}, method={RequestMethod.GET}, produces={"text/plain"})
    public void boundingBoxDeprecated(@ParameterObject SpatialSearchRequestParams requestParams, HttpServletResponse response) throws Exception {
        this.boundingBox(requestParams, response);
    }

    @Operation(summary="Get query bounding box as JSON", tags={"Mapping"})
    @RequestMapping(value={"/mapping/bounds"}, method={RequestMethod.GET}, produces={"application/json"})
    @ResponseBody
    public double[] jsonBoundingBox(@ParameterObject SpatialSearchRequestParams params, HttpServletResponse response) throws Exception {
        SpatialSearchRequestDTO dto = SpatialSearchRequestDTO.create((SpatialSearchRequestParams)params);
        response.setHeader("Cache-Control", this.wmsCacheControlHeaderPublicOrPrivate + ", max-age=" + this.wmsCacheControlHeaderMaxAge);
        response.setHeader("ETag", (String)this.wmsETag.get());
        double[] bbox = null;
        String q = dto.getQ();
        if (q.startsWith("qid:") && StringUtils.isEmpty((String)dto.getWkt()) && (dto.getFq().length == 0 || dto.getFq().length == 1 && StringUtils.isEmpty((String)dto.getFq()[0]))) {
            try {
                bbox = this.qidCacheDAO.get(q.substring(4)).getBbox();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (bbox == null) {
            bbox = this.searchDAO.getBBox(dto);
        }
        return bbox;
    }

    @Deprecated
    @Operation(summary="Deprecated use /mapping/bounds", tags={"Deprecated"})
    @RequestMapping(value={"/mapping/bounds.json", "/webportal/bounds.json", "/webportal/bounds"}, method={RequestMethod.GET}, produces={"application/json"})
    @ResponseBody
    public double[] jsonBoundingBoxDeprecated(@ParameterObject SpatialSearchRequestParams params, HttpServletResponse response) throws Exception {
        return this.jsonBoundingBox(params, response);
    }

    @Operation(summary="Get query bounding box as JSON", tags={"Deprecated"})
    @Deprecated
    @RequestMapping(value={"/webportal/occurrences", "/mapping/occurrences.json", "/webportal/occurrences", "/mapping/occurrences.json"}, method={RequestMethod.GET}, produces={"application/json"})
    @ResponseBody
    public SearchResultDTO occurrences(@ParameterObject SpatialSearchRequestParams requestParams, Model model) throws Exception {
        if (StringUtils.isEmpty((String)requestParams.getQ())) {
            return new SearchResultDTO();
        }
        SearchResultDTO searchResult = this.searchDAO.findByFulltextSpatialQuery(SpatialSearchRequestDTO.create((SpatialSearchRequestParams)requestParams), false, null);
        model.addAttribute("searchResult", (Object)searchResult);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Returning results set with: " + searchResult.getTotalRecords()));
        }
        return searchResult;
    }

    @SecurityRequirement(name="JWT")
    @Secured(value={"ROLE_USER", "ROLE_ADMIN"})
    @Operation(summary="Get occurrences by query as gzipped csv.", tags={"Deprecated"})
    @Deprecated
    @RequestMapping(value={"/mapping/occurrences.gz"}, method={RequestMethod.GET}, produces={"application/octet-stream"})
    public void occurrenceGz(@ParameterObject SpatialSearchRequestParams params, HttpServletResponse response) {
        response.setContentType("text/plain");
        SpatialSearchRequestDTO dto = SpatialSearchRequestDTO.create((SpatialSearchRequestParams)params);
        try {
            ServletOutputStream outStream = response.getOutputStream();
            GZIPOutputStream gzip = new GZIPOutputStream((OutputStream)outStream);
            dto.setPageSize(Integer.valueOf(-1));
            if (dto.getStart() == 0) {
                this.writeOccurrencesCsvToStream(SpatialSearchRequestDTO.create((SpatialSearchRequestParams)params), (OutputStream)gzip);
            }
            gzip.flush();
            gzip.close();
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    @Deprecated
    @RequestMapping(value={"/webportal/occurrences.gz"}, method={RequestMethod.GET}, produces={"application/octet-stream"})
    public void occurrenceGzDeprecated(@ParameterObject SpatialSearchRequestParams params, HttpServletResponse response) {
        this.occurrenceGz(params, response);
    }

    private void writeOccurrencesCsvToStream(SpatialSearchRequestDTO requestParams, OutputStream stream) throws Exception {
        this.searchDAO.streamingQuery(requestParams, (ProcessInterface)new StreamAsCSV(this.fieldMappingUtil, stream, requestParams), null);
    }

    private void writeBytes(HttpServletResponse response, byte[] bytes) throws IOException {
        try {
            response.setContentType("text/plain");
            response.setCharacterEncoding("UTF-8");
            ServletOutputStream outStream = response.getOutputStream();
            outStream.write(bytes);
            outStream.flush();
            outStream.close();
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    int scaleLatitudeForImage(double lat, double top, double bottom, int pixelHeight) {
        return (int)((lat - top) / (bottom - top) * (double)pixelHeight);
    }

    int scaleLongitudeForImage(double lng, double left, double right, int pixelWidth) {
        return (int)((lng - left) / (right - left) * (double)pixelWidth);
    }

    double convertMetersToLng(double meters) {
        return meters / 2.0037508342789244E7 * 180.0;
    }

    double convertMetersToLat(double meters) {
        return 57.29577951308232 * (2.0 * Math.atan(Math.exp(meters / 2.0037508342789244E7 * Math.PI)) - 1.5707963267948966);
    }

    protected PointType getPointTypeForDegreesPerPixel(double resolution) {
        if (resolution >= 1.0) {
            return PointType.POINT_1;
        }
        if (resolution >= 0.1) {
            return PointType.POINT_01;
        }
        if (resolution >= 0.01) {
            return PointType.POINT_001;
        }
        if (resolution >= 0.001) {
            return PointType.POINT_0001;
        }
        if (resolution >= 1.0E-4) {
            return PointType.POINT_00001;
        }
        return PointType.POINT_RAW;
    }

    void displayBlankImage(HttpServletResponse response) {
        try {
            ServletOutputStream outStream = response.getOutputStream();
            outStream.write(blankImageBytes);
            outStream.flush();
            outStream.close();
        }
        catch (Exception e) {
            logger.error((Object)"Unable to write image", (Throwable)e);
        }
    }

    private double getBBoxesSRS(CoordinateOperation transformTo4326, String bboxString, int width, int height, int size, boolean uncertainty, double[] mbbox, double[] bbox, double[] pbbox, double[] tilebbox) throws TransformException {
        String[] splitBBox = bboxString.split(",");
        for (int i = 0; i < 4; ++i) {
            try {
                tilebbox[i] = Double.parseDouble(splitBBox[i]);
                mbbox[i] = tilebbox[i];
                continue;
            }
            catch (Exception e) {
                logger.error((Object)("Problem parsing BBOX: '" + bboxString + "' at position " + i), (Throwable)e);
                tilebbox[i] = 0.0;
                mbbox[i] = 0.0;
            }
        }
        double pixelWidthInTargetSRS = (mbbox[2] - mbbox[0]) / (double)width;
        double pixelHeightInTargetSRS = (mbbox[3] - mbbox[1]) / (double)height;
        mbbox[0] = mbbox[0] + pixelWidthInTargetSRS / 2.0;
        mbbox[2] = mbbox[2] - pixelWidthInTargetSRS / 2.0;
        mbbox[1] = mbbox[1] + pixelHeightInTargetSRS / 2.0;
        mbbox[3] = mbbox[3] - pixelHeightInTargetSRS / 2.0;
        double srsOffset = 10.0;
        double xoffset = pixelWidthInTargetSRS * (double)(size + 1) * srsOffset;
        double yoffset = pixelHeightInTargetSRS * (double)(size + 1) * srsOffset;
        pbbox[0] = mbbox[0];
        pbbox[1] = mbbox[1];
        pbbox[2] = mbbox[2];
        pbbox[3] = mbbox[3];
        GeneralDirectPosition directPositionSW = new GeneralDirectPosition(mbbox[0] - xoffset, mbbox[1] - yoffset);
        GeneralDirectPosition directPositionNE = new GeneralDirectPosition(mbbox[2] + xoffset, mbbox[3] + yoffset);
        GeneralDirectPosition directPositionSE = new GeneralDirectPosition(mbbox[2] - xoffset, mbbox[1] - yoffset);
        GeneralDirectPosition directPositionNW = new GeneralDirectPosition(mbbox[0] + xoffset, mbbox[3] + yoffset);
        DirectPosition sw4326 = transformTo4326.getMathTransform().transform((DirectPosition)directPositionSW, null);
        DirectPosition ne4326 = transformTo4326.getMathTransform().transform((DirectPosition)directPositionNE, null);
        DirectPosition se4326 = transformTo4326.getMathTransform().transform((DirectPosition)directPositionSE, null);
        DirectPosition nw4326 = transformTo4326.getMathTransform().transform((DirectPosition)directPositionNW, null);
        bbox[0] = Math.min(Math.min(Math.min(sw4326.getOrdinate(0), ne4326.getOrdinate(0)), se4326.getOrdinate(0)), nw4326.getOrdinate(0));
        bbox[1] = Math.min(Math.min(Math.min(sw4326.getOrdinate(1), ne4326.getOrdinate(1)), se4326.getOrdinate(1)), nw4326.getOrdinate(1));
        bbox[2] = Math.max(Math.max(Math.max(sw4326.getOrdinate(0), ne4326.getOrdinate(0)), se4326.getOrdinate(0)), nw4326.getOrdinate(0));
        bbox[3] = Math.max(Math.max(Math.max(sw4326.getOrdinate(1), ne4326.getOrdinate(1)), se4326.getOrdinate(1)), nw4326.getOrdinate(1));
        double degreesPerPixel = Math.min((bbox[2] - bbox[0]) / (double)width, (bbox[3] - bbox[1]) / (double)height);
        return degreesPerPixel;
    }

    @Operation(summary="Get metadata request", tags={"OGC"})
    @Tag(name="OGC", description="Services for providing OGC compliant mapping functionalities")
    @RequestMapping(value={"/ogc/getMetadata"}, method={RequestMethod.GET}, produces={"text/xml"})
    public String getMetadata(@RequestParam(value="LAYER", required=false, defaultValue="") String layer, @RequestParam(value="q", required=false, defaultValue="") String query, HttpServletResponse response, Model model) throws Exception {
        String[] parts;
        String taxonName = "";
        if (StringUtils.trimToNull((String)layer) != null) {
            parts = layer.split(":");
            taxonName = parts[parts.length - 1];
        } else if (StringUtils.trimToNull((String)query) != null) {
            parts = query.split(":");
            taxonName = parts[parts.length - 1];
        } else {
            response.sendError(400);
        }
        ObjectMapper om = new ObjectMapper();
        String guid = null;
        JsonNode guidLookupNode = om.readTree(new URL(this.bieWebService + "/guid/" + URLEncoder.encode(taxonName, "UTF-8")));
        if (guidLookupNode.isArray() && guidLookupNode.size() > 0) {
            JsonNode idNode = guidLookupNode.get(0).get("acceptedIdentifier");
            guid = idNode != null ? idNode.asText() : null;
        }
        String newQuery = "raw_scientificName:" + taxonName;
        if (guid != null) {
            JsonNode authorshipNode;
            JsonNode nameNode;
            JsonNode commonNameNode;
            String imageUrl;
            model.addAttribute("guid", guid);
            model.addAttribute("speciesPageUrl", (Object)(this.bieUiUrl + "/species/" + guid));
            JsonNode node = om.readTree(new URL(this.bieWebService + "/species/" + guid));
            JsonNode tc = node.get("taxonConcept");
            JsonNode imageNode = tc.get("smallImageUrl");
            String string = imageUrl = imageNode != null ? imageNode.asText() : null;
            if (imageUrl != null) {
                model.addAttribute("imageUrl", (Object)imageUrl);
                JsonNode imageMetadataNode = node.get("taxonConcept").get("imageMetadataUrl");
                String imageMetadataUrl = imageMetadataNode != null ? imageMetadataNode.asText() : null;
                JsonNode imageMetadata = om.readTree(new URL(imageMetadataUrl));
                if (imageMetadata != null) {
                    if (imageMetadata.get("http://purl.org/dc/elements/1.1/creator") != null) {
                        model.addAttribute("imageCreator", (Object)imageMetadata.get("http://purl.org/dc/elements/1.1/creator").asText());
                    }
                    if (imageMetadata.get("http://purl.org/dc/elements/1.1/license") != null) {
                        model.addAttribute("imageLicence", (Object)imageMetadata.get("http://purl.org/dc/elements/1.1/license").asText());
                    }
                    if (imageMetadata.get("http://purl.org/dc/elements/1.1/source") != null) {
                        model.addAttribute("imageSource", (Object)imageMetadata.get("http://purl.org/dc/elements/1.1/source").asText());
                    }
                }
            }
            JsonNode leftNode = tc.get("left");
            JsonNode rightNode = tc.get("right");
            String string2 = newQuery = leftNode != null && rightNode != null ? "lft:[" + leftNode.asText() + " TO " + rightNode.asText() + "]" : "taxonConceptID:" + guid;
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("The new query : " + newQuery));
            }
            if ((commonNameNode = tc.get("commonNameSingle")) != null) {
                model.addAttribute("commonName", (Object)commonNameNode.asText());
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("retrieved name: " + commonNameNode.asText()));
                }
            }
            if ((nameNode = tc.get("nameComplete")) != null) {
                model.addAttribute("name", (Object)nameNode.asText());
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("retrieved name: " + nameNode.asText()));
                }
            }
            if ((authorshipNode = node.get("taxonConcept").get("author")) != null) {
                model.addAttribute("authorship", (Object)authorshipNode.asText());
            }
            JsonNode node2 = om.readTree(new URL(this.bieWebService + "/species/" + guid + ".json"));
            JsonNode classificationNode = node2.get("classification");
            model.addAttribute("kingdom", (Object)StringUtils.capitalize((String)classificationNode.get("kingdom").asText().toLowerCase()));
            model.addAttribute("phylum", (Object)StringUtils.capitalize((String)classificationNode.get("phylum").asText().toLowerCase()));
            model.addAttribute("clazz", (Object)StringUtils.capitalize((String)classificationNode.get("clazz").asText().toLowerCase()));
            model.addAttribute("order", (Object)StringUtils.capitalize((String)classificationNode.get("order").asText().toLowerCase()));
            model.addAttribute("family", (Object)StringUtils.capitalize((String)classificationNode.get("family").asText().toLowerCase()));
            model.addAttribute("genus", (Object)classificationNode.get("genus").asText());
            JsonNode taxonNameNode = node2.get("taxonName");
            if (taxonNameNode != null && taxonNameNode.get("specificEpithet") != null) {
                model.addAttribute("specificEpithet", (Object)taxonNameNode.get("specificEpithet").asText());
            }
        }
        SpatialSearchRequestDTO searchParams = new SpatialSearchRequestDTO();
        searchParams.setQ(newQuery);
        searchParams.setFacets(new String[]{"dataResourceName"});
        searchParams.setPageSize(Integer.valueOf(0));
        List facets = this.searchDAO.getFacetCounts(searchParams);
        model.addAttribute("query", (Object)newQuery);
        model.addAttribute("dataProviders", (Object)((FacetResultDTO)facets.get(0)).getFieldResult());
        return "metadata/mcp";
    }

    @Operation(summary="Get feature request", tags={"OGC"})
    @RequestMapping(value={"/ogc/getFeatureInfo"}, method={RequestMethod.GET}, produces={"text/html"})
    public String getFeatureInfo(@RequestParam(value="ENV", required=false, defaultValue="") String env, @RequestParam(value="BBOX", required=false, defaultValue="0,-90,180,0") String bboxString, @RequestParam(value="WIDTH", required=false, defaultValue="256") Integer width, @RequestParam(value="HEIGHT", required=false, defaultValue="256") Integer height, @RequestParam(value="STYLES", required=false, defaultValue="") String styles, @RequestParam(value="SRS", required=false, defaultValue="EPSG:3857") String srs, @RequestParam(value="QUERY_LAYERS", required=false, defaultValue="") String queryLayers, @RequestParam(value="X", required=true, defaultValue="0") Double x, @RequestParam(value="Y", required=true, defaultValue="0") Double y, Model model) throws Exception {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("WMS - GetFeatureInfo requested for: " + queryLayers));
        }
        WmsEnv vars = new WmsEnv(env, styles);
        double[] mbbox = new double[4];
        double[] bbox = new double[4];
        double[] pbbox = new double[4];
        double[] tilebbox = new double[4];
        int size = vars.size + (vars.highlight != null ? this.HIGHLIGHT_RADIUS * 2 + (int)((double)vars.size * 0.2) : 0) + 5;
        CRSAuthorityFactory factory = CRS.getAuthorityFactory((boolean)true);
        CoordinateReferenceSystem sourceCRS = factory.createCoordinateReferenceSystem(srs);
        CoordinateReferenceSystem targetCRS = factory.createCoordinateReferenceSystem("EPSG:4326");
        CoordinateOperation transformTo4326 = new DefaultCoordinateOperationFactory().createOperation(sourceCRS, targetCRS);
        double resolution = this.getBBoxesSRS(transformTo4326, bboxString, width.intValue(), height.intValue(), size, vars.uncertainty, mbbox, bbox, pbbox, tilebbox);
        PointType pointType = this.getPointTypeForDegreesPerPixel(resolution);
        double longitude = bbox[0] + (bbox[2] - bbox[0]) / width.doubleValue() * x;
        double latitude = bbox[3] - (bbox[3] - bbox[1]) / height.doubleValue() * y;
        double roundedLongitude = longitude;
        double roundedLatitude = latitude;
        double minLng = pointType.roundDownToPointType(roundedLongitude - (double)(pointType.getValue().floatValue() * 2.0f * (float)(size + 3)));
        double maxLng = pointType.roundUpToPointType(roundedLongitude + (double)(pointType.getValue().floatValue() * 2.0f * (float)(size + 3)));
        double minLat = pointType.roundDownToPointType(roundedLatitude - (double)(pointType.getValue().floatValue() * 2.0f * (float)(size + 3)));
        double maxLat = pointType.roundUpToPointType(roundedLatitude + (double)(pointType.getValue().floatValue() * 2.0f * (float)(size + 3)));
        SpatialSearchRequestDTO requestParams = new SpatialSearchRequestDTO();
        String longitudeField = "decimalLongitude";
        String latitudeField = "decimalLatitude";
        String q = WMSUtils.convertLayersParamToQ((String)queryLayers);
        requestParams.setQ(WMSUtils.convertLayersParamToQ((String)queryLayers));
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("WMS GetFeatureInfo for " + queryLayers + ", " + longitudeField + ":[" + minLng + " TO " + maxLng + "],  " + latitudeField + ":[" + minLat + " TO " + maxLat + "]"));
        }
        String[] fqs = new String[]{longitudeField + ":[" + minLng + " TO " + maxLng + "]", latitudeField + ":[" + minLat + " TO " + maxLat + "]"};
        requestParams.setFq(fqs);
        requestParams.setFacet(Boolean.valueOf(false));
        SolrDocumentList sdl = this.searchDAO.findByFulltext(requestParams);
        if (sdl != null && sdl.size() > 0) {
            SolrDocument doc = (SolrDocument)sdl.get(0);
            model.addAttribute("record", (Object)doc.getFieldValueMap());
            model.addAttribute("totalRecords", (Object)sdl.getNumFound());
        }
        model.addAttribute("uriUrl", (Object)(this.baseUiUrl + "/occurrences/search?q=" + URLEncoder.encode(q == null ? "" : q, "UTF-8") + "&fq=" + URLEncoder.encode(fqs[0], "UTF-8") + "&fq=" + URLEncoder.encode(fqs[1], "UTF-8")));
        model.addAttribute("pointType", (Object)pointType.name());
        model.addAttribute("minLng", (Object)minLng);
        model.addAttribute("maxLng", (Object)maxLng);
        model.addAttribute("minLat", (Object)minLat);
        model.addAttribute("maxLat", (Object)maxLat);
        model.addAttribute("latitudeClicked", (Object)latitude);
        model.addAttribute("longitudeClicked", (Object)longitude);
        return "metadata/getFeatureInfo";
    }

    @Operation(summary="Get Legend Graphic", tags={"OGC"})
    @RequestMapping(value={"/ogc/legendGraphic"}, method={RequestMethod.GET}, produces={"image/png"})
    public void getLegendGraphic(@RequestParam(value="ENV", required=false, defaultValue="") String env, @RequestParam(value="STYLE", required=false, defaultValue="8b0000;opacity=1;size=5") String style, @RequestParam(value="WIDTH", required=false, defaultValue="30") Integer width, @RequestParam(value="HEIGHT", required=false, defaultValue="20") Integer height, HttpServletRequest request, HttpServletResponse response) {
        try {
            if (StringUtils.trimToNull((String)env) == null && StringUtils.trimToNull((String)style) == null) {
                style = "8b0000;opacity=1;size=5";
            }
            WmsEnv wmsEnv = new WmsEnv(env, style);
            BufferedImage img = new BufferedImage(width, height, 2);
            Graphics2D g = (Graphics2D)img.getGraphics();
            int size = width > height ? height : width;
            Color fill = new Color(wmsEnv.colour | wmsEnv.alpha << 24);
            g.setPaint(fill);
            g.fillOval(0, 0, size, size);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("WMS - GetLegendGraphic requested : " + request.getQueryString()));
            }
            try (ServletOutputStream out = response.getOutputStream();){
                response.setContentType("image/png");
                response.setHeader("Cache-Control", this.wmsCacheControlHeaderPublicOrPrivate + ", max-age=" + this.wmsCacheControlHeaderMaxAge);
                response.setHeader("ETag", (String)this.wmsETag.get());
                ImageIO.write((RenderedImage)img, "png", (OutputStream)out);
            }
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    @Operation(summary="Get Capabilities OGC request", tags={"OGC"})
    @RequestMapping(value={"/ogc/ows", "/ogc/ows.xml", "/ogc/capabilities", "/ogc/capabilities.xml", "/ogc/getCapabilities"}, method={RequestMethod.GET}, produces={"text/xml"})
    public void getCapabilities(@ParameterObject SpatialSearchRequestParams requestParams, @RequestParam(value="CQL_FILTER", required=false, defaultValue="") String cql_filter, @RequestParam(value="ENV", required=false, defaultValue="") String env, @RequestParam(value="SRS", required=false, defaultValue="EPSG:3857") String srs, @RequestParam(value="STYLES", required=false, defaultValue="") String styles, @RequestParam(value="STYLE", required=false, defaultValue="") String style, @RequestParam(value="BBOX", required=false, defaultValue="") String bboxString, @RequestParam(value="WIDTH", required=false, defaultValue="256") Integer width, @RequestParam(value="HEIGHT", required=false, defaultValue="256") Integer height, @RequestParam(value="REQUEST", required=false, defaultValue="GetCapabilities") String requestString, @RequestParam(value="OUTLINE", required=false, defaultValue="false") boolean outlinePoints, @RequestParam(value="OUTLINECOLOUR", required=false, defaultValue="0x000000") String outlineColour, @RequestParam(value="LAYERS", required=false, defaultValue="") String layers, @RequestParam(value="q", required=false, defaultValue="*:*") String query, @FqField @RequestParam(value="fq", required=false) String[] filterQueries, @RequestParam(value="X", required=false, defaultValue="0") Double x, @RequestParam(value="Y", required=false, defaultValue="0") Double y, @RequestParam(value="GRIDDETAIL", required=false, defaultValue="16") int gridDivisionCount, @RequestParam(value="HQ", required=false) String[] hqs, @RequestParam(value="marineSpecies", required=false, defaultValue="false") boolean marineOnly, @RequestParam(value="terrestrialSpecies", required=false, defaultValue="false") boolean terrestrialOnly, @RequestParam(value="limitToFocus", required=false, defaultValue="false") boolean limitToFocus, @RequestParam(value="useSpeciesGroups", required=false, defaultValue="false") boolean useSpeciesGroups, HttpServletRequest request, HttpServletResponse response, Model model) throws Exception {
        String encodedQuery = URLEncoder.encode(query, "UTF-8");
        if ("GetMap".equalsIgnoreCase(requestString)) {
            this.generateWmsTileViaHeatmap(requestParams, cql_filter, env, srs, styles, bboxString, width, height, requestString, outlinePoints, outlineColour, layers, hqs, Integer.valueOf(gridDivisionCount), request, response);
            return;
        }
        if ("GetLegendGraphic".equalsIgnoreCase(requestString)) {
            this.getLegendGraphic(env, style, Integer.valueOf(30), Integer.valueOf(20), request, response);
            return;
        }
        if ("GetFeatureInfo".equalsIgnoreCase(requestString)) {
            this.getFeatureInfo(env, bboxString, width, height, styles, srs, layers, x, y, model);
            return;
        }
        response.setContentType("text/xml");
        response.setHeader("Content-Description", "File Transfer");
        response.setHeader("Content-Disposition", "attachment; filename=GetCapabilities.xml");
        response.setHeader("Content-Transfer-Encoding", "binary");
        try {
            String biocacheServerUrl = request.getSession().getServletContext().getInitParameter("webservicesRoot");
            PrintWriter writer = response.getWriter();
            Object supportedCodes = "      <SRS>EPSG:4326</SRS>\n";
            for (String code : CRS.getSupportedCodes((String)"EPSG")) {
                if ("EPSG:4326".equals(code)) continue;
                supportedCodes = (String)supportedCodes + "      <SRS>" + code + "</SRS>\n";
            }
            writer.write("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<!DOCTYPE WMT_MS_Capabilities SYSTEM \"https://spatial.ala.org.au/geoserver/schemas/wms/1.1.1/WMS_MS_Capabilities.dtd\">\n<WMT_MS_Capabilities version=\"1.1.1\" updateSequence=\"28862\">\n  <Service>\n    <Name>ALA WMS</Name>\n    <Title>" + this.organizationName + "(WMS) - Species occurrences</Title>\n    <Abstract>WMS services for species occurrences.</Abstract>\n    <KeywordList>\n      <Keyword>WMS</Keyword>\n      <Keyword>Species occurrence data</Keyword>\n      <Keyword>ALA</Keyword>\n      <Keyword>CRIS</Keyword>\n    </KeywordList>\n    <OnlineResource xmlns:xlink=\"http://www.w3.org/1999/xlink\" xlink:type=\"simple\" xlink:href=\"" + this.baseUiUrl + "\"/>\n    <ContactInformation>\n      <ContactPersonPrimary>\n        <ContactPerson>ALA Support</ContactPerson>\n        <ContactOrganization>" + this.organizationName + "</ContactOrganization>\n      </ContactPersonPrimary>\n      <ContactPosition>Support Manager</ContactPosition>\n      <ContactAddress>\n        <AddressType></AddressType>\n        <Address/>\n        <City>" + this.orgCity + "</City>\n        <StateOrProvince>" + this.orgStateProvince + "</StateOrProvince>\n        <PostCode>" + this.orgPostcode + "</PostCode>\n        <Country>" + this.orgCountry + "</Country>\n      </ContactAddress>\n      <ContactVoiceTelephone>" + this.orgPhone + "</ContactVoiceTelephone>\n      <ContactFacsimileTelephone>" + this.orgFax + "</ContactFacsimileTelephone>\n      <ContactElectronicMailAddress>" + this.orgEmail + "</ContactElectronicMailAddress>\n    </ContactInformation>\n    <Fees>NONE</Fees>\n    <AccessConstraints>NONE</AccessConstraints>\n  </Service>\n  <Capability>\n    <Request>\n      <GetCapabilities>\n        <Format>application/vnd.ogc.wms_xml</Format>\n        <DCPType>\n          <HTTP>\n            <Get>\n              <OnlineResource xmlns:xlink=\"http://www.w3.org/1999/xlink\" xlink:type=\"simple\" xlink:href=\"" + this.baseWsUrl + "/ogc/ows?SERVICE=WMS&amp;q=" + encodedQuery + "&amp;REQUEST=GetCapabilities&amp;\"/>\n            </Get>\n            <Post>\n              <OnlineResource xmlns:xlink=\"http://www.w3.org/1999/xlink\" xlink:type=\"simple\" xlink:href=\"" + this.baseWsUrl + "/ogc/ows?SERVICE=WMS&amp;q=" + encodedQuery + "&amp;REQUEST=GetCapabilities&amp;\"/>\n            </Post>\n          </HTTP>\n        </DCPType>\n      </GetCapabilities>\n      <GetMap>\n        <Format>image/png</Format>\n        <DCPType>\n          <HTTP>\n            <Get>\n              <OnlineResource xmlns:xlink=\"http://www.w3.org/1999/xlink\" xlink:type=\"simple\" xlink:href=\"" + this.baseWsUrl + "/ogc/ows?SERVICE=WMS&amp;OUTLINE=TRUE&amp;q=" + encodedQuery + "&amp;REQUEST=getMap&amp;\"/>\n            </Get>\n          </HTTP>\n        </DCPType>\n      </GetMap>\n      <GetFeatureInfo>\n        <Format>text/html</Format>\n        <DCPType>\n          <HTTP>\n            <Get>\n              <OnlineResource xmlns:xlink=\"http://www.w3.org/1999/xlink\" xlink:type=\"simple\" xlink:href=\"" + this.baseWsUrl + "/ogc/ows?SERVICE=WMS&amp;q=" + encodedQuery + "&amp;REQUEST=GetFeatureInfo&amp;\"/>\n            </Get>\n            <Post>\n              <OnlineResource xmlns:xlink=\"http://www.w3.org/1999/xlink\" xlink:type=\"simple\" xlink:href=\"" + this.baseWsUrl + "/ogc/ows?SERVICE=WMS&amp;q=" + encodedQuery + "&amp;REQUEST=GetFeatureInfo&amp;\"/>\n            </Post>\n          </HTTP>\n        </DCPType>\n      </GetFeatureInfo>\n      <GetLegendGraphic>\n        <Format>image/png</Format>\n        <Format>image/jpeg</Format>\n        <Format>image/gif</Format>\n        <DCPType>\n          <HTTP>\n            <Get>\n              <OnlineResource xmlns:xlink=\"http://www.w3.org/1999/xlink\" xlink:type=\"simple\" xlink:href=\"" + this.baseWsUrl + "/ogc/ows?SERVICE=WMS&amp;q=" + encodedQuery + "&amp;REQUEST=GetLegendGraphic&amp;\"/>\n            </Get>\n          </HTTP>\n        </DCPType>\n      </GetLegendGraphic>\n    </Request>\n    <Exception>\n      <Format>application/vnd.ogc.se_xml</Format>\n      <Format>application/vnd.ogc.se_inimage</Format>\n    </Exception>\n    <Layer>\n      <Title>" + this.organizationName + " - Species occurrence layers</Title>\n      <Abstract>Custom WMS services for " + this.organizationName + " species occurrences</Abstract>\n" + (String)supportedCodes + "     <LatLonBoundingBox minx=\"-179.9\" miny=\"-89.9\" maxx=\"179.9\" maxy=\"89.9\"/>\n");
            writer.write(this.generateStylesForPoints());
            if (marineOnly) {
                filterQueries = (String[])ArrayUtils.add((Object[])filterQueries, (Object)"biome:Marine OR biome:\"Marine and Non-marine\"");
            }
            if (terrestrialOnly) {
                filterQueries = (String[])ArrayUtils.add((Object[])filterQueries, (Object)"biome:\"Non-marine\" OR biome:Limnetic");
            }
            if (limitToFocus) {
                filterQueries = (String[])ArrayUtils.add((Object[])filterQueries, (Object)this.limitToFocusValue20);
            }
            query = this.searchUtils.convertRankAndName(query);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("GetCapabilities query in use: " + query));
            }
            if (useSpeciesGroups) {
                this.taxonDAO.extractBySpeciesGroups(this.baseWsUrl + "/ogc/getMetadata", query, filterQueries, (Writer)writer);
            } else {
                this.taxonDAO.extractHierarchy(this.baseWsUrl + "/ogc/getMetadata", query, filterQueries, (Writer)writer);
            }
            writer.write("</Layer></Capability></WMT_MS_Capabilities>\n");
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    private String generateStylesForPoints() {
        String[] sizes = new String[]{"5", "10", "2"};
        String[] sizesNames = new String[]{"medium", "large", "small"};
        String[] opacities = new String[]{"0.5", "1", "0.2"};
        String[] opacitiesNames = new String[]{"medium", "opaque", "transparency"};
        StringBuffer sb = new StringBuffer();
        int colorIdx = 0;
        int sizeIdx = 0;
        int opIdx = 0;
        for (String color : ColorUtil.colorsNames) {
            for (String size : sizes) {
                for (String opacity : opacities) {
                    sb.append("<Style>\n<Name>" + ColorUtil.colorsCodes[colorIdx] + ";opacity=" + opacity + ";size=" + size + "</Name> \n<Title>" + color + ";opacity=" + opacitiesNames[opIdx] + ";size=" + sizesNames[sizeIdx] + "</Title> \n</Style>\n");
                    ++opIdx;
                }
                opIdx = 0;
                ++sizeIdx;
            }
            sizeIdx = 0;
            ++colorIdx;
        }
        return sb.toString();
    }

    @Deprecated
    @Operation(summary="Web Mapping Service", tags={"Deprecated"})
    @GetMapping(value={"/webportal/wms/reflect"}, produces={"image/png"})
    public void generateWmsTileViaHeatmapDeprecated(@ParameterObject SpatialSearchRequestParams params, @RequestParam(value="CQL_FILTER", required=false, defaultValue="") String cql_filter, @RequestParam(value="ENV", required=false, defaultValue="") String env, @RequestParam(value="SRS", required=false, defaultValue="EPSG:3857") String srs, @RequestParam(value="STYLES", required=false, defaultValue="") String styles, @RequestParam(value="BBOX", required=true, defaultValue="") String bboxString, @RequestParam(value="WIDTH", required=false, defaultValue="256") Integer width, @RequestParam(value="HEIGHT", required=false, defaultValue="256") Integer height, @RequestParam(value="REQUEST", required=false, defaultValue="GetMap") String requestString, @RequestParam(value="OUTLINE", required=false, defaultValue="true") boolean outlinePoints, @RequestParam(value="OUTLINECOLOUR", required=false, defaultValue="0x000000") String outlineColour, @RequestParam(value="LAYERS", required=false, defaultValue="") String layers, @RequestParam(value="HQ", required=false) String[] hqs, @RequestParam(value="GRIDDETAIL", required=false, defaultValue="16") Integer gridDivisionCount, HttpServletRequest request, HttpServletResponse response) throws Exception {
        this.generateWmsTileViaHeatmap(params, cql_filter, env, srs, styles, bboxString, width, height, requestString, outlinePoints, outlineColour, layers, hqs, gridDivisionCount, request, response);
    }

    @Operation(summary="Web Mapping Service", tags={"Mapping", "OGC"}, description="WMS services for point occurrence data")
    @GetMapping(value={"/ogc/wms/reflect", "/mapping/wms/reflect"}, produces={"image/png"})
    public void generateWmsTileViaHeatmap(@ParameterObject SpatialSearchRequestParams params, @RequestParam(value="CQL_FILTER", required=false, defaultValue="") String cql_filter, @RequestParam(value="ENV", required=false, defaultValue="") String env, @RequestParam(value="SRS", required=false, defaultValue="EPSG:3857") String srs, @RequestParam(value="STYLES", required=false, defaultValue="") String styles, @RequestParam(value="BBOX", required=true, defaultValue="") String bboxString, @RequestParam(value="WIDTH", required=false, defaultValue="256") Integer width, @RequestParam(value="HEIGHT", required=false, defaultValue="256") Integer height, @RequestParam(value="REQUEST", required=false, defaultValue="GetMap") String requestString, @RequestParam(value="OUTLINE", required=false, defaultValue="true") boolean outlinePoints, @RequestParam(value="OUTLINECOLOUR", required=false, defaultValue="0x000000") String outlineColour, @RequestParam(value="LAYERS", required=false, defaultValue="") String layers, @RequestParam(value="HQ", required=false) String[] hqs, @RequestParam(value="GRIDDETAIL", required=false, defaultValue="16") Integer gridDivisionCount, HttpServletRequest request, HttpServletResponse response) throws Exception {
        SpatialSearchRequestDTO requestParams = SpatialSearchRequestDTO.create((SpatialSearchRequestParams)params);
        if (StringUtils.trimToNull((String)cql_filter) != null) {
            requestParams.setQ(WMSUtils.getQ((String)cql_filter));
        } else if (StringUtils.trimToNull((String)layers) != null && !"ALA:Occurrences".equalsIgnoreCase(layers)) {
            if (!"*:*".equals(requestParams.getQ())) {
                this.queryFormatUtils.addFqs(new String[]{requestParams.getQ()}, requestParams);
            }
            requestParams.setQ(WMSUtils.convertLayersParamToQ((String)layers));
        }
        if (env != null && env.contains("osgrid")) {
            this.wmsosGridController.generateWmsTile(requestParams, cql_filter, env, srs, styles, bboxString, layers, width, height, outlinePoints, outlineColour, request, response);
            return;
        }
        if ("GetLegendGraphic".equalsIgnoreCase(requestString)) {
            this.getLegendGraphic(env, styles, Integer.valueOf(30), Integer.valueOf(20), request, response);
            return;
        }
        if (StringUtils.isBlank((String)bboxString)) {
            this.sendWmsError(response, 400, "MissingOrInvalidParameter", "Missing valid BBOX parameter");
            return;
        }
        HashSet<Integer> hiddenFacets = new HashSet<Integer>();
        if (hqs != null && hqs.length > 0) {
            for (String h : hqs) {
                hiddenFacets.add(Integer.parseInt(h));
            }
        }
        WmsEnv vars = new WmsEnv(env, styles);
        String[] splitBBox = bboxString.split(",");
        double[] tilebbox = new double[4];
        for (int i = 0; i < 4; ++i) {
            try {
                tilebbox[i] = Double.parseDouble(splitBBox[i]);
                continue;
            }
            catch (Exception e) {
                this.sendWmsError(response, 400, "MissingOrInvalidParameter", "Missing valid BBOX parameter");
            }
        }
        double[] bbox = this.reprojectBBox(tilebbox, srs);
        boolean isGrid = vars.colourMode.equals("grid");
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("vars.colourMode = " + vars.colourMode));
        }
        float pointWidth = vars.size * 2;
        this.queryFormatUtils.formatSearchQuery(requestParams, true);
        List legend = this.searchDAO.getColours(requestParams, vars.colourMode);
        double bWidth = (bbox[2] - bbox[0]) / (double)width.intValue() * (double)(Math.max((float)this.wmsMaxPointWidth.intValue(), pointWidth) + (float)this.additionalBuffer);
        double bHeight = (bbox[3] - bbox[1]) / (double)height.intValue() * (double)(Math.max((float)this.wmsMaxPointWidth.intValue(), pointWidth) + (float)this.additionalBuffer);
        HeatmapDTO heatmapDTO = this.searchDAO.getHeatMap(requestParams.getFormattedQuery(), requestParams.getFormattedFq(), Double.valueOf(bbox[0] - bWidth), Double.valueOf(bbox[1] - bHeight), Double.valueOf(bbox[2] + bWidth), Double.valueOf(bbox[3] + bHeight), legend, isGrid ? (int)Math.ceil((double)width.intValue() / (double)gridDivisionCount.intValue()) : 1);
        heatmapDTO.setTileExtents(bbox);
        if (hiddenFacets != null) {
            for (Integer hf : hiddenFacets) {
                if (hf >= heatmapDTO.layers.size()) continue;
                heatmapDTO.layers.set(hf, null);
            }
        }
        if (heatmapDTO.layers == null) {
            this.displayBlankImage(response);
            return;
        }
        HeatmapDTO circlesHeatmap = this.getCirclesHeatmap(vars, bbox, requestParams, width.intValue(), height.intValue(), pointWidth);
        CRSAuthorityFactory factory = CRS.getAuthorityFactory((boolean)true);
        CoordinateReferenceSystem sourceCRS = factory.createCoordinateReferenceSystem(srs);
        CoordinateReferenceSystem targetCRS = factory.createCoordinateReferenceSystem("EPSG:4326");
        CoordinateOperation transformFrom4326 = new DefaultCoordinateOperationFactory().createOperation(targetCRS, sourceCRS);
        ImgObj tile = this.renderHeatmap(heatmapDTO, vars, (float)((int)pointWidth), outlinePoints, outlineColour, width.intValue(), height.intValue(), transformFrom4326, tilebbox, circlesHeatmap);
        if (tile != null && tile.g != null) {
            tile.g.dispose();
            try (ServletOutputStream outStream = response.getOutputStream();){
                response.setContentType("image/png");
                ImageIO.write((RenderedImage)tile.img, "png", (OutputStream)outStream);
                outStream.flush();
            }
            catch (Exception e) {
                logger.debug((Object)"Unable to write image", (Throwable)e);
            }
        } else {
            this.displayBlankImage(response);
        }
    }

    private HeatmapDTO getCirclesHeatmap(WmsEnv vars, double[] bbox, SpatialSearchRequestDTO requestParams, int width, int height, float pointWidth) throws Exception {
        boolean isGrid = vars.colourMode.equals("grid");
        ArrayList<LegendItem> circlesLegend = new ArrayList<LegendItem>();
        Double lastDistance = 0.0;
        if (!isGrid && vars.uncertainty) {
            double widthInDecimalDegrees = bbox[2] - bbox[0];
            double[] dArray = this.getUncertaintyGrouping();
            int n = dArray.length;
            for (int i = 0; i < n; ++i) {
                Double d = dArray[i];
                if (widthInDecimalDegrees / (double)width * (double)pointWidth * 1.5 < d / 100000.0 && widthInDecimalDegrees > d / 100000.0) {
                    LegendItem li;
                    if (lastDistance == null) {
                        li = new LegendItem(null, null, null, 0L, "coordinateUncertaintyInMeters:[* TO " + d + "]");
                        li.setColour(0xFFAA00);
                    } else if (lastDistance == this.getUncertaintyGrouping()[this.getUncertaintyGrouping().length - 2]) {
                        li = new LegendItem(null, null, null, (long)lastDistance.intValue(), "coordinateUncertaintyInMeters:{" + d + " TO *]");
                        li.setColour(0x32FF32);
                    } else {
                        li = new LegendItem(null, null, null, (long)lastDistance.intValue(), "coordinateUncertaintyInMeters:{" + lastDistance + " TO " + d + "]");
                        li.setColour(0xFFAA00);
                    }
                    circlesLegend.add(li);
                }
                lastDistance = d;
            }
        }
        double hWidth = 0.0;
        double hHeight = 0.0;
        if (!isGrid && vars.highlight != null) {
            LegendItem li = new LegendItem(null, null, null, 0L, vars.highlight);
            li.setColour(0xFF0000);
            circlesLegend.add(li);
            hWidth = (bbox[2] - bbox[0]) / (double)width * (double)(Math.max((float)this.wmsMaxPointWidth.intValue(), pointWidth) + (float)this.additionalBuffer + (float)this.HIGHLIGHT_RADIUS);
            hHeight = (bbox[3] - bbox[1]) / (double)height * (double)(Math.max((float)this.wmsMaxPointWidth.intValue(), pointWidth) + (float)this.additionalBuffer + (float)this.HIGHLIGHT_RADIUS);
        }
        if (circlesLegend.size() > 0) {
            double buffer = lastDistance / 100000.0 * 1.01;
            double bufferWidth = Math.max(buffer, hWidth);
            double bufferHeight = Math.max(buffer, hHeight);
            HeatmapDTO circlesHeatmap = this.searchDAO.getHeatMap(requestParams.getFormattedQuery(), requestParams.getFormattedFq(), Double.valueOf(bbox[0] - bufferWidth), Double.valueOf(bbox[1] - bufferHeight), Double.valueOf(bbox[2] + bufferWidth), Double.valueOf(bbox[3] + bufferHeight), circlesLegend, 1);
            circlesHeatmap.setTileExtents(bbox);
            return circlesHeatmap;
        }
        return null;
    }

    private double[] reprojectBBox(double[] tilebbox, String srs) throws Exception {
        CRSAuthorityFactory factory = CRS.getAuthorityFactory((boolean)true);
        CoordinateReferenceSystem sourceCRS = factory.createCoordinateReferenceSystem(srs);
        CoordinateReferenceSystem targetCRS = factory.createCoordinateReferenceSystem("EPSG:4326");
        CoordinateOperation transformTo4326 = new DefaultCoordinateOperationFactory().createOperation(sourceCRS, targetCRS);
        GeneralDirectPosition directPositionSW = new GeneralDirectPosition(tilebbox[0], tilebbox[1]);
        GeneralDirectPosition directPositionNE = new GeneralDirectPosition(tilebbox[2], tilebbox[3]);
        DirectPosition sw4326 = transformTo4326.getMathTransform().transform((DirectPosition)directPositionSW, null);
        DirectPosition ne4326 = transformTo4326.getMathTransform().transform((DirectPosition)directPositionNE, null);
        double[] bbox = new double[]{sw4326.getCoordinate()[0], sw4326.getCoordinate()[1], ne4326.getCoordinate()[0], ne4326.getCoordinate()[1]};
        return bbox;
    }

    private ModelAndView sendWmsError(HttpServletResponse response, int status, String errorType, String errorDescription) {
        response.setStatus(status);
        HashMap<String, String> model = new HashMap<String, String>();
        model.put("errorType", errorType);
        model.put("errorDescription", errorDescription);
        return new ModelAndView("wms/error", model);
    }

    private void transformBBox(CoordinateOperation op, String bbox, double[] source, double[] target) throws TransformException {
        String[] bb = bbox.split(",");
        source[0] = Double.parseDouble(bb[0]);
        source[1] = Double.parseDouble(bb[1]);
        source[2] = Double.parseDouble(bb[2]);
        source[3] = Double.parseDouble(bb[3]);
        GeneralDirectPosition sw = new GeneralDirectPosition(source[0], source[1]);
        GeneralDirectPosition ne = new GeneralDirectPosition(source[2], source[3]);
        GeneralDirectPosition se = new GeneralDirectPosition(source[2], source[1]);
        GeneralDirectPosition nw = new GeneralDirectPosition(source[0], source[3]);
        DirectPosition targetSW = op.getMathTransform().transform((DirectPosition)sw, null);
        DirectPosition targetNE = op.getMathTransform().transform((DirectPosition)ne, null);
        DirectPosition targetSE = op.getMathTransform().transform((DirectPosition)se, null);
        DirectPosition targetNW = op.getMathTransform().transform((DirectPosition)nw, null);
        target[0] = Math.min(Math.min(Math.min(targetSW.getOrdinate(0), targetNE.getOrdinate(0)), targetSE.getOrdinate(0)), targetNW.getOrdinate(0));
        target[1] = Math.min(Math.min(Math.min(targetSW.getOrdinate(1), targetNE.getOrdinate(1)), targetSE.getOrdinate(1)), targetNW.getOrdinate(1));
        target[2] = Math.max(Math.max(Math.max(targetSW.getOrdinate(0), targetNE.getOrdinate(0)), targetSE.getOrdinate(0)), targetNW.getOrdinate(0));
        target[3] = Math.max(Math.max(Math.max(targetSW.getOrdinate(1), targetNE.getOrdinate(1)), targetSE.getOrdinate(1)), targetNW.getOrdinate(1));
    }

    @Operation(summary="Produces a downloadable map", tags={"Mapping"})
    @RequestMapping(value={"/mapping/wms/image"}, method={RequestMethod.GET}, produces={"image/png"})
    public void generatePublicationMap(@ParameterObject SpatialSearchRequestParams params, @RequestParam(value="format", required=false, defaultValue="jpg") String format, @RequestParam(value="extents", required=false) String extents, @RequestParam(value="bbox", required=false) String bboxString, @RequestParam(value="widthmm", required=false, defaultValue="60") Double widthMm, @RequestParam(value="pradiusmm", required=false, defaultValue="2") Double pointRadiusMm, @RequestParam(value="pradiuspx", required=false) Integer pradiusPx, @RequestParam(value="pcolour", required=false, defaultValue="FF0000") String pointColour, @RequestParam(value="ENV", required=false, defaultValue="") String env, @RequestParam(value="SRS", required=false, defaultValue="EPSG:3857") String srs, @RequestParam(value="popacity", required=false, defaultValue="0.8") Double pointOpacity, @RequestParam(value="baselayer", required=false, defaultValue="world") String baselayer, @RequestParam(value="scale", required=false, defaultValue="off") String scale, @RequestParam(value="dpi", required=false, defaultValue="300") Integer dpi, @RequestParam(value="baselayerStyle", required=false, defaultValue="") String baselayerStyle, @RequestParam(value="outline", defaultValue="false") boolean outlinePoints, @RequestParam(value="outlineColour", defaultValue="#000000") String outlineColour, @RequestParam(value="fileName", required=false) String fileName, @RequestParam(value="baseMap", required=false, defaultValue="ALA") String baseMap, HttpServletRequest request, HttpServletResponse response) throws Exception {
        if (Strings.isNullOrEmpty((String)request.getQueryString())) {
            response.sendError(400, "No parameters supplied for this request");
            return;
        }
        CRSAuthorityFactory factory = CRS.getAuthorityFactory((boolean)true);
        CoordinateReferenceSystem sourceCRS = factory.createCoordinateReferenceSystem(srs);
        CoordinateReferenceSystem targetCRS = factory.createCoordinateReferenceSystem("EPSG:4326");
        CoordinateOperation transformTo4326 = new DefaultCoordinateOperationFactory().createOperation(sourceCRS, targetCRS);
        CoordinateOperation transformFrom4326 = new DefaultCoordinateOperationFactory().createOperation(targetCRS, sourceCRS);
        double[] bbox4326 = new double[4];
        double[] bboxSRS = new double[4];
        if (bboxString != null) {
            this.transformBBox(transformTo4326, (String)bboxString, bboxSRS, bbox4326);
        } else {
            this.transformBBox(transformFrom4326, extents, bbox4326, bboxSRS);
            bboxString = bboxSRS[0] + "," + bboxSRS[1] + "," + bboxSRS[2] + "," + bboxSRS[3];
        }
        int width = (int)((double)dpi.intValue() / 25.4 * widthMm);
        int height = (int)Math.round((double)width * ((bboxSRS[3] - bboxSRS[1]) / (bboxSRS[2] - bboxSRS[0])));
        if (height * width > this.MAX_IMAGE_PIXEL_COUNT) {
            String errorMessage = "Image size in pixels " + width + "x" + height + " exceeds " + this.MAX_IMAGE_PIXEL_COUNT + " pixels.  Make the image smaller";
            response.sendError(406, errorMessage);
            throw new Exception(errorMessage);
        }
        int pointSize = -1;
        pointSize = pradiusPx != null ? pradiusPx : (int)((double)dpi.intValue() / 25.4 * pointRadiusMm);
        String rendering = "ENV=color%3A" + pointColour + "%3Bname%3Acircle%3Bsize%3A" + pointSize + "%3Bopacity%3A" + pointOpacity;
        if (StringUtils.isNotEmpty((String)env)) {
            rendering = "ENV=" + env;
        }
        String speciesAddress = this.baseWsUrl + "/ogc/wms/reflect?" + rendering + "&SRS=" + srs + "&BBOX=" + (String)bboxString + "&WIDTH=" + width + "&HEIGHT=" + height + "&OUTLINE=" + outlinePoints + "&OUTLINECOLOUR=" + outlineColour;
        SpatialSearchRequestDTO dto = SpatialSearchRequestDTO.create((SpatialSearchRequestParams)params);
        String serialisedQueryParameters = dto.getEncodedParams();
        if (!serialisedQueryParameters.isEmpty()) {
            speciesAddress = speciesAddress + "&";
        }
        speciesAddress = speciesAddress + serialisedQueryParameters;
        URL speciesURL = new URL(speciesAddress);
        BufferedImage speciesImage = ImageIO.read(speciesURL);
        Object layout = "";
        if (!scale.equals("off")) {
            layout = (String)layout + "layout:scale";
        }
        String basemapAddress = this.geoserverUrl + "/wms/reflect?LAYERS=ALA%3A" + baselayer + "&SERVICE=WMS&VERSION=1.1.1&REQUEST=GetMap&STYLES=" + baselayerStyle + "&FORMAT=image%2Fpng&SRS=" + srs + "&BBOX=" + (String)bboxString + "&WIDTH=" + width + "&HEIGHT=" + height + "&OUTLINE=" + outlinePoints + "&format_options=dpi:" + dpi + ";" + (String)layout;
        BufferedImage basemapImage = "roadmap".equalsIgnoreCase(baseMap) || "satellite".equalsIgnoreCase(baseMap) || "hybrid".equalsIgnoreCase(baseMap) || "terrain".equalsIgnoreCase(baseMap) ? this.basemapGoogle(width, height, bboxSRS, baseMap) : ImageIO.read(new URL(basemapAddress));
        BufferedImage img = new BufferedImage(width, height, 2);
        Graphics2D combined = (Graphics2D)img.getGraphics();
        combined.drawImage(basemapImage, 0, 0, Color.WHITE, null);
        combined.setComposite(AlphaComposite.getInstance(3, 1.0f));
        combined.drawImage(speciesImage, null, 0, 0);
        combined.dispose();
        if (fileName != null) {
            response.setContentType("application/octet-stream;charset=UTF-8");
            response.setHeader("Content-Description", "File Transfer");
            response.setHeader("Content-Disposition", "attachment; filename=" + fileName);
            response.setHeader("Content-Transfer-Encoding", "binary");
        } else if (format.equalsIgnoreCase("png")) {
            response.setContentType("image/png");
        } else {
            response.setContentType("image/jpeg");
        }
        response.setHeader("Cache-Control", this.wmsCacheControlHeaderPublicOrPrivate + ", max-age=" + this.wmsCacheControlHeaderMaxAge);
        response.setHeader("ETag", (String)this.wmsETag.get());
        try {
            if (format.equalsIgnoreCase("png")) {
                ServletOutputStream os = response.getOutputStream();
                ImageIO.write((RenderedImage)img, format, (OutputStream)os);
                os.close();
            } else {
                BufferedImage img2 = new BufferedImage(width, height, 1);
                Graphics2D c2 = (Graphics2D)img2.getGraphics();
                c2.drawImage(img, 0, 0, Color.WHITE, null);
                c2.dispose();
                ServletOutputStream os = response.getOutputStream();
                ImageIO.write((RenderedImage)img2, format, (OutputStream)os);
                os.close();
            }
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    @Deprecated
    @Operation(summary="Produces a downloadable map - Deprecated use /mapping/wms/image", tags={"Deprecated"})
    @RequestMapping(value={"/webportal/wms/image"}, method={RequestMethod.GET}, produces={"image/png"})
    public void generatePublicationMapDeprecated(@ParameterObject SpatialSearchRequestParams params, @RequestParam(value="format", required=false, defaultValue="jpg") String format, @RequestParam(value="extents", required=false) String extents, @RequestParam(value="bbox", required=false) String bboxString, @RequestParam(value="widthmm", required=false, defaultValue="60") Double widthMm, @RequestParam(value="pradiusmm", required=false, defaultValue="2") Double pointRadiusMm, @RequestParam(value="pradiuspx", required=false) Integer pradiusPx, @RequestParam(value="pcolour", required=false, defaultValue="FF0000") String pointColour, @RequestParam(value="ENV", required=false, defaultValue="") String env, @RequestParam(value="SRS", required=false, defaultValue="EPSG:3857") String srs, @RequestParam(value="popacity", required=false, defaultValue="0.8") Double pointOpacity, @RequestParam(value="baselayer", required=false, defaultValue="world") String baselayer, @RequestParam(value="scale", required=false, defaultValue="off") String scale, @RequestParam(value="dpi", required=false, defaultValue="300") Integer dpi, @RequestParam(value="baselayerStyle", required=false, defaultValue="") String baselayerStyle, @RequestParam(value="outline", defaultValue="false") boolean outlinePoints, @RequestParam(value="outlineColour", defaultValue="#000000") String outlineColour, @RequestParam(value="fileName", required=false) String fileName, @RequestParam(value="baseMap", required=false, defaultValue="ALA") String baseMap, HttpServletRequest request, HttpServletResponse response) throws Exception {
        this.generatePublicationMap(params, format, extents, bboxString, widthMm, pointRadiusMm, pradiusPx, pointColour, env, srs, pointOpacity, baselayer, scale, dpi, baselayerStyle, outlinePoints, outlineColour, fileName, baseMap, request, response);
    }

    private BufferedImage basemapGoogle(int width, int height, double[] extents, String maptype) throws Exception {
        int res;
        double[] resolutions = new double[]{156543.03390625, 78271.516953125, 39135.7584765625, 19567.87923828125, 9783.939619140625, 4891.9698095703125, 2445.9849047851562, 1222.9924523925781, 611.4962261962891, 305.74811309814453, 152.87405654907226, 76.43702827453613, 38.218514137268066, 19.109257068634033, 9.554628534317017, 4.777314267158508, 2.388657133579254, 1.194328566789627, 0.5971642833948135};
        int imgSize = 640;
        int gScale = 2;
        double actualWidth = extents[2] - extents[0];
        double actualHeight = extents[3] - extents[1];
        for (res = 0; res < resolutions.length - 1 && resolutions[res + 1] * (double)imgSize > actualWidth && resolutions[res + 1] * (double)imgSize > actualHeight; ++res) {
        }
        int centerX = (int)((extents[2] - extents[0]) / 2.0 + extents[0]);
        int centerY = (int)((extents[3] - extents[1]) / 2.0 + extents[1]);
        double latitude = this.convertMetersToLat((double)centerY);
        double longitude = this.convertMetersToLng((double)centerX);
        int imgWidth = (int)((extents[2] - extents[0]) / resolutions[res]);
        int imgHeight = (int)((extents[3] - extents[1]) / resolutions[res]);
        String uri = "http://maps.googleapis.com/maps/api/staticmap?";
        String parameters = "center=" + latitude + "," + longitude + "&zoom=" + res + "&scale=" + gScale + "&size=" + imgWidth + "x" + imgHeight + "&maptype=" + maptype;
        BufferedImage img = ImageIO.read(new URL(uri + parameters));
        BufferedImage tmp = new BufferedImage(width, height, 2);
        tmp.getGraphics().drawImage(img, 0, 0, width, height, 0, 0, imgWidth * gScale, imgHeight * gScale, null);
        return tmp;
    }

    private ImgObj renderHeatmap(HeatmapDTO heatmapDTO, WmsEnv vars, float pointWidth, boolean outlinePoints, String outlineColour, int tileWidthInPx, int tileHeightInPx, CoordinateOperation transformFrom4326, double[] tilebbox, HeatmapDTO cirlesHeatmap) {
        List layers = heatmapDTO.layers;
        if (layers.isEmpty()) {
            return null;
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Image width:" + tileWidthInPx + ", height:" + tileHeightInPx));
        }
        ImgObj imgObj = ImgObj.create((int)tileWidthInPx, (int)tileHeightInPx);
        int layerIdx = 0;
        for (List rows : layers) {
            if (heatmapDTO.legend != null && heatmapDTO.legend.get(layerIdx) != null && ((LegendItem)heatmapDTO.legend.get(layerIdx)).isRemainder()) {
                this.renderLayer(heatmapDTO, vars, pointWidth, outlinePoints, outlineColour, true, (float)tileWidthInPx, (float)tileHeightInPx, imgObj, layerIdx, rows, transformFrom4326, tilebbox);
            }
            ++layerIdx;
        }
        layerIdx = 0;
        for (List rows : layers) {
            if (heatmapDTO.legend == null || heatmapDTO.legend.get(layerIdx) == null || !((LegendItem)heatmapDTO.legend.get(layerIdx)).isRemainder()) {
                this.renderLayer(heatmapDTO, vars, pointWidth, outlinePoints, outlineColour, true, (float)tileWidthInPx, (float)tileHeightInPx, imgObj, layerIdx, rows, transformFrom4326, tilebbox);
            }
            ++layerIdx;
        }
        if (cirlesHeatmap != null && cirlesHeatmap.layers != null) {
            layerIdx = 0;
            try {
                for (List rows : cirlesHeatmap.layers) {
                    if (rows != null) {
                        double dist = ((LegendItem)cirlesHeatmap.legend.get(layerIdx)).getCount();
                        int circleWidthInPixels = (int)pointWidth + this.HIGHLIGHT_RADIUS;
                        if (dist > 0.0) {
                            GeneralDirectPosition coord1 = new GeneralDirectPosition(dist / 100000.0, 0.0);
                            GeneralDirectPosition coord2 = new GeneralDirectPosition(0.0, 0.0);
                            DirectPosition pos1 = transformFrom4326.getMathTransform().transform((DirectPosition)coord1, null);
                            DirectPosition pos2 = transformFrom4326.getMathTransform().transform((DirectPosition)coord2, null);
                            int px1 = this.scaleLongitudeForImage(pos1.getOrdinate(0), tilebbox[0], tilebbox[2], tileWidthInPx);
                            int px2 = this.scaleLatitudeForImage(pos2.getOrdinate(0), tilebbox[0], tilebbox[2], tileWidthInPx);
                            circleWidthInPixels = Math.abs(px1 - px2);
                        }
                        String colour = String.format("0x%06X", ((LegendItem)cirlesHeatmap.legend.get(layerIdx)).getColour());
                        this.renderLayer(cirlesHeatmap, vars, (float)circleWidthInPixels, true, colour, false, (float)tileWidthInPx, (float)tileHeightInPx, imgObj, layerIdx, rows, transformFrom4326, tilebbox);
                    }
                    ++layerIdx;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return imgObj;
    }

    private void renderLayer(HeatmapDTO heatmapDTO, WmsEnv vars, float pointWidth, boolean outlinePoints, String outlineColour, boolean drawPointFill, float tileWidthInPx, float tileHeightInPx, ImgObj imgObj, int layerIdx, List<List<Integer>> rows, CoordinateOperation transformFrom4326, double[] tilebbox) {
        if (rows != null && !rows.isEmpty()) {
            int numberOfRows = rows.size();
            double cellWidth = heatmapDTO.columnWidth();
            double cellHeight = heatmapDTO.rowHeight();
            Color oColour = Color.decode(outlineColour);
            Color currentFill = null;
            if (heatmapDTO.legend == null || heatmapDTO.legend.isEmpty()) {
                currentFill = new Color(vars.colour);
                imgObj.g.setPaint(currentFill);
            }
            int rowStep = 1;
            int columnStep = 1;
            if (heatmapDTO.gridSizeInPixels > 1) {
                while ((double)tileWidthInPx / (double)heatmapDTO.gridSizeInPixels < (double)(heatmapDTO.columns / columnStep)) {
                    ++columnStep;
                }
                while ((double)tileHeightInPx / (double)heatmapDTO.gridSizeInPixels < (double)(heatmapDTO.rows / rowStep)) {
                    ++rowStep;
                }
            }
            for (int row = 0; row < numberOfRows; row += rowStep) {
                double lat = heatmapDTO.maxy - cellHeight * ((double)row + 0.5);
                List<Integer> columns = rows.get(row);
                if (columns == null) continue;
                for (int column = 0; column < columns.size(); column += columnStep) {
                    Integer cellValue = columns.get(column);
                    if (rowStep > 1 || columnStep > 1) {
                        cellValue = 0;
                        for (int r = 0; r < rowStep && row + r < rows.size(); ++r) {
                            List<Integer> rw = rows.get(row + r);
                            for (int c = 0; rw != null && c < columnStep && column + c < rw.size(); ++c) {
                                cellValue = cellValue + rw.get(column + c);
                            }
                        }
                    }
                    if (cellValue <= 0) continue;
                    try {
                        if (heatmapDTO.gridSizeInPixels > 1) {
                            double minLat = heatmapDTO.maxy - cellHeight * (double)(row + rowStep);
                            double maxLat = heatmapDTO.maxy - cellHeight * (double)row;
                            double minLng = heatmapDTO.minx + cellWidth * (double)column;
                            double maxLng = heatmapDTO.minx + cellWidth * (double)(column + columnStep);
                            if (heatmapDTO.minx > heatmapDTO.tileMaxx) {
                                maxLng -= 360.0;
                                minLng -= 360.0;
                            }
                            GeneralDirectPosition sourceCoordsBottomLeft = new GeneralDirectPosition(minLng, minLat);
                            GeneralDirectPosition sourceCoordsTopRight = new GeneralDirectPosition(maxLng, maxLat);
                            DirectPosition targetCoordsBottomLeft = transformFrom4326.getMathTransform().transform((DirectPosition)sourceCoordsBottomLeft, null);
                            DirectPosition targetCoordsTopRight = transformFrom4326.getMathTransform().transform((DirectPosition)sourceCoordsTopRight, null);
                            int px1 = this.scaleLongitudeForImage(targetCoordsBottomLeft.getOrdinate(0), tilebbox[0], tilebbox[2], (int)tileWidthInPx);
                            int py1 = this.scaleLatitudeForImage(targetCoordsBottomLeft.getOrdinate(1), tilebbox[3], tilebbox[1], (int)tileHeightInPx);
                            int px2 = this.scaleLongitudeForImage(targetCoordsTopRight.getOrdinate(0), tilebbox[0], tilebbox[2], (int)tileWidthInPx);
                            int py2 = this.scaleLatitudeForImage(targetCoordsTopRight.getOrdinate(1), tilebbox[3], tilebbox[1], (int)tileHeightInPx);
                            int v = cellValue;
                            if (v > 500) {
                                v = 500;
                            }
                            int colour = (500 - v) / 2 << 8 | vars.alpha << 24 | 0xFF0000;
                            if (drawPointFill) {
                                imgObj.g.setColor(new Color(colour));
                                imgObj.g.fillRect(Math.min(px1, px2), Math.min(py1, py2), Math.abs(px2 - px1), Math.abs(py2 - py1));
                            }
                            if (!outlinePoints) continue;
                            imgObj.g.setPaint(oColour);
                            imgObj.g.drawRect(Math.min(px1, px2), Math.min(py1, py2), Math.abs(px2 - px1), Math.abs(py2 - py1));
                            continue;
                        }
                        double lng = heatmapDTO.minx + cellWidth * ((double)column + 0.5);
                        if (heatmapDTO.minx > heatmapDTO.tileMaxx) {
                            lng -= 360.0;
                        }
                        GeneralDirectPosition sourceCoords = new GeneralDirectPosition(lng, lat);
                        DirectPosition targetCoords = transformFrom4326.getMathTransform().transform((DirectPosition)sourceCoords, null);
                        int px = this.scaleLongitudeForImage(targetCoords.getOrdinate(0), tilebbox[0], tilebbox[2], (int)tileWidthInPx);
                        int py = this.scaleLatitudeForImage(targetCoords.getOrdinate(1), tilebbox[3], tilebbox[1], (int)tileHeightInPx);
                        if (drawPointFill) {
                            if (heatmapDTO.legend != null && !heatmapDTO.legend.isEmpty()) {
                                currentFill = new Color(((LegendItem)heatmapDTO.legend.get(layerIdx)).getColour() | vars.alpha << 24);
                                imgObj.g.setPaint(currentFill);
                            }
                            imgObj.g.fillOval(px - (int)(pointWidth / 2.0f), py - (int)(pointWidth / 2.0f), (int)pointWidth, (int)pointWidth);
                        }
                        if (!outlinePoints) continue;
                        imgObj.g.setPaint(oColour);
                        imgObj.g.drawOval(px - (int)(pointWidth / 2.0f), py - (int)(pointWidth / 2.0f), (int)pointWidth, (int)pointWidth);
                        imgObj.g.setPaint(currentFill);
                        continue;
                    }
                    catch (MismatchedDimensionException mismatchedDimensionException) {
                        continue;
                    }
                    catch (TransformException transformException) {
                        // empty catch block
                    }
                }
            }
        }
    }

    static {
        byte[] b = null;
        try (RandomAccessFile raf = new RandomAccessFile(WMSController.class.getResource("/blank.png").getFile(), "r");){
            b = new byte[(int)raf.length()];
            raf.read(b);
        }
        catch (Exception e) {
            logger.error((Object)"Unable to open blank image file", (Throwable)e);
        }
        blankImageBytes = b;
        System.setProperty("org.geotools.referencing.forceXY", "true");
    }
}

