/*
 * Decompiled with CFR 0.152.
 */
package au.org.ala.biocache.web;

import au.org.ala.biocache.dao.IndexDAO;
import au.org.ala.biocache.dao.SearchDAO;
import au.org.ala.biocache.dto.IndexFieldDTO;
import au.org.ala.biocache.dto.SpatialSearchRequestDTO;
import au.org.ala.biocache.dto.SpatialSearchRequestParams;
import au.org.ala.biocache.stream.ProcessInterface;
import au.org.ala.biocache.stream.ScatterplotSearch;
import com.fasterxml.jackson.annotation.JsonInclude;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.awt.Color;
import java.awt.Font;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.geom.Ellipse2D;
import java.awt.image.BufferedImage;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import javax.inject.Inject;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.apache.solr.client.solrj.SolrQuery;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartRenderingInfo;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.encoders.EncoderUtil;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.XYPlot;
import org.jfree.data.xy.DefaultXYDataset;
import org.jfree.data.xy.XYDataset;
import org.jfree.ui.RectangleEdge;
import org.locationtech.jts.math.Vector2D;
import org.springdoc.api.annotations.ParameterObject;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class ScatterplotController {
    private static final Logger logger = Logger.getLogger(ScatterplotController.class);
    private static final String DEFAULT_SCATTERPLOT_TITLE = " ";
    private static final String DEFAULT_SCATTERPLOT_HEIGHT = "256";
    private static final String DEFAULT_SCATTERPLOT_WIDTH = "256";
    private static final String DEFAULT_SCATTERPLOT_POINTCOLOUR = "0000FF";
    private static final String DEFAULT_SCATTERPLOT_POINTRADIUS = "3";
    private static final List<String> VALID_DATATYPES = Arrays.asList("float", "double", "int", "long", "tfloat", "tdouble", "tint", "tlong");
    @Inject
    protected SearchDAO searchDAO;
    @Inject
    protected IndexDAO indexDao;

    @Operation(summary="Generate a scatterplot", tags={"Scatterplots"})
    @Tag(name="Scatterplots", description="Services for the generation of scatterplots for occurrence data")
    @RequestMapping(value={"/scatterplot"}, method={RequestMethod.GET}, produces={"image/png"})
    public void scatterplot(@ParameterObject SpatialSearchRequestParams params, @RequestParam(value="x", required=true) String x, @RequestParam(value="y", required=true) String y, @RequestParam(value="height", required=false, defaultValue="256") Integer height, @RequestParam(value="width", required=false, defaultValue="256") Integer width, @RequestParam(value="title", required=false, defaultValue=" ") String title, @RequestParam(value="pointcolour", required=false, defaultValue="0000FF") String pointcolour, @RequestParam(value="pointradius", required=false, defaultValue="3") Double pointradius, HttpServletResponse response) throws Exception {
        SpatialSearchRequestDTO requestParams = SpatialSearchRequestDTO.create((SpatialSearchRequestParams)params);
        JFreeChart jChart = this.makeScatterplot(requestParams, x, y, title, pointcolour, pointradius);
        ChartRenderingInfo chartRenderingInfo = new ChartRenderingInfo();
        BufferedImage bi = jChart.createBufferedImage(width.intValue(), height.intValue(), 3, chartRenderingInfo);
        byte[] bytes = EncoderUtil.encode((BufferedImage)bi, (String)"png", (boolean)true);
        response.setContentType("image/png");
        try {
            response.getOutputStream().write(bytes);
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    @Operation(summary="Get details of a point on a plot", tags={"Scatterplots"})
    @RequestMapping(value={"/scatterplot/point"}, method={RequestMethod.GET}, produces={"application/json"})
    @ResponseBody
    public Map scatterplotPointInfo(@ParameterObject SpatialSearchRequestParams params, @RequestParam(value="x", required=true) String x, @RequestParam(value="y", required=true) String y, @RequestParam(value="height", required=false, defaultValue="256") Integer height, @RequestParam(value="width", required=false, defaultValue="256") Integer width, @RequestParam(value="title", required=false, defaultValue=" ") String title, @RequestParam(value="pointx1", required=true) Integer pointx1, @RequestParam(value="pointy1", required=true) Integer pointy1, @RequestParam(value="pointx2", required=true) Integer pointx2, @RequestParam(value="pointy2", required=true) Integer pointy2) throws Exception {
        SpatialSearchRequestDTO requestParams = SpatialSearchRequestDTO.create((SpatialSearchRequestParams)params);
        JFreeChart jChart = this.makeScatterplot(requestParams, x, y, title, "000000", Double.valueOf(1.0));
        ChartRenderingInfo chartRenderingInfo = new ChartRenderingInfo();
        BufferedImage bi = jChart.createBufferedImage(width.intValue(), height.intValue(), 3, chartRenderingInfo);
        XYPlot plot = (XYPlot)jChart.getPlot();
        double tx1 = plot.getRangeAxis().java2DToValue((double)pointx1.intValue(), chartRenderingInfo.getPlotInfo().getDataArea(), RectangleEdge.BOTTOM);
        double tx2 = plot.getRangeAxis().java2DToValue((double)pointx2.intValue(), chartRenderingInfo.getPlotInfo().getDataArea(), RectangleEdge.BOTTOM);
        double ty1 = plot.getDomainAxis().java2DToValue((double)pointy1.intValue(), chartRenderingInfo.getPlotInfo().getDataArea(), RectangleEdge.LEFT);
        double ty2 = plot.getDomainAxis().java2DToValue((double)pointy2.intValue(), chartRenderingInfo.getPlotInfo().getDataArea(), RectangleEdge.LEFT);
        double x1 = Math.min(tx1, tx2);
        double x2 = Math.max(tx1, tx2);
        double y1 = Math.min(ty1, ty2);
        double y2 = Math.max(ty1, ty2);
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("xaxis_pixel_selection", new int[]{pointx1, pointx2});
        map.put("yaxis_pixel_selection", new int[]{pointy1, pointy2});
        map.put("xaxis", x);
        map.put("yaxis", y);
        map.put("xaxis_range", new double[]{x1, x2});
        map.put("yaxis_range", new double[]{y1, y2});
        return map;
    }

    @Deprecated
    @Operation(summary="Get details of a point on a plot", tags={"Deprecated"})
    @RequestMapping(value={"/scatterplot/point.json"}, method={RequestMethod.GET}, produces={"application/json"})
    @ResponseBody
    public Map scatterplotPointInfoDeprecated(@ParameterObject SpatialSearchRequestParams params, @RequestParam(value="x", required=true) String x, @RequestParam(value="y", required=true) String y, @RequestParam(value="height", required=false, defaultValue="256") Integer height, @RequestParam(value="width", required=false, defaultValue="256") Integer width, @RequestParam(value="title", required=false, defaultValue=" ") String title, @RequestParam(value="pointx1", required=true) Integer pointx1, @RequestParam(value="pointy1", required=true) Integer pointy1, @RequestParam(value="pointx2", required=true) Integer pointx2, @RequestParam(value="pointy2", required=true) Integer pointy2) throws Exception {
        return this.scatterplotPointInfo(params, x, y, height, width, title, pointx1, pointy1, pointx2, pointy2);
    }

    private JFreeChart makeScatterplot(SpatialSearchRequestDTO requestParams, String x, String y, String title, String pointcolour, Double pointradius) throws Exception {
        String displayNameX = null;
        String displayNameY = null;
        Set indexedFields = this.indexDao.getIndexedFields();
        displayNameX = this.getFieldDescription(x, indexedFields);
        displayNameY = this.getFieldDescription(y, indexedFields);
        requestParams.setFlimit(Integer.valueOf(-1));
        SolrQuery query = this.searchDAO.initSolrQuery(requestParams, false, null);
        query.set("facet.field", new String[]{x + "," + y});
        query.setFacetSort(x + " asc," + y + " asc");
        HashSet vectors = new HashSet();
        AtomicInteger count = new AtomicInteger();
        ScatterplotSearch proc = new ScatterplotSearch(vectors, x, y, count);
        try {
            this.indexDao.streamingQuery(query, null, (ProcessInterface)proc, null);
        }
        catch (Exception e) {
            logger.error((Object)"scatterplot failed", (Throwable)e);
        }
        if (count.get() == 0) {
            throw new Exception("No valid records found for these input parameters");
        }
        double[][] data = new double[2][vectors.size()];
        int i = 0;
        for (Vector2D v : vectors) {
            data[0][i] = v.getX();
            data[1][i] = v.getY();
            ++i;
        }
        DefaultXYDataset xyDataset = new DefaultXYDataset();
        xyDataset.addSeries((Comparable)((Object)"series"), data);
        JFreeChart jChart = ChartFactory.createScatterPlot((String)(title.equals(DEFAULT_SCATTERPLOT_TITLE) ? requestParams.getDisplayString() : title), (String)displayNameX, (String)displayNameY, (XYDataset)xyDataset, (PlotOrientation)PlotOrientation.HORIZONTAL, (boolean)false, (boolean)false, (boolean)false);
        jChart.setBackgroundPaint((Paint)Color.white);
        XYPlot plot = (XYPlot)jChart.getPlot();
        Font axisfont = new Font("Arial", 0, 10);
        Font titlefont = new Font("Arial", 1, 11);
        plot.getDomainAxis().setLabelFont(axisfont);
        plot.getDomainAxis().setTickLabelFont(axisfont);
        plot.getRangeAxis().setLabelFont(axisfont);
        plot.getRangeAxis().setTickLabelFont(axisfont);
        plot.setBackgroundPaint((Paint)new Color(220, 220, 220));
        jChart.getTitle().setFont(titlefont);
        Color c = new Color(Integer.parseInt(pointcolour, 16));
        plot.getRenderer().setSeriesPaint(0, (Paint)c);
        plot.getRenderer().setSeriesShape(0, (Shape)new Ellipse2D.Double(-pointradius.doubleValue(), -pointradius.doubleValue(), pointradius * 2.0, pointradius * 2.0));
        return jChart;
    }

    public String getFieldDescription(String fieldName, Set<IndexFieldDTO> indexedFields) throws Exception {
        for (IndexFieldDTO field : indexedFields) {
            if (!field.getName().equals(fieldName)) continue;
            if (!VALID_DATATYPES.contains(field.getDataType())) {
                throw new Exception("'" + fieldName + "' with data type '" + field.getDataType() + "' is not a valid data type (" + StringUtils.join((Iterable)VALID_DATATYPES, (String)", ") + ")");
            }
            if (!field.isStored() && !field.isDocvalue()) {
                throw new Exception("Cannot use '" + fieldName + "'.  It is not a stored or docvalue field.");
            }
            return field.getDescription();
        }
        throw new Exception("'" + fieldName + "'is not a vaild field.");
    }
}

