/*
 * Decompiled with CFR 0.152.
 */
package au.org.ala.biocache.web;

import au.org.ala.biocache.dao.SearchDAO;
import au.org.ala.biocache.dto.OccurrencePoint;
import au.org.ala.biocache.dto.PointType;
import au.org.ala.biocache.dto.SpatialSearchRequestDTO;
import au.org.ala.biocache.dto.SpatialSearchRequestParams;
import au.org.ala.biocache.heatmap.HeatMap;
import au.org.ala.biocache.util.ColorUtil;
import au.org.ala.biocache.util.QueryFormatUtils;
import au.org.ala.biocache.web.WMSController;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.google.common.base.Strings;
import io.swagger.v3.oas.annotations.Operation;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.UnsupportedEncodingException;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicReference;
import javax.imageio.ImageIO;
import javax.inject.Inject;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.log4j.Logger;
import org.apache.solr.common.SolrDocumentList;
import org.springdoc.api.annotations.ParameterObject;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller(value="mapController")
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class MapController {
    private static final Logger logger = Logger.getLogger(MapController.class);
    @Value(value="${heatmap.output.dir:/data/output/heatmap}")
    protected String heatmapOutputDir;
    @Inject
    protected SearchDAO searchDAO;
    @Inject
    protected QueryFormatUtils queryFormatUtils;
    @Value(value="${heatmap.legend.occurrence.label:occurrence}")
    protected String heatmapLegendOccurrenceLabel;
    @Value(value="${heatmap.legend.cache.cachecontrol.publicorprivate:public}")
    private String mapCacheControlHeaderPublicOrPrivate;
    @Value(value="${heatmap.legend.cache.cachecontrol.maxage:86400}")
    private String mapCacheControlHeaderMaxAge;
    private final AtomicReference<String> mapETag = new AtomicReference<String>(UUID.randomUUID().toString());
    @Inject
    protected WMSController wmsController;

    @Deprecated
    @Operation(summary="Deprecated path.", tags={"Deprecated"})
    @RequestMapping(value={"/occurrences/wms"}, method={RequestMethod.GET})
    public void pointsWmsImage(@ParameterObject SpatialSearchRequestParams requestParams, @RequestParam(value="colourby", required=false, defaultValue="0") Integer colourby, @RequestParam(value="width", required=false, defaultValue="256") Integer width, @RequestParam(value="height", required=false, defaultValue="256") Integer height, @RequestParam(value="zoom", required=false, defaultValue="0") Integer zoomLevel, @RequestParam(value="symsize", required=false, defaultValue="4") Integer size, @RequestParam(value="symbol", required=false, defaultValue="circle") String symbol, @RequestParam(value="bbox", required=false, defaultValue="110,-45,157,-9") String bboxString, @RequestParam(value="type", required=false, defaultValue="normal") String type, @RequestParam(value="outline", required=false, defaultValue="false") boolean outlinePoints, @RequestParam(value="outlineColour", required=false, defaultValue="0x000000") String outlineColour, HttpServletRequest request, HttpServletResponse response) throws Exception {
        Object color = Integer.toHexString(colourby);
        color = "000000".substring(((String)color).length()) + (String)color;
        String env = "color:" + (String)color + ";size:" + size + ";opacity:1.0";
        this.wmsController.generateWmsTileViaHeatmap(requestParams, "", env, "EPSG:3857", "", bboxString, width, height, "", outlinePoints, outlineColour, "", null, Integer.valueOf(16), request, response);
    }

    @Operation(summary="Occurrence info summary service for JS map popups.", tags={"Mapping"})
    @RequestMapping(value={"/occurrences/info"}, method={RequestMethod.GET}, produces={"application/json"})
    public String getOccurrencesInformation(SpatialSearchRequestDTO requestParams, @RequestParam(value="callback", required=false) String callback, Model model, HttpServletResponse response) throws Exception {
        if (requestParams.getLon() == null) {
            response.sendError(400, "Required Double parameter 'lon' is not present");
        }
        if (requestParams.getLat() == null) {
            response.sendError(400, "Required Double parameter 'lat' is not present");
        }
        if (requestParams.getRadius() == null) {
            response.sendError(400, "Required Double parameter 'radius' is not present");
        }
        requestParams.setFl("id");
        requestParams.setPageSize(Integer.valueOf(100));
        response.setHeader("Cache-Control", this.mapCacheControlHeaderPublicOrPrivate + ", max-age=" + this.mapCacheControlHeaderMaxAge);
        response.setHeader("ETag", (String)this.mapETag.get());
        if (callback != null && !callback.isEmpty()) {
            response.setContentType("text/javascript");
        } else {
            response.setContentType("application/json");
        }
        SolrDocumentList sdl = this.searchDAO.findByFulltext(requestParams);
        ArrayList points = new ArrayList();
        if (sdl != null) {
            sdl.stream().forEach(sd -> {
                OccurrencePoint point = new OccurrencePoint();
                point.setOccurrenceUid((String)sd.getFirstValue("id"));
                points.add(point);
            });
        }
        model.addAttribute("points", points);
        model.addAttribute("count", (Object)points.size());
        return "json/infoPointGeojson";
    }

    @Deprecated
    @Operation(summary="Point legend service", tags={"Deprecated"})
    @RequestMapping(value={"/occurrences/legend"}, method={RequestMethod.GET})
    public void pointLegendImage(@RequestParam(value="colourby", required=false, defaultValue="0") Integer colourby, @RequestParam(value="width", required=false, defaultValue="50") Integer width, @RequestParam(value="height", required=false, defaultValue="50") Integer height, HttpServletResponse response) {
        try {
            BufferedImage img = new BufferedImage(width, height, 2);
            Graphics2D g = (Graphics2D)img.getGraphics();
            int colour = 0xFF000000 | colourby;
            Color c = new Color(colour);
            g.setPaint(c);
            g.fillOval(0, 0, width, width);
            g.dispose();
            this.streamImage(img, response);
        }
        catch (Exception e) {
            logger.error((Object)"Unable to write image", (Throwable)e);
        }
    }

    private void streamImage(BufferedImage img, HttpServletResponse response) throws Exception {
        response.setHeader("Cache-Control", this.mapCacheControlHeaderPublicOrPrivate + ", max-age=" + this.mapCacheControlHeaderMaxAge);
        response.setHeader("ETag", (String)this.mapETag.get());
        response.setContentType("image/png");
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        ImageIO.write((RenderedImage)img, "png", outputStream);
        ServletOutputStream outStream = response.getOutputStream();
        outStream.write(outputStream.toByteArray());
        outStream.flush();
        outStream.close();
    }

    @Operation(summary="Renders a density map for a species.", tags={"Mapping"})
    @RequestMapping(value={"/density/map", "/occurrences/static"}, method={RequestMethod.GET})
    @ResponseBody
    public void speciesDensityMap(SpatialSearchRequestDTO requestParams, @RequestParam(value="forceRefresh", required=false, defaultValue="false") boolean forceRefresh, @RequestParam(value="forcePointsDisplay", required=false, defaultValue="false") boolean forcePointsDisplay, @RequestParam(value="pointColour", required=false, defaultValue="0000ff") String pointColour, @RequestParam(value="colourByFq", required=false, defaultValue="") String colourByFqCSV, @RequestParam(value="colours", required=false, defaultValue="") String coloursCSV, @RequestParam(value="pointHeatMapThreshold", required=false, defaultValue="500") Integer pointHeatMapThreshold, @RequestParam(value="opacity", required=false, defaultValue="1.0") Float opacity, HttpServletRequest request, HttpServletResponse response) throws Exception {
        File f;
        File outputDir = new File(this.heatmapOutputDir);
        if (!outputDir.exists()) {
            FileUtils.forceMkdir((File)outputDir);
        }
        if (Strings.isNullOrEmpty((String)request.getQueryString())) {
            response.sendError(400, "   No query parameters provided");
            return;
        }
        String outputHMFile = this.getOutputFile(request);
        String[] facetValues = null;
        String[] facetColours = null;
        if (StringUtils.trimToNull((String)colourByFqCSV) != null && StringUtils.trimToNull((String)coloursCSV) != null) {
            facetValues = colourByFqCSV.split(",");
            facetColours = coloursCSV.split(",");
            if (facetValues.length == 0 || facetValues.length != facetColours.length) {
                throw new IllegalArgumentException(String.format("Mismatch in facet values and colours. Values: %d, Colours: %d", facetValues.length, facetColours.length));
            }
        }
        if (!(f = new File(outputDir + "/" + outputHMFile)).isFile() || !f.exists() || forceRefresh) {
            logger.debug((Object)"Regenerating heatmap image");
            this.generateStaticHeatmapImages(requestParams, false, forcePointsDisplay, pointHeatMapThreshold, pointColour, facetValues, facetColours, opacity, request);
        } else {
            logger.debug((Object)"Heatmap file already exists on disk, sending file back to user");
        }
        try {
            File file = new File(outputDir + "/" + outputHMFile);
            BufferedImage img = ImageIO.read(file);
            this.streamImage(img, response);
        }
        catch (Exception e) {
            logger.error((Object)"Unable to write image.", (Throwable)e);
        }
    }

    private String getQueryHash(HttpServletRequest request) throws NoSuchAlgorithmException, UnsupportedEncodingException {
        MessageDigest md = MessageDigest.getInstance("MD5");
        String qs = request.getQueryString().replaceAll("&(?i)forceRefresh=true", "").replaceAll("(?i)forceRefresh=true&", "");
        md.update(qs.getBytes(StandardCharsets.UTF_8));
        byte[] digest = md.digest();
        StringBuffer sb = new StringBuffer();
        for (byte b : digest) {
            sb.append(Integer.toHexString(b & 0xFF));
        }
        return sb.toString();
    }

    @Operation(summary="Renders a density map legend for a species.", tags={"Mapping"})
    @RequestMapping(value={"/density/legend"}, method={RequestMethod.GET})
    @ResponseBody
    public void speciesDensityLegend(SpatialSearchRequestDTO requestParams, @RequestParam(value="forceRefresh", required=false, defaultValue="false") boolean forceRefresh, @RequestParam(value="pointHeatMapThreshold", required=false, defaultValue="500") Integer pointHeatMapThreshold, HttpServletRequest request, HttpServletResponse response) throws Exception {
        File baseDir = new File(this.heatmapOutputDir);
        String outputHMFile = this.getOutputFile(request);
        File f = new File(baseDir + "/legend_" + outputHMFile);
        if (!f.isFile() || !f.exists() || forceRefresh) {
            logger.debug((Object)"regenerating heatmap legend");
            this.generateStaticHeatmapImages(requestParams, true, false, pointHeatMapThreshold, "0000ff", null, null, Float.valueOf(1.0f), request);
        } else {
            logger.debug((Object)"legend file already exists on disk, sending file back to user");
        }
        try {
            File file = new File(baseDir + "/legend_" + outputHMFile);
            if (file.exists()) {
                BufferedImage img = ImageIO.read(file);
                this.streamImage(img, response);
            }
        }
        catch (Exception e) {
            logger.error((Object)"Unable to write image.", (Throwable)e);
        }
    }

    private String getOutputFile(HttpServletRequest request) throws NoSuchAlgorithmException, UnsupportedEncodingException {
        return this.getQueryHash(request) + "_hm.png";
    }

    public void generateStaticHeatmapImages(SpatialSearchRequestDTO requestParams, boolean generateLegend, boolean forcePointsDisplay, Integer pointHeatMapThreshold, String defaultPointColour, String[] colourByFq, String[] colours, Float opacity, HttpServletRequest request) throws Exception {
        File baseDir = new File(this.heatmapOutputDir);
        logger.debug((Object)("Heatmap output directory is " + this.heatmapOutputDir));
        String outputHMFile = this.getOutputFile(request);
        PointType pointType = PointType.POINT_001;
        double[] points = this.retrievePoints(requestParams, pointType);
        HeatMap hm = new HeatMap();
        if (forcePointsDisplay || points.length == 0 || points.length / 2 < pointHeatMapThreshold) {
            hm.setLegendImage(null);
            if (!generateLegend && colourByFq != null) {
                Object[] originalFq = requestParams.getFq();
                for (int k = 0; k < colourByFq.length; ++k) {
                    if (originalFq != null) {
                        requestParams.setFq((String[])ArrayUtils.add((Object[])originalFq, (Object)colourByFq[k]));
                    } else {
                        requestParams.setFq(new String[]{colourByFq[k]});
                    }
                    if (forcePointsDisplay && points.length > 0 && points.length / 2 < pointHeatMapThreshold) {
                        pointType = PointType.POINT_01;
                    }
                    double[] pointsForFacet = this.retrievePoints(requestParams, pointType);
                    Color pointColor = ColorUtil.getColor((String)colours[k], (Float)opacity);
                    String facetDisplayString = this.queryFormatUtils.formatQueryTerm(colourByFq[k], null)[0];
                    hm.generatePoints(pointsForFacet, pointColor, facetDisplayString);
                }
            } else {
                Color pointColor = ColorUtil.getColor((String)defaultPointColour, (Float)opacity);
                hm.generatePoints(points, pointColor, this.heatmapLegendOccurrenceLabel);
            }
            hm.drawOutput(baseDir + "/" + outputHMFile, false);
            hm.drawLegend(baseDir + "/legend_" + outputHMFile);
        } else {
            hm.generateClasses(points);
            if (generateLegend) {
                hm.drawLegend(baseDir + "/legend_" + outputHMFile);
            } else {
                hm.drawOutput(baseDir + "/" + outputHMFile, true);
            }
        }
    }

    @Deprecated
    private double[] retrievePoints(SpatialSearchRequestDTO requestParams, PointType pointType) {
        double[] points = new double[]{};
        try {
            requestParams.setQ(requestParams.getQ());
            List occ_points = this.searchDAO.getFacetPoints(requestParams, pointType);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Points search for " + pointType.getLabel() + " - found: " + occ_points.size()));
            }
            int totalItems = 0;
            for (int i = 0; i < occ_points.size(); ++i) {
                OccurrencePoint pt = (OccurrencePoint)occ_points.get(i);
                totalItems = (int)((long)totalItems + pt.getCount());
            }
            logger.debug((Object)("total number of occurrence points is " + totalItems));
            points = new double[totalItems * 2];
            int j = 0;
            for (int i = 0; i < occ_points.size(); ++i) {
                OccurrencePoint pt = (OccurrencePoint)occ_points.get(i);
                pt.getCount();
                double lng = ((Float)pt.getCoordinates().get(0)).doubleValue();
                double lat = ((Float)pt.getCoordinates().get(1)).doubleValue();
                points[j] = lng;
                points[j + 1] = lat;
                j += 2;
            }
        }
        catch (Exception e) {
            logger.error((Object)"An error occurred getting heatmap points", (Throwable)e);
        }
        return points;
    }
}

