/*
 * Decompiled with CFR 0.152.
 */
package au.org.ala.biocache.web;

import au.org.ala.biocache.dao.SearchDAO;
import au.org.ala.biocache.dto.DownloadRequestDTO;
import au.org.ala.biocache.dto.DownloadRequestParams;
import au.org.ala.biocache.dto.FacetResultDTO;
import au.org.ala.biocache.dto.FieldResultDTO;
import au.org.ala.biocache.dto.SearchResultDTO;
import au.org.ala.biocache.dto.SpatialSearchRequestDTO;
import au.org.ala.biocache.dto.SpatialSearchRequestParams;
import au.org.ala.biocache.dto.SpeciesGroupDTO;
import au.org.ala.biocache.util.QueryFormatUtils;
import com.ctc.wstx.util.URLUtil;
import com.fasterxml.jackson.annotation.JsonInclude;
import io.swagger.annotations.ApiParam;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.opengis.metadata.identification.CharacterSet;
import org.springdoc.api.annotations.ParameterObject;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Controller;
import org.springframework.util.StreamUtils;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class ExploreController {
    private static final Logger logger = Logger.getLogger(ExploreController.class);
    public static final String ENDEMISM_CSV_HEADER = "Family,Scientific name,Common name,Taxon rank,LSID,# Occurrences";
    @Inject
    protected SearchDAO searchDao;
    @Inject
    protected QueryFormatUtils queryFormatUtils;
    @Value(value="${species.subgroups.url:/data/biocache/config/subgroups.json}")
    protected String speciesSubgroupsUrl;
    private String speciesSubgroups = null;
    @Value(value="${species.groups.url:/data/biocache/config/groups.json}")
    protected String speciesGroupsUrl;
    private String speciesGroups = null;
    public static final HashMap<Float, Integer> radiusToZoomLevelMap = new HashMap();

    private String getSubgroupsConfig() {
        if (this.speciesSubgroups == null) {
            this.speciesSubgroups = this.getStringFromPath(this.speciesSubgroupsUrl);
        }
        return this.speciesSubgroups;
    }

    private String getGroupsConfig() {
        if (this.speciesGroups == null) {
            this.speciesGroups = this.getStringFromPath(this.speciesGroupsUrl);
        }
        return this.speciesGroups;
    }

    private String getStringFromPath(String path) {
        String result = null;
        try {
            result = path.startsWith("http") ? StreamUtils.copyToString((InputStream)URLUtil.inputStreamFromURL((URL)new URL(path)), (Charset)CharacterSet.UTF_8.toCharset()) : FileUtils.readFileToString((File)new File(path), (Charset)StandardCharsets.UTF_8);
        }
        catch (Exception e) {
            logger.error((Object)("Exception reading from species.subgroups.url: " + this.speciesSubgroups), (Throwable)e);
        }
        return result;
    }

    @Operation(summary="Returns a hierarchical listing of all species groups", tags={"Explore"})
    @Tag(name="Explore", description="Services for retrieval of all species groups")
    @RequestMapping(value={"/explore/hierarchy"}, method={RequestMethod.GET}, produces={"application/json"})
    public void getHierarchy(HttpServletResponse response) throws Exception {
        response.setContentType("application/json");
        try {
            ServletOutputStream out = response.getOutputStream();
            out.write(this.getSubgroupsConfig().getBytes(StandardCharsets.UTF_8));
            out.flush();
            out.close();
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    @Operation(summary="Returns a hierarchical listing of species groups", tags={"Explore"})
    @Tag(name="Explore", description="Services for retrieval of Specimens & occurrence data based on species groups")
    @RequestMapping(value={"/explore/hierarchy/groups"}, method={RequestMethod.GET}, produces={"application/json"})
    @ResponseBody
    public Collection<SpeciesGroupDTO> yourHierarchicalAreaView(@ParameterObject SpatialSearchRequestParams params, String speciesGroup) throws Exception {
        JSONArray ssgs = JSONArray.fromObject((Object)this.getSubgroupsConfig());
        LinkedHashMap<String, SpeciesGroupDTO> parentGroupMap = new LinkedHashMap<String, SpeciesGroupDTO>();
        HashMap parentLookup = new HashMap();
        ssgs.stream().forEach(sg -> ((JSONArray)((JSONObject)sg).get("taxa")).stream().forEach(ssg -> parentLookup.put(((JSONObject)ssg).getString("common").toLowerCase(), ((JSONObject)sg).getString("speciesGroup"))));
        SpatialSearchRequestDTO requestParams = SpatialSearchRequestDTO.create((SpatialSearchRequestParams)params);
        requestParams.setFormattedQuery(null);
        requestParams.setFacets(new String[]{"speciesSubgroup"});
        requestParams.setFacet(Boolean.valueOf(true));
        requestParams.setPageSize(Integer.valueOf(0));
        requestParams.setFlimit(Integer.valueOf(-1));
        if (StringUtils.isNotBlank((String)speciesGroup)) {
            requestParams.setFq(new String[]{"speciesGroup:\"" + speciesGroup + "\""});
        }
        List speciesSubgroupCounts = this.searchDao.getFacetCounts(requestParams);
        HashMap<String, Long> occurrenceCounts = new HashMap<String, Long>();
        if (speciesSubgroupCounts.size() > 0) {
            for (FieldResultDTO fr : ((FacetResultDTO)speciesSubgroupCounts.get(0)).getFieldResult()) {
                occurrenceCounts.put(fr.getLabel(), fr.getCount());
            }
        }
        String taxonName = "scientificName";
        for (String ssg : occurrenceCounts.keySet()) {
            requestParams.setQ("speciesSubgroup:\"" + ssg + "\"");
            requestParams.setFormattedQuery(null);
            requestParams.setFacets(new String[]{taxonName});
            long count = this.searchDao.estimateUniqueValues(requestParams, taxonName);
            if (count <= 0L) continue;
            String parentName = (String)parentLookup.get(ssg.toLowerCase());
            SpeciesGroupDTO parentGroup = (SpeciesGroupDTO)parentGroupMap.get(parentName);
            if (parentGroup == null) {
                parentGroup = new SpeciesGroupDTO(parentName, 0L, 0L, 1);
                parentGroupMap.put(parentName, parentGroup);
            }
            if (parentGroup != null) {
                if (parentGroup.getChildGroups() == null) {
                    parentGroup.setChildGroups(new ArrayList());
                }
                parentGroup.getChildGroups().add(new SpeciesGroupDTO(ssg, count, ((Long)occurrenceCounts.get(ssg)).longValue(), 2));
                parentGroup.setSpeciesCount(parentGroup.getSpeciesCount() + count);
                parentGroup.setCount(parentGroup.getCount() + (Long)occurrenceCounts.get(ssg));
                continue;
            }
            logger.warn((Object)("Parent group lookup failed for: " + parentName + ", ssg: " + ssg));
        }
        ArrayList<String> toRemove = new ArrayList<String>();
        for (String parentName : parentGroupMap.keySet()) {
            if (((SpeciesGroupDTO)parentGroupMap.get(parentName)).getChildGroups() != null && ((SpeciesGroupDTO)parentGroupMap.get(parentName)).getChildGroups().size() != 0) continue;
            toRemove.add(parentName);
        }
        for (String key : toRemove) {
            parentGroupMap.remove(key);
        }
        return parentGroupMap.values();
    }

    @Operation(summary="Returns a list of species groups and counts that will need to be displayed", tags={"Explore"})
    @RequestMapping(value={"/explore/groups"}, method={RequestMethod.GET}, produces={"application/json"})
    @ResponseBody
    public List<SpeciesGroupDTO> yourAreaView(@ParameterObject SpatialSearchRequestParams params) throws Exception {
        SpatialSearchRequestDTO requestParams = SpatialSearchRequestDTO.create((SpatialSearchRequestParams)params);
        JSONArray sgs = JSONArray.fromObject((Object)this.getGroupsConfig());
        ArrayList<SpeciesGroupDTO> speciesGroups = new ArrayList<SpeciesGroupDTO>();
        SpeciesGroupDTO all = new SpeciesGroupDTO();
        String[] originalFqs = requestParams.getFq();
        all.setName("ALL_SPECIES");
        all.setLevel(0);
        Integer[] counts = this.getYourAreaCount(params, "ALL_SPECIES");
        all.setCount((long)counts[0].intValue());
        all.setSpeciesCount((long)counts[1].intValue());
        speciesGroups.add(all);
        String oldName = null;
        String kingdom = null;
        for (Object sg : sgs) {
            if (!(sg instanceof JSONObject) || !((JSONObject)sg).containsKey((Object)"name")) continue;
            String parent = null;
            if (((JSONObject)sg).containsKey((Object)"parent")) {
                parent = ((JSONObject)sg).getString("parent");
            }
            String name = ((JSONObject)sg).getString("name");
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("name: " + name + " parent: " + parent));
            }
            int level = 3;
            SpeciesGroupDTO sdto = new SpeciesGroupDTO();
            sdto.setName(name);
            if (oldName != null && parent != null && parent.equals(kingdom)) {
                level = 2;
            }
            oldName = name;
            if (StringUtils.isBlank((String)parent) || "null".equalsIgnoreCase(parent)) {
                level = 1;
                kingdom = name;
            }
            sdto.setLevel(level);
            requestParams.setFq(originalFqs);
            counts = this.getYourAreaCount(params, name);
            sdto.setCount((long)counts[0].intValue());
            sdto.setSpeciesCount((long)counts[1].intValue());
            speciesGroups.add(sdto);
        }
        return speciesGroups;
    }

    @Operation(summary="Returns the number of records and distinct species in a particular species group", tags={"Explore"}, description="The first count is total number of occurrence, the second is the number of distinct species")
    @RequestMapping(value={"/explore/counts/group/{group}"}, method={RequestMethod.GET}, produces={"application/json"})
    @ResponseBody
    public Integer[] getYourAreaCount(@ParameterObject SpatialSearchRequestParams params, @PathVariable(value="group") String group) throws Exception {
        SpatialSearchRequestDTO requestParams = SpatialSearchRequestDTO.create((SpatialSearchRequestParams)params);
        this.addGroupFilterToQuery(requestParams, group);
        requestParams.setPageSize(Integer.valueOf(0));
        requestParams.setFacet(Boolean.valueOf(false));
        SearchResultDTO results = this.searchDao.findByFulltextSpatialQuery(requestParams, false, null);
        int speciesCount = (int)this.searchDao.estimateUniqueValues(requestParams, "scientificName");
        return new Integer[]{(int)results.getTotalRecords(), speciesCount};
    }

    private void addGroupFilterToQuery(SpatialSearchRequestDTO requestParams, String group) {
        this.addFacetFilterToQuery(requestParams, "speciesGroup", group);
    }

    private void addFacetFilterToQuery(SpatialSearchRequestDTO requestParams, String facetName, String facetValue) {
        if (!facetValue.equals("ALL_SPECIES")) {
            this.queryFormatUtils.addFqs(new String[]{facetName + ":" + facetValue}, requestParams);
        }
        this.queryFormatUtils.addFqs(new String[]{"taxonRankID:[7000 TO *]"}, requestParams);
        requestParams.setFormattedQuery(null);
    }

    private void applyFacetForCounts(SpatialSearchRequestDTO requestParams, boolean useCommonName) {
        if (useCommonName) {
            requestParams.setFacets(new String[]{"common_name_and_lsid"});
        } else {
            requestParams.setFacets(new String[]{"names_and_lsid"});
        }
    }

    @Operation(summary="Occurrence search page uses SOLR JSON to display results", tags={"Explore"}, description="The first count is total number of occurrence, the second is the number of distinct species")
    @RequestMapping(value={"/explore/group/{group}/download"}, method={RequestMethod.GET}, produces={"application/vnd.ms-excel"})
    public void yourAreaDownload(@ParameterObject DownloadRequestParams requestParams, @PathVariable(value="group") String group, @RequestParam(value="common", required=false, defaultValue="false") boolean common, HttpServletRequest request, HttpServletResponse response) {
        DownloadRequestDTO dto = DownloadRequestDTO.create((DownloadRequestParams)requestParams, (HttpServletRequest)request);
        String filename = requestParams.getFile() != null ? requestParams.getFile() : "data";
        logger.debug((Object)"Downloading the species in your area... ");
        response.setHeader("Cache-Control", "must-revalidate");
        response.setHeader("Pragma", "must-revalidate");
        response.setHeader("Content-Disposition", "attachment;filename=" + filename);
        response.setContentType("application/vnd.ms-excel");
        this.addGroupFilterToQuery((SpatialSearchRequestDTO)dto, group);
        this.applyFacetForCounts((SpatialSearchRequestDTO)dto, common);
        try {
            ServletOutputStream out = response.getOutputStream();
            this.searchDao.writeSpeciesCountByCircleToStream((SpatialSearchRequestDTO)dto, group, out);
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    @Operation(summary="Returns a list of species and record counts for a given location search and a higher taxa with rank.", tags={"Explore"})
    @RequestMapping(value={"/explore/group/{group}"}, method={RequestMethod.GET}, produces={"application/json"})
    @ApiParam(value="group", required=true)
    public void listSpeciesForHigherTaxa(@ParameterObject SpatialSearchRequestParams params, @PathVariable(value="group") String group, @RequestParam(value="common", required=false, defaultValue="false") boolean common, HttpServletResponse response) throws Exception {
        SpatialSearchRequestDTO requestParams = SpatialSearchRequestDTO.create((SpatialSearchRequestParams)params);
        this.addGroupFilterToQuery(requestParams, group);
        this.applyFacetForCounts(requestParams, common);
        requestParams.setFlimit(requestParams.getPageSize());
        requestParams.setPageSize(Integer.valueOf(0));
        requestParams.setFoffset(requestParams.getStart());
        requestParams.setFsort(requestParams.getSort());
        requestParams.setSort("");
        response.setContentType("application/json");
        this.searchDao.findAllSpeciesJSON(requestParams, (OutputStream)response.getOutputStream());
    }

    @Operation(summary="Returns the number of distinct species that are in the supplied region", tags={"Explore"})
    @RequestMapping(value={"/explore/counts/endemic"}, method={RequestMethod.GET})
    @ResponseBody
    public int getSpeciesCountOnlyInWKT(@ParameterObject SpatialSearchRequestParams requestParams) throws Exception {
        List list = this.getSpeciesOnlyInWKT(requestParams);
        if (list != null) {
            return list.size();
        }
        return 0;
    }

    @Operation(summary="Returns the species that only have occurrences in the supplied WKT.", tags={"Endemism"})
    @Tag(name="Endemism", description="Services for reports on endemism for an area")
    @RequestMapping(value={"/explore/endemic/species"}, method={RequestMethod.GET}, produces={"application/json"})
    @ResponseBody
    public List<FieldResultDTO> getSpeciesOnlyInWKT(@ParameterObject SpatialSearchRequestParams requestParams) throws Exception {
        SpatialSearchRequestDTO requested = SpatialSearchRequestDTO.create((SpatialSearchRequestParams)requestParams);
        SpatialSearchRequestDTO superset = new SpatialSearchRequestDTO();
        superset.setQ("decimalLongitude:[-180 TO 180]");
        superset.setFq(new String[]{"decimalLatitude:[-90 TO 90]"});
        this.prepareEndemicFacet(requested);
        this.prepareEndemicFacet(superset);
        return this.searchDao.getSubquerySpeciesOnly(requested, superset);
    }

    private void prepareEndemicFacet(SpatialSearchRequestDTO parentQuery) {
        if (parentQuery.getFacets() == null || parentQuery.getFacets().length != 1) {
            parentQuery.setFacets(new String[]{"names_and_lsid"});
        }
    }

    @Operation(summary="Returns facet values that only occur in the supplied subQueryID and not in the parentQuery.", tags={"Endemism"})
    @RequestMapping(value={"/explore/endemic/species/{subQueryID}"}, method={RequestMethod.GET}, produces={"application/json"})
    @ApiParam(value="subQueryID", required=true)
    @ResponseBody
    public List<FieldResultDTO> getSpeciesOnlyInOneQuery(@ParameterObject SpatialSearchRequestParams parentQueryParams, @PathVariable(value="subQueryID") Long subQueryID) throws Exception {
        SpatialSearchRequestDTO parentQuery = SpatialSearchRequestDTO.create((SpatialSearchRequestParams)parentQueryParams);
        SpatialSearchRequestDTO subQuery = new SpatialSearchRequestDTO();
        subQuery.setQ("qid:" + subQueryID);
        this.prepareEndemicFacet(parentQuery);
        subQuery.setFacets(parentQuery.getFacets());
        return this.searchDao.getSubquerySpeciesOnly(subQuery, parentQuery);
    }

    @Operation(summary="Returns count of facet values that only occur in the supplied subQueryID and not in the parentQuery.", tags={"Endemism"})
    @RequestMapping(value={"/explore/endemic/speciescount/{subQueryID}"}, method={RequestMethod.GET}, produces={"application/json"})
    @ApiParam(value="subQueryID", required=true)
    @ResponseBody
    public Map getSpeciesOnlyInOneCountQuery(@ParameterObject SpatialSearchRequestParams parentQuery, @PathVariable(value="subQueryID") Long subQueryID) throws Exception {
        return Collections.singletonMap("count", this.getSpeciesOnlyInOneQuery(parentQuery, subQueryID).size());
    }

    @Operation(summary="Download a CSV of the species that only have occurrences in the supplied WKT", tags={"Endemism", "Download"}, description="Download a CSV of the species that only have occurrences in the supplied WKT. Columns: \" + ENDEMISM_CSV_HEADER")
    @RequestMapping(value={"/explore/endemic/species.csv"}, method={RequestMethod.GET})
    public void getEndemicSpeciesCSV(@ParameterObject SpatialSearchRequestParams requestParams, HttpServletResponse response) throws Exception {
        requestParams.setFacets(new String[]{"names_and_lsid"});
        requestParams.setFq((String[])ArrayUtils.add((Object[])requestParams.getFq(), (Object)"speciesID:*"));
        List list = this.getSpeciesOnlyInWKT(requestParams);
        response.setCharacterEncoding("UTF-8");
        response.setContentType("text/plain");
        PrintWriter writer = response.getWriter();
        writer.write(ENDEMISM_CSV_HEADER);
        for (FieldResultDTO item : list) {
            String[] values;
            String s = item.getLabel();
            if (s.startsWith("\"") && s.endsWith("\"") && s.length() > 2) {
                s = s.substring(1, s.length() - 1);
            }
            if ((values = s.split("\\|", 6)).length < 5) continue;
            writer.write("\n" + values[4] + ",\"" + values[0] + "\",\"" + values[2] + "\",," + values[1] + "," + item.getCount());
        }
        writer.flush();
        writer.close();
    }

    @Operation(summary="Download a CSV of facet values that only occur in the supplied subQueryID and not in the parentQuery.", tags={"Endemism", "Download"})
    @RequestMapping(value={"/explore/endemic/species/{subQueryID}.csv"}, method={RequestMethod.GET})
    @ApiParam(value="subQueryID", required=true)
    public void getSpeciesOnlyInOneQueryCSV(@ParameterObject SpatialSearchRequestParams parentQueryParams, @PathVariable(value="subQueryID") Long subQueryID, @RequestParam(value="count", required=false, defaultValue="false") boolean includeCount, @RequestParam(value="lookup", required=false, defaultValue="false") boolean lookupName, @RequestParam(value="synonym", required=false, defaultValue="false") boolean includeSynonyms, @RequestParam(value="lists", required=false, defaultValue="false") boolean includeLists, @RequestParam(value="file", required=false, defaultValue="") String file, HttpServletResponse response) {
        SpatialSearchRequestDTO parentQuery = SpatialSearchRequestDTO.create((SpatialSearchRequestParams)parentQueryParams);
        SpatialSearchRequestDTO subQuery = new SpatialSearchRequestDTO();
        subQuery.setQ("qid:" + subQueryID);
        this.prepareEndemicFacet(parentQuery);
        this.prepareEndemicFacet(subQuery);
        String filename = StringUtils.isNotEmpty((String)file) ? file : parentQuery.getFacets()[0];
        response.setHeader("Cache-Control", "must-revalidate");
        response.setHeader("Pragma", "must-revalidate");
        response.setHeader("Content-Disposition", "attachment;filename=" + filename + ".csv");
        response.setContentType("text/csv");
        try {
            this.searchDao.writeEndemicFacetToStream(subQuery, parentQuery, includeCount, lookupName, includeSynonyms, includeLists, (OutputStream)response.getOutputStream());
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    static {
        radiusToZoomLevelMap.put(Float.valueOf(1.0f), 14);
        radiusToZoomLevelMap.put(Float.valueOf(5.0f), 12);
        radiusToZoomLevelMap.put(Float.valueOf(10.0f), 11);
        radiusToZoomLevelMap.put(Float.valueOf(50.0f), 9);
    }
}

