/*
 * Decompiled with CFR 0.152.
 */
package au.org.ala.biocache.util;

import org.apache.log4j.Logger;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryCollection;
import org.locationtech.jts.io.WKTReader;
import org.locationtech.jts.simplify.TopologyPreservingSimplifier;

/*
 * Exception performing whole class analysis ignored.
 */
public class SpatialUtils {
    private static final Logger logger = Logger.getLogger(SpatialUtils.class);

    public static String getWKTQuery(String spatialField, String wkt, boolean negated) {
        Object field;
        StringBuilder sb = new StringBuilder();
        String operation = negated ? " AND " : " OR ";
        Object object = field = negated ? "-" + spatialField : spatialField;
        if (wkt.startsWith("GEOMETRYCOLLECTION")) {
            try {
                WKTReader r = new WKTReader();
                GeometryCollection gc = (GeometryCollection)r.read(wkt);
                sb.append("(");
                for (int i = 0; i < gc.getNumGeometries(); ++i) {
                    Geometry g = gc.getGeometryN(i);
                    if (i > 0) {
                        sb.append(operation);
                    }
                    sb.append((String)field).append(":\"Intersects(");
                    sb.append(g.toText());
                    sb.append(")\"");
                }
                sb.append(")");
            }
            catch (Exception e) {
                logger.error((Object)("failed to parse WKT: " + wkt.substring(0, 255) + "..."), (Throwable)e);
            }
        } else {
            sb.append((String)field).append(":\"Intersects(");
            sb.append(wkt);
            sb.append(")\"");
        }
        return sb.toString();
    }

    public static String simplifyWkt(String wkt, int maxPoints) {
        double distanceFactor = 2.0;
        double distanceInitialPrecision = 1.0E-4;
        double distanceMaxPrecision = 10.0;
        return SpatialUtils.simplifyWkt((String)wkt, (int)maxPoints, (double)2.0, (double)1.0E-4, (double)10.0);
    }

    public static String simplifyWkt(String wkt, int maxPoints, double distanceFactor, double distanceInitialPrecision, double distanceMaxPrecision) {
        WKTReader r = new WKTReader();
        try {
            Geometry g = r.read(wkt);
            if (maxPoints <= 0 || g.getNumPoints() <= maxPoints) {
                return wkt;
            }
            for (double distance = distanceInitialPrecision; distance < distanceMaxPrecision; distance *= distanceFactor) {
                g = TopologyPreservingSimplifier.simplify((Geometry)g, (double)distance);
                if (!logger.isDebugEnabled()) continue;
                logger.debug((Object)("Simplified geometry to " + g.getNumPoints() + " at distance precision " + distance));
                if (g.getNumPoints() > maxPoints) continue;
                return g.toText();
            }
            logger.warn((Object)("WKT simplification failed to achieve the required precision:  finalNumberOfPoints=" + g.getNumPoints() + " maxPoints=" + maxPoints + " distanceFactor=" + distanceFactor + " distanceInitialPrecision=" + distanceInitialPrecision + " distanceMaxPrecision=" + distanceMaxPrecision));
        }
        catch (Exception e) {
            logger.error((Object)("WKT reduction failed due to an exception: " + e.getMessage()));
        }
        return null;
    }
}

