/*
 * Decompiled with CFR 0.152.
 */
package au.org.ala.biocache.stream;

import au.com.bytecode.opencsv.CSVWriter;
import au.org.ala.biocache.dao.SearchDAOImpl;
import au.org.ala.biocache.dto.SpatialSearchRequestDTO;
import au.org.ala.biocache.dto.TaxaCountDTO;
import au.org.ala.biocache.stream.StreamTaxaCount;
import au.org.ala.biocache.util.SearchUtils;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import org.apache.log4j.Logger;

public class StreamTaxaAsCSV
extends StreamTaxaCount {
    private static final Logger logger = Logger.getLogger(StreamTaxaAsCSV.class);
    private final String NULL_NAME = "Unknown";
    CSVWriter csvWriter;

    public StreamTaxaAsCSV(SearchDAOImpl searchDAO, SearchUtils searchUtils, SpatialSearchRequestDTO request, OutputStream outputStream) {
        super(searchDAO, searchUtils, request, outputStream);
    }

    public boolean flush() {
        try {
            this.csvWriter.flush();
        }
        catch (IOException e) {
            logger.error((Object)e);
        }
        return true;
    }

    void initWriter() {
        try {
            this.csvWriter = new CSVWriter((Writer)new OutputStreamWriter(this.outputStream));
        }
        catch (Exception e) {
            logger.error((Object)"cannot init CSV output");
        }
        this.csvWriter.writeNext(new String[]{"Family", "Scientific name", "Common name", "Taxon rank", "LSID", "# Occurrences"});
    }

    void write(TaxaCountDTO d) {
        String family = d.getFamily();
        String name = d.getName();
        String commonName = d.getCommonName();
        String guid = d.getGuid();
        String rank = d.getRank();
        if (family == null) {
            family = "";
        }
        if (name == null) {
            name = "";
        }
        if (commonName == null) {
            commonName = "";
        }
        if (d.getGuid() == null && d.getName() != null) {
            String[] nameLsid = d.getName().split("\\|");
            if (nameLsid.length >= 2) {
                name = nameLsid[0];
                guid = nameLsid[1];
                rank = "scientific name";
                if (nameLsid.length >= 3) {
                    commonName = nameLsid[2];
                }
            } else {
                name = "Unknown";
            }
        }
        if (d.getCount() != null && guid != null) {
            this.csvWriter.writeNext(new String[]{family, name, commonName, rank, guid, d.getCount().toString()});
        }
    }
}

