/*
 * Decompiled with CFR 0.152.
 */
package au.org.ala.biocache.stream;

import au.org.ala.biocache.dto.FieldResultDTO;
import au.org.ala.biocache.stream.ProcessInterface;
import java.util.List;
import org.apache.log4j.Logger;
import org.apache.solr.client.solrj.io.Tuple;

public class EndemicFacet
implements ProcessInterface {
    private static final Logger logger = Logger.getLogger(EndemicFacet.class);
    List<FieldResultDTO> output;
    String facetName;

    public EndemicFacet(List<FieldResultDTO> output, String facetName) {
        this.output = output;
        this.facetName = facetName;
    }

    public boolean process(Tuple tuple) {
        try {
            long entryCount;
            if (tuple != null && (entryCount = tuple.getLong((Object)"count(*)").longValue()) > 0L) {
                String value = tuple.getString((Object)this.facetName);
                this.output.add(new FieldResultDTO(value, value, entryCount));
            }
            return true;
        }
        catch (IllegalArgumentException e) {
            logger.warn((Object)("Failed to convert tuple to FieldResultDTO: " + e.getMessage()));
            return false;
        }
    }

    public boolean flush() {
        return true;
    }
}

