/*
 * Decompiled with CFR 0.152.
 */
package au.org.ala.biocache.service;

import au.com.bytecode.opencsv.CSVReader;
import au.com.bytecode.opencsv.CSVWriter;
import au.org.ala.biocache.dao.IndexDAO;
import au.org.ala.biocache.dao.PersistentQueueDAO;
import au.org.ala.biocache.dao.SearchDAO;
import au.org.ala.biocache.dto.DownloadDetailsDTO;
import au.org.ala.biocache.dto.DownloadDoiDTO;
import au.org.ala.biocache.dto.DownloadHeaders;
import au.org.ala.biocache.dto.DownloadRequestDTO;
import au.org.ala.biocache.dto.IndexFieldDTO;
import au.org.ala.biocache.dto.QualityFilterDTO;
import au.org.ala.biocache.dto.SearchRequestDTO;
import au.org.ala.biocache.service.AuthService;
import au.org.ala.biocache.service.DataQualityService;
import au.org.ala.biocache.service.DoiService;
import au.org.ala.biocache.service.DownloadService;
import au.org.ala.biocache.service.EmailService;
import au.org.ala.biocache.service.LoggerService;
import au.org.ala.biocache.stream.OptionalZipOutputStream;
import au.org.ala.biocache.util.AlaFileUtils;
import au.org.ala.biocache.util.TooManyDownloadRequestsException;
import au.org.ala.biocache.writer.RecordWriterException;
import au.org.ala.doi.CreateDoiResponse;
import au.org.ala.ws.security.profile.AlaUserProfile;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Lists;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Queue;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import javax.servlet.http.HttpServletResponse;
import org.ala.client.model.LogEventVO;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.output.CloseShieldOutputStream;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.apache.velocity.Template;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.context.Context;
import org.apache.velocity.runtime.RuntimeServices;
import org.apache.velocity.runtime.RuntimeSingleton;
import org.apache.velocity.runtime.log.Log4JLogChute;
import org.apache.velocity.runtime.parser.ParseException;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.ApplicationListener;
import org.springframework.context.event.ContextClosedEvent;
import org.springframework.context.support.AbstractMessageSource;
import org.springframework.core.io.Resource;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;
import org.springframework.web.client.RestOperations;

@Component(value="downloadService")
public class DownloadService
implements ApplicationListener<ContextClosedEvent> {
    public static final String OFFICIAL_DOI_RESOLVER = "https://doi.org/";
    public static final String CSDM_SELECTOR = "csdm";
    public static final String DOI_SELECTOR = "doi";
    public static final String DEFAULT_SELECTOR = "default";
    private static final String DOWNLOAD_FILE_LOCATION = "[url]";
    private static final String OFFICIAL_FILE_LOCATION = "[officialDoiUrl]";
    private static final String START_DATE_TIME = "[date]";
    private static final String QUERY_TITLE = "[queryTitle]";
    private static final String SEARCH_URL = "[searchUrl]";
    private static final String DOI_FAILURE_MESSAGE = "[doiFailureMessage]";
    private static final String BCCVL_IMPORT_ID = "[bccvlImportID]";
    private static final String SUPPORT = "[support]";
    private static final String UNIQUE_ID = "[uniqueId]";
    private static final String MY_DOWNLOADS_URL = "[myDownloadsUrl]";
    private static final String HUB_NAME = "[hubName]";
    protected static final Logger logger = Logger.getLogger(DownloadService.class);
    @Inject
    protected PersistentQueueDAO persistentQueueDAO;
    @Inject
    protected SearchDAO searchDAO;
    @Inject
    protected IndexDAO indexDao;
    @Inject
    protected RestOperations restTemplate;
    @Inject
    protected ObjectMapper objectMapper;
    @Inject
    protected EmailService emailService;
    @Inject
    protected LoggerService loggerService;
    @Inject
    protected AbstractMessageSource messageSource;
    @Inject
    protected DoiService doiService;
    @Inject
    protected AuthService authService;
    @Inject
    protected DataQualityService dataQualityService;
    @Value(value="${webservices.root:http://localhost:8080/biocache-service}")
    public String webservicesRoot = "http://localhost:8080/biocache-service";
    @Value(value="${citations.enabled:true}")
    public Boolean citationsEnabled = Boolean.TRUE;
    @Value(value="${headings.enabled:true}")
    public Boolean headingsEnabled = Boolean.TRUE;
    @Value(value="${download.readme.enabled:true}")
    public Boolean readmeEnabled = Boolean.TRUE;
    @Value(value="${download.support.email.enabled:true}")
    public Boolean supportEmailEnabled = Boolean.TRUE;
    @Value(value="${download.support.email:support@ala.org.au}")
    public String supportEmail = "support@ala.org.au";
    @Value(value="${data.description.url:headings.csv}")
    protected String dataFieldDescriptionURL = "headings.csv";
    @Value(value="${registry.url:https://collections.ala.org.au/ws}")
    protected String registryUrl = "https://collections.ala.org.au/ws";
    @Value(value="${citations.url:https://collections.ala.org.au/ws/citations}")
    protected String citationServiceUrl = "https://collections.ala.org.au/ws/citations";
    @Value(value="${download.email.subject:ALA Occurrence Download Complete - [filename]}")
    protected String biocacheDownloadEmailSubject = "ALA Occurrence Download Complete - [filename]";
    @Value(value="${download.email.template:}")
    protected String biocacheDownloadEmailTemplate;
    @Value(value="${download.doi.resolver:https://doi.ala.org.au/doi/}")
    public String alaDoiResolver;
    @Value(value="${my.download.doi.baseUrl:https://doi.ala.org.au/myDownloads}")
    public String myDownloadsUrl;
    @Value(value="${download.support:support@ala.org.au}")
    public String support;
    @Value(value="${download.doi.email.template:}")
    protected String biocacheDownloadDoiEmailTemplate;
    @Value(value="${download.email.subject.failure:Occurrence Download Failed - [filename]}")
    protected String biocacheDownloadEmailSubjectError = "Occurrence Download Failed - [filename]";
    @Value(value="${download.email.body.error:Your [hubName] download has failed.}")
    protected String biocacheDownloadEmailBodyError = "Your [hubName] download has failed.";
    @Value(value="${download.readme.template:}")
    protected String biocacheDownloadReadmeTemplate;
    @Value(value="${download.doi.readme.template:}")
    protected String biocacheDownloadDoiReadmeTemplate;
    @Value(value="${download.doi.failure.message:}")
    protected String biocacheDownloadDoiFailureMessage;
    @Value(value="${download.doi.title.prefix:Occurrence download }")
    protected String biocacheDownloadDoiTitlePrefix = "Occurrence download ";
    @Value(value="${download.doi.landing.page.baseUrl:https://doi-test.ala.org.au/doi/}")
    protected String biocacheDownloadDoiLandingPage = "https://doi-test.ala.org.au/doi/";
    @Value(value="${download.additional.local.files:}")
    protected String biocacheDownloadAdditionalLocalFiles;
    @Value(value="${download.doi.propagation.delay:60000}")
    protected long doiPropagationDelay;
    @Value(value="${download.offline.parallelquery.maxthreads:30}")
    protected Integer maxOfflineParallelQueryDownloadThreads = 30;
    @Value(value="${download.offline.queue.maxsize:50}")
    protected Integer maxOfflineQueueMaxSize = 50;
    @Value(value="${zip.file.size.mb.max:4000}")
    public Integer maxMB;
    @Value(value="${download.url:https://biocache.ala.org.au/biocache-download}")
    public String biocacheDownloadUrl;
    @Value(value="${download.dir:/data/biocache-download}")
    public String biocacheDownloadDir;
    @Value(value="${download.auth.sensitive:false}")
    private Boolean downloadAuthSensitive;
    @Value(value="${biocache.ui.url:https://biocache.ala.org.au}")
    protected String biocacheUiUrl = "https://biocache.ala.org.au";
    @Value(value="${sensitiveAccessRoles20:{\n\n\"ROLE_SDS_ACT\" : \"sensitive:\\\"generalised\\\" AND (cl927:\\\"Australian Captial Territory\\\" OR cl927:\\\"Jervis Bay Territory\\\") AND -(dataResourceUid:dr359 OR dataResourceUid:dr571 OR dataResourceUid:dr570)\"\n\"ROLE_SDS_NSW\" : \"sensitive:\\\"generalised\\\" AND cl927:\\\"New South Wales (including Coastal Waters)\\\" AND -(dataResourceUid:dr359 OR dataResourceUid:dr571 OR dataResourceUid:dr570)\",\n\"ROLE_SDS_NZ\" : \"sensitive:\\\"generalised\\\" AND (dataResourceUid:dr2707 OR dataResourceUid:dr812 OR dataResourceUid:dr814 OR dataResourceUid:dr808 OR dataResourceUid:dr806 OR dataResourceUid:dr815 OR dataResourceUid:dr802 OR dataResourceUid:dr805 OR dataResourceUid:dr813) AND -cl927:* AND -(dataResourceUid:dr359 OR dataResourceUid:dr571 OR dataResourceUid:dr570)\",\n\"ROLE_SDS_NT\" : \"sensitive:\\\"generalised\\\" AND cl927:\\\"Northern Territory (including Coastal Waters)\\\" AND -(dataResourceUid:dr359 OR dataResourceUid:dr571 OR dataResourceUid:dr570)\",\n\"ROLE_SDS_QLD\" : \"sensitive:\\\"generalised\\\" AND cl927:\\\"Queensland (including Coastal Waters)\\\" AND -(dataResourceUid:dr359 OR dataResourceUid:dr571 OR dataResourceUid:dr570)\",\n\"ROLE_SDS_SA\" : \"sensitive:\\\"generalised\\\" AND cl927:\\\"South Australia (including Coastal Waters)\\\" AND -(dataResourceUid:dr359 OR dataResourceUid:dr571 OR dataResourceUid:dr570)\",\n\"ROLE_SDS_TAS\" : \"sensitive:\\\"generalised\\\" AND cl927:\\\"Tasmania (including Coastal Waters)\\\" AND -(dataResourceUid:dr359 OR dataResourceUid:dr571 OR dataResourceUid:dr570)\",\n\"ROLE_SDS_VIC\" : \"sensitive:\\\"generalised\\\" AND cl927:\\\"Victoria (including Coastal Waters)\\\" AND -(dataResourceUid:dr359 OR dataResourceUid:dr571 OR dataResourceUid:dr570)\",\n\"ROLE_SDS_WA\" : \"sensitive:\\\"generalised\\\" AND cl927:\\\"Western Australia (including Coastal Waters)\\\" AND -(dataResourceUid:dr359 OR dataResourceUid:dr571 OR dataResourceUid:dr570)\",\n\"ROLE_SDS_BIRDLIFE\" : \"sensitive:\\\"generalised\\\" AND (dataResourceUid:dr359 OR dataResourceUid:dr571 OR dataResourceUid:dr570)\"\n\n}}")
    protected String sensitiveAccessRoles20 = "{}";
    private JSONObject sensitiveAccessRolesToSolrFilters20;
    @Value(value="${download.offline.max.url:https://downloads.ala.org.au}")
    public String dowloadOfflineMaxUrl = "https://downloads.ala.org.au";
    @Value(value="${download.offline.max.size:100000000}")
    public Integer dowloadOfflineMaxSize = 100000000;
    @Value(value="${download.offline.msg:Too many records requested. Bulk download files for Lifeforms are available.}")
    public String downloadOfflineMsg = "Too many records requested. Bulk download files for Lifeforms are available.";
    @Value(value="${download.offline.msg:This download is unavailable. Run the download again.}")
    public String downloadOfflineMsgDeleted = "This download is unavailable. Run the download again.";
    @Value(value="${download.qualityFiltersTemplate:classpath:download-email-quality-filter-snippet.html}")
    public Resource downloadQualityFiltersTemplate;
    @Value(value="${download.date.format:dd MMMMM yyyy}")
    public String downloadDateFormat = "dd MMMMM yyyy";
    @Value(value="${download.csdm.email.template:}")
    protected String biocacheDownloadCSDMEmailTemplate;
    ConcurrentHashMap<String, ThreadPoolExecutor> userExecutors;

    @PostConstruct
    public void init() throws org.json.simple.parser.ParseException {
        this.sensitiveAccessRolesToSolrFilters20 = (JSONObject)new JSONParser().parse(this.sensitiveAccessRoles20);
        Queue fromPersistent = this.persistentQueueDAO.refreshFromPersistent();
        for (DownloadDetailsDTO dd : fromPersistent) {
            try {
                this.add(dd);
            }
            catch (TooManyDownloadRequestsException tooManyDownloadRequestsException) {
            }
            catch (IOException e) {
                logger.error((Object)("failed to add unfinished download to download queue, id: " + dd.getUniqueId() + ", " + e.getMessage()));
            }
        }
        this.userExecutors = new ConcurrentHashMap();
    }

    public void onApplicationEvent(ContextClosedEvent event) {
        for (ThreadPoolExecutor ex : this.userExecutors.values()) {
            ex.shutdown();
        }
    }

    @Scheduled(fixedDelay=43200000L)
    public void removeUnusedExecutors() {
        for (Map.Entry set : this.userExecutors.entrySet()) {
            if (((ThreadPoolExecutor)set.getValue()).getActiveCount() != 0) continue;
            this.userExecutors.remove(set.getKey());
            ((ThreadPoolExecutor)set.getValue()).shutdown();
        }
    }

    private boolean isAuthorisedSystem(DownloadDetailsDTO dd) {
        return false;
    }

    public void add(DownloadDetailsDTO dd) throws TooManyDownloadRequestsException, IOException {
        ThreadPoolExecutor executor;
        int maxPoolSize = 1;
        if (this.isAuthorisedSystem(dd)) {
            maxPoolSize = this.maxOfflineParallelQueryDownloadThreads;
        }
        if ((executor = (ThreadPoolExecutor)this.userExecutors.get(this.getUserId(dd))) == null) {
            LinkedBlockingQueue<Runnable> queue = new LinkedBlockingQueue<Runnable>();
            executor = new ThreadPoolExecutor(1, maxPoolSize, 0L, TimeUnit.MILLISECONDS, queue);
            this.userExecutors.put(this.getUserId(dd), executor);
        }
        if (executor.getQueue().size() >= this.maxOfflineQueueMaxSize) {
            throw new TooManyDownloadRequestsException();
        }
        this.persistentQueueDAO.add(dd);
        executor.execute((Runnable)this.getDownloadRunnable(dd));
    }

    private String getUserId(DownloadDetailsDTO dd) {
        String userId = "";
        if (dd.getAlaUser() != null && dd.getAlaUser().getUserId() != null) {
            userId = dd.getAlaUser().getUserId();
        }
        return userId;
    }

    protected DownloadRunnable getDownloadRunnable(DownloadDetailsDTO dd) {
        return new DownloadRunnable(this, dd);
    }

    public List<DownloadDetailsDTO> getCurrentDownloads() {
        ArrayList<DownloadDetailsDTO> result = new ArrayList<DownloadDetailsDTO>();
        for (ThreadPoolExecutor ex : this.userExecutors.values()) {
            for (Runnable r : ex.getQueue()) {
                result.add(((DownloadRunnable)r).currentDownload);
            }
        }
        return Collections.unmodifiableList(result);
    }

    public void writeQueryToStream(DownloadDetailsDTO dd, OutputStream out, boolean limit, boolean zip, ExecutorService parallelExecutor, List<CreateDoiResponse> doiResponseList) throws Exception {
        block38: {
            DownloadRequestDTO requestParams = dd.getRequestParams();
            String filename = dd.getRequestParams().getFile();
            String originalParams = dd.getRequestParams().toString();
            String assertions = "assertions";
            String data_resource_uid = "dataResourceUid";
            try (OptionalZipOutputStream sp = new OptionalZipOutputStream(zip ? OptionalZipOutputStream.Type.zipped : OptionalZipOutputStream.Type.unzipped, (OutputStream)new CloseShieldOutputStream(out), this.maxMB);){
                String suffix = requestParams.getFileType();
                sp.putNextEntry(filename + "." + suffix);
                if ("all".equals(requestParams.getQa())) {
                    requestParams.setFacets(new String[]{assertions, data_resource_uid});
                } else {
                    requestParams.setFacets(new String[]{data_resource_uid});
                }
                ConcurrentHashMap uidStats = new ConcurrentHashMap();
                DownloadHeaders downloadHeaders = this.searchDAO.writeResultsFromIndexToStream(requestParams, (OutputStream)sp, uidStats, dd, limit, parallelExecutor);
                sp.closeEntry();
                if (dd.getInterrupt().booleanValue()) break block38;
                ArrayList citationsForReadme = new ArrayList();
                Boolean mintDoi = requestParams.getMintDoi();
                CreateDoiResponse doiResponse = null;
                String doi = "";
                Map enabledQualityFiltersByLabel = this.dataQualityService.getEnabledFiltersByLabel((SearchRequestDTO)requestParams);
                List qualityFilters = this.getQualityFilterDTOS(enabledQualityFiltersByLabel);
                String searchUrl = this.generateSearchUrl(requestParams, enabledQualityFiltersByLabel);
                String dqFixedSearchUrl = this.dataQualityService.convertDataQualityParameters(searchUrl, enabledQualityFiltersByLabel);
                if (this.citationsEnabled.booleanValue()) {
                    ArrayList datasetMetadata = null;
                    if (mintDoi.booleanValue()) {
                        datasetMetadata = new ArrayList();
                    }
                    sp.putNextEntry("citation.csv");
                    try {
                        this.getCitations(uidStats, (OutputStream)sp, requestParams.getSep().charValue(), requestParams.getEsc().charValue(), citationsForReadme, datasetMetadata);
                    }
                    catch (IOException e) {
                        logger.error((Object)e.getMessage(), (Throwable)e);
                    }
                    sp.closeEntry();
                    if (mintDoi.booleanValue()) {
                        TreeSet<String> datasetLicences = new TreeSet<String>();
                        for (Map dataset : datasetMetadata) {
                            String licence = (String)dataset.get("licence");
                            if (!StringUtils.isNotBlank((String)licence)) continue;
                            datasetLicences.add(licence);
                        }
                        ArrayList licence = Lists.newArrayList(datasetLicences);
                        try {
                            DownloadDoiDTO doiDetails = new DownloadDoiDTO();
                            doiDetails.setTitle(this.biocacheDownloadDoiTitlePrefix + filename);
                            doiDetails.setApplicationUrl(dqFixedSearchUrl);
                            doiDetails.setRequesterId(dd.getAlaUser() == null ? null : this.getUserId(dd));
                            doiDetails.setRequesterName(dd.getAlaUser() == null ? null : dd.getAlaUser().getGivenName() + " " + dd.getAlaUser().getFamilyName());
                            doiDetails.setAuthorisedRoles(dd.getAlaUser() == null ? Collections.emptySet() : dd.getAlaUser().getRoles());
                            doiDetails.setDatasetMetadata(datasetMetadata);
                            doiDetails.setRequestTime(dd.getStartDateString());
                            doiDetails.setRecordCount(dd.getTotalRecords());
                            doiDetails.setLicence((List)licence);
                            doiDetails.setQueryTitle(requestParams.getDisplayString());
                            doiDetails.setApplicationMetadata(requestParams.getDoiMetadata());
                            if (StringUtils.isNotBlank((String)requestParams.getQualityProfile())) {
                                doiDetails.setDataProfile(this.dataQualityService.getProfileFullName(requestParams.getQualityProfile()));
                            }
                            doiDetails.setQualityFilters(qualityFilters);
                            doiDetails.setDisplayTemplate(requestParams.getDoiDisplayTemplate());
                            doiResponse = this.doiService.mintDoi(doiDetails);
                        }
                        catch (Exception e) {
                            logger.error((Object)"DOI minting failed", (Throwable)e);
                        }
                        if (doiResponse != null) {
                            logger.debug((Object)("DOI minted: " + doiResponse.getDoi()));
                            doiResponseList.add(doiResponse);
                        } else {
                            logger.error((Object)("DOI minting failed for path " + dd.getFileLocation()));
                        }
                    }
                } else if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Not adding citation. Enabled: " + this.citationsEnabled + " uids: " + uidStats));
                }
                if (dd.getRequestParams() == null) {
                    dd.setRequestParams(requestParams);
                }
                if (dd.getFileLocation() == null) {
                    dd.setFileLocation(dqFixedSearchUrl);
                }
                if (this.readmeEnabled.booleanValue()) {
                    Object fileLocation;
                    String[] readmeFile;
                    sp.putNextEntry("README.html");
                    String dataProviders = "<ul><li>" + StringUtils.join(citationsForReadme, (String)"</li><li>") + "</li></ul>";
                    if (mintDoi.booleanValue() && doiResponse != null) {
                        readmeFile = this.biocacheDownloadDoiReadmeTemplate;
                        doi = doiResponse.getDoi();
                        fileLocation = OFFICIAL_DOI_RESOLVER + doi;
                    } else {
                        readmeFile = this.biocacheDownloadReadmeTemplate;
                        fileLocation = dd.getFileLocation().replace(this.biocacheDownloadDir, this.biocacheDownloadUrl);
                    }
                    String readmeTemplate = "";
                    if (readmeFile != null && new File((String)readmeFile).exists()) {
                        readmeTemplate = FileUtils.readFileToString((File)new File((String)readmeFile), (Charset)StandardCharsets.UTF_8);
                    }
                    String dataQualityFilters = "";
                    if (!qualityFilters.isEmpty()) {
                        dataQualityFilters = this.getDataQualityFiltersString(qualityFilters);
                    }
                    String readmeContent = readmeTemplate.replace(DOWNLOAD_FILE_LOCATION, (CharSequence)fileLocation).replace(START_DATE_TIME, dd.getStartDateString(this.downloadDateFormat)).replace(SEARCH_URL, dqFixedSearchUrl).replace(QUERY_TITLE, dd.getRequestParams().getDisplayString()).replace("[dataProviders]", dataProviders).replace("[dataQualityFilters]", dataQualityFilters);
                    sp.write(readmeContent.getBytes(StandardCharsets.UTF_8));
                    sp.write(("For more information about the fields that are being downloaded please consult <a href='" + this.dataFieldDescriptionURL + "'>Download Fields</a>.").getBytes(StandardCharsets.UTF_8));
                    sp.closeEntry();
                }
                if (mintDoi.booleanValue() && doiResponse != null) {
                    sp.putNextEntry("doi.txt");
                    sp.write((OFFICIAL_DOI_RESOLVER + doiResponse.getDoi()).getBytes(StandardCharsets.UTF_8));
                    sp.write("\n".getBytes(StandardCharsets.UTF_8));
                    sp.closeEntry();
                }
                if (this.headingsEnabled.booleanValue()) {
                    sp.putNextEntry("headings.csv");
                    try {
                        this.getHeadings(downloadHeaders, (OutputStream)sp, requestParams, dd.getMiscFields());
                    }
                    catch (Exception e) {
                        logger.error((Object)e.getMessage(), (Throwable)e);
                    }
                    sp.closeEntry();
                } else if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Not adding header. Enabled: " + this.headingsEnabled + " uids: " + uidStats));
                }
                if (this.biocacheDownloadAdditionalLocalFiles != null && !this.biocacheDownloadAdditionalLocalFiles.isEmpty()) {
                    String[] localFiles;
                    for (String localFile : localFiles = this.biocacheDownloadAdditionalLocalFiles.split(",")) {
                        File f = new File(localFile);
                        if (!f.exists()) continue;
                        sp.putNextEntry(f.getName());
                        sp.write(IOUtils.toByteArray((InputStream)new FileInputStream(f)));
                        sp.closeEntry();
                    }
                }
                sp.flush();
                String sourceUrl = originalParams.contains("qid:") ? this.webservicesRoot + "?" + requestParams.toString() : this.webservicesRoot + "?" + originalParams;
                LogEventVO vo = new LogEventVO(1002, requestParams.getReasonTypeId(), requestParams.getSourceTypeId(), requestParams.getEmail(), requestParams.getReason(), dd.getIpAddress(), dd.getUserAgent(), null, uidStats, sourceUrl);
                this.loggerService.logEvent(vo);
            }
            catch (RecordWriterException e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw e;
            }
        }
    }

    private List<QualityFilterDTO> getQualityFilterDTOS(Map<String, String> filtersByLabel) {
        return filtersByLabel.entrySet().stream().map(e -> new QualityFilterDTO((String)e.getKey(), (String)e.getValue())).collect(Collectors.toList());
    }

    @VisibleForTesting
    String getDataQualityFiltersString(List<QualityFilterDTO> qualityFilters) throws IOException, ParseException {
        RuntimeServices runtimeServices = RuntimeSingleton.getRuntimeServices();
        runtimeServices.setProperty("runtime.log.logsystem.class", (Object)Log4JLogChute.class.getName());
        runtimeServices.setProperty("runtime.log.logsystem.log4j.logger", (Object)"velocity");
        InputStreamReader reader = new InputStreamReader(this.downloadQualityFiltersTemplate.getInputStream(), StandardCharsets.UTF_8);
        Template template = new Template();
        template.setRuntimeServices(runtimeServices);
        template.setData((Object)runtimeServices.parse((Reader)reader, "download-quality-filters-template"));
        template.initDocument();
        StringWriter sw = new StringWriter();
        VelocityContext context = new VelocityContext();
        context.put("qualityFilters", qualityFilters);
        template.merge((Context)context, (Writer)sw);
        String dataQualityFilters = sw.toString();
        return dataQualityFilters;
    }

    public void writeQueryToStream(DownloadRequestDTO requestParams, HttpServletResponse response, AlaUserProfile alaUser, String ip, String userAgent, OutputStream out, boolean zip, ExecutorService parallelQueryExecutor) throws Exception {
        String filename = requestParams.getFile();
        response.setHeader("Cache-Control", "must-revalidate");
        response.setHeader("Pragma", "must-revalidate");
        if (zip) {
            response.setHeader("Content-Disposition", "attachment;filename=" + filename + ".zip");
            response.setContentType("application/zip");
        } else {
            response.setHeader("Content-Disposition", "attachment;filename=" + filename + ".txt");
            response.setContentType("text/plain");
        }
        DownloadDetailsDTO.DownloadType type = DownloadDetailsDTO.DownloadType.RECORDS_INDEX;
        DownloadDetailsDTO dd = new DownloadDetailsDTO(requestParams, alaUser, ip, userAgent, type);
        this.writeQueryToStream(dd, (OutputStream)new CloseShieldOutputStream(out), true, zip, parallelQueryExecutor, null);
    }

    public void getCitations(ConcurrentMap<String, AtomicInteger> uidStats, OutputStream out, char sep, char esc, List<String> readmeCitations, List<Map<String, String>> datasetMetadata) throws IOException {
        if (this.citationsEnabled.booleanValue()) {
            if (uidStats == null) {
                logger.error((Object)"Unable to generate citations: logger statistics was null", new Exception().fillInStackTrace());
                return;
            }
            if (out == null) {
                logger.error((Object)"Unable to generate citations: output stream was null", new Exception().fillInStackTrace());
                return;
            }
            try (CSVWriter writer = new CSVWriter((Writer)new OutputStreamWriter((OutputStream)new CloseShieldOutputStream(out), StandardCharsets.UTF_8), sep, '\"', esc);){
                writer.writeNext(new String[]{this.messageSource.getMessage("citation.uid", null, "UID", null), this.messageSource.getMessage("citation.name", null, "Name", null), this.messageSource.getMessage("citation.doi", null, "DOI", null), this.messageSource.getMessage("citation.citation", null, "Citation", null), this.messageSource.getMessage("citation.rights", null, "Rights", null), this.messageSource.getMessage("citation.link", null, "More Information", null), this.messageSource.getMessage("citation.dataGeneralizations", null, "Data generalisations", null), this.messageSource.getMessage("citation.informationWithheld", null, "Information withheld", null), this.messageSource.getMessage("citation.downloadLimit", null, "Download limit", null), this.messageSource.getMessage("citation.count", null, "Number of Records in Download", null)});
                if (!uidStats.isEmpty()) {
                    List entities = (List)this.restTemplate.postForObject(this.citationServiceUrl, uidStats.keySet(), List.class, new Object[0]);
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("Posting to " + this.citationServiceUrl));
                        logger.debug((Object)("UIDs " + uidStats.keySet().stream().collect(Collectors.joining(","))));
                    }
                    boolean UID = false;
                    boolean NAME = true;
                    int CITATION = 3;
                    int RIGHTS = 4;
                    int LINK = 5;
                    int COUNT = 9;
                    List useableRecords = entities.stream().filter(m -> m != null && m.get("uid") != null).collect(Collectors.toList());
                    for (Map record2 : useableRecords) {
                        Object uid2 = record2.get("uid");
                        AtomicInteger uidRecordCount = (AtomicInteger)uidStats.get(uid2);
                        String count = Optional.ofNullable(uidRecordCount).orElseGet(() -> new AtomicInteger(0)).toString();
                        String[] row = new String[]{record2.getOrDefault("uid", ""), record2.getOrDefault("name", ""), record2.getOrDefault("DOI", ""), record2.getOrDefault("citation", ""), record2.getOrDefault("rights", ""), record2.getOrDefault("link", ""), record2.getOrDefault("dataGeneralizations", ""), record2.getOrDefault("informationWithheld", ""), record2.getOrDefault("downloadLimit", ""), count};
                        writer.writeNext(row);
                        if (readmeCitations != null) {
                            readmeCitations.add(row[3] + " (" + row[4] + "). " + row[5]);
                        }
                        if (datasetMetadata == null) continue;
                        HashMap<String, String> dataSet = new HashMap<String, String>();
                        dataSet.put("uid", row[0]);
                        dataSet.put("name", row[1]);
                        dataSet.put("licence", row[4]);
                        dataSet.put("count", row[9]);
                        datasetMetadata.add(dataSet);
                    }
                    if (useableRecords.size() < uidStats.keySet().size()) {
                        List usedUids = useableRecords.stream().map(record -> (String)record.get("uid")).collect(Collectors.toList());
                        String missingUids = uidStats.keySet().stream().filter(uid -> !usedUids.contains(uid)).collect(Collectors.joining());
                        logger.warn((Object)("The following UIDs will not have citations (missing in registry): " + missingUids));
                    }
                } else {
                    logger.warn((Object)"No collected stats for a download");
                }
                writer.flush();
            }
        }
    }

    public void getHeadings(DownloadHeaders downloadHeaders, OutputStream out, DownloadRequestDTO params, String[] miscHeaders) throws Exception {
        if (this.headingsEnabled.booleanValue()) {
            if (out == null) {
                logger.error((Object)"Unable to generate headings info: output stream was null", new Exception().fillInStackTrace());
                return;
            }
            try (CSVWriter writer = new CSVWriter((Writer)new OutputStreamWriter((OutputStream)new CloseShieldOutputStream(out), StandardCharsets.UTF_8), params.getSep().charValue(), '\"', params.getEsc().charValue());){
                Set indexedFields = this.indexDao.getIndexedFields();
                writer.writeNext(new String[]{"Column name", "Requested field", "DwC Name", "Field name", "Field description", "Download field name", "Download field description", "More information"});
                String[] fieldsRequested = downloadHeaders.joinOriginalIncluded();
                String[] headerOutput = downloadHeaders.joinedHeader();
                if (fieldsRequested != null && headerOutput != null) {
                    for (int i = 1; i < fieldsRequested.length && i < headerOutput.length; ++i) {
                        IndexFieldDTO ifdto = null;
                        for (IndexFieldDTO f : indexedFields) {
                            if (!fieldsRequested[i].equalsIgnoreCase(f.getDownloadName())) continue;
                            ifdto = f;
                            break;
                        }
                        if (ifdto == null) {
                            for (IndexFieldDTO f : indexedFields) {
                                if (!fieldsRequested[i].equalsIgnoreCase(f.getName())) continue;
                                ifdto = f;
                                break;
                            }
                        }
                        if (ifdto != null && StringUtils.isNotEmpty((String)headerOutput[i])) {
                            writer.writeNext(new String[]{headerOutput[i], fieldsRequested[i], ifdto.getDwcTerm() != null ? ifdto.getDwcTerm() : "", ifdto.getName() != null ? ifdto.getName() : "", ifdto.getDescription() != null ? ifdto.getDescription() : "", ifdto.getDownloadName() != null ? ifdto.getDownloadName() : "", ifdto.getDownloadDescription() != null ? ifdto.getDownloadDescription() : "", ifdto.getInfo() != null ? ifdto.getInfo() : ""});
                            continue;
                        }
                        if (!StringUtils.isNotEmpty((String)headerOutput[i])) continue;
                        String info = this.messageSource.getMessage("description." + fieldsRequested[i], null, "", null);
                        writer.writeNext(new String[]{headerOutput[i], fieldsRequested[i], "", "", "", "", "", info != null ? info : ""});
                    }
                }
                if (miscHeaders != null) {
                    String defaultDescription = this.messageSource.getMessage("description.", null, "Raw field from data provider.", null);
                    for (int i = 0; i < miscHeaders.length; ++i) {
                        writer.writeNext(new String[]{miscHeaders[i], "", "", "", "", "", this.messageSource.getMessage("description." + miscHeaders[i], null, defaultDescription, null)});
                    }
                }
                writer.flush();
            }
        }
    }

    public String generateSearchUrl(DownloadRequestDTO params) {
        return this.generateSearchUrl(params, null);
    }

    public String generateSearchUrl(DownloadRequestDTO params, @Nullable Map<String, String> enabledQualityFiltersByLabel) {
        if (params.getSearchUrl() != null) {
            return params.getSearchUrl();
        }
        StringBuilder sb = new StringBuilder();
        sb.append(this.biocacheUiUrl + "/occurrences/search?");
        if (params.getQId() != null) {
            try {
                sb.append("qid=").append(URLEncoder.encode("" + params.getQId(), "UTF-8"));
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
        }
        if (params.getQ() != null) {
            try {
                sb.append("&q=").append(URLEncoder.encode(params.getQ(), "UTF-8"));
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
        }
        if (params.getFq().length > 0) {
            for (String fq2 : params.getFq()) {
                if (!StringUtils.isNotEmpty((String)fq2)) continue;
                try {
                    sb.append("&fq=").append(URLEncoder.encode(fq2, "UTF-8"));
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    // empty catch block
                }
            }
        }
        if (params.isDisableAllQualityFilters()) {
            sb.append("&disableAllQualityFilters=true");
        } else {
            sb.append("&disableAllQualityFilters=true");
            if (enabledQualityFiltersByLabel == null) {
                enabledQualityFiltersByLabel = this.dataQualityService.getEnabledFiltersByLabel((SearchRequestDTO)params);
            }
            enabledQualityFiltersByLabel.forEach((label, fq) -> {
                try {
                    sb.append("&fq=").append(URLEncoder.encode(fq, "UTF-8"));
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    // empty catch block
                }
            });
        }
        if (StringUtils.isNotEmpty((String)params.getQc())) {
            try {
                sb.append("&qc=").append(URLEncoder.encode(params.getQc(), "UTF-8"));
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
        }
        if (StringUtils.isNotEmpty((String)params.getWkt())) {
            try {
                sb.append("&wkt=").append(URLEncoder.encode(params.getWkt(), "UTF-8"));
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
        }
        if (params.getLat() != null && params.getLon() != null && params.getRadius() != null) {
            sb.append("&lat=").append(params.getLat());
            sb.append("&lon=").append(params.getLon());
            sb.append("&radius=").append(params.getRadius());
        }
        return sb.toString();
    }

    private void insertMiscHeader(DownloadDetailsDTO download) {
        if (download.getMiscFields() != null && download.getMiscFields().length > 0 && download.getRequestParams() != null) {
            try {
                File unzipDir = new File(download.getFileLocation() + ".dir" + File.separator);
                unzipDir.mkdirs();
                AlaFileUtils.unzip((String)unzipDir.getPath(), (String)download.getFileLocation());
                for (File f : unzipDir.listFiles()) {
                    if (!f.getName().endsWith(".csv") && !f.getName().endsWith(".tsv") || "headings.csv".equals(f.getName())) continue;
                    try (FileReader fileReader = new FileReader(f);
                         BufferedReader bufferedReader = new BufferedReader(fileReader);){
                        File fnew = new File(f.getPath() + ".new");
                        try (FileWriter fw = new FileWriter(fnew);){
                            Object line;
                            int row = 0;
                            while ((line = bufferedReader.readLine()) != null) {
                                if (row == 0) {
                                    String[] miscHeader = download.getMiscFields();
                                    if ("csv".equals(download.getRequestParams().getFileType())) {
                                        CSVReader reader = new CSVReader((Reader)new StringReader((String)line));
                                        String[] header = reader.readNext();
                                        reader.close();
                                        String[] newHeader = new String[header.length + miscHeader.length];
                                        if (header.length > 0) {
                                            System.arraycopy(header, 0, newHeader, 0, header.length);
                                        }
                                        if (miscHeader.length > 0) {
                                            System.arraycopy(miscHeader, 0, newHeader, header.length, miscHeader.length);
                                        }
                                        StringWriter sw = new StringWriter();
                                        try (CSVWriter writer = new CSVWriter((Writer)sw, download.getRequestParams().getSep().charValue(), '\"', download.getRequestParams().getEsc().charValue());){
                                            writer.writeNext(newHeader);
                                        }
                                        line = sw.toString().trim();
                                    } else {
                                        for (int i = 0; i < miscHeader.length; ++i) {
                                            line = (String)line + "\t";
                                            line = (String)line + miscHeader[i].replace("\r", "").replace("\n", "").replace("\t", "");
                                        }
                                        line = (String)line + "\n";
                                    }
                                } else {
                                    fw.write("\n");
                                }
                                fw.write((String)line);
                                ++row;
                            }
                        }
                        FileUtils.copyFile((File)fnew, (File)f);
                        fnew.delete();
                    }
                }
                FileUtils.deleteQuietly((File)new File(download.getFileLocation()));
                AlaFileUtils.createZip((String)unzipDir.getPath(), (String)download.getFileLocation());
                FileUtils.deleteDirectory((File)unzipDir);
            }
            catch (Exception e) {
                logger.error((Object)"failed to append misc header", (Throwable)e);
            }
        }
    }

    public String getSensitiveFq(Set<String> userRoles) {
        if (this.downloadAuthSensitive == null || !this.downloadAuthSensitive.booleanValue()) {
            return null;
        }
        ArrayList sensitiveRoles = new ArrayList(this.sensitiveAccessRolesToSolrFilters20.keySet());
        sensitiveRoles.retainAll(userRoles);
        Object sensitiveFq = "";
        for (String sensitiveRole : sensitiveRoles) {
            if (((String)sensitiveFq).length() > 0) {
                sensitiveFq = (String)sensitiveFq + " OR ";
            }
            sensitiveFq = (String)sensitiveFq + "(" + this.sensitiveAccessRolesToSolrFilters20.get((Object)sensitiveRole) + ")";
        }
        if (((String)sensitiveFq).length() == 0) {
            return null;
        }
        return sensitiveFq;
    }

    public String getEmailTemplateFile(DownloadDetailsDTO currentDownload) {
        String file;
        switch (currentDownload.getRequestParams().getEmailTemplate()) {
            case "csdm": {
                file = this.biocacheDownloadCSDMEmailTemplate;
                break;
            }
            case "doi": {
                file = this.biocacheDownloadDoiEmailTemplate;
                break;
            }
            default: {
                file = this.biocacheDownloadEmailTemplate;
            }
        }
        return file;
    }

    public String getFailEmailBodyTemplate(DownloadDetailsDTO currentDownload) {
        String emailTemplate;
        switch (currentDownload.getRequestParams().getEmailTemplate()) {
            case "csdm": {
                emailTemplate = this.messageSource.getMessage("offlineFailEmailBodyCSDM", null, "", null);
                break;
            }
            default: {
                emailTemplate = this.messageSource.getMessage("offlineFailEmailBody", null, "", null);
            }
        }
        return emailTemplate;
    }

    public String generateEmailContent(String template, Map<String, String> substitutions) {
        if (template != null && substitutions.size() > 0) {
            for (Map.Entry<String, String> entry : substitutions.entrySet()) {
                template = template.replace(entry.getKey(), entry.getValue());
            }
        }
        return template;
    }

    public void cancel(DownloadDetailsDTO dd) throws InterruptedException {
        dd.setInterrupt(Boolean.valueOf(true));
        Thread.sleep(500L);
        ThreadPoolExecutor ex = (ThreadPoolExecutor)this.userExecutors.get(this.getUserId(dd));
        if (ex != null) {
            this.persistentQueueDAO.remove(dd);
            for (Runnable r : ex.getQueue()) {
                if (!((DownloadRunnable)r).currentDownload.getUniqueId().equals(dd.getUniqueId())) continue;
                ex.remove(r);
            }
            File outputFile = new File(dd.getFileLocation());
            if (outputFile.exists()) {
                outputFile.delete();
            }
        }
    }

    public List<DownloadDetailsDTO> getDownloadsForUserId(String userId) {
        ArrayList<DownloadDetailsDTO> all = new ArrayList<DownloadDetailsDTO>();
        for (DownloadDetailsDTO dd : this.persistentQueueDAO.getAllDownloads()) {
            if (!userId.equalsIgnoreCase(this.getUserId(dd))) continue;
            all.add(dd);
        }
        return all;
    }
}

