/*
 * Decompiled with CFR 0.152.
 */
package au.org.ala.biocache.service;

import au.org.ala.biocache.dto.DownloadRequestDTO;
import au.org.ala.biocache.service.AuthService;
import au.org.ala.biocache.service.RestartDataService;
import au.org.ala.biocache.util.AlaUnvalidatedProfile;
import au.org.ala.ws.security.profile.AlaUserProfile;
import au.org.ala.ws.tokens.TokenService;
import com.fasterxml.jackson.core.type.TypeReference;
import jakarta.mail.internet.AddressException;
import jakarta.mail.internet.InternetAddress;
import java.security.Principal;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import javax.inject.Inject;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestOperations;

@Component(value="authService")
public class AuthService {
    private static final Logger log = LoggerFactory.getLogger(AuthService.class);
    private static final org.apache.log4j.Logger logger = org.apache.log4j.Logger.getLogger(AuthService.class);
    @Inject
    protected RestOperations restTemplate;
    @Value(value="${auth.user.details.url:}")
    protected String userDetailsUrl = null;
    @Value(value="${auth.user.names.id.path:getUserList}")
    protected String userNamesForIdPath = null;
    @Value(value="${auth.usernames.for.numeric.id.path:getUserListWithIds}")
    protected String userNamesForNumericIdPath = null;
    @Value(value="${auth.usernames.full.path:getUserList}")
    protected String userNamesFullPath = null;
    @Value(value="${auth.user.details.path:getUserDetails}")
    protected String userDetailsPath = null;
    @Value(value="${auth.startup.initialise:false}")
    protected boolean startupInitialise = false;
    @Value(value="${caches.auth.enabled:true}")
    protected Boolean enabled = true;
    @Value(value="${auth.legacy.emailonly.downloads.enabled:true}")
    protected Boolean emailOnlyEnabled = true;
    @Inject
    private TokenService tokenService;
    protected Map<String, String> userNamesById = (Map)RestartDataService.get((Object)this, (String)"userNamesById", (TypeReference)new /* Unavailable Anonymous Inner Class!! */, HashMap.class);
    protected Map<String, String> userNamesByNumericIds = (Map)RestartDataService.get((Object)this, (String)"userNamesByNumericIds", (TypeReference)new /* Unavailable Anonymous Inner Class!! */, HashMap.class);
    protected Map<String, String> userEmailToId = (Map)RestartDataService.get((Object)this, (String)"userEmailToId", (TypeReference)new /* Unavailable Anonymous Inner Class!! */, HashMap.class);

    public AuthService() {
        if (this.startupInitialise) {
            logger.info((Object)"Loading auth caches now");
            this.reloadCaches();
        }
    }

    public Map<String, String> getMapOfAllUserNamesById() {
        return this.userNamesById;
    }

    public Map<String, String> getMapOfAllUserNamesByNumericId() {
        return this.userNamesByNumericIds;
    }

    public Map<String, String> getMapOfEmailToId() {
        return this.userEmailToId;
    }

    public String getDisplayNameFor(String value) {
        String displayName = value;
        if (value != null) {
            displayName = this.userNamesById.containsKey(value) ? (String)this.userNamesById.get(value) : (this.userNamesByNumericIds.containsKey(value) ? (String)this.userNamesByNumericIds.get(value) : displayName.replaceAll("\\@\\w+", "@.."));
        }
        return displayName;
    }

    public String substituteEmailAddress(String raw) {
        return raw == null ? raw : raw.replaceAll("\\@\\w+", "@..");
    }

    private void loadMapOfAllUserNamesById() {
        if (StringUtils.isNotBlank((String)this.userDetailsUrl)) {
            String jsonUri = this.userDetailsUrl + this.userNamesForIdPath;
            try {
                logger.debug((Object)("authCache requesting: " + jsonUri));
                HttpHeaders requestHeaders = new HttpHeaders();
                requestHeaders.set("Authorization", this.tokenService.getAuthToken(false).toAuthorizationHeader());
                HttpEntity request = new HttpEntity(null, (MultiValueMap)requestHeaders);
                Map m = (Map)this.restTemplate.postForObject(jsonUri, (Object)request, Map.class, new Object[0]);
                if (m != null && m.size() > 0) {
                    this.userNamesById = m;
                }
            }
            catch (Exception ex) {
                logger.error((Object)("RestTemplate error for " + jsonUri + ": " + ex.getMessage()), (Throwable)ex);
            }
        }
    }

    private void loadMapOfAllUserNamesByNumericId() {
        if (StringUtils.isNotBlank((String)this.userDetailsUrl)) {
            String jsonUri = this.userDetailsUrl + this.userNamesForNumericIdPath;
            try {
                logger.debug((Object)("authCache requesting: " + jsonUri));
                HttpHeaders requestHeaders = new HttpHeaders();
                requestHeaders.set("Authorization", this.tokenService.getAuthToken(false).toAuthorizationHeader());
                HttpEntity request = new HttpEntity(null, (MultiValueMap)requestHeaders);
                Map m = (Map)this.restTemplate.postForObject(jsonUri, (Object)request, Map.class, new Object[0]);
                if (m != null && m.size() > 0) {
                    this.userNamesByNumericIds = m;
                }
            }
            catch (Exception ex) {
                logger.error((Object)("RestTemplate error for " + jsonUri + ": " + ex.getMessage()), (Throwable)ex);
            }
        }
    }

    private void loadMapOfEmailToUserId() {
        if (StringUtils.isNotBlank((String)this.userDetailsUrl)) {
            String jsonUri = this.userDetailsUrl + this.userNamesFullPath;
            try {
                logger.debug((Object)("authCache requesting: " + jsonUri));
                HttpHeaders requestHeaders = new HttpHeaders();
                requestHeaders.set("Authorization", this.tokenService.getAuthToken(false).toAuthorizationHeader());
                HttpEntity request = new HttpEntity(null, (MultiValueMap)requestHeaders);
                Map m = (Map)this.restTemplate.postForObject(jsonUri, (Object)request, Map.class, new Object[0]);
                if (m != null && m.size() > 0) {
                    this.userEmailToId = m;
                }
                logger.debug((Object)("authCache userEmail cache: " + this.userEmailToId.size()));
                if (!this.userEmailToId.isEmpty()) {
                    String email = (String)this.userEmailToId.keySet().iterator().next();
                    String id = (String)this.userEmailToId.get(email);
                    logger.info((Object)("authCache userEmail example: " + email + " -> " + id));
                }
            }
            catch (Exception ex) {
                logger.error((Object)("RestTemplate error for " + jsonUri + ": " + ex.getMessage()), (Throwable)ex);
            }
        }
    }

    @Scheduled(fixedDelay=600000L)
    public void reloadCaches() {
        4 thread = new /* Unavailable Anonymous Inner Class!! */;
        if (this.userDetailsPath.length() > 0) {
            thread.start();
        } else {
            thread.run();
        }
    }

    @Deprecated
    public Set<String> getUserRoles(String userId) {
        HashSet<String> roles = new HashSet<String>();
        if (StringUtils.isNotBlank((String)this.userDetailsUrl)) {
            String jsonUri = this.userDetailsUrl + this.userDetailsPath + "?userName=" + userId;
            logger.info((Object)("authCache requesting: " + jsonUri));
            HttpHeaders requestHeaders = new HttpHeaders();
            requestHeaders.set("Authorization", this.tokenService.getAuthToken(false).toAuthorizationHeader());
            HttpEntity request = new HttpEntity(null, (MultiValueMap)requestHeaders);
            roles.addAll(((Map)this.restTemplate.postForObject(jsonUri, (Object)request, Map.class, new Object[0])).getOrDefault("roles", Collections.EMPTY_LIST));
        }
        return roles;
    }

    @Deprecated
    public Map<String, ?> getUserDetails(String userId) {
        Map userDetails = new HashMap();
        if (StringUtils.isNotBlank((String)this.userDetailsUrl)) {
            String jsonUri = this.userDetailsUrl + this.userDetailsPath + "?userName=" + userId;
            logger.info((Object)("authCache requesting: " + jsonUri));
            HttpHeaders requestHeaders = new HttpHeaders();
            requestHeaders.set("Authorization", this.tokenService.getAuthToken(false).toAuthorizationHeader());
            HttpEntity request = new HttpEntity(null, (MultiValueMap)requestHeaders);
            userDetails = (Map)this.restTemplate.postForObject(jsonUri, (Object)request, Map.class, new Object[0]);
        }
        return userDetails;
    }

    public Optional<AlaUserProfile> getDownloadUser(DownloadRequestDTO downloadRequestDTO, HttpServletRequest request) {
        Principal userPrincipal = request.getUserPrincipal();
        if (userPrincipal != null && userPrincipal instanceof AlaUserProfile) {
            return Optional.of((AlaUserProfile)userPrincipal);
        }
        if (this.emailOnlyEnabled.booleanValue() && downloadRequestDTO.getEmail() != null) {
            try {
                new InternetAddress(downloadRequestDTO.getEmail()).validate();
                return this.lookupAuthUser(downloadRequestDTO.getEmail(), false);
            }
            catch (AddressException e) {
                logger.info((Object)("Email only download request failed - invalid email " + downloadRequestDTO.getEmail()));
            }
        } else if (!this.emailOnlyEnabled.booleanValue() && downloadRequestDTO.getEmail() != null) {
            return Optional.of(new AlaUnvalidatedProfile(downloadRequestDTO.getEmail()));
        }
        return Optional.empty();
    }

    public Optional<AlaUserProfile> getRecordViewUser(HttpServletRequest request) {
        Principal userPrincipal = request.getUserPrincipal();
        if (userPrincipal != null && userPrincipal instanceof AlaUserProfile) {
            return Optional.of((AlaUserProfile)userPrincipal);
        }
        return Optional.empty();
    }

    public Optional<AlaUserProfile> lookupAuthUser(String userIdOrEmail, boolean getRoles) {
        Map userDetails = this.getUserDetails(userIdOrEmail);
        if (userDetails == null || userDetails.isEmpty()) {
            return Optional.empty();
        }
        String userId = userDetails.getOrDefault("userId", null);
        boolean activated = userDetails.getOrDefault("activated", false);
        boolean locked = userDetails.getOrDefault("locked", true);
        String firstName = userDetails.getOrDefault("firstName", "");
        String lastName = userDetails.getOrDefault("lastName", "");
        String email = userDetails.getOrDefault("email", "");
        HashSet userRoles = new HashSet(Collections.emptySet());
        if (getRoles) {
            userRoles.addAll(userDetails.getOrDefault("roles", Collections.EMPTY_LIST));
        }
        if (email != null && activated && !locked) {
            return Optional.of(new /* Unavailable Anonymous Inner Class!! */);
        }
        log.info("Download request with API key failed - email  " + email + " , activated " + activated + " , locked " + locked);
        return Optional.empty();
    }
}

