/*
 * Decompiled with CFR 0.152.
 */
package au.org.ala.biocache.dto;

import au.org.ala.biocache.dto.DownloadRequestParams;
import au.org.ala.biocache.dto.SpatialSearchRequestDTO;
import au.org.ala.biocache.util.QueryFormatUtils;
import au.org.ala.biocache.validate.LogType;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Pattern;
import org.apache.log4j.Logger;
import org.springframework.beans.BeanUtils;

/*
 * Exception performing whole class analysis ignored.
 */
@Schema(name="DownloadRequest")
public class DownloadRequestDTO
extends SpatialSearchRequestDTO {
    public static final List<String> validTemplates = Arrays.asList("default", "doi", "csdm");
    private static final Logger logger = Logger.getLogger(DownloadRequestDTO.class);
    protected boolean emailNotify = true;
    protected String email = "";
    protected String reason = "";
    protected String file = "data";
    protected String fields = "";
    protected String extra = "";
    protected String qa = "all";
    protected Character sep = Character.valueOf(',');
    protected Character esc = Character.valueOf('\"');
    protected Boolean dwcHeaders = false;
    protected Boolean includeMisc = false;
    @NotNull
    @LogType(type="reason")
    protected Integer reasonTypeId = null;
    @LogType(type="source")
    protected Integer sourceTypeId = null;
    @Pattern(regexp="(csv|tsv)")
    protected @Pattern(regexp="(csv|tsv)") String fileType = "csv";
    protected String layersServiceUrl = "";
    protected String customHeader = "";
    protected Boolean mintDoi = false;
    protected String doiDisplayTemplate = "biocache";
    protected String searchUrl;
    protected String doiDisplayUrl;
    protected String hubName;
    protected String emailTemplate = (String)validTemplates.get(0);
    Map<String, String> doiMetadata = new HashMap();

    public static DownloadRequestDTO create(DownloadRequestParams params, HttpServletRequest request) {
        DownloadRequestDTO dto = new DownloadRequestDTO();
        BeanUtils.copyProperties((Object)params, (Object)dto);
        if (dto.getEmail() == null) {
            dto.setEmail(request.getUserPrincipal().getName());
        }
        return dto;
    }

    public String toString() {
        return this.addParams(super.toString(), Boolean.valueOf(false));
    }

    public String getEncodedParams() {
        return this.addParams(super.getEncodedParams(), Boolean.valueOf(true));
    }

    protected String addParams(String paramString, Boolean encodeParams) {
        StringBuilder req = new StringBuilder(paramString);
        if (!this.emailNotify) {
            req.append("&emailNotify=false");
        }
        req.append("&email=").append(super.conditionalEncode(this.email, encodeParams));
        req.append("&reason=").append(super.conditionalEncode(this.reason, encodeParams));
        req.append("&file=").append(super.conditionalEncode(this.getFile(), encodeParams));
        req.append("&fields=").append(super.conditionalEncode(this.fields, encodeParams));
        req.append("&extra=").append(super.conditionalEncode(this.extra, encodeParams));
        if (this.reasonTypeId != null) {
            req.append("&reasonTypeId=").append(this.reasonTypeId);
        }
        if (this.sourceTypeId != null) {
            req.append("&sourceTypeId=").append(this.sourceTypeId);
        }
        if (!"csv".equals(this.fileType)) {
            req.append("&fileType=").append(super.conditionalEncode(this.fileType, encodeParams));
        }
        if (!"all".equals(this.qa)) {
            req.append("&qa=").append(super.conditionalEncode(this.qa, encodeParams));
        }
        if (this.dwcHeaders.booleanValue()) {
            req.append("&dwcHeaders=true");
        }
        if (this.includeMisc.booleanValue()) {
            req.append("&includeMisc=true");
        }
        return req.toString();
    }

    public boolean isEmailNotify() {
        return this.emailNotify;
    }

    public void setEmailNotify(boolean emailNotify) {
        this.emailNotify = emailNotify;
    }

    public String getEmail() {
        return this.email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public String getFile() {
        return DownloadRequestDTO.sanitiseFileName((String)this.file);
    }

    public void setFile(String file) {
        this.file = DownloadRequestDTO.sanitiseFileName((String)file);
    }

    private static String sanitiseFileName(String nextFile) {
        return nextFile.replaceAll("[^a-zA-Z0-9-_\\.]", "_");
    }

    public String getReason() {
        return this.reason;
    }

    public void setReason(String reason) {
        this.reason = reason;
    }

    public String getFields() {
        return this.fields;
    }

    public void setFields(String fields) {
        QueryFormatUtils.assertNoSensitiveValues(DownloadRequestDTO.class, (String)"fields", (String)fields);
        this.fields = fields;
    }

    public String getExtra() {
        return this.extra;
    }

    public void setExtra(String extra) {
        QueryFormatUtils.assertNoSensitiveValues(DownloadRequestDTO.class, (String)"extra", (String)extra);
        this.extra = extra;
    }

    public Integer getReasonTypeId() {
        return this.reasonTypeId;
    }

    public void setReasonTypeId(Integer reasonTypeId) {
        this.reasonTypeId = reasonTypeId;
    }

    public Integer getSourceTypeId() {
        return this.sourceTypeId;
    }

    public void setSourceTypeId(Integer sourceTypeId) {
        this.sourceTypeId = sourceTypeId;
    }

    public String getFileType() {
        return this.fileType;
    }

    public String getEmailTemplate() {
        return this.emailTemplate;
    }

    public void setFileType(String fileType) {
        this.fileType = fileType;
    }

    public String getQa() {
        return this.qa;
    }

    public void setQa(String qa) {
        this.qa = qa;
    }

    public Character getEsc() {
        return this.esc;
    }

    public void setEsc(Character esc) {
        this.esc = esc;
    }

    public Character getSep() {
        return this.sep;
    }

    public void setSep(Character sep) {
        this.sep = sep;
    }

    public Boolean getDwcHeaders() {
        return this.dwcHeaders;
    }

    public void setDwcHeaders(Boolean dwcHeaders) {
        this.dwcHeaders = dwcHeaders;
    }

    public Boolean getIncludeMisc() {
        return this.includeMisc;
    }

    public void setIncludeMisc(Boolean includeMisc) {
        this.includeMisc = includeMisc;
    }

    public String getLayersServiceUrl() {
        return this.layersServiceUrl;
    }

    public void setLayersServiceUrl(String layersServiceUrl) {
        this.layersServiceUrl = layersServiceUrl;
    }

    public String getCustomHeader() {
        return this.customHeader;
    }

    public void setCustomHeader(String customHeader) {
        this.customHeader = customHeader;
    }

    public Boolean getMintDoi() {
        return this.mintDoi;
    }

    public void setMintDoi(Boolean mintDoi) {
        this.mintDoi = mintDoi;
    }

    public String getSearchUrl() {
        return this.searchUrl;
    }

    public void setSearchUrl(String searchUrl) {
        this.searchUrl = searchUrl;
    }

    public String getDoiDisplayUrl() {
        return this.doiDisplayUrl;
    }

    public void setDoiDisplayUrl(String doiDisplayUrl) {
        this.doiDisplayUrl = doiDisplayUrl;
    }

    public String getHubName() {
        return this.hubName;
    }

    public void setHubName(String hubName) {
        this.hubName = hubName;
    }

    public Map<String, String> getDoiMetadata() {
        return this.doiMetadata;
    }

    public void setDoiMetadata(Map<String, String> doiMetadata) {
        this.doiMetadata = doiMetadata;
    }

    public void setEmailTemplate(String emailTemplate) {
        if (validTemplates.contains(emailTemplate)) {
            this.emailTemplate = emailTemplate;
        } else {
            this.emailTemplate = (String)validTemplates.get(0);
            logger.info((Object)("Unsupported emailTemplate passed - " + emailTemplate + ".  Using emailTemplate - " + this.emailTemplate));
        }
    }

    public String getDoiDisplayTemplate() {
        return this.doiDisplayTemplate;
    }

    public void setDoiDisplayTemplate(String doiDisplayTemplate) {
        this.doiDisplayTemplate = doiDisplayTemplate;
    }
}

