/*
 * Decompiled with CFR 0.152.
 */
package au.org.ala.biocache.dto;

import au.org.ala.biocache.dto.ALAOccurrenceIssue;
import com.google.common.collect.ImmutableSet;
import java.util.Set;
import org.gbif.api.util.AnnotationUtils;
import org.gbif.api.vocabulary.InterpretationRemark;
import org.gbif.api.vocabulary.InterpretationRemarkSeverity;
import org.gbif.api.vocabulary.OccurrenceIssue;
import org.gbif.dwc.terms.Term;

public enum ALAOccurrenceIssue implements InterpretationRemark
{
    LOCATION_NOT_SUPPLIED(InterpretationRemarkSeverity.WARNING, TermsGroup.COORDINATES_TERMS_NO_DATUM),
    COORDINATES_CENTRE_OF_STATEPROVINCE(InterpretationRemarkSeverity.WARNING, TermsGroup.COORDINATES_TERMS_NO_DATUM),
    UNCERTAINTY_IN_PRECISION(InterpretationRemarkSeverity.WARNING, TermsGroup.COORDINATES_TERMS),
    UNCERTAINTY_NOT_SPECIFIED(InterpretationRemarkSeverity.WARNING, TermsGroup.COORDINATES_TERMS),
    STATE_COORDINATE_MISMATCH(InterpretationRemarkSeverity.WARNING, TermsGroup.COORDINATES_COUNTRY_TERMS),
    UNKNOWN_COUNTRY_NAME(InterpretationRemarkSeverity.WARNING, TermsGroup.COORDINATES_COUNTRY_TERMS),
    COORDINATES_CENTRE_OF_COUNTRY(InterpretationRemarkSeverity.WARNING, TermsGroup.COORDINATES_COUNTRY_TERMS),
    MISSING_GEODETICDATUM(InterpretationRemarkSeverity.WARNING, TermsGroup.GEOREFERENCE_TERMS),
    MISSING_GEOREFERENCE_DATE(InterpretationRemarkSeverity.WARNING, TermsGroup.GEOREFERENCE_TERMS),
    MISSING_GEOREFERENCEDBY(InterpretationRemarkSeverity.WARNING, TermsGroup.GEOREFERENCE_TERMS),
    MISSING_GEOREFERENCEPROTOCOL(InterpretationRemarkSeverity.WARNING, TermsGroup.GEOREFERENCE_TERMS),
    MISSING_GEOREFERENCESOURCES(InterpretationRemarkSeverity.WARNING, TermsGroup.GEOREFERENCE_TERMS),
    MISSING_GEOREFERENCEVERIFICATIONSTATUS(InterpretationRemarkSeverity.WARNING, TermsGroup.GEOREFERENCE_TERMS),
    MISSING_COLLECTION_DATE(InterpretationRemarkSeverity.WARNING, TermsGroup.RECORDED_DATE_TERMS),
    GEOREFERENCE_POST_OCCURRENCE(InterpretationRemarkSeverity.WARNING, TermsGroup.RECORDED_DATE_TERMS),
    ID_PRE_OCCURRENCE(InterpretationRemarkSeverity.WARNING, TermsGroup.RECORDED_DATE_TERMS),
    FIRST_OF_MONTH(InterpretationRemarkSeverity.WARNING, TermsGroup.RECORDED_DATE_TERMS),
    FIRST_OF_YEAR(InterpretationRemarkSeverity.WARNING, TermsGroup.RECORDED_DATE_TERMS),
    FIRST_OF_CENTURY(InterpretationRemarkSeverity.WARNING, TermsGroup.RECORDED_DATE_TERMS),
    TAXON_AFFINITY_SPECIES(InterpretationRemarkSeverity.WARNING, TermsGroup.TAXONOMY_TERMS),
    TAXON_EXCLUDED_ASSOCIATED(InterpretationRemarkSeverity.WARNING, TermsGroup.TAXONOMY_TERMS),
    TAXON_CONFER_SPECIES(InterpretationRemarkSeverity.WARNING, TermsGroup.TAXONOMY_TERMS),
    TAXON_EXCLUDED(InterpretationRemarkSeverity.WARNING, TermsGroup.TAXONOMY_TERMS),
    TAXON_ERROR(InterpretationRemarkSeverity.WARNING, TermsGroup.TAXONOMY_TERMS),
    TAXON_HOMONYM(InterpretationRemarkSeverity.WARNING, TermsGroup.TAXONOMY_TERMS),
    TAXON_INDETERMINATE_SPECIES(InterpretationRemarkSeverity.WARNING, TermsGroup.TAXONOMY_TERMS),
    TAXON_MISAPPLIED_MATCHED(InterpretationRemarkSeverity.WARNING, TermsGroup.TAXONOMY_TERMS),
    TAXON_MISAPPLIED(InterpretationRemarkSeverity.WARNING, TermsGroup.TAXONOMY_TERMS),
    TAXON_PARENT_CHILD_SYNONYM(InterpretationRemarkSeverity.WARNING, TermsGroup.TAXONOMY_TERMS),
    TAXON_QUESTION_SPECIES(InterpretationRemarkSeverity.WARNING, TermsGroup.TAXONOMY_TERMS),
    TAXON_SPECIES_PLURAL(InterpretationRemarkSeverity.WARNING, TermsGroup.TAXONOMY_TERMS),
    MISSING_TAXONRANK(InterpretationRemarkSeverity.WARNING, TermsGroup.TAXONOMY_TERMS),
    NAME_NOT_SUPPLIED(InterpretationRemarkSeverity.WARNING, TermsGroup.TAXONOMY_TERMS),
    UNKNOWN_KINGDOM(InterpretationRemarkSeverity.WARNING, TermsGroup.TAXONOMY_TERMS),
    TAXON_SCOPE_MISMATCH(InterpretationRemarkSeverity.WARNING, TermsGroup.TAXONOMY_TERMS),
    TAXON_DEFAULT_MATCH(InterpretationRemarkSeverity.WARNING, TermsGroup.TAXONOMY_TERMS),
    INVALID_SCIENTIFIC_NAME(InterpretationRemarkSeverity.WARNING, TermsGroup.TAXONOMY_TERMS),
    SENSITIVITY_REPORT_INVALID(InterpretationRemarkSeverity.ERROR, TermsGroup.SENSITIVE_DATA_TERMS),
    SENSITIVITY_REPORT_NOT_LOADABLE(InterpretationRemarkSeverity.ERROR, TermsGroup.SENSITIVE_DATA_TERMS),
    UNRECOGNISED_COLLECTION_CODE(InterpretationRemarkSeverity.ERROR, TermsGroup.ATTRIBUTION_TERMS),
    UNRECOGNISED_INSTITUTION_CODE(InterpretationRemarkSeverity.ERROR, TermsGroup.ATTRIBUTION_TERMS);

    private final Set<Term> relatedTerms;
    private final InterpretationRemarkSeverity severity;
    private final boolean isDeprecated;

    private ALAOccurrenceIssue(InterpretationRemarkSeverity severity, Term[] relatedTerms) {
        this.severity = severity;
        this.relatedTerms = ImmutableSet.copyOf((Object[])relatedTerms);
        this.isDeprecated = AnnotationUtils.isFieldDeprecated(OccurrenceIssue.class, (String)this.name());
    }

    public String getId() {
        return this.name();
    }

    public Set<Term> getRelatedTerms() {
        return this.relatedTerms;
    }

    public InterpretationRemarkSeverity getSeverity() {
        return this.severity;
    }

    public boolean isDeprecated() {
        return this.isDeprecated;
    }
}

